/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import java.util.ArrayList;
import java.util.List;
import javax.sip.RequestEvent;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import jp.ac.naka.ec.EventDispatcher;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.sip.SipCore;
import jp.ac.naka.ec.sip.pidf.PIDFData;
import jp.ac.naka.ec.sip.pidf.Tuple;

abstract class MethodDelegate {
    EventDispatcher dispatcher;
    SipCore core;

    MethodDelegate() {
    }

    public abstract boolean forward(RequestEvent var1);

    protected Entity[] makeEntitiesFromPIDF(PIDFData data) {
        SipURI uri = (SipURI)data.getURI();
        String name = uri.getUser();
        EntityContainerImpl con = new EntityContainerImpl(name);
        con.setURI((URI)uri);
        con.setLocal(false);
        if (data.getLocation() != null) {
            con.setLocation(data.getLocation());
        }
        List<Tuple> tuples = data.getTuples();
        ArrayList<EntityImpl> entities = new ArrayList<EntityImpl>();
        entities.add(con);
        for (Tuple tuple : tuples) {
            URI e_uri;
            EntityType type = EntityType.valueOf((String)tuple.getExtension("type"));
            EntityImpl entity = type == EntityType.CONTAINER ? new EntityContainerImpl() : new EntityImpl();
            entity.setLocal(false);
            entity.setParent(con);
            entity.setName((String)tuple.getExtension("name"));
            entity.setTupleId(tuple.id);
            entity.setEntityType(type);
            String temp = (String)tuple.getExtension("uri");
            if (temp != null && (e_uri = this.core.createURI(temp)) != null) {
                entity.setURI(e_uri);
            }
            entities.add(entity);
        }
        if (tuples.size() == 0) {
            return null;
        }
        Entity[] temp = new Entity[entities.size()];
        return entities.toArray(temp);
    }
}

