/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.media;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.media.ControllerListener;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaException;
import javax.media.Player;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.DataSource;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPControl;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;
import javax.media.rtp.event.StreamMappedEvent;
import javax.swing.JFrame;
import jp.ac.naka.ec.media.MediaListener;
import jp.ac.naka.ec.media.MediaReceiveEvent;
import jp.ac.naka.ec.media.RTPSocketAdapter;
import jp.ac.naka.ec.media.SDPGenerator;
import jp.ac.naka.ec.media.SessionInformation;
import jp.ac.naka.ec.media.WaitingListener;
import net.sourceforge.jsdp.Connection;
import net.sourceforge.jsdp.Media;
import net.sourceforge.jsdp.MediaDescription;
import net.sourceforge.jsdp.SessionDescription;

public class MediaReceiver
implements ReceiveStreamListener {
    protected int[] receivableJmfVideoFormats = new int[]{34, 26, 31};
    protected int[] receivableJmfAudioFormats;
    List<Integer> availableVideoFormats;
    List<Integer> availableAudioFormats;
    private Player video_player;
    private Player audio_player;
    private RTPManager[] mgrs;
    private RTPSocketAdapter[] adapter;
    Object dataSync;
    private WaitingListener listener;
    boolean dataReceived;
    SessionInformation[] info;
    private int audio_port;
    private int video_port;
    private List<MediaListener> listeners;

    public MediaReceiver() {
        int format;
        int[] nArray = new int[7];
        nArray[0] = 4;
        nArray[1] = 3;
        nArray[3] = 5;
        nArray[4] = 6;
        nArray[5] = 8;
        nArray[6] = 15;
        this.receivableJmfAudioFormats = nArray;
        this.availableVideoFormats = new ArrayList<Integer>();
        this.availableAudioFormats = new ArrayList<Integer>();
        this.dataSync = new Object();
        this.listener = new WaitingListener();
        this.dataReceived = false;
        this.info = null;
        this.audio_port = 22222;
        this.video_port = 44444;
        this.listeners = new ArrayList<MediaListener>();
        Arrays.sort(this.receivableJmfVideoFormats);
        int[] nArray2 = this.receivableJmfVideoFormats;
        int n = 0;
        int n2 = nArray2.length;
        while (n < n2) {
            format = nArray2[n];
            this.availableVideoFormats.add(format);
            ++n;
        }
        Arrays.sort(this.receivableJmfAudioFormats);
        nArray2 = this.receivableJmfAudioFormats;
        n = 0;
        n2 = nArray2.length;
        while (n < n2) {
            format = nArray2[n];
            this.availableAudioFormats.add(format);
            ++n;
        }
    }

    public MediaReceiver(int port) throws UnknownHostException {
        int[] nArray = new int[7];
        nArray[0] = 4;
        nArray[1] = 3;
        nArray[3] = 5;
        nArray[4] = 6;
        nArray[5] = 8;
        nArray[6] = 15;
        this.receivableJmfAudioFormats = nArray;
        this.availableVideoFormats = new ArrayList<Integer>();
        this.availableAudioFormats = new ArrayList<Integer>();
        this.dataSync = new Object();
        this.listener = new WaitingListener();
        this.dataReceived = false;
        this.info = null;
        this.audio_port = 22222;
        this.video_port = 44444;
        this.listeners = new ArrayList<MediaListener>();
        this.info = new SessionInformation[1];
        InetAddress addr = InetAddress.getByName("localhost");
        this.info[0] = new SessionInformation(addr.getHostAddress(), port);
    }

    public MediaReceiver(SessionDescription sdp) throws UnknownHostException {
        int[] nArray = new int[7];
        nArray[0] = 4;
        nArray[1] = 3;
        nArray[3] = 5;
        nArray[4] = 6;
        nArray[5] = 8;
        nArray[6] = 15;
        this.receivableJmfAudioFormats = nArray;
        this.availableVideoFormats = new ArrayList<Integer>();
        this.availableAudioFormats = new ArrayList<Integer>();
        this.dataSync = new Object();
        this.listener = new WaitingListener();
        this.dataReceived = false;
        this.info = null;
        this.audio_port = 22222;
        this.video_port = 44444;
        this.listeners = new ArrayList<MediaListener>();
        this.info = this.getSessionInformations(sdp);
    }

    public void receiveMedia() throws MediaException, IOException {
        this.initialize(this.info);
        this.play();
    }

    public void receiveMedia(SessionDescription sdp) throws MediaException, IOException {
        if (this.isPlaying()) {
            this.setNewSessionDescription(sdp);
            return;
        }
        this.info = this.getSessionInformations(sdp);
        this.initialize(this.info);
        this.play();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(SessionInformation[] sessions) throws IOException, MediaException {
        this.mgrs = new RTPManager[sessions.length];
        this.adapter = new RTPSocketAdapter[sessions.length];
        int i = 0;
        while (i < sessions.length) {
            SessionInformation session = sessions[i];
            System.err.println("  - Open RTP session for: addr: " + session.addr + " port: " + session.port + " ttl: " + session.ttl);
            this.mgrs[i] = RTPManager.newInstance();
            this.mgrs[i].addReceiveStreamListener((ReceiveStreamListener)this);
            this.adapter[i] = new RTPSocketAdapter(InetAddress.getLocalHost(), session.port, session.ttl);
            this.mgrs[i].initialize((RTPConnector)this.adapter[i]);
            BufferControl bc = (BufferControl)this.mgrs[i].getControl("javax.media.control.BufferControl");
            if (bc != null) {
                bc.setBufferLength(350L);
            }
            ++i;
        }
        long then = System.currentTimeMillis();
        long waitingPeriod = 30000L;
        try {
            Object object = this.dataSync;
            synchronized (object) {
                while (!this.dataReceived && System.currentTimeMillis() - then < waitingPeriod) {
                    if (!this.dataReceived) {
                        System.err.println("  - Waiting for RTP data to arrive...");
                    }
                    this.dataSync.wait(1000L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!this.dataReceived) {
            this.close();
            throw new MediaException("No RTP data was received.");
        }
        MediaReceiveEvent evt = new MediaReceiveEvent(this, MediaReceiveEvent.EventType.RECEIVE);
        this.dispatchEvent(evt);
    }

    public void setNewSessionDescription(SessionDescription sdp) throws IOException, MediaException {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.isPlaying()) {
            this.close();
        }
        SessionInformation[] info = this.getSessionInformations(sdp);
        this.initialize(info);
    }

    private SessionInformation[] getSessionInformations(SessionDescription sdp) throws UnknownHostException {
        MediaDescription[] media = sdp.getMediaDescriptions();
        SessionInformation[] info = new SessionInformation[media.length];
        Connection c = sdp.getConnection();
        InetAddress addr = InetAddress.getByName(c.getAddress());
        int i = 0;
        MediaDescription[] mediaDescriptionArray = media;
        int n = 0;
        int n2 = mediaDescriptionArray.length;
        while (n < n2) {
            MediaDescription md = mediaDescriptionArray[n];
            Media m = md.getMedia();
            int port = m.getPort();
            info[i++] = new SessionInformation(addr.getHostAddress(), port);
            ++n;
        }
        return info;
    }

    public void play() {
        if (this.video_player != null) {
            this.video_player.start();
        }
        if (this.audio_player != null) {
            this.audio_player.start();
        }
    }

    public void stop() {
        if (this.video_player != null) {
            this.video_player.stop();
        }
        if (this.audio_player != null) {
            this.audio_player.stop();
        }
    }

    public boolean isPlaying() {
        if (this.video_player != null) {
            boolean a = this.video_player.getState() == 600;
            return a;
        }
        return false;
    }

    public Component getControlPanelComponent() {
        if (this.audio_player != null) {
            return this.audio_player.getControlPanelComponent();
        }
        if (this.video_player != null) {
            return this.video_player.getControlPanelComponent();
        }
        throw new NullPointerException("Player\u304c\u4f5c\u3089\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public Component getVisualComponent() {
        if (this.video_player != null) {
            return this.video_player.getVisualComponent();
        }
        throw new NullPointerException("Player\u304c\u4f5c\u3089\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    synchronized void close() {
        this.dataReceived = false;
        int i = 0;
        while (i < this.mgrs.length) {
            if (this.mgrs[i] != null) {
                this.mgrs[i].removeTargets("Closing session from VideoPlayer");
                this.mgrs[i].dispose();
                this.mgrs[i] = null;
            }
            ++i;
        }
        if (this.adapter != null) {
            RTPSocketAdapter[] rTPSocketAdapterArray = this.adapter;
            int n = 0;
            int n2 = rTPSocketAdapterArray.length;
            while (n < n2) {
                RTPSocketAdapter a = rTPSocketAdapterArray[n];
                if (a != null) {
                    a.close();
                    a = null;
                }
                ++n;
            }
        }
        if (this.video_player != null) {
            this.video_player.close();
            this.video_player.deallocate();
        }
        if (this.audio_player != null) {
            this.audio_player.close();
            this.audio_player.deallocate();
        }
        MediaReceiveEvent evt = new MediaReceiveEvent(this, MediaReceiveEvent.EventType.TERMINATE);
        this.dispatchEvent(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(ReceiveStreamEvent evt) {
        block22: {
            Participant participant = evt.getParticipant();
            ReceiveStream stream = evt.getReceiveStream();
            if (evt instanceof RemotePayloadChangeEvent) {
                System.err.println("  - Received an RTP PayloadChangeEvent.");
                System.err.println("Sorry, cannot handle payload change.");
                this.close();
                return;
            }
            if (evt instanceof NewReceiveStreamEvent) {
                try {
                    stream = ((NewReceiveStreamEvent)evt).getReceiveStream();
                    DataSource ds = stream.getDataSource();
                    RTPControl ctl = (RTPControl)ds.getControl("javax.media.rtp.RTPControl");
                    if (ctl != null) {
                        System.err.println("  - Recevied new RTP stream: " + ctl.getFormat());
                    } else {
                        System.err.println("  - Recevied new RTP stream");
                    }
                    if (participant == null) {
                        System.err.println("      The sender of this stream had yet to be identified.");
                    } else {
                        System.err.println("      The stream comes from: " + participant.getCNAME());
                    }
                    Format receivedMediaFormat = ctl.getFormat();
                    Player p = Manager.createPlayer((DataSource)ds);
                    if (p == null) {
                        return;
                    }
                    if (receivedMediaFormat instanceof AudioFormat) {
                        this.audio_player = p;
                    } else {
                        this.video_player = p;
                    }
                    p.realize();
                    p.addControllerListener((ControllerListener)this.listener);
                    Object object = this.listener;
                    synchronized (object) {
                        this.listener.waitForEvent(300);
                    }
                    object = this.dataSync;
                    synchronized (object) {
                        this.dataReceived = true;
                        this.dataSync.notifyAll();
                        break block22;
                    }
                }
                catch (Exception e) {
                    System.err.println("NewReceiveStreamEvent exception " + e.getMessage());
                    return;
                }
            }
            if (evt instanceof StreamMappedEvent) {
                if (stream != null && stream.getDataSource() != null) {
                    DataSource ds = stream.getDataSource();
                    RTPControl ctl = (RTPControl)ds.getControl("javax.media.rtp.RTPControl");
                    System.err.println("  - The previously unidentified stream ");
                    if (ctl != null) {
                        System.err.println("      " + ctl.getFormat());
                    }
                    System.err.println("      had now been identified as sent by: " + participant.getCNAME());
                }
            } else if (evt instanceof ByeEvent) {
                System.err.println("  - Got \"bye\" from: " + participant.getCNAME());
                this.close();
            }
        }
    }

    public void addMediaListener(MediaListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeMediaListener(MediaListener listener) {
        return this.listeners.remove(listener);
    }

    private void dispatchEvent(MediaReceiveEvent e) {
        for (MediaListener listener : this.listeners) {
            switch (e.type) {
                case RECEIVE: {
                    listener.receiveMedia(e);
                    break;
                }
                case TERMINATE: {
                    listener.terminateMedia(e);
                }
            }
        }
    }

    public SessionDescription getResponseSessionDescription(SessionDescription sdp) {
        SessionDescription ret = SDPGenerator.getResponseSessionDescription(sdp);
        return ret;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        try {
            MediaReceiver receiver = new MediaReceiver(44444);
            receiver.addMediaListener(new MediaListener(){

                public void receiveMedia(MediaReceiveEvent e) {
                    JFrame jf = new JFrame();
                    MediaReceiver receiver = (MediaReceiver)e.getSource();
                    jf.setLayout(new BorderLayout());
                    Component video = receiver.getVisualComponent();
                    video.setPreferredSize(new Dimension(640, 480));
                    jf.add(video, "Center");
                    jf.add(receiver.getControlPanelComponent(), "South");
                    jf.setVisible(true);
                    jf.pack();
                    jf.setDefaultCloseOperation(3);
                }

                public void terminateMedia(MediaReceiveEvent e) {
                    System.out.println("Bye");
                    System.exit(1);
                }
            });
            receiver.receiveMedia();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SessionDescription getRequestSessionDescription() throws UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        List<Integer> audio = null;
        SessionDescription sdp = SDPGenerator.getRequestSessionDescription(0, "media_sender", "-", addr, audio, this.audio_port, this.availableVideoFormats, this.video_port);
        return sdp;
    }
}

