/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.media;

import java.awt.Component;
import java.io.IOException;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Manager;
import javax.media.MediaException;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.protocol.DataSource;
import javax.swing.JFrame;
import net.sourceforge.jsdp.Media;
import net.sourceforge.jsdp.MediaDescription;
import net.sourceforge.jsdp.SessionDescription;

public class AudioReceiver {
    MediaLocator locator;
    Player player;
    SessionDescription sdp;
    WaitingListener listener;

    public void receiveMedia(SessionDescription sdp) throws MediaException {
        try {
            MediaDescription[] mls;
            int port = 0;
            MediaDescription[] mediaDescriptionArray = mls = sdp.getMediaDescriptions();
            int n = 0;
            int n2 = mediaDescriptionArray.length;
            while (n < n2) {
                MediaDescription md = mediaDescriptionArray[n];
                Media media = md.getMedia();
                if (media.getMediaType().equals("audio")) {
                    port = media.getPort();
                }
                ++n;
            }
            String url = "rtp://:" + port + "/audio";
            this.locator = new MediaLocator(url);
            this.createPlayer();
            this.player.prefetch();
            this.player.start();
            this.listener.waitForEvent(600);
            this.sdp = sdp;
        }
        catch (IOException e) {
            this.player.close();
            throw new MediaException(e.getMessage());
        }
    }

    public void receiveMedia(int port) throws MediaException {
        try {
            String url = "rtp://:" + port + "/audio";
            this.locator = new MediaLocator(url);
            this.createPlayer();
            this.player.prefetch();
            this.player.start();
        }
        catch (IOException e) {
            this.player.close();
            throw new MediaException(e.getMessage());
        }
    }

    public boolean isPlaying() {
        return this.player.getState() == 600;
    }

    public void stop() {
        this.player.close();
    }

    public Component getControlPanelComponent() {
        if (this.player != null) {
            return this.player.getControlPanelComponent();
        }
        throw new NullPointerException("Player\u304c\u4f5c\u3089\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    private void createPlayer() throws IOException, MediaException {
        if (this.locator == null) {
            throw new NullPointerException("Locator is null");
        }
        DataSource dataSource = Manager.createDataSource((MediaLocator)this.locator);
        this.player = Manager.createPlayer((DataSource)dataSource);
        this.listener = new WaitingListener();
        this.player.addControllerListener((ControllerListener)this.listener);
        this.player.realize();
        this.listener.waitForEvent(300);
    }

    public static void main(String[] args) {
        AudioReceiver receiver = new AudioReceiver();
        try {
            receiver.receiveMedia(22224);
            JFrame jf = new JFrame();
            jf.add(receiver.getControlPanelComponent());
            jf.setVisible(true);
            jf.pack();
            jf.setDefaultCloseOperation(3);
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    class WaitingListener
    implements ControllerListener {
        Thread th;
        int state;
        int previous;

        WaitingListener() {
        }

        public void waitForEvent(final int state) {
            this.state = state;
            this.th = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (WaitingListener.this.previous < state) {
                                this.wait();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            this.th.start();
            try {
                this.th.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void controllerUpdate(ControllerEvent evt) {
            System.out.println(evt.toString());
            Player p = (Player)evt.getSourceController();
            this.previous = p.getState();
            if (this.th == null) {
                return;
            }
            if (p.getState() >= this.state) {
                Thread thread = this.th;
                synchronized (thread) {
                    this.th.notifyAll();
                }
            }
        }
    }
}

