/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.http;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import javax.sip.address.SipURI;
import jp.ac.naka.ec.EventSource;
import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.db.TupleSpaceAdapter;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.sip.SipCore;
import org.apache.log4j.Logger;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.ResourceHandler;

public class HttpCore
extends EventSource {
    private static Logger logger = Logger.getLogger(HttpCore.class);
    HttpServer server;
    EntityContainer source;
    public static int DEFAULT_PORT = 8080;
    public static String VALUE_PARAM = "value";
    public static String TARGET_PARAM = "target";
    public static String AJAX_REQUEST_PATH = "event/ajax";

    public void init(EntityContainer source, Properties prop) throws Exception {
        String t = prop.getProperty("port");
        int port = DEFAULT_PORT;
        if (!t.equals("") || t != null) {
            port = Integer.parseInt(t);
        }
        this.server = new HttpServer();
        this.source = source;
        SocketListener listener = new SocketListener();
        listener.setPort(port);
        this.server.addListener((HttpListener)listener);
        HttpContext context = new HttpContext();
        context.setContextPath("/");
        context.setResourceBase("./html");
        context.addHandler((HttpHandler)new MyHttpHandler());
        this.server.addContext(context);
        this.server.start();
    }

    public boolean isStarted() {
        if (this.server == null) {
            return false;
        }
        return this.server.isStarted();
    }

    public void stopServer() throws InterruptedException {
        this.server.stop();
    }

    class MyHttpHandler
    extends ResourceHandler {
        private static final long serialVersionUID = -3390140933419713641L;

        MyHttpHandler() {
        }

        public void handle(String pathInContext, String pathParams, HttpRequest req, HttpResponse res) throws HttpException, IOException {
            if (!"GET".equals(req.getMethod()) && !"POST".equals(req.getMethod())) {
                return;
            }
            logger.info((Object)("Request to : " + pathInContext));
            String res_str = "YES";
            String target = req.getParameter(TARGET_PARAM);
            if (pathInContext.equals(AJAX_REQUEST_PATH)) {
                int count = 0;
                String temp = req.getParameter("count");
                try {
                    if (temp != null) {
                        count = Integer.valueOf(temp);
                        res_str = ((TupleSpaceAdapter)HttpCore.this.dispatcher).getDataByXML(target, count);
                    } else {
                        res_str = ((TupleSpaceAdapter)HttpCore.this.dispatcher).getDataByXML(target);
                        if (res_str.equals("")) {
                            res_str = ((TupleSpaceAdapter)HttpCore.this.dispatcher).getDataByXML(target, 1);
                        }
                    }
                }
                catch (SQLException e) {
                    logger.warn((Object)"Error while processing Database", (Throwable)e);
                    res_str = "Error while processing Database";
                }
            } else {
                String longitude;
                String latitude;
                String value = req.getParameter(VALUE_PARAM);
                if (value == null) {
                    super.handle(pathInContext, pathParams, req, res);
                    return;
                }
                logger.info((Object)("Receive value : " + value));
                EntityEvent evt = null;
                Location location = null;
                String location_name = req.getParameter("location");
                if (location_name != null && (latitude = req.getParameter("latitude")) != null && (longitude = req.getParameter("longitude")) != null) {
                    location = new Location(location_name, latitude, longitude);
                    HttpCore.this.source.setLocation(location);
                }
                if (target != null) {
                    SipURI target_uri = null;
                    target_uri = (SipURI)SipCore.getInstance().createURI(target);
                    if (target_uri != null) {
                        EntityImpl e = new EntityImpl(target_uri);
                        evt = new EntityEvent(value, e, HttpCore.this.source, EntityEvent.EventType.MESSAGE);
                    } else {
                        res_str = "Invalid URI :" + target;
                    }
                } else {
                    evt = new EntityEvent(value, null, (Entity)HttpCore.this.source);
                    evt.setBroadcast(true);
                }
                if (evt != null) {
                    if (evt.isBroadcast()) {
                        logger.info((Object)"Dispatch Event by Broadcast.");
                    } else {
                        logger.info((Object)("Dispatch Event to " + target));
                    }
                    HttpCore.this.dispatcher.dispatchEvent(evt);
                }
            }
            BufferedOutputStream bos = new BufferedOutputStream(res.getOutputStream());
            byte[] b = res_str.getBytes();
            bos.write(b, 0, b.length);
            bos.flush();
        }
    }
}

