/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.sip.address.URI;
import jp.ac.naka.ec.EventSource;
import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.db.DatabaseConnector;
import jp.ac.naka.ec.db.TupleSpaceAdapter;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityConfigParser;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityEventDispatcher;
import jp.ac.naka.ec.entity.EntityListener;
import jp.ac.naka.ec.manager.ECManager;
import jp.ac.naka.ec.media.MediaTransmitter;
import jp.ac.naka.ec.sip.SipCore;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static final String config_file = "./config/container.properties";
    private static final String sip_config = "./config/sip.properties";
    public static final String entity_config = "./config/entities.xml";
    private static final String jmf_config_file = "./config/jmf.properties";
    public static String log4j_properties = "./config/log4j.properties";
    public static Logger logger = Logger.getLogger(Main.class);
    private static boolean use_db = false;
    public static DatabaseConnector con;
    private static int manager_port;
    private static int sip_port;
    private static String parent_uri;
    private static Location location;

    static {
        manager_port = 8080;
        sip_port = 5060;
        parent_uri = "";
    }

    public static void main(String[] args) {
        try {
            Entity[] entities;
            Main.init();
            Properties prop = new Properties();
            Main.procProperty(prop);
            ECManager.getInstance().setPort(manager_port);
            String hostname = Main.getHostName();
            String ipAddr = Main.getIpAddress(hostname);
            EntityContainerImpl parent = null;
            TupleSpaceAdapter dispatcher = TupleSpaceAdapter.getInstance();
            EntityContainerImpl container = new EntityContainerImpl();
            container.setName(hostname);
            container.setLocal(true);
            if (location != null) {
                container.setLocation(location);
            }
            dispatcher.addEntityListener(container);
            SipCore core = SipCore.getInstance();
            SipCore.initialize(hostname, ipAddr, sip_port, sip_config);
            URI uri = core.createURI("sip:" + hostname + "@" + ipAddr + ":" + sip_port);
            container.setURI(uri);
            core.setEntityContainer(container);
            Entity[] entityArray = entities = EntityConfigParser.parse(entity_config);
            int n = 0;
            int n2 = entityArray.length;
            while (n < n2) {
                Entity e = entityArray[n];
                URI e_uri = core.createURI("sip:" + e.getName() + "@" + ipAddr + ":" + sip_port);
                e.setParent(container);
                e.setURI(e_uri);
                if (location != null) {
                    e.setLocation(location);
                }
                container.addEntity(e);
                ++n;
            }
            if (use_db) {
                con = DatabaseConnector.getInstance();
                if (!con.hasTables()) {
                    con.createNewTable();
                }
                dispatcher.setDatabaseConnector(con);
            }
            if (parent_uri != null && !parent_uri.equals("")) {
                URI p_uri = core.createURI(parent_uri);
                parent = new EntityContainerImpl();
                parent.setLocal(false);
                parent.setURI(p_uri);
                container.setParent(parent);
            }
            List<EntityListener> plugins = Main.invokePlugin(container);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static List<EntityListener> invokePlugin(EntityContainer container) {
        ArrayList<EntityListener> loadedPlugins = new ArrayList<EntityListener>();
        File folder = new File("plugin");
        if (!folder.exists() || !folder.isDirectory()) {
            folder.mkdir();
        }
        File[] plugins = folder.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.getName().equals("CVS")) {
                    return false;
                }
                return pathname.isDirectory();
            }
        });
        EntityEventDispatcher dispatcher = EntityEventDispatcher.getInstance();
        File[] fileArray = plugins;
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File plugin = fileArray[n];
            File[] files = plugin.listFiles(new FilenameFilter(){

                public boolean accept(File path, String name) {
                    return name.equals("plugin.properties");
                }
            });
            if (files.length == 0) {
                logger.warn((Object)("In " + plugin.getName() + ", There is no plugin.properties file."));
                break;
            }
            File propfile = files[0];
            Properties prop = new Properties();
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(propfile);
                    prop.load(fis);
                    fis.close();
                    String classname = prop.getProperty("className");
                    String pluginname = prop.getProperty("pluginName");
                    Class<?> clazz = Class.forName(classname);
                    EntityListener instance = (EntityListener)clazz.newInstance();
                    if (instance instanceof EventSource) {
                        EventSource source = (EventSource)instance;
                        source.init(container, prop);
                    }
                    dispatcher.addEntityListener(instance);
                    logger.info((Object)("Plugin loaded successfully :" + pluginname));
                    loadedPlugins.add(instance);
                }
                catch (Exception e) {
                    logger.error((Object)("Error while processing plugin :" + plugin.getName()), (Throwable)e);
                    if (fis == null) break;
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                    break;
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ++n;
        }
        return loadedPlugins;
    }

    private static void init() throws IOException {
        File config = new File(config_file);
        File entities = new File(entity_config);
        if (!config.exists() && config.createNewFile()) {
            logger.info((Object)"Create: container.properties");
        }
        if (!entities.exists() && entities.createNewFile()) {
            logger.info((Object)"Create: entities.xml");
        }
    }

    private static void procProperty(Properties prop) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(config_file);
            prop.load(fis);
            fis.close();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        String port = prop.getProperty("port");
        sip_port = !port.equals("") ? Integer.valueOf(port) : 5060;
        parent_uri = prop.getProperty("parent_uri");
        PropertyConfigurator.configure((String)log4j_properties);
        use_db = Main.initDatabase(prop);
        String a = prop.getProperty("location");
        if (a != null && !a.equals("")) {
            String lat = prop.getProperty("latitude");
            String lon = prop.getProperty("longitude");
            location = new Location(a, lat, lon);
        }
        try {
            try {
                fis = new FileInputStream(jmf_config_file);
                Properties jmf_setting = new Properties();
                jmf_setting.load(fis);
                String temp = jmf_setting.getProperty("video_device_name");
                if (temp != null || !temp.equals("")) {
                    MediaTransmitter.defaultVideoDeviceName = temp;
                }
                if ((temp = jmf_setting.getProperty("audio_device_name")) != null || !temp.equals("")) {
                    MediaTransmitter.defaultAudioDeviceName = temp;
                }
                if ((temp = jmf_setting.getProperty("video_capture_format")) != null || !temp.equals("")) {
                    MediaTransmitter.defaultVideoFormatString = temp;
                }
                if ((temp = jmf_setting.getProperty("audio_capture_format")) != null || !temp.equals("")) {
                    MediaTransmitter.defaultAudioFormatString = temp;
                }
            }
            catch (IOException iOException) {}
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    private static String getIpAddress(String name) throws IOException {
        String address = "";
        Enumeration<NetworkInterface> enuIfs = NetworkInterface.getNetworkInterfaces();
        if (enuIfs != null) {
            while (enuIfs.hasMoreElements()) {
                NetworkInterface ni = enuIfs.nextElement();
                Enumeration<InetAddress> enuAddrs = ni.getInetAddresses();
                boolean flag = false;
                while (enuAddrs.hasMoreElements()) {
                    InetAddress in4 = enuAddrs.nextElement();
                    if (ni.getName().equals("lo")) continue;
                    if (in4 instanceof Inet4Address) {
                        address = in4.getHostAddress();
                        flag = true;
                        break;
                    }
                    if (flag) break;
                }
                if (flag) break;
            }
        }
        return address;
    }

    private static boolean initDatabase(Properties prop) {
        String driver_class = prop.getProperty("jdbc_driver_class");
        String jdbc_address = prop.getProperty("jdbc_address");
        String catalog_name = prop.getProperty("db_catalog_name");
        String user = prop.getProperty("db_user");
        String pwd = prop.getProperty("db_password");
        if (driver_class == null || driver_class.equals("") || jdbc_address == null || jdbc_address.equals("")) {
            return false;
        }
        DatabaseConnector.driver_name = driver_class;
        DatabaseConnector.db_location = jdbc_address;
        DatabaseConnector.catalog = catalog_name;
        DatabaseConnector.user = user;
        DatabaseConnector.pass = pwd;
        String a = prop.getProperty("use_database");
        if (a.equals("YES") || a.equals("true")) {
            return true;
        }
        prop.setProperty("use_database", "NO");
        return false;
    }

    private static String getHostName() throws IOException {
        String name = "";
        Enumeration<NetworkInterface> enuIfs = NetworkInterface.getNetworkInterfaces();
        if (enuIfs != null) {
            block0: while (enuIfs.hasMoreElements()) {
                NetworkInterface ni = enuIfs.nextElement();
                if (ni.getName().equals("lo")) continue;
                Enumeration<InetAddress> enuAddrs = ni.getInetAddresses();
                while (enuAddrs.hasMoreElements()) {
                    InetAddress in4 = enuAddrs.nextElement();
                    if (!(in4 instanceof Inet4Address)) continue;
                    name = in4.getHostName();
                    continue block0;
                }
            }
        }
        return name;
    }
}

