#
# RSSitem̍ŏdescriptionTextSetter
#
class TextSetter_HasChildren:
    def getChildren(self):
        return self.titles
    def getText(self, key):
        if key=="Reload":
            self.reload()
            return ""

        return self.items[key]


class GetFromRSS(TextSetter_HasChildren):
    name="RSS1.0擾"
    def __init__(self):
        self.items={"Reload":self.reload}
        self.titles=["Reload"]
        
    def reload(self):
        import urllib
        d=urllib.urlopen(self.rss).read()
        import xmllib
        class MyParser(xmllib.XMLParser):
            inItem=0
            inDesc=0
            inTitle=0
            descList=[]
            titleList=[]
            def startDesc(self, attr):
                if self.inItem:
                    self.inDesc=1
            def endDesc(self):
                self.inDesc=0
            def startTitle(self, attr):
                if self.inItem:
                    self.inTitle=1
            def endTitle(self):
                self.inTitle=0
            def startItem(self, attr):
                self.inItem=1
            def endItem(self):
                self.inItem=0
            def handle_data(self, data):
                if self.inDesc:
                    self.descList.append(data)
                if self.inTitle:
                    self.titleList.append(data)

        p=MyParser()
        self.setElements(p)
        p.feed(d)
        p.close()
        self.__init__()
        for i in range(len(p.titleList)):
            self.titles.append(p.titleList[i])
            self.items[p.titleList[i]]=p.descList[i]

    def setElements(self, p):
        p.elements={
            "http://purl.org/rss/1.0/ item":
            (p.startItem, p.endItem),
            "http://purl.org/rss/1.0/ description":
            (p.startDesc, p.endDesc),
            "http://purl.org/rss/1.0/ title":
            (p.startTitle, p.endTitle)
        }

class GetFromRSS2(GetFromRSS):
    name="RSS2.0擾"
    def setElements(self, p):
        p.elements={
            "item":
            (p.startItem, p.endItem),
            "description":
            (p.startDesc, p.endDesc),
            "title":
            (p.startTitle, p.endTitle)
        }
