/* ~Օʉ
 * Copyright (C) 2004 Kagetani Hideto
 */
#ifndef __UI_H__
#define __UI_H__

#include <windows.h>
#include "option.h"

#ifdef __cplusplus
extern "C" {
#endif

#define WM_USER_UICTL	(WM_USER+1)
#define UICTL_METER1INIT	0
#define UICTL_METER2INIT	1
#define UICTL_METER1SETPOS	2
#define UICTL_METER2SETPOS	3
#define UICTL_SETTING		4
#define UICTL_DISPINFO		5
#define UICTL_GETARGREADER	6
#define UICTL_GETARGWRITER	7

void UISetHWND(HWND hWnd);
BOOL UICheckAbort();
void UISetAbort();
void UIClearAbort();
int UIDispMessage(const char *message, int type);
int UIFileDialog(BOOL bOpen, char *filename, int size, const char *suffix);
int UINetDialog(BOOL bServer, char *remote, int size, int *port_number);

/* type value */
#define UIDMT_INFORMATION	0
#define UIDMT_ERROR		1
#define UIDMT_QUESTION	2
/* return value */
#define UIDMRET_OK		0
#define UIDMRET_CANCEL	1

void UIMeter1Initialize(const char *message);
void UIMeter2Initialize(const char *message);
void UIMeter1Update(float percentage);
void UIMeter2Update(float percentage);
void UIDispInfo(const char *message);

int UISetting(OPTIONS *option);

#ifdef __cplusplus
}
#endif

#endif /* !__EVENT_H__ */
