/* ~Օʉ
 * Copyright (C) 2004 Kagetani Hideto
 */
// SettingDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "enbanfukusya.h"
#include "SettingDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSettingDlg _CAO



CSettingDlg::CSettingDlg(CWnd* pParent /*=NULL*/)
	: CThemeDialog(CSettingDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSettingDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
	m_pOption = NULL;
}


void CSettingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSettingDlg)
	DDX_Control(pDX, IDC_CHK_OUTSIDE, m_ChkOutside);
	DDX_Control(pDX, IDC_STC_TEMPPATH, m_StcTempPath);
	DDX_Control(pDX, IDC_EDT_TEMPPATH, m_EdtTempPath);
	DDX_Control(pDX, IDOK, m_BtnOK);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	DDX_Control(pDX, IDC_STC_WRITESPEED, m_StcWriteSpeed);
	DDX_Control(pDX, IDC_STC_READSPEED, m_StcReadSpeed);
	DDX_Control(pDX, IDC_CMB_WRITESPEED, m_CmbWriteSpeed);
	DDX_Control(pDX, IDC_CMB_READSPEED, m_CmbReadSpeed);
	DDX_Control(pDX, IDC_CHK_TESTWRITE, m_ChkTestWrite);
	DDX_Control(pDX, IDC_CHK_ONTHEFLY, m_ChkOnthefly);
	DDX_Control(pDX, IDC_CHK_DAO, m_ChkDAO);
	DDX_Control(pDX, IDC_CHK_BUFE, m_ChkBUFE);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSettingDlg, CDialog)
	//{{AFX_MSG_MAP(CSettingDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSettingDlg bZ[W nh

BOOL CSettingDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	CThemeSet *pTheme = GetTheme();
	m_BtnOK.SetTheme(pTheme);
	m_BtnCancel.SetTheme(pTheme);
	m_CmbReadSpeed.SetTheme(pTheme);
	m_CmbWriteSpeed.SetTheme(pTheme);
	m_StcReadSpeed.SetTheme(pTheme);
	m_StcWriteSpeed.SetTheme(pTheme);
	m_ChkBUFE.SetTheme(pTheme);
	m_ChkTestWrite.SetTheme(pTheme);
	m_ChkDAO.SetTheme(pTheme);
	m_ChkOnthefly.SetTheme(pTheme);
	m_ChkOutside.SetTheme(pTheme);
	m_StcTempPath.SetTheme(pTheme);

	if(m_pOption==NULL){
		EndDialog(IDCANCEL);
		return TRUE;
	}

	// `FbNԐݒ
	m_ChkBUFE.SetCheckState(m_pOption->bufe);
	m_ChkTestWrite.SetCheckState(m_pOption->test_write);
	m_ChkOnthefly.SetCheckState(m_pOption->on_the_fly);
	m_ChkDAO.SetCheckState(m_pOption->dao);
	m_ChkOutside.SetCheckState(m_pOption->outside);
	// L/ݒ
	m_ChkBUFE.EnableWindow((m_pOption->flags & OPFLG_BUFE)!=0);
	m_ChkTestWrite.EnableWindow((m_pOption->flags & OPFLG_TESTWRITE)!=0);
	m_ChkOnthefly.EnableWindow((m_pOption->flags & OPFLG_ONTHEFLY)!=0);
	m_ChkDAO.EnableWindow((m_pOption->flags & OPFLG_DAO)!=0);
	m_ChkOutside.EnableWindow((m_pOption->flags & OPFLG_OUTSIDE)!=0);
	// xݒ荀ڂݒ
	SetSpeedItems(&m_CmbReadSpeed, m_pOption->read_speed,
			(m_pOption->flags & OPFLG_DVD)!=0,
			m_pOption->readable_speed, m_pOption->num_readable_speed);
	SetSpeedItems(&m_CmbWriteSpeed, m_pOption->write_speed,
			(m_pOption->flags & OPFLG_DVD)!=0,
			m_pOption->writable_speed, m_pOption->num_writable_speed);
	// ꎞfBNg̃ftHgݒ
	m_EdtTempPath.SetWindowText(m_pOption->temppath);
	m_EdtTempPath.EnableWindow((m_pOption->flags & OPFLG_TEMPPATH)!=0);
	m_EdtTempPath.SetLimitText(_MAX_PATH);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}


void CSettingDlg::SetSpeedItems(CComboBox *pCB, int nDefaultSpeed, BOOL bDVD,
								BYTE *speeds, int num_speeds)
{
	int i;
	char buf[32];

	pCB->ResetContent();
	pCB->AddString(bDVD ? "W" : "ő呬");
	for(i=0; i<num_speeds; i++){
		_snprintf(buf, sizeof(buf), "%d{", speeds[i]);
		pCB->AddString(buf);
		if(speeds[i]==nDefaultSpeed){
			pCB->SetCurSel(i+1);
		}
	}
	if(pCB->GetCurSel() == CB_ERR){
		pCB->SetCurSel(0);
	}
}

void CSettingDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	if((m_pOption->flags & OPFLG_BUFE)!=0)
		m_pOption->bufe = m_ChkBUFE.GetCheckState();
	if((m_pOption->flags & OPFLG_TESTWRITE)!=0)
		m_pOption->test_write = m_ChkTestWrite.GetCheckState();
	if((m_pOption->flags & OPFLG_ONTHEFLY)!=0)
		m_pOption->on_the_fly = m_ChkOnthefly.GetCheckState();
	if((m_pOption->flags & OPFLG_DAO)!=0)
		m_pOption->dao = m_ChkDAO.GetCheckState();
	if((m_pOption->flags & OPFLG_OUTSIDE)!=0)
		m_pOption->outside = m_ChkOutside.GetCheckState();

	CString csSpeed;
	int sel;
	sel = m_CmbReadSpeed.GetCurSel();
	if(sel!=CB_ERR){
		m_CmbReadSpeed.GetLBText(sel, csSpeed);
		m_pOption->read_speed = atoi((LPCTSTR)csSpeed);
	}
	sel = m_CmbWriteSpeed.GetCurSel();
	if(sel!=CB_ERR){
		m_CmbWriteSpeed.GetLBText(sel, csSpeed);
		m_pOption->write_speed = atoi((LPCTSTR)csSpeed);
	}

	if((m_pOption->flags & OPFLG_TEMPPATH)!=0)
		m_EdtTempPath.GetWindowText(m_pOption->temppath, _MAX_PATH);

	CDialog::OnOK();
}
