#import "SettingDlgControl.h"

@implementation SettingDlgControl

- (IBAction)buttonCancel:(id)sender
{
	[NSApp stopModalWithCode: RET_ABORT];
}

- (IBAction)buttonStart:(id)sender
{
	[NSApp stopModalWithCode: RET_OK];
}

- (int)openSettingDialog:(OPTIONS *)option
{
	int ret;
	
	[checkTestWrite setState : (option->test_write ? NSOnState:NSOffState)];
	[checkBUFE setState : (option->bufe ? NSOnState:NSOffState)];
	[checkOnTheFly setState : (option->on_the_fly ? NSOnState:NSOffState)];
	[checkDiscAtOnce setState : (option->dao ? NSOnState:NSOffState)];
	[checkOutSide setState : (option->outside ? NSOnState:NSOffState)];
	
	[checkTestWrite setEnabled : ((option->flags & OPFLG_TESTWRITE) ? YES:NO)];
	[checkBUFE setEnabled : ((option->flags & OPFLG_BUFE) ? YES:NO)];
	[checkOnTheFly setEnabled : ((option->flags & OPFLG_ONTHEFLY) ? YES:NO)];
	[checkDiscAtOnce setEnabled : ((option->flags & OPFLG_DAO) ? YES:NO)];
	[checkOutSide setEnabled : ((option->flags & OPFLG_OUTSIDE) ? YES:NO)];
	
	[textTempDirectory setStringValue :
		[NSString stringWithCString : option->temppath]];
	[textTempDirectory setEnabled : ((option->flags & OPFLG_TEMPPATH) ? YES:NO)];
	
	[self setSpeedItems: readSpeedSel
			   defValue: option->read_speed
				  isdvd: (option->flags & OPFLG_DVD)
			  speedList: option->readable_speed
			   numSpeed: option->num_readable_speed];
	[self setSpeedItems: writeSpeedSel
			   defValue: option->write_speed
				  isdvd: (option->flags & OPFLG_DVD)
			  speedList: option->writable_speed
			   numSpeed: option->num_writable_speed];
	/* _CAO\ */
	ret = [NSApp runModalForWindow: settingPanel];
	[settingPanel orderOut: self];
	if(ret!=RET_OK)
		return ret;
	
	option->test_write = [checkTestWrite state]==NSOnState;
	option->bufe = [checkBUFE state]==NSOnState;
	option->on_the_fly = [checkOnTheFly state]==NSOnState;
	option->dao = [checkDiscAtOnce state]==NSOnState;
	option->outside = [checkOutSide state]==NSOnState;
	
	option->read_speed = atoi([[readSpeedSel titleOfSelectedItem] cString]);
	option->write_speed = atoi([[writeSpeedSel titleOfSelectedItem] cString]);
	
	const char *tempPath = [[textTempDirectory stringValue] cString];
	strncpy(option->temppath, tempPath, _MAX_PATH-1);
	option->temppath[_MAX_PATH-1] = '\0';
	return RET_OK;
}

- (void)setSpeedItems:(id)target
	     defValue:(int)defaultSpeed
		isdvd:(BOOL)dvd
	    speedList:(BYTE *)speeds
	     numSpeed:(int)num_speed
{
	int i;
	char buf[32];
	
	[target removeAllItems];
	[target addItemWithTitle:
		  [NSString stringWithCString: (dvd ? "W":"ő呬")]];

	for(i=0; i<num_speed; i++){
		snprintf(buf, sizeof(buf), "%d{", speeds[i]);
		[target addItemWithTitle:
			[NSString stringWithCString: buf]];
		if(speeds[i]==defaultSpeed){
			[target selectItemAtIndex: i+1];
		}
	}
}


@end
