/**
 * @file netdlg.h
 * @brief ͥåȥ
 * @author BananaJinn
 * @version $Id: netdlg.c,v 1.4 2007/10/02 16:51:47 bananajinn Exp $
 * ʣ̲
 * Copyright (c) 2004-2007 Kagetani Hideto(BananaJinn)
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cmd.h"
#include "netdlg.h"
#include "common.h"
#include "text.h"
#include "main.h"

#define DEFAULT_PORTNUMBER 11877

int NetDialog(int bServer, char *remote, int size, int *port_number)
{
  const char *a = NULL;

  printf("=== %s ===\n", GT("netdlg"));
  
  *remote = '\0';
  *port_number = DEFAULT_PORTNUMBER;

  a = bServer ? GetArgWriter() : GetArgReader();
  if(a != NULL){
	  const char *wp = strchr(a, ':');
	  if(wp == NULL){
		  if(!bServer){
			  strncpy(remote, a, size-1);
			  remote[size-1] = '\0';
		  }
	  }
	  else{
		  if(!bServer){
			  int remlen = wp-a;
			  if(size-1 < remlen){
				  remlen = size-1;
			  }
			  strncpy(remote, a, remlen);
			  remote[remlen] = '\0';
		  }
		  int p = atoi(wp+1);
		  if(p > 0){
			  *port_number = p;
		  }
	  }
	  if(!bServer){
		  printf("%s : %s\n", GT("Connect host"), remote);
	  }
	  printf("%s : %d\n", GT("Port number"), *port_number);
	  return NDR_OK;
  }

  if(!bServer){
	  InputString(GT("Connect host") /* ³襢ɥ쥹 */,
				  remote, size);
  }
  InputNumber(GT("Port number") /* ݡֹ */,
	      port_number);

  return NDR_OK;
}
