/**
 * @file filedlg.c
 * @brief Linux󥽡ǥե
 * @author BananaJinn
 * @version $Id: filedlg.c,v 1.4 2007/10/02 16:51:47 bananajinn Exp $
 * ʣ̲
 * Copyright (c) 2004-2007 Kagetani Hideto(BananaJinn)
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "text.h"
#include "typedefs.h"
#include "common.h"
#include "filedlg.h"
#include "main.h"

/**
 * @brief ե̾
 * @param[in] bOpen ե򳫤ξTRUE¸ξFALSE
 * @param[out] filename Ϥե̾
 * @param[in] size ե̾ǼХåեΥ
 * @param[in] suffix եޥȤĥ
 * @retval FDR_OK λ
 * @retval FDR_CANCEL 󥻥
 * @note ߤϤǤʤϤΤߡ
 */
int FileDialog(int bOpen, char *filename, int size, const char *suffix)
{
  const char *title = bOpen ? GT("open file") : GT("save file");
  const char *a = NULL;

  a = bOpen ? GetArgReader() : GetArgWriter();
  if(a != NULL){
	  strncpy(filename, a, size-1);
	  filename[size-1] = '\0';
	  printf("%s : %s\n", title, filename);
	  return FDR_OK;
  }
#if 0
  char *mask=NULL;

  if(bOpen && suffix!=NULL){
    mask=(char *)malloc(strlen(suffix)+1+2);
  }
  if(mask!=NULL){
    strcpy(mask, "*.");
    strcat(mask, suffix);
  }
#endif
  InputString(title, filename, size);
  return FDR_OK;
}
