/*
 * @file scan.c
 * @brief u
 * @author BananaJinn
 * @version $Id: scan.c,v 1.13 2007/10/02 15:10:52 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "mem.h"
#include "aspi.h"
#include "cmd.h"
#include "scan.h"
#include "log.h"


#define MAX_SCAN 16*6

#if !defined(MACOSX)
static BOOL IsWriterDrive(CMDDRIVE *drive)
{
	int ret;
	struct _MODEPAGE2A *mp2a;
	
	ret = SendModeSense(drive, MSPC_CURRENT, 0x2a);
	if(ret!=RET_OK)
		return FALSE;
	mp2a = (struct _MODEPAGE2A *)
		(drive->data_buf + (drive->cmd_type==CMDDRVCTYPE_ATAPI ? 8:16));
	if(mp2a->cd_r_write || mp2a->cd_rw_write || mp2a->dvd_r_write)
		return TRUE;

	/* GetConfig.Ȃƃ_ */
	return FALSE;
}
#endif


SCAN_t *ScanDrive(BOOL bWriter)
{
#if !defined(MACOSX)
	const BYTE inqcmd[12]={CMD_INQUIRY, 0, 0, 0, 96, 0, 0, 0, 0, 0, 0, 0};
	DWORD timeout=0;
	BYTE device_type;
	int ret;	
#endif
	int num_drive=0;
	int hid, tid, max_hid, max_tid;
	SCAN_t *drives;
	CMDDRIVE drive;

	drives = (SCAN_t *)MemNew(sizeof(SCAN_t)*MAX_SCAN);

#if defined(WIN32) || defined(linux)
	max_hid = GetHostAdapterCount();
	max_tid = GetMaxTarget();
#else
	/* MacOSX */
	max_hid = 1;
	max_tid = GetDriveCount();
#endif

	memset(&drive, 0, sizeof(CMDDRIVE));
	InitializeCmdDrive(&drive, 0x10000, 0, CMDDRVTYPE_DRIVE);

	for(hid=0; hid<max_hid; hid++){
		for(tid=0; tid<max_tid; tid++){
			if(num_drive>=MAX_SCAN-1){
				break;
			}
			DebugLog("[%d:%d]\n", hid, tid);
#ifdef MACOSX
			if(GetInquiryString(tid, drive.data_buf, drive.bufsize)){
				continue;
			}
			sprintf(drives[num_drive].inqdata, "[%d:%d] ", hid, tid);
			strcpy(drives[num_drive].inqdata+strlen(drives[num_drive].inqdata),
				drive.data_buf);
#else
			DebugLog("[%d:%d] SetAspiSetting Start\n", hid, tid);
			if(SetDriveAspiSetting(&drive, &hid, &tid, &timeout)!=RET_OK){
				DebugLog("[%d:%d] select error\n", hid, tid);
				continue;
			}
			DebugLog("[%d:%d] SetAspiSetting End\n", hid, tid);
# ifdef WIN32
			if(CheckDiscDevice(&drive.u.drive)==0){
				DebugLog("[%d:%d] not a disc device\n", hid, tid);
				continue;
			}
# endif
			memset(drive.data_buf, 0, 96*2);
			ret = SendCmd(&drive, (BYTE *)inqcmd, 96, REQ_DATAIN);
			if(ret!=RET_OK){
				/*DebugLog("[%d:%d] inquiry command error(%d:%d)\n", hid, tid, ret, drive.srb->SRB_Status);*/
				continue;
			}
#if 0
			if(!memcmp(drive.data_buf, drive.data_buf+96, 96)){
				DebugLog("[%d:%d] no inquiry data\n", hid, tid);
				continue;
			}
			/* f[^MĂOKƂ */
#endif
			device_type = drive.data_buf[0]&0x1f;
			if(device_type!=4 && device_type!=5){
				DebugLog("[%d:%d] device=%d\n", hid, tid, device_type);
				continue;
			}
			DebugLog("[%d:%d] OK\n", hid, tid);
#if defined(WIN32)
			if(UsingSPTI())
				sprintf(drives[num_drive].inqdata, "[%c:] ", tid+'C');
			else
#endif
			sprintf((char *)drives[num_drive].inqdata, "[%d:%d] ", hid, tid);
			drives[num_drive].inqdata[strlen((char *)drives[num_drive].inqdata)+40]='\0';
			strncpy((char *)drives[num_drive].inqdata+strlen((char *)drives[num_drive].inqdata),
					(char *)drive.data_buf+8, 40);
#endif
			drives[num_drive].hid = hid;
			drives[num_drive].tid = tid;
			if(bWriter){
#ifdef MACOSX
				if(MMCIsWriterDrive(tid, drive.data_buf, drive.bufsize)==FALSE){
					continue;
				}
#else
				if(IsWriterDrive(&drive)==FALSE){
					continue;
				}
#endif
			}
			num_drive++;
		}
	}

	drives[num_drive].inqdata[0] = '\0';

	FreeCmdDrive(&drive);
	return drives;
}

