/**
 * @file offsetiso.c
 * @brief ISOC[WOɂ炷
 * @author BananaJinn
 * @version $Id: offsetiso.c,v 1.5 2007/01/30 15:49:27 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "mem.h"
#include "cmd.h"
#include "ui.h"
#include "text.h"
#include "log.h"

#define BLOCKKIND_VOLUME 0
#define BLOCKKIND_PATHTABLE_L_PVD 1
#define BLOCKKIND_PATHTABLE_M_PVD 2
#define BLOCKKIND_PATHTABLE_L_SVD 3
#define BLOCKKIND_PATHTABLE_M_SVD 4
#define BLOCKKIND_DIRECTORY 5

#define GET4BYTES(p,l) (l) ? Get4bytesLE(p) : Get4bytes(p)
#define GET2BYTES(p,l) (l) ? Get4bytesLE(p) : Get4bytes(p)
#define SET4BYTES(p,v,l) (l) ? Set4bytesLE(p,v) : Set4bytes(p,v)
#define SET2BYTES(p,v,l) (l) ? Set2bytesLE(p,v) : Set2bytes(p,v)


/**
 * @brief uAhXێ\
 */
typedef struct {
  int kind;	/**< f[^̎ */
  DWORD lba;	/**< AhX */
  DWORD size;	/**< TCY */
} REPLBA;


static DWORD gOffset = 0;	/**< Oɂ炷ubN */
static REPLBA *gRepLBA = NULL;	/**< uAhXz */
static int gNumRepLBA = 0;	/**< uAhXzTCY */
static int gNext = -1;		/**< ɎQƂuAhX */
static BYTE gVolumeDesc = 0;	/**< {[Lqq̎ */


/**
 * @brief uAhXzɒǉ
 * @param[in] kind f[^̎
 * @param[in] lba AhX
 * @param[in] size TCY
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 * @retval	RET_MEMERR G[
 */
static int AddRepLBA(int kind, DWORD lba, DWORD size)
{
  int i;

  lba += gOffset;

  gRepLBA = MemResize(gRepLBA, sizeof(REPLBA)*(gNumRepLBA+1));
  if(gRepLBA == NULL){
    return RET_MEMERR;
  }
  for(i=0; i<gNumRepLBA; i++){
    if(lba < gRepLBA[i].lba){
      break;
    }
    else if(lba == gRepLBA[i].lba){
      return RET_OK;
    }
  }

  if((gNumRepLBA-i) > 0){
    memmove(gRepLBA+i+1, gRepLBA+i, (gNumRepLBA-i)*sizeof(REPLBA));
  }
  gRepLBA[i].kind = kind;
  gRepLBA[i].lba = lba;
  gRepLBA[i].size = size;
  gNumRepLBA++;

  if(gNext < 0){
    gNext = 0;
  }
  return RET_OK;
}


/**
 * @brief uAhXz
 */
static void FreeRepLBA()
{
  MemFree(gRepLBA);
  gRepLBA = NULL;
  gNumRepLBA = 0;
}

/**
 * @brief fBNgR[hOFFSET
 * @param[in] top ubN擪|C^
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int OffsetLbaAtDirectoryRecord(BYTE *top)
{
  DWORD lba;
  DWORD size;
  int ret;
  int i;

  lba = Get4bytesLE(top+0x02);
  size = Get4bytesLE(top+0x0a);
  if(top[0x19] & 0x02){
    /* t@CtOfBNg̏ꍇ */
    i = 0;
    while(size > 0){
      ret = AddRepLBA(BLOCKKIND_DIRECTORY, lba+i,
		      size>0x800 ? 0x800:size);
      if(ret != RET_OK)
	return ret;
      size -= size>0x800 ? 0x800:size;
      i++;
    }
  }
  Set4bytesLE(top+0x02, lba+gOffset);
  Set4bytes(top+0x06, lba+gOffset);

  return RET_OK;
}


/**
 * @brief pXe[uR[hOFFSET
 * @param[in] top ubN擪|C^
 * @param[in] kind ubN(BLOCKKIND_PATHTABLE_[LM]_[PS]VD)
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int OffsetLbaAtPathTableRecord(BYTE *top, int kind)
{
  DWORD lba;
  //int ret;
  BOOL le = FALSE;

  le = (kind==BLOCKKIND_PATHTABLE_L_PVD) || (kind==BLOCKKIND_PATHTABLE_L_SVD);
  lba = GET4BYTES(top+0x02, le);
#if 0
  ret = AddRepLBA(BLOCKKIND_DIRECTORY, lba);
  if(ret != RET_OK)
    return ret;
#endif
  SET4BYTES(top+0x02, lba+gOffset, le);

  return RET_OK;
}


/**
 * @brief {[ubNOFFSET
 * @param[in] top ubN擪|C^
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int OffsetLbaAtVolume(BYTE *top)
{
  DWORD size;
  DWORD blocks, i;
  DWORD lba;
  int ret;

  if(top[0] == 0x03){
    /* ?? */
    lba = Get4bytesLE(top+0x48);
    Set4bytesLE(top+0x48, lba+gOffset);
    Set4bytes(top+0x4c, lba+gOffset);
  }
  else if((top[0] == 0x01) || (top[0] == 0x02)){
    /* PVD/SVD */

    /* pXe[uTCY(bytes) */
    size = Get4bytes(top+0x88);
    blocks = (size+2047)/2048;
    
    /* L`pXe[uLBA */
    lba = Get4bytesLE(top+0x8c);
    for(i=0; i<blocks; i++){
      ret = AddRepLBA(top[0] == 1 ?
		      BLOCKKIND_PATHTABLE_L_PVD : BLOCKKIND_PATHTABLE_L_SVD,
		      lba+i, size);
      if(ret != RET_OK)
	return ret;
    }
    Set4bytesLE(top+0x8c, lba+gOffset);
    DebugLog("L type PathTable : 0x%08lX -> 0x%08lX\n",
	     lba, lba+gOffset);
    
    /* CL^pXe[uLBA */
    lba = Get4bytesLE(top+0x90);
    if(lba != 0x00000000){
      for(i=0; i<blocks; i++){
	ret = AddRepLBA(top[0] == 1 ?
			BLOCKKIND_PATHTABLE_L_PVD : BLOCKKIND_PATHTABLE_L_SVD,
			lba+i, size);
	if(ret != RET_OK)
	  return ret;
      }
      Set4bytesLE(top+0x90, lba+gOffset);
      DebugLog("L type PathTable2 : 0x%08lX -> 0x%08lX\n",
	       lba, lba+gOffset);
    }
    
    /* M`pXe[uLBA */
    lba = Get4bytes(top+0x94);
    for(i=0; i<blocks; i++){
      ret = AddRepLBA(top[0] == 1 ?
		      BLOCKKIND_PATHTABLE_M_PVD : BLOCKKIND_PATHTABLE_M_SVD,
		      lba+i, size);
      if(ret != RET_OK)
	return ret;
    }
    Set4bytes(top+0x94, lba+gOffset);
    DebugLog("M type PathTable : 0x%08lX -> 0x%08lX\n",
	     lba, lba+gOffset);
    
    /* CM^pXe[uLBA */
    lba = Get4bytes(top+0x98);
    if(lba != 0x00000000){
      for(i=0; i<blocks; i++){
	ret = AddRepLBA(top[0] == 1 ?
			BLOCKKIND_PATHTABLE_M_PVD : BLOCKKIND_PATHTABLE_M_SVD,
			lba+i, size);
	if(ret != RET_OK)
	  return ret;
      }
      Set4bytes(top+0x98, lba+gOffset);
      DebugLog("M type PathTable2 : 0x%08lX -> 0x%08lX\n",
	       lba, lba+gOffset);
    }
    
    ret = OffsetLbaAtDirectoryRecord(top+0x9c);
    if(ret != RET_OK)
      return ret;
  }

  return RET_OK;
}

/**
 * @brief pXe[uubNOFFSET
 * @param[in] top ubN擪|C^
 * @param[in] kind ubN(BLOCKKIND_PATHTABLE_[LM]_[PS]VD)
 * @param[in] size pXe[uTCY(oCg)
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int OffsetLbaAtPathTable(BYTE *top, int kind, DWORD size)
{
  DWORD reclen = 0;
  DWORD i = 0;
  int ret;

  while(i < size){
    ret = OffsetLbaAtPathTableRecord(top+i, kind);
    if(ret != RET_OK){
      return ret;
    }
    reclen = top[i]+8;
    if(reclen & 1) reclen++;
    i += reclen;
  }

  return RET_OK;
}

/**
 * @brief fBNgubNOFFSET
 * @param[in] top ubN擪|C^
 * @param[in] size fBNgTCY(oCg)
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int OffsetLbaAtDirectory(BYTE *top, DWORD size)
{
  DWORD reclen = 0;
  DWORD i = 0;
  int ret;

  while(i < size){
    reclen  = top[i];
    if(reclen == 0){
      break;
    }
    ret = OffsetLbaAtDirectoryRecord(top+i);
    if(ret != RET_OK){
      return ret;
    }
    i += reclen;
  }

  return RET_OK;
}

/**
 * @brief ނɉĕ
 * @param[in] top 1ubN̐擪|C^
 * @param[in] 
 * @param[in] size TCY(oCg)
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int OffsetLBA(BYTE *top, int kind, DWORD size)
{
  int ret;

  switch(kind){
  case BLOCKKIND_VOLUME:
    ret = OffsetLbaAtVolume(top);
    break;
  case BLOCKKIND_PATHTABLE_L_PVD:
  case BLOCKKIND_PATHTABLE_L_SVD:
  case BLOCKKIND_PATHTABLE_M_PVD:
  case BLOCKKIND_PATHTABLE_M_SVD:
    ret = OffsetLbaAtPathTable(top, kind, size);
    break;
  case BLOCKKIND_DIRECTORY: 
    ret = OffsetLbaAtDirectory(top, size);
    break;
  default:
    return RET_NG;
  }
  return ret;
}
  

/**
 * @brief ISO9660C[WOɂ炷ubNݒ肷B
 * @param[in] offset ubN
 */
void SetOffset(DWORD offset)
{
  gOffset = offset;

  /*  */
  FreeRepLBA();
  gNext = -1;
  gVolumeDesc = 0;
}


/**
 * @brief ISO9660C[WOɂ炷ubN擾B
 * @return ubN
 */
DWORD GetOffset()
{
  return gOffset;
}


/**
 * @brief ISO9660C[WOɂ炷
 * @param[in] data f[^
 * @param[in] lba f[^̃AhX
 * @param[in] blocksize 1ubÑoCg(2048)
 * @param[in] len f[^̒(ubN)
 */
int OffsetISO(BYTE *data, DWORD lba, DWORD blocksize, DWORD len)
{
  DWORD i;
  DWORD curr_lba;
  BYTE *top;
  int ret;

  if(gOffset == 0){
    return RET_OK;
  }

  for(i=0; i<len; i++){
    top = data+i*blocksize;
    if(gVolumeDesc < 0xff){
      if(!memcmp(top+1, "CD001", 5)){
	gVolumeDesc = top[0];
	ret = OffsetLBA(top, BLOCKKIND_VOLUME, 0);
	if(ret != RET_OK){
	  FreeRepLBA();
	  return ret;
	}
      }
    }
    else if(gNext >= 0){
      curr_lba = lba+i;
      while(curr_lba > gRepLBA[gNext].lba){
	if(gNext >= gNumRepLBA-1){
	  /* I(ȍ~̃f[^ɂ̓AhXuȂ) */
	  gNext = -1;
	  return RET_OK;
	}
	gNext++;
      }
      if(curr_lba == gRepLBA[gNext].lba){
	ret = OffsetLBA(top, gRepLBA[gNext].kind, gRepLBA[gNext].size);
	if(ret != RET_OK){
	  FreeRepLBA();
	  return ret;
	}
	if(gNext >= gNumRepLBA-1){
	  /* I(ȍ~̃f[^ɂ̓AhXuȂ) */
	  gNext = -1;
	  return RET_OK;
	}
      }
    }
  }
  
  return RET_OK;
}
