/**
 * @file emg.c
 * @brief ~ՕʉC[Wǂݏ
 * @author BananaJinn
 * @version $Id: emg.c,v 1.4 2007/01/30 15:49:27 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "mem.h"
#include "aspi.h"
#include "struct.h"
#include "cmd.h"
#include "drive.h"
#include "text.h"
#include "log.h"
#include "ui.h"
#include "discinfo.h"
#include "emg.h"

/**
 * @brief ~ՕʉC[W̃gbN
 */
typedef struct {
  BYTE mark[4];			/**< "ETRK" */
  struct _TRACKINFO trackinfo;	/**< hCuǂݏogbN */
  BYTE mode2;			/**< mode2ǂ */
  BYTE isrc[12+1];		/**< ISRC */
  BYTE tao;			/**< TAOǂ */
  BYTE pause_len[2];		/**< AUDIO PAUSE LENGTH */
} EMG_TRACKINFO;

/**
 * @brief ~ՕʉC[W̃fBXN
 */
typedef struct {
  BYTE mark[4];			/**< "EDSC" */
  BYTE disc_type;		/**< fBXN */
  BYTE disc_stat;		/**< fBXNXe[^X */
  BYTE last_sess_stat;		/**< ŏIZbVXe[^X */
  BYTE mcn[13+1];		/**< fBAJ^Oԍ */
  BYTE last_addr[4];		/**< ŏIAhX(LBA) */
  BYTE sessions[2];		/**< ZbV */
  BYTE tracks[2];		/**< gbN */
  BYTE cdtext_size[4];		/**< CD-TEXTTCY(oCg) */
} EMG_DISCINFO;

#define EMGMARK_SIZE 4

#define EMGMARK_DISCINFO ((BYTE *)"EDSC")
#define EMGMARK_CDTEXT ((BYTE *)"ECDT")
#define EMGMARK_TRACKINFO ((BYTE *)"ETRK")
#define EMGMARK_DATA ((BYTE *)"EDTA")

/**
 * @brief ~ՕʉC[W`ŃfBXNt@Cɏ
 * @param[in] image C[Wt@C
 * @param[in] discinfo ރfBXN
 * @retval RET_OK	I
 * @retval RET_NG	G[
 */
int EmgWriteDiscInformation(IMAGEFILE *image, CPDISCINFO *discinfo)
{
  union {
    EMG_DISCINFO disc;
    EMG_TRACKINFO track;
  } buf;
  EMG_DISCINFO *emg_disc = &buf.disc;
  EMG_TRACKINFO *emg_track = &buf.track;
  int ret;
  WORD track;
  BYTE version[4];
  CPTRACKINFO *trackinfo;

  Set4bytes(version, EMGFILE_VERSION);
  ret = WriteImageFile(image, &version, sizeof(version), TRUE);
  if(ret!=RET_OK){
    return ret;
  }

  memset(emg_disc, 0, sizeof(EMG_DISCINFO));
  memcpy(emg_disc->mark, EMGMARK_DISCINFO, EMGMARK_SIZE);
  emg_disc->disc_type = discinfo->disc_type;
  emg_disc->disc_stat = discinfo->disc_stat;
  emg_disc->last_sess_stat = discinfo->last_sess_stat;
  memcpy(emg_disc->mcn, discinfo->media_catalog_number,
	 sizeof(emg_disc->mcn));
  Set4bytes(emg_disc->last_addr, discinfo->last_addr);
  Set2bytes(emg_disc->sessions, discinfo->sessions);
  Set2bytes(emg_disc->tracks, discinfo->tracks);
  Set4bytes(emg_disc->cdtext_size, discinfo->cdtext_size);
  ret = WriteImageFile(image, emg_disc, sizeof(EMG_DISCINFO), TRUE);
  if(ret!=RET_OK){
    return ret;
  }

  if(discinfo->cdtext_size > 0){
    ret = WriteImageFile(image, EMGMARK_CDTEXT, EMGMARK_SIZE, TRUE);
    if(ret!=RET_OK){
      return ret;
    }
    ret = WriteImageFile(image, discinfo->cdtext, discinfo->cdtext_size, TRUE);
    if(ret!=RET_OK){
      return ret;
    }
  }

  for(track=0; track<discinfo->tracks; track++){
    trackinfo = &discinfo->trackinfo[track];
    memset(emg_track, 0, sizeof(EMG_TRACKINFO));
    memcpy(emg_track->mark, EMGMARK_TRACKINFO, EMGMARK_SIZE);
    memcpy(&emg_track->trackinfo, &trackinfo->trackinfo,
	   sizeof(struct _TRACKINFO));
    emg_track->mode2 = trackinfo->mode2;
    memcpy(emg_track->isrc, trackinfo->isrc, sizeof(emg_track->isrc));
    emg_track->tao = (BYTE)(trackinfo->tao ? 1:0);
    Set2bytes(emg_track->pause_len, trackinfo->pause_len);
    ret = WriteImageFile(image, emg_track, sizeof(EMG_TRACKINFO), TRUE);
    if(ret!=RET_OK){
      return ret;
    }
  }

  ret = WriteImageFile(image, EMGMARK_DATA, EMGMARK_SIZE, TRUE);
  if(ret!=RET_OK){
    return ret;
  }

  return RET_OK;
}


/**
 * @brief C[Wt@C4oCgǂݎA}[NmF
 * @param[in] image C[Wt@C
 * @param[in] mark }[N4oCg
 * @retval RET_OK	mFOK
 * @retval RET_NG	mFNG
 */
static int EmgCheckMark(IMAGEFILE *image, BYTE *mark)
{
  int ret;
  BYTE buf[EMGMARK_SIZE];

  ret = ReadImageFile(image, buf, sizeof(buf), TRUE);
  if(ret!=RET_OK){
    return ret;
  }
  if(memcmp(buf, mark, sizeof(buf))){
    UIDispMessage(MSG_INVALID_IMAGE_FILE
		  /*"sȃC[Wt@CłB"*/, UIDMT_ERROR);
    return RET_NG;
  }
  return RET_OK;
}


/**
 * @brief ~ՕʉC[W`ŃfBXNt@Cǂݍ
 * @param[in] image C[Wt@C
 * @param[out] discinfo ރfBXN
 * @retval RET_OK	I
 * @retval RET_NG	G[
 */
int EmgReadDiscInformation(IMAGEFILE *image, CPDISCINFO *discinfo)
{
  union {
    EMG_DISCINFO disc;
    EMG_TRACKINFO track;
  } buf;
  EMG_DISCINFO *emg_disc = &buf.disc;
  EMG_TRACKINFO *emg_track = &buf.track;
  int ret;
  WORD track;
  BYTE version[4];
  CPTRACKINFO *trackinfo;

  ret = ReadImageFile(image, version, sizeof(version), TRUE);
  if(ret!=RET_OK){
    return ret;
  }
  if(Get4bytes(version) != EMGFILE_VERSION){
    UIDispMessage(MSG_INVALID_IMAGE_FILE
		  /*"sȃC[Wt@CłB"*/, UIDMT_ERROR);
    return RET_NG;
  }
  
  ret = ReadImageFile(image, emg_disc, sizeof(EMG_DISCINFO), TRUE);
  if(ret!=RET_OK){
    return ret;
  }
  if(memcmp(emg_disc->mark, EMGMARK_DISCINFO, EMGMARK_SIZE)){
    UIDispMessage(MSG_INVALID_IMAGE_FILE
		  /*"sȃC[Wt@CłB"*/, UIDMT_ERROR);
    return RET_NG;
  }
  memset(discinfo, 0, sizeof(CPDISCINFO));
  discinfo->disc_type = emg_disc->disc_type;
  discinfo->disc_stat = emg_disc->disc_stat;
  discinfo->last_sess_stat = emg_disc->last_sess_stat;
  memcpy(discinfo->media_catalog_number, emg_disc->mcn,
	  sizeof(discinfo->media_catalog_number));
  discinfo->last_addr = Get4bytes(emg_disc->last_addr);
  discinfo->sessions = Get2bytes(emg_disc->sessions);
  discinfo->tracks = Get2bytes(emg_disc->tracks);
  discinfo->cdtext_size = Get4bytes(emg_disc->cdtext_size);

  if(discinfo->cdtext_size > 0){
    ret = EmgCheckMark(image, EMGMARK_CDTEXT);
    if(ret!=RET_OK){
      return ret;
    }
    discinfo->cdtext = MemNew(discinfo->cdtext_size);
    if(discinfo->cdtext == NULL){
      return RET_MEMERR;
    }
    ret = ReadImageFile(image, discinfo->cdtext, discinfo->cdtext_size,
			TRUE);
    if(ret!=RET_OK){
      MemFree(discinfo->cdtext);
      discinfo->cdtext = NULL;
      return ret;
    }
  }

  discinfo->trackinfo = MemNew(sizeof(CPTRACKINFO)*discinfo->tracks);
  if(discinfo->trackinfo == NULL){
    MemFree(discinfo->cdtext);
    discinfo->cdtext = NULL;
    return RET_MEMERR;
  }
  memset(discinfo->trackinfo, 0, sizeof(CPTRACKINFO)*discinfo->tracks);
  for(track=0; track<discinfo->tracks; track++){
    trackinfo = &discinfo->trackinfo[track];
    ret = ReadImageFile(image, emg_track, sizeof(EMG_TRACKINFO), TRUE);
    if(ret!=RET_OK){
      MemFree(discinfo->trackinfo);
      discinfo->trackinfo = NULL;
      MemFree(discinfo->cdtext);
      discinfo->cdtext = NULL;
      return ret;
    }
    if(memcmp(emg_track->mark, EMGMARK_TRACKINFO, EMGMARK_SIZE)){
      MemFree(discinfo->trackinfo);
      discinfo->trackinfo = NULL;
      MemFree(discinfo->cdtext);
      discinfo->cdtext = NULL;
      UIDispMessage(MSG_INVALID_IMAGE_FILE
		    /*"sȃC[Wt@CłB"*/, UIDMT_ERROR);
      return RET_NG;
    }
    memcpy(&trackinfo->trackinfo, &emg_track->trackinfo,
	   sizeof(struct _TRACKINFO));
    trackinfo->mode2 = emg_track->mode2;
    memcpy(trackinfo->isrc, emg_track->isrc, sizeof(trackinfo->isrc));
    trackinfo->tao = emg_track->tao != 0;
    trackinfo->pause_len = Get2bytes(emg_track->pause_len);
  }

  ret = EmgCheckMark(image, EMGMARK_DATA);
  if(ret!=RET_OK){
    MemFree(discinfo->trackinfo);
    discinfo->trackinfo = NULL;
    MemFree(discinfo->cdtext);
    discinfo->cdtext = NULL;
    return ret;
  }

  return RET_OK;
}
