/**
 * ʣ̲
 * Copyright (c) 2004 Kagetani Hideto
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <malloc.h>

#include "aspi.h"
#include "logo.xpm"
#include "scan.h"
#include "cmd.h"
#include "cmdlog.h"
#include "ui.h"
#include "copydisc.h"
#include "messagebox.h"
#include <libintl.h>
#include "text.h"

static BOOL g_bRunningCopy=FALSE;
static GtkWidget *g_MainWindow=NULL;
static GtkWidget *g_btnStartCopy=NULL;
static GtkWidget *g_btnExit=NULL;
static GtkWidget *g_optMenu1=NULL;
static GtkWidget *g_optMenu2=NULL;
static GtkWidget *g_labelInfo=NULL;
static SCAN_t *g_ReaderList=NULL;
static SCAN_t *g_WriterList=NULL;
static int g_AllWritableDrives= -1;
static int g_ReaderISO = -1;
static int g_WriterISO = -1;
static int g_ReaderEmg = -1;
static int g_WriterEmg = -1;
static int g_ReaderNet = -1;
static int g_WriterNet = -1;

static int scan_drive(GtkWidget *optmenu, BOOL writer)
{
  GtkWidget *menu;
  GtkWidget *menuitem;
  SCAN_t *drives;
  int count;

  drives = ScanDrive(writer);
  if(drives==NULL){
    return RET_NG;
  }

  gtk_option_menu_remove_menu(GTK_OPTION_MENU(optmenu));
  menu = gtk_menu_new();

  for(count=0; strlen((char *)drives[count].inqdata)!=0; count++){
	  menuitem = gtk_menu_item_new_with_label((char *)drives[count].inqdata);
    gtk_object_set_user_data(GTK_OBJECT(menuitem), GINT_TO_POINTER(count));
    gtk_menu_append(GTK_MENU(menu), menuitem);
    gtk_widget_show(menuitem);
  }

  if(writer){
    menuitem = gtk_menu_item_new_with_label(GT("All devices that have inserted disc for record")
					    /*"ϿѥǥѤ"*/);
    gtk_object_set_user_data(GTK_OBJECT(menuitem), GINT_TO_POINTER(count));
    gtk_menu_append(GTK_MENU(menu), menuitem);
    gtk_widget_show(menuitem);
    g_AllWritableDrives = count;
    count++;
  }

  menuitem = gtk_menu_item_new_with_label(GT("ISO image file")
					  /*"ISO᡼ե"*/);
  gtk_object_set_user_data(GTK_OBJECT(menuitem), GINT_TO_POINTER(count));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_widget_show(menuitem);
  if(writer){
    g_WriterISO = count;
  }
  else{
    g_ReaderISO = count;
  }
  count++;

  menuitem = gtk_menu_item_new_with_label(GT("Enban image file")
					  /*"ץ᡼ե"*/);
  gtk_object_set_user_data(GTK_OBJECT(menuitem), GINT_TO_POINTER(count));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_widget_show(menuitem);
  if(writer){
    g_WriterEmg = count;
  }
  else{
    g_ReaderEmg = count;
  }
  count++;

  menuitem = gtk_menu_item_new_with_label(GT("Network")/*"ͥåȥ"*/);
  gtk_object_set_user_data(GTK_OBJECT(menuitem), GINT_TO_POINTER(count));
  gtk_menu_append(GTK_MENU(menu), menuitem);
  gtk_widget_show(menuitem);
  if(writer){
    g_WriterNet = count;
  }
  else{
    g_ReaderNet = count;
  }
  count++;

  gtk_option_menu_set_menu(GTK_OPTION_MENU(optmenu), menu);

  if(writer)
    g_WriterList = drives;
  else
    g_ReaderList = drives;

  return RET_OK;
}

/*
 * Callbacks
 */
void
on_optionmenu1_map(GtkWidget *widget, gpointer user_data)
{
  scan_drive((GtkWidget *)user_data, FALSE);
}

void
on_optionmenu2_map(GtkWidget *widget, gpointer user_data)
{
  scan_drive((GtkWidget *)user_data, TRUE);
}

void
on_btnStartCopy_clicked(GtkWidget *widget, gpointer user_data)
{
  DRIVEID reader, *writerp=NULL;
  GtkWidget *menu;
  GtkWidget *menuitem;
  int sel_reader, sel_writer;
  int ret;
  int writer_num=1, index;

  if(g_bRunningCopy){
    UISetAbort();
    gtk_widget_set_sensitive(g_btnStartCopy, FALSE);
    return;
  }

	  /* ɥ饤ּ */
  menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(g_optMenu1));
  menuitem = gtk_menu_get_active(GTK_MENU(menu));
  sel_reader = GPOINTER_TO_INT(gtk_object_get_user_data(GTK_OBJECT(menuitem)));
  
  menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(g_optMenu2));
  menuitem = gtk_menu_get_active(GTK_MENU(menu));
  sel_writer = GPOINTER_TO_INT(gtk_object_get_user_data(GTK_OBJECT(menuitem)));

	  /* ѥ */
  writerp = (DRIVEID *)malloc(sizeof(DRIVEID));
  if(writerp==NULL){
    MessageBoxDlg(GT("Error in the initialization of the drive.")
		  /*"֤ν˼Ԥޤ(ݥ顼)"*/, NULL,
		  MBF_TYPEOK|MBF_ICONSTOP);
    return;
  }

	  /*  */
  if(sel_writer == g_AllWritableDrives){
    writer_num = 0;
    for(index=0; strlen((char *)g_WriterList[index].inqdata)!=0; index++){
      if(g_ReaderList[sel_reader].hid == g_WriterList[index].hid &&
		 g_ReaderList[sel_reader].tid == g_WriterList[index].tid){
			/* ɼ̵֤ */
		continue;
      }
      writerp = (DRIVEID *)realloc(writerp, (writer_num+1)*sizeof(DRIVEID));
      if(writerp == NULL){
	MessageBoxDlg(GT("Error in the initialization of the writer drive.")
		      /*"֤ν˼Ԥޤ(ݥ顼)"*/,
		      NULL,
		      MBF_TYPEOK|MBF_ICONSTOP);
	return;
      }
      writerp[writer_num].hid = g_WriterList[index].hid;
      writerp[writer_num].tid = g_WriterList[index].tid;
      writer_num++;
    }
  }
  else if(sel_writer == g_WriterISO){
    writerp->hid = HID_VIRTUAL;
    writerp->tid = CMDDRVTYPE_ISO;
    writer_num = 1;
  }
  else if(sel_writer == g_WriterEmg){
	writerp->hid = HID_VIRTUAL;
	writerp->tid = CMDDRVTYPE_IMAGE;
	writer_num = 1;
  }
  else if(sel_writer == g_WriterNet){
    writerp->hid = HID_VIRTUAL;
    writerp->tid = CMDDRVTYPE_NET;
    writer_num = 1;
  }
  else{
    writerp->hid = g_WriterList[sel_writer].hid;
    writerp->tid = g_WriterList[sel_writer].tid;
    writer_num = 1;
  }

  /* ɹ */
  if(sel_reader == g_ReaderISO){
    reader.hid = HID_VIRTUAL;
    reader.tid = CMDDRVTYPE_ISO;
  }
  else if(sel_reader == g_ReaderEmg){
	reader.hid = HID_VIRTUAL;
	reader.tid = CMDDRVTYPE_IMAGE;
  }
  else if(sel_reader == g_ReaderNet){
    reader.hid = HID_VIRTUAL;
    reader.tid = CMDDRVTYPE_NET;
  }
  else{
    reader.hid = g_ReaderList[sel_reader].hid;
    reader.tid = g_ReaderList[sel_reader].tid;
  }


  UIClearAbort();
  g_bRunningCopy = TRUE;
  gtk_widget_set_sensitive(g_btnExit, FALSE);
  gtk_widget_set_sensitive(g_optMenu1, FALSE);
  gtk_widget_set_sensitive(g_optMenu2, FALSE);
  gtk_label_set_text(GTK_LABEL(GTK_BIN(g_btnStartCopy)->child),
		     GT("Cancel")/*""*/);

  ret = CopyDisc(&reader, writerp, writer_num);
  
  gtk_widget_set_sensitive(g_btnStartCopy, TRUE);
  gtk_widget_set_sensitive(g_btnExit, TRUE);
  gtk_widget_set_sensitive(g_optMenu1, TRUE);
  gtk_widget_set_sensitive(g_optMenu2, TRUE);
  gtk_label_set_text(GTK_LABEL(GTK_BIN(g_btnStartCopy)->child),
		     GT("Start")/*"ʣ̳"*/);
  g_bRunningCopy = FALSE;
  
  /* ֥ */
  free(writerp);

  UIMeter1Initialize(NULL);
  UIMeter2Initialize(NULL);
}

void
on_btnExit_clicked(GtkWidget *widget, gpointer user_data)
{
  gtk_widget_destroy((GtkWidget *)user_data);
}

void
on_mainwindow_destroy(GtkWidget *widget, gpointer user_data)
{
  if(g_ReaderList!=NULL)
    free(g_ReaderList);
  if(g_WriterList!=NULL)
    free(g_WriterList);

  gtk_main_quit();
}

static GtkWidget*
create_mainwindow(void)
{
  GtkWidget *window1;
  GtkWidget *table1;
  GtkWidget *btnExit;
  GtkWidget *optionmenu1;
  GtkWidget *optionmenu1_menu;
  GtkWidget *optionmenu2;
  GtkWidget *optionmenu2_menu;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *label3;
  GtkWidget *label4;
  GtkWidget *progressbar1;
  GtkWidget *progressbar2;
  GtkWidget *btnStartCopy;
  GtkWidget *pixmap1;
  GtkWidget *label_ver;
  GtkWidget *label_info;
  guint table_line=0;
  GdkPixmap *gdkpixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
  char ver_buf[32];

  /* ᥤ󥦥ɥ */
  window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (window1), "window1", window1);
  gtk_window_set_title (GTK_WINDOW (window1), GT("EnbanFukusyaYa")
			/*"ʣ̲"*/);
  /* ơ֥ */
  table1 = gtk_table_new (7, 3, FALSE);
  gtk_widget_ref (table1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "table1", table1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (window1), table1);
  gtk_container_set_border_width (GTK_CONTAINER (table1), 10);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 5);

  /*  */
  colormap = gtk_widget_get_colormap (window1);
  gdkpixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask,
						    NULL, logo_xpm);
  pixmap1 = gtk_pixmap_new (gdkpixmap, mask);
  gdk_pixmap_unref (gdkpixmap);
  gdk_bitmap_unref (mask);

  gtk_widget_ref(pixmap1);
  gtk_object_set_data_full(GTK_OBJECT(window1), "pixmap1", pixmap1,
			   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(pixmap1);
  gtk_table_attach (GTK_TABLE(table1), pixmap1, 0, 3,
		    table_line, table_line+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  
  table_line++;

  /* С */
  sprintf(ver_buf, "Version %s", VERSION);
  label_ver = gtk_label_new(ver_buf);
  gtk_widget_ref(label_ver);
  gtk_object_set_data_full(GTK_OBJECT(window1), "label_ver", label_ver,
						   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(label_ver);
  gtk_table_attach(GTK_TABLE(table1), label_ver, 0, 3,
				   table_line, table_line+1,
				   (GtkAttachOptions)(GTK_FILL),
				   (GtkAttachOptions)(0), 0, 0);
  gtk_misc_set_alignment(GTK_MISC(label_ver), 0.5, 0.5);
  table_line++;

  /* ٥ */
  label1 = gtk_label_new (GT("Reader")/*"ɼ"*/);
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_table_attach (GTK_TABLE (table1), label1, 0, 1,
		    table_line, table_line+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label1), 0, 0.5);

  /* ɹ֥ץ˥塼 */
  optionmenu1 = gtk_option_menu_new ();
  gtk_widget_ref (optionmenu1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "optionmenu1", optionmenu1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (optionmenu1);
  gtk_table_attach (GTK_TABLE (table1), optionmenu1, 1, 2,
		    table_line, table_line+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (optionmenu1, 300, -2);
  optionmenu1_menu = gtk_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu1), optionmenu1_menu);

  /* ʣ̳ϥܥ */
  btnStartCopy = gtk_button_new_with_label (GT("Start")/*"ʣ̳"*/);
  gtk_widget_ref (btnStartCopy);
  gtk_object_set_data_full (GTK_OBJECT (window1), "btnStartCopy", btnStartCopy,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (btnStartCopy);
  gtk_table_attach (GTK_TABLE (table1), btnStartCopy, 2, 3,
		    table_line, table_line+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  table_line++;

  /* ٥ */
  label2 = gtk_label_new (GT("Writer")/*""*/);
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_table_attach (GTK_TABLE (table1), label2, 0, 1,
		    table_line, table_line+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);


  /* ֥ץ˥塼 */
  optionmenu2 = gtk_option_menu_new ();
  gtk_widget_ref (optionmenu2);
  gtk_object_set_data_full (GTK_OBJECT (window1), "optionmenu2", optionmenu2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (optionmenu2);
  gtk_table_attach (GTK_TABLE (table1), optionmenu2, 1, 2,
		    table_line, table_line+1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (optionmenu2, 300, -2);
  optionmenu2_menu = gtk_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu1), optionmenu2_menu);

  /* λܥ */
  btnExit = gtk_button_new_with_label (GT("Quit")/*"λ"*/);
  gtk_widget_ref (btnExit);
  gtk_object_set_data_full (GTK_OBJECT (window1), "btnExit", btnExit,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (btnExit);
  gtk_table_attach (GTK_TABLE (table1), btnExit, 2, 3,
		    table_line, table_line+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  table_line++;

  /* ٥ */
  label3 = gtk_label_new (GT("Total")/*""*/);
  gtk_widget_ref (label3);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label3", label3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label3);
  gtk_table_attach (GTK_TABLE (table1), label3, 0, 1,
		    table_line, table_line+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label3), 0, 0.5);

  /* ĽС1 */
  progressbar1 = gtk_progress_bar_new ();
  gtk_widget_ref (progressbar1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "progressbar1", progressbar1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (progressbar1);
  gtk_table_attach (GTK_TABLE (table1), progressbar1, 1, 3,
		    table_line, table_line+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  table_line++;

  /* ٥ */
  label4 = gtk_label_new (GT("Track")/*"ȥå"*/);
  gtk_widget_ref (label4);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label4", label4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label4);
  gtk_table_attach (GTK_TABLE (table1), label4, 0, 1,
		    table_line, table_line+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label4), 0, 0.5);

  /* ĽС2 */
  progressbar2 = gtk_progress_bar_new ();
  gtk_widget_ref (progressbar2);
  gtk_object_set_data_full (GTK_OBJECT (window1), "progressbar2", progressbar2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (progressbar2);
  gtk_table_attach (GTK_TABLE (table1), progressbar2, 1, 3,
		    table_line, table_line+1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  table_line++;
  /* ɽѥ٥ */
  label_info = gtk_label_new("");
  gtk_widget_ref(label_info);
  gtk_object_set_data_full(GTK_OBJECT(window1), "label_info", label_info,
						   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(label_info);
  gtk_table_attach(GTK_TABLE(table1), label_info, 0, 3,
				   table_line, table_line+1,
				   (GtkAttachOptions)(GTK_FILL),
				   (GtkAttachOptions)(0), 0, 0);
  gtk_misc_set_alignment(GTK_MISC(label_info), 0.5, 0.5);

  
  gtk_signal_connect(GTK_OBJECT(optionmenu1), "map",
		     GTK_SIGNAL_FUNC(on_optionmenu1_map),
		     optionmenu1);
  gtk_signal_connect(GTK_OBJECT(optionmenu2), "map",
		     GTK_SIGNAL_FUNC(on_optionmenu2_map),
		     optionmenu2);
  gtk_signal_connect(GTK_OBJECT(btnStartCopy), "clicked",
		     GTK_SIGNAL_FUNC(on_btnStartCopy_clicked),
		     NULL);
  gtk_signal_connect(GTK_OBJECT(btnExit), "clicked",
		     GTK_SIGNAL_FUNC(on_btnExit_clicked),
		     window1);

  gtk_signal_connect(GTK_OBJECT(window1), "destroy",
		     GTK_SIGNAL_FUNC(on_mainwindow_destroy),
		     NULL);

  g_btnStartCopy = btnStartCopy;
  g_btnExit = btnExit;
  g_optMenu1 = optionmenu1;
  g_optMenu2 = optionmenu2;
  g_labelInfo = label_info;
  g_MainWindow = window1;
  UISetWidgetMeter1(label3, progressbar1);
  UISetWidgetMeter2(label4, progressbar2);
  UISetWidgetInfo(label_info);

  return window1;
}


int
main (int argc, char *argv[])
{
  GtkWidget *mainwindow;

  gtk_set_locale();
#if defined(__MINGW32__)
  char *rc[] = { "gtkrc", "theme\\gtkrc", NULL };
  gtk_rc_set_default_files(rc);
  bindtextdomain("EnbanFukusyaYa", ".");
  bind_textdomain_codeset("EnbanFukusyaYa", "UTF-8");
  textdomain("EnbanFukusyaYa");
#else
  bind_textdomain_codeset("EnbanFukusyaYa", "UTF-8");
  textdomain("EnbanFukusyaYa");
#endif
  gtk_init(&argc, &argv);

  gtk_window_set_default_icon_from_file("/usr/share/pixmaps/EnbanFukusyaYa.png", NULL);

  OpenAspi();

  mainwindow = create_mainwindow();
  gtk_widget_show(mainwindow);

  gtk_main ();

  CloseAspi();

  return 0;
}

