/*
 * @file drive.h
 * @brief hCuANZX
 * @author BananaJinn
 * @version $Id: drive.h,v 1.8 2006/07/02 13:22:56 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */
#ifndef __DRIVE_H__
#define __DRIVE_H__

#include "aspi.h"
#include "netaccess.h"
#include "image.h"

#define CMDDRVTYPE_DRIVE	0
#define CMDDRVTYPE_NET		1
#define CMDDRVTYPE_IMAGE	2
#define CMDDRVTYPE_ISO		3

#define CMDDRVCTYPE_UNKNOWN		-1
#define CMDDRVCTYPE_CHECKING	0
#define CMDDRVCTYPE_ATAPI		1
#define CMDDRVCTYPE_SCSI		2

#define SD_SENSEKEY(d)	((d)->sense_data[2] & 0x0f)
#define SD_ASC(d)		((d)->sense_data[12])
#define SD_ASCQ(d)		((d)->sense_data[13])

/* return value */
#define RET_OK		0
#define RET_ABORT	1
#define RET_READFD	2
#define RET_COMPLETE	3
#define RET_NG		-1
#define RET_TIMEOUT -2
#define RET_CMDERR	-3
#define RET_MEMERR	-4
#define RET_SOCKET	-5

/* reqflag */
#define REQ_NODATA	0x18
#define REQ_DATAOUT	0x10
#define REQ_DATAIN	0x08

#define SENSEDATA_SIZE		0x20

typedef struct {
	BYTE cdb[12];
	BYTE snskey;
	BYTE asc;
	BYTE ascq;
	BYTE reqflag;
	DWORD datalen;
	BYTE *data;
	WORD repeat;
} CMDLOG;


typedef struct {
  int type;		/* CMDDRVTYPE_* */
  union {
	DRIVE drive;
	SOCKCB net;
	IMAGEFILE image;
  } u;
  BOOL own_alloc;	/* ̍\̂Ńobt@Ǘ */
  BYTE *data_buf;
  int bufsize;
  BYTE sense_data[SENSEDATA_SIZE];
  int cmd_type;		/* CMDDRVCTYPE_* */
  BYTE cmdcode;
  CMDLOG *cmdlog;
  int cmdlog_size;
  int cmdlog_start;
  int cmdlog_end;
  DWORD cmdlog_maxdatalen;
  int disc_type;
} CMDDRIVE;


#define REALDRIVE(d)	((d)->type==CMDDRVTYPE_DRIVE || (d)->type==CMDDRVTYPE_NET)


#ifdef __cplusplus
extern "C" {
#endif

extern int SendCmd(CMDDRIVE *drive, BYTE *cdb, DWORD buflen, BYTE reqflag);
extern int SendCmdLongRead(CMDDRIVE *drive, BYTE *cdb, DWORD buflen,
						   BYTE reqflag, DWORD total_blocks);
extern int InitializeCmdDrive(CMDDRIVE *drive, int bufsize, int cdblog_size, int type);
extern void FreeCmdDrive(CMDDRIVE *drive);
extern void CheckAtapi(CMDDRIVE *drive);
extern int SetDriveAspiSetting(CMDDRIVE *drive, int *ha, int *tg, DWORD *timeout);
extern void SetDriveBuffer(CMDDRIVE *drive, char *data_buf, int bufsize);

extern int OpenDevice(CMDDRIVE *drive, int hid, int tid,
		      BOOL reader, BOOL bWaitDisc,
		      BYTE *data_buf, int bufsize);
extern void CloseDevice(CMDDRIVE *drive);
extern int OpenTempImageDevice(CMDDRIVE *drive, BOOL reader,
			       BYTE *data_buf, int bufsize,
			       const char *tmpfile);
extern int OpenISOImageDevice(CMDDRIVE *drive, BOOL reader,
			      BYTE *data_buf, int bufsize);
extern int OpenEnbanImageDevice(CMDDRIVE *drive, BOOL reader,
				BYTE *data_buf, int bufsize);
extern int OpenNetDevice(CMDDRIVE *drive, BOOL server,
			 BYTE *data_buf, int bufsize);

#ifdef __cplusplus
}
#endif

#endif /* !__DRIVE_H__ */
