/**
 * @file copydisc.c
 * @brief ~Ղ𕡎
 * @author BananaJinn
 * @version $Id: copydisc.c,v 1.60 2007/04/09 14:52:00 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>
#if defined(WIN32)
# include <io.h>
# define snprintf _snprintf
#else
# include <pwd.h>
# include <unistd.h>
#endif
#include "mem.h"
#include "aspi.h"
#include "struct.h"
#include "cmd.h"
#include "ui.h"
#include "copydisc.h"
#include "cmdlog.h"
#include "netserver.h"
#include "text.h"
#include "log.h"
#include "discinfo.h"
#include "offsetiso.h"

#define SEND_GAPDATA 1

static DWORD g_SpeedData[10];
static int g_NumSpeedData=0;
static int g_MaxSpeedData=sizeof(g_SpeedData)/sizeof(DWORD);

/**
 * ixf[^
 */
static void InitSpeedData()
{
	g_NumSpeedData=0;
}

/**
 * ixƎc莞ԓ\
 * @param[in]	lba	݋L^AhX
 * @param[in]	rest_blocks  cubN
 * @param[in]	total_rest   Ŝ̎c
 * @param[in]	src	ǎ摕u\
 * @param[in]	dst	u\
 */
static void DispSpeed(DWORD lba, DWORD rest_blocks, DWORD total_rest,
					  CMDDRIVE *src, CMDDRIVE *dst)
{
	double blocks_per_sec;
	double curr_speed;
	char info[256];
	DWORD rest_time;
	int ret;
	double buffer_capacity;
  
	if(g_NumSpeedData >= g_MaxSpeedData){
		memmove(&g_SpeedData[0], &g_SpeedData[1],
				(g_MaxSpeedData-1)*sizeof(DWORD));
		g_NumSpeedData--;
	}
	g_SpeedData[g_NumSpeedData] = lba;
	g_NumSpeedData++;

	if(g_NumSpeedData <= 1){
		return;
	}
	blocks_per_sec = (double)(lba-g_SpeedData[0])/(g_NumSpeedData-1);
	if(GetOption()->flags & OPFLG_DVD){
		curr_speed = blocks_per_sec*2048/1024.0/1385;
	}
	else{
		curr_speed = blocks_per_sec*2352/1000.0/176.4;
	}

	snprintf(info, sizeof(info), MSG_SPEED_ /* "%.1fx"*/, curr_speed);
	/* c莞ԌvZ(݃gbN) */
	rest_time = (DWORD)(0.5+rest_blocks/blocks_per_sec);
	snprintf(info+strlen(info), sizeof(info)-strlen(info),
			 MSG_REMAINS_ /*" remains=%d:%02d"*/,
			 (int)(rest_time/60), (int)(rest_time%60));
	if(total_rest > 0){
		/* c莞ԌvZ(S) */
		rest_time = (DWORD)(0.5+total_rest/blocks_per_sec);
		snprintf(info+strlen(info), sizeof(info)-strlen(info),
				 MSG_TOTAL_REMAINS_ /*" toral_remains=%d:%02d"*/,
				 (int)(rest_time/60), (int)(rest_time%60));
	}

	if(REALDRIVE(dst)){
		ret = SendReadBufferCapacity(dst, 0);
		if(ret == RET_OK){
			buffer_capacity = 100-
				100.0*Get4bytes(dst->data_buf+8)/Get4bytes(dst->data_buf+4);
			sprintf(info+strlen(info), MSG_BUFFER_ /* " buffer=%.1f%%" */, buffer_capacity);
		}
	}
	UIDispInfo(info);
	if(src->type == CMDDRVTYPE_NET){
		NAUIDispInfo(&src->u.net, info);
	}
}



/**
 * DVD-RW/+RWtH[}bg
 * @param[in]	drive	u\
 * @param[in]	type	tH[}bg^Cv
 * @param[in]	size	tH[}bgTCY
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int FormatDVD(CMDDRIVE *drive, BYTE type, DWORD size)
{
	int ret;
	WORD len, offset;
	struct _FORMATCAPA_HEADER *fch;
	struct _FORMATLIST_HEADER *fh;
	struct _FORMATDESC *fd, fcd;
	const char *message;

	if(!REALDRIVE(drive))
		return RET_OK;

	/* Format Descriptor 𓾂 */
	ret = SendReadFormatCapacities(drive);
	if(ret!=RET_OK){
		DispCommandError(drive);
		return ret;
	}
	fch = (struct _FORMATCAPA_HEADER *)drive->data_buf;
	len = fch->list_len;
	offset = sizeof(struct _FORMATCAPA_HEADER) + sizeof(struct _FORMATCURMAXDESC);
	for(; offset<len; offset += sizeof(struct _FORMATDESC)){
		fd = (struct _FORMATDESC *)(drive->data_buf + offset);
		if(fd->format_type==type){
			memcpy(&fcd, fd, sizeof(struct _FORMATDESC));
			break;
		}
	}
	if(offset>=len){
		return RET_NG;
	}

	fh = (struct _FORMATLIST_HEADER *)drive->data_buf;
	fd = (struct _FORMATDESC *)(drive->data_buf+sizeof(struct _FORMATLIST_HEADER));
	memset(fh, 0, sizeof(struct _FORMATLIST_HEADER));
	memcpy(fd, &fcd, sizeof(struct _FORMATDESC));
	fh->fov = 1;
	fh->immed = 1;
	Set2bytes(fh->fmtdesc_len, sizeof(struct _FORMATDESC));
	if(Get4bytes(fd->num_blocks) > size)
		Set4bytes(fd->num_blocks, size);
	len = sizeof(struct _FORMATLIST_HEADER) + sizeof(struct _FORMATDESC);
	ret = SendFormatUnit(drive, 1, 0, FUFC_OTHER, len);
	if(ret!=RET_OK){
		DispCommandError(drive);
		return ret;
	}

	if(type==FDFT_QUICK || type==FDFT_QUICKADD || type==FDFT_QUICKGROW)
		message = MSG_MIN_FORMAT;  /*  */
	else
		message = MSG_FORMATTING;  /*  */
	ret = WaitProgress(drive, message, FALSE);
	if(ret!=RET_OK){
		if(ret==RET_CMDERR)
			DispCommandError(drive);
		return ret;
	}

	return RET_OK;
}

/**
 * Kv΃tH[}bg
 * @param[in]	drive	u\
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int Formatting(CMDDRIVE *drive)
{
	int ret;
	struct _DISCINFO *di;

	if(!REALDRIVE(drive)){
		return RET_OK;
	}

	if(drive->disc_type!=DT_DVDPRW){
		return RET_OK;
	}

	ret = SendReadDiscInfo(drive);
	if(ret!=RET_OK){
		DispCommandError(drive);
		return ret;
	}

	di = (struct _DISCINFO *)drive->data_buf;
	if(di->bgformat_stat != BGFSTAT_NOTFORMATTED){
		return RET_OK;
	}

	ret = FormatDVD(drive, FDFT_DVDPRW, 0xffffffff);
	if(ret!=RET_OK){
		return ret;
	}

	return RET_OK;
}

/**
 * Kv΃fBXN
 * @param[in]	drive	u\
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int Blanking(CMDDRIVE *drive)
{
	int ret;
	struct _DISCINFO *di;

	if(!REALDRIVE(drive)){
		return RET_OK;
	}

	if(drive->disc_type==DT_DVDRWS || drive->disc_type==DT_DVDRWO){
		if(GetOption()->dao==FALSE){
			/* QuickFormat ̂ Blank sv */
			return RET_OK;
		}
	}
	if(drive->disc_type==DT_DVDPRW){
		/* sv */
		return RET_OK;
	}
	ret = SendReadDiscInfo(drive);
	if(ret!=RET_OK){
		DispCommandError(drive);
		return ret;
	}

	di = (struct _DISCINFO *)drive->data_buf;
	if(di->disc_status==DISCSTAT_EMPTY){
		return RET_OK;
	}
	if(di->erasable==0){
		/* "L^fBXNuNł͂Ȃ̂ŕʂł܂B" */
		UIDispMessage(MSG_NOT_BLANK, UIDMT_ERROR);
		return RET_NG;
	}

	/* "L^fBXNuNł͂܂B܂?" */
	ret = UIDispMessage(MSG_NOT_BLANK_QUICK_BLANK, UIDMT_QUESTION);
	if(ret==UIDMRET_CANCEL){
		return RET_ABORT;
	}

	ret = BlankDisc(drive, 1);
	if(ret!=RET_OK){
		if(ret==RET_CMDERR){
			DispCommandError(drive);
		}
		return ret;
	}

	return RET_OK;
}

/**
 * L^\TCY(ubN)擾
 * @param[in]	drive	u\
 * @param[out]	size_ret  L^\TCY
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int GetWritableSize(CMDDRIVE *drive, DWORD *size_ret)
{
	int ret;
	WORD track_num;
	struct _DISCINFO *di;
	struct _TRACKINFO *ti;

	*size_ret = 0UL;
	if(!REALDRIVE(drive))
		return RET_OK;

	ret = SendReadDiscInfo(drive);
	if(ret!=RET_OK){
		DispCommandError(drive);
		return ret;
	}
	di = (struct _DISCINFO *)drive->data_buf;
	track_num = (WORD)di->last_track_ls_msb<<8 | di->last_track_ls_lsb;
	ret = SendReadTrackInfo(drive, track_num);
	if(ret!=RET_OK){
		DispCommandError(drive);
		return ret;
	}
	ti = (struct _TRACKINFO *)drive->data_buf;
	*size_ret = Get4bytes(ti->free_blocks);

	return RET_OK;
}


/**
 * ZbV
 * @param[in]	drive	u\̔z
 * @param[in]	num_drv	u\̐
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int CloseSession(CMDDRIVE *drive, int num_drv)
{
	int ret;
	int index;

	if(!REALDRIVE(&drive[0])){
		return RET_OK;
	}

	for(index=0; index<num_drv; index++){
		ret = SendCloseTrackSession(&drive[index], 1, CTST_CLOSESESSION, 0);
		if(ret!=RET_OK){
			DispCommandError(&drive[index]);
			return ret;
		}
	}

	index=num_drv-1;
	ret = WaitProgress(&drive[index], MSG_CLOSE_SESSION/*"ZbV"*/, FALSE);
	if(ret!=RET_OK){
		if(ret==RET_CMDERR)
			DispCommandError(&drive[index]);
		return ret;
	}

	return RET_OK;
}

/**
 * gbN
 * @param[in]	drive	u\̔z
 * @param[in]	num_drv	u\̐
 * @param[in]	track_num  gbNԍ
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int ExecCloseTrack(CMDDRIVE *drive, int num_drv, WORD track_num)
{
	int ret;
	int index;

	if(!REALDRIVE(&drive[0]))
		return RET_OK;

	for(index=0; index<num_drv; index++){
		ret = SendCloseTrackSession(&drive[index], 1, CTST_CLOSETRACK, track_num);
		if(ret!=RET_OK){
			DispCommandError(&drive[index]);
			return ret;
		}
	}

	index = num_drv-1;
	ret = WaitProgress(&drive[index], MSG_CLOSE_TRACK/*"gbN"*/, FALSE);
	if(ret!=RET_OK){
		if(ret==RET_CMDERR)
			DispCommandError(&drive[index]);
		return ret;
	}

	return RET_OK;
}

/**
 * (Synchronize Cache)
 * @param[in]	drive	u\
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int SyncCache(CMDDRIVE *drive)
{
	int ret;

	if(!REALDRIVE(drive))
		return RET_OK;

	ret = SendSynchronizeCache(drive, 1);
	if(ret!=RET_OK){
		DispCommandError(drive);
		return ret;
	}

	ret = WaitProgress(drive, NULL, FALSE);
	if(ret!=RET_OK){
		if(ret==RET_CMDERR)
			DispCommandError(drive);
		return ret;
	}

	return RET_OK;
}

/**
 * U[ugbN
 * @param[in]	drive	u\
 * @param[in]	size	U[uTCY(ubN)
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int ReserveTrack(CMDDRIVE *drive, DWORD size)
{
	int ret;

	if(!REALDRIVE(drive))
		return RET_OK;

	ret = SendReserveTrack(drive, size);
	if(ret!=RET_OK){
		DispCommandError(drive);
		return ret;
	}

	return RET_OK;
}


/**
 * L^[h(WriteParametersPage(05h))ݒ
 * @param[in]	drive	u\
 * @param[in]	discinfo  fBXN
 * @param[in]	track_num gbNԍ
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int SetWriteParametersPage(CMDDRIVE *drive, CPDISCINFO *discinfo,
								  WORD track_num, BOOL sao)
{
	CPTRACKINFO *cpti;
	struct _MODEPAGE05 *mp05;
	WORD sess_num;
	int ret;

	if(!REALDRIVE(drive))
		return RET_OK;

	if(track_num==0)
		track_num=1;
	cpti = &discinfo->trackinfo[track_num-1];
	sess_num = (WORD)cpti->trackinfo.session_number_msb<<8 |
		(WORD)cpti->trackinfo.session_number_lsb;

	/* ݒl擾ĕKvȕ */
	ret = SendModeSense(drive, MSPC_CURRENT, 5);
	if(ret!=RET_OK){
		DispCommandError(drive);
		return ret;
	}
	mp05 = (struct _MODEPAGE05 *)(drive->data_buf +
								  (drive->cmd_type==CMDDRVCTYPE_ATAPI ? 8 : 16));

	if(DT_DVD_FAMILY(drive->disc_type)){
		mp05->write_type = MP05WT_PACKET;
		mp05->track_mode = MP05TM_DATA;
		mp05->dbtype = MP05DBT_MODE1;
	}
	else{
		mp05->track_mode = cpti->trackinfo.track_mode;
		if(IS_TRACKMODE_DATA(mp05->track_mode)){
			mp05->dbtype = cpti->mode2 ? MP05DBT_MIX : MP05DBT_MODE1;
			mp05->write_type = cpti->trackinfo.packet ? MP05WT_PACKET : MP05WT_TAO;
		}
		else{
			mp05->dbtype = MP05DBT_CDDA_2352;
			mp05->write_type = MP05WT_TAO;
			Set2bytes(mp05->audio_pause_len, cpti->pause_len);
		}
	}

	mp05->BUFE = GetOption()->bufe;
	mp05->test_write = GetOption()->test_write;
	if(discinfo->sessions == sess_num){
		/* ŏIZbV */
		mp05->multi_session = discinfo->disc_stat==DISCSTAT_COMPLETE ? 0 : 3;
	}
	else{
		mp05->multi_session = 3;
	}
	mp05->fp = cpti->trackinfo.fp;
	mp05->copy = cpti->trackinfo.copy;
	mp05->session_format = discinfo->disc_type;
	memcpy(mp05->packet_size, cpti->trackinfo.packet_size, 4);

	if(sao){
		mp05->write_type = MP05WT_SAO;
		mp05->track_mode = MP05TM_DATA;
		mp05->fp = 0;
		Set4bytes(mp05->packet_size, 0UL);
	}

	/* MCN */
	if(strlen(discinfo->media_catalog_number)>0){
		memcpy(mp05->media_cat_number, discinfo->media_catalog_number, 13);
		mp05->mc_val = 1;
	}
	else{
		memset(mp05->media_cat_number, 0, 13);
		mp05->mc_val = 0;
	}
	/* ISRC */
	if(strlen(cpti->isrc)>0){
		memcpy(mp05->ISRC, cpti->isrc, 12);
		mp05->tc_val = 1;
	}
	else{
		memset(mp05->ISRC, 0, 12);
		mp05->tc_val = 0;
	}
  
	ret = SendModeSelect(drive, 5);
	if(ret!=RET_OK){
		DispCommandError(drive);
		return ret;
	}

	return RET_OK;
}


/**
 * VariablePacket̃pPbg擾
 * @param[in]	drive	ǎ摕u\
 * @param[in]	lba	pPbgJnAhX
 * @param[out]	size_ret  pPbgTCY(ubN)
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int GetVPSize(CMDDRIVE *drive, DWORD lba, DWORD *size_ret)
{
	BYTE tmp[4];
	DWORD start_lba;
	DWORD len;
	int ret;

	if(!REALDRIVE(drive)){
		if(drive->type == CMDDRVTYPE_ISO){
			return RET_OK;
		}
		else{
			ret = ReadImageFile(&drive->u.image, tmp, 4, TRUE);
			if(ret!=RET_OK)
				return ret;
			*size_ret = Get4bytes(tmp);
		}	  
	}
	else{
		start_lba = lba;
		len = drive->bufsize / 2352;
		ret=RET_OK;
		while(TRUE){
			while(TRUE){
				if(UICheckAbort())
					return RET_ABORT;
				ret = SendReadCD(drive, lba, len);
				if(ret!=RET_OK)
					break;
				lba += len;
			}
			if(len==1)
				break;
			len=1;
		}
		*size_ret = lba - start_lba;
	}
  
	return RET_OK;
}

/**
 * VariablePacket̃pPbgݒ(C[Wt@C̏ꍇ̂)
 * @param[in]	drive	u\
 * @param[in]	size	pPbg(ubN)
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int SetVPSize(CMDDRIVE *drive, DWORD size)
{
	BYTE tmp[4];
	int ret;

	if(!REALDRIVE(drive)){
		if(drive->type == CMDDRVTYPE_ISO){
			return RET_OK;
		}
		else{
			Set4bytes(tmp, size);
			ret = WriteImageFile(&drive->u.image, tmp, 4, TRUE);
			if(ret!=RET_OK)
				return ret;
		}
	}
  
	return RET_OK;
}


/**
 * @brief	READgC񐔐ݒ(ModePage01h)
 * @param[in]	drive	ΏۃhCu
 * @param[in]	count	ݒ肷郊gC
 * @param[out]	current	ݒÕgC
 * @retval	RET_OK	I
 * @retval	RET_CMDERR	R}hG[
 * @retval	RET_NG	G[
 */
static int SetReadRetryCount(CMDDRIVE *drive, BYTE count, BYTE *current)
{
	int ret;
	struct _MODEPAGE01 *mp01;
	ret = SendModeSense(drive, MSPC_CURRENT, 1);
	if(ret != RET_OK){
		return ret;
	}
	mp01 = (struct _MODEPAGE01 *)
		(drive->data_buf + (drive->cmd_type==CMDDRVCTYPE_ATAPI ? 8 : 16));
	if(current != NULL){
		*current = mp01->rd_retry_count;
	}
	mp01->rd_retry_count = count;
	ret = SendModeSelect(drive, 1);
	if(ret != RET_OK){
		return ret;
	}

	return RET_OK;
}

/**
 * @brief	READs
 * @param[in]	src		ǂݍ݃hCu
 * @param[in]	lba		JnLBA
 * @param[in]	blocksize	ubNTCY
 * @param[in]	len		ǂݍ݃ubN
 * @param[in]	long_read	LONGREAD邩ǂ
 * @param[in]	long_read_size	LONGREAD̃TCY
 * @retval	RET_OK	I
 * @retval	RET_CMDERR	R}hG[
 * @retval	RET_NG	G[
 */
static int ExecRead(CMDDRIVE *src, DWORD lba, DWORD blocksize, DWORD len,
					BOOL long_read, DWORD long_read_size)
{
	int ret;
	BYTE *sp, *dp;
	DWORD cnt;
  
	/* Read */
	if(!REALDRIVE(src)){
		ret = ReadImageFile(&src->u.image, src->data_buf, blocksize*len,
							(src->type==CMDDRVTYPE_IMAGE) ? TRUE:FALSE);
		if(ret!=RET_OK)
			return ret;
	}
	else{
		if(long_read){
			if(long_read_size){
				/* LONGREADM */
				if(blocksize==2048){
					ret = SendLongRead12(src, lba, (WORD)len, len*blocksize,
										 long_read_size);
				}
				else{
					ret = SendLongReadCD(src, lba, len, long_read_size);
				}
				if(ret!=RET_OK){
					return ret;
				}
			}
			/* LONGREADʎM */
			if(blocksize==2048){
				ret = SendLongRead12(src, lba, (WORD)len, len*blocksize, 0);
			}
			else{
				ret = SendLongReadCD(src, lba, len, 0);
			}
			if(ret!=RET_OK){
				return ret;
			}
		}
		else{
			/* ʏREAD */
			if(blocksize==2048){
				ret = SendRead10(src, lba, (WORD)len, len*blocksize);
			}
			else{
				ret = SendReadCD(src, lba, len);
			}
      
			if(ret!=RET_OK){
				return ret;
			}
		}
    
		if(blocksize==2332){
			/* ReadCD bs=2352 œǂ񂾂ǂA
			   KvȂ̂ 2332 Ȃ̂Ńobt@l߂ */
			sp = dp = src->data_buf;
			sp += 16;	/* sync 16bytes */
			for(cnt=0; cnt<len; cnt++){
				memmove(dp, sp, 2332);
				sp += 2352;
				dp += 2332;
			}
		}
		else if(blocksize==2336){
			/* 2336 Ƀobt@l߂ */
			sp = dp = src->data_buf;
			sp += 16;	/* sync 16bytes */
			for(cnt=0; cnt<len; cnt++){
				memmove(dp, sp, 2336);
				sp += 2352;
				dp += 2336;
			}
		}
	}

	return RET_OK;
}


/**
 * wAhX̓ǎƋL^s
 * @param[in]	src	ǎ摕u\
 * @param[in]	dst	u\̔z
 * @param[in]	num_dst	u\̔z
 * @param[in]	lba	AhX
 * @param[in]	blocksize  1ubÑTCY(oCg)
 * @param[in]	len	ǎ&L^ubN
 * @param[in]	long_read  lbghCuLONGREADLɂ邩ǂ
 * @param[in]	long_read_size	LONGREADLɂꍇ̃TCY
 * @param[in]	readin	Lead-inǂ
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 * @note	blocksize  2048/2332/2336/2352 삷B
 * 		ȊO͑ΉĂȂB
 */
static int ExecReadWrite(CMDDRIVE *src, CMDDRIVE *dst, int num_dst,
						 DWORD lba, DWORD blocksize, DWORD len,
						 BOOL long_read, DWORD long_read_size,
						 BOOL leadin, BOOL zerodata)
{
	int ret=RET_OK;
	int index;
	int retry=0;
	char info[80];
	BYTE rdretry_keep=0;
	DWORD offset = 0;

	if(zerodata){
		memset(src->data_buf, 0, len*blocksize);
	}
	else{
		if(GetOption()->outside){
			offset = GetOffset();
		}
		for(retry=0; retry<=300/*32*/; retry++){ /* BANANA */
			if(retry > 0){
				if(rdretry_keep == 0){
					/* hCuREADgC񐔂𑝂₷ */
					ret = SetReadRetryCount(src, 0xff, &rdretry_keep);
					if(ret != RET_OK){
						rdretry_keep=0;
					}
				}
				if((retry&1)==0 && lba>0){
					if((retry&3)==0 && lba>16){
						ExecRead(src, (lba-offset)/16*16-16, blocksize, 1, FALSE, 0);
					}
					else{
						ExecRead(src, lba-offset-1, blocksize, 1, FALSE, 0);
					}
				}
				if(retry>=16 && (retry&3)==0){
					/* ăXsAbvĂ݂肷 */
					UIDispInfo(MSG_SPINUP/*"ĉ]"*/);
					if(UICheckAbort()){
						ret = RET_ABORT;
						break;
					}
					SendStartStop(src, 1, 0, 0);
#ifdef WIN32
					Sleep(1000);
#else
					sleep(1);
#endif
				}
				sprintf(info, MSG_RETRY_ /*"ēǍ:%d"*/, retry);
				UIDispInfo(info);
				if(UICheckAbort()){
					ret = RET_ABORT;
					break;
				}
			}
			ret = ExecRead(src, lba-offset, blocksize, len, long_read, 
						   long_read_size);
			if(ret==RET_OK){
				break;
			}
			else if(ret!=RET_CMDERR){
				break;
			}
		}
		if(rdretry_keep > 0){
			/* hCuREADgC񐔐ݒ߂ */
			SetReadRetryCount(src, rdretry_keep, NULL);
		}
		if(ret!=RET_OK){
			DispCommandError(src);
			return ret;
		}
	}

	if(GetOption()->outside){
		ret = OffsetISO(src->data_buf, lba, blocksize, len);
		if(ret != RET_OK){
			return ret;
		}
	}

	/* Write */
	if(!REALDRIVE(&dst[0])){
		if(!zerodata){
			ret = WriteImageFile(&dst->u.image, dst->data_buf, len*blocksize,
								 (dst->type==CMDDRVTYPE_IMAGE) ? TRUE:FALSE);
			if(ret!=RET_OK)
				return ret;
		}
	}
	else{
		if(leadin && (num_dst>1)){
			/*
			 * SAOLead-inL^JnꍇAL^uœ
			 * Lead-inL^Jn悤ɂB
			 */
			BOOL *started = (BOOL *)MemNew(sizeof(BOOL)*num_dst);
			int start_count=0;
			if(started==NULL){
				return RET_MEMERR;
			}
			memset(started, 0, sizeof(BOOL)*num_dst);
			while(start_count<num_dst){
				for(index=0; index<num_dst; index++){
					if(started[index]){
						continue;
					}
					ret = SendWrite10(&dst[index], lba, (WORD)len, len*blocksize,
									  FALSE);
					if(ret==RET_CMDERR){
						if((SD_SENSEKEY(&dst[index])==0x02) &&
						   (SD_ASC(&dst[index])==0x04) &&
						   (SD_ASCQ(&dst[index])==0x08)){
							continue;
						}
					}
					if(ret!=RET_OK){
						DispCommandError(&dst[index]);
						MemFree(started);
						return ret;
					}
					started[index] = TRUE;
					start_count++;
				}
			}
			MemFree(started);
		}
		else{
			/* Lead-inL^JnȂǂ͈ӎɕʂɋL^ */
			for(index=0; index<num_dst; index++){
				ret = SendWrite10(&dst[index], lba, (WORD)len, len*blocksize, TRUE);
				if(ret!=RET_OK){
					DispCommandError(&dst[index]);
					return ret;
				}
			}
      
		}
	}
  
	return RET_OK;
}


/**
 * gbN̊Jn
 * @param[in]	drive	u\
 * @param[in]	discinfo  fBXN
 * @param[in]	track_num gbNԍ
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int OpenTrack(CMDDRIVE *drive, CPDISCINFO *discinfo, WORD track_num)
{
	int ret;

	if(REALDRIVE(drive)){
		if(DT_CD_FAMILY(drive->disc_type)){
			ret = SetWriteParametersPage(drive, discinfo, track_num,
										 !discinfo->trackinfo[track_num-1].tao );
			if(ret!=RET_OK)
				return ret;
		}
		else{
			if(drive->disc_type==DT_DVDR ||
			   drive->disc_type==DT_DVDRWS || drive->disc_type==DT_DVDRWO){
				/* DVD-R/-RW */
				if(drive->disc_type!=DT_DVDR && GetOption()->dao==FALSE){
					ret = FormatDVD(drive,
									(BYTE)(track_num==1 ? FDFT_QUICK : FDFT_QUICKADD),
									0x00000000);
				}
				else{
					ret = SetWriteParametersPage(drive, discinfo, track_num,
												 GetOption()->dao);
				}
				if(ret!=RET_OK)
					return ret;
			}
		}
	}

	return RET_OK;
}


/**
 * gbN
 * @param[in]	drive	u\
 * @param[in]	discinfo  fBXN
 * @param[in]	track_num gbNԍ
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int CloseTrack(CMDDRIVE *drive, int num_drv,
					  CPDISCINFO *discinfo, WORD track_num)
{
	CPTRACKINFO *cpti;
	int ret;

	if(REALDRIVE(&drive[0])){
		cpti = &discinfo->trackinfo[track_num-1];
		if(cpti->trackinfo.packet && cpti->trackinfo.nwa_valid==0 &&
		   Get4bytes(cpti->trackinfo.free_blocks)==0 &&
		   drive[0].disc_type!=DT_DVDRWS &&
		   drive[0].disc_type!=DT_DVDRWO &&
		   GetOption()->dao==FALSE){
			ret = ExecCloseTrack(drive, num_drv, track_num);
			if(ret!=RET_OK)
				return ret;
		}
	}

	return RET_OK;
}

/**
 * CD-TEXT̃f[^obt@ɍ쐬
 * @param[out]	buf	i[obt@
 * @param[in]	fillsize  쐬TCY(oCg)
 * @param[in]	cdtext	CD-TEXT
 * @param[in]	cdtext_size  CD-TEXToCg
 * @param[in]	cdtext_offset  QƊJnItZbg(ȎsۂɕKv)
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static void MakeCDTextBuffer(BYTE *buf, DWORD fillsize,
							 BYTE *cdtext, DWORD cdtext_size, DWORD *cdtext_offset)
{
	DWORD cdtext_restsize;
	DWORD copysize;

	while(fillsize>0){
		cdtext_restsize = cdtext_size - (*cdtext_offset);
		if(fillsize < cdtext_restsize){
			copysize = fillsize;
		}
		else{
			copysize = cdtext_restsize;
		}
	
		memcpy(buf, cdtext+(*cdtext_offset), copysize);
		buf += copysize;
		fillsize -= copysize;
		*cdtext_offset += copysize;
		if(*cdtext_offset >= cdtext_size)
			*cdtext_offset = 0;
	}
}

/*
 * CRČvZ̓Tbp܂B
 * crc.h ɏĂʂAcdrecord 2.0 pNĂĂ܂B
 */
#define LOCAL
#define UInt16_t WORD
#include "crc.h"
static void CalcCDTextCRC(CPDISCINFO *discinfo)
{
	int i, j;
	WORD crc;

	for(i=0; i<discinfo->cdtext_size; i+=18){
		crc = 0;
		for(j=0; j<16; j++){
			crc = (crc<<BPB) ^ crctab[(crc>>(BPW-BPB)) ^ discinfo->cdtext[i+j]];
		}
		crc = crc ^ 0xFFFF;
		discinfo->cdtext[i+16] = (BYTE)(crc>>8);
		discinfo->cdtext[i+17] = (BYTE)(crc);
	}
}


/**
 * CD-TEXTL^
 * @param[in]	drive	u\̔z
 * @param[in]	num_drv	u\̔z
 * @param[in]	discinfo  fBXN
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int WriteCDText(CMDDRIVE *drive, int num_drv, CPDISCINFO *discinfo)
{
	int ret = RET_OK;
	struct _DISCINFO *di;
	DWORD lba;
	DWORD rest_blocks, total_blocks, len, deflen;
	BYTE *converted_cdtext=NULL;
	DWORD converted_cdtext_size;
	DWORD cdtext_offset=0;
	long t1, t2;
	DWORD i;
	DWORD *leadin_start;
	DWORD max_leadin;
	int index;

	if(!REALDRIVE(&drive[0]))
		return RET_OK;

	leadin_start = (DWORD *)MemNew(sizeof(DWORD)*num_drv);
	if(leadin_start == NULL){
		return RET_MEMERR;
	}
	/* Lead-inJnԂ擾 */
	max_leadin = 0;
	for(index=0; index<num_drv; index++){
		ret = SendReadDiscInfo(&drive[index]);
		if(ret!=RET_OK){
			DispCommandError(&drive[index]);
			MemFree(leadin_start);
			return ret;
		}
		di = (struct _DISCINFO *)drive[index].data_buf;
		leadin_start[index] = MSF2LBA(di->last_lead_in[1],
									  di->last_lead_in[2],
									  di->last_lead_in[3], FALSE);
		if(max_leadin < leadin_start[index]){
			max_leadin = leadin_start[index];
		}
	}
	/*
	 * }ĂfBXN̒ŁALead-inJnԂ
	 * x̂ɍ킹B
	 */
	for(index=0; index<num_drv; index++){
		len = (drive[index].bufsize-1)/96;
		lba = leadin_start[index];
		rest_blocks = (DWORD)(max_leadin-lba);
		memset(drive[index].data_buf, 0, drive[index].bufsize);
		while(rest_blocks > 0){
			if(len > rest_blocks){
				len = rest_blocks;
			}
			ret = SendWrite10(&drive[index], lba, (WORD)len, len*96, TRUE);
			if(ret!=RET_OK){
				DispCommandError(&drive[index]);
				MemFree(leadin_start);
				return ret;
			}
			rest_blocks -= len;
			lba += len;
		}
	}
	MemFree(leadin_start);

	/* CD-TEXTf[^쐬 */
	CalcCDTextCRC(discinfo);
	converted_cdtext_size = (discinfo->cdtext_size * 4+2)/3;
	converted_cdtext = MemNew(converted_cdtext_size);
	if(converted_cdtext==NULL)
		return RET_MEMERR;
	for(i=0; i<converted_cdtext_size/4; i++){
		/*   8bit        6bit
		 * aaaaaaaa    00aaaaaa
		 * bbbbbbbb => 00aabbbb
		 * cccccccc    00bbbbcc
		 *             00cccccc
		 */
		converted_cdtext[i*4+0] = (discinfo->cdtext[i*3+0]>>2) & 0x3f;
		converted_cdtext[i*4+1] = ((discinfo->cdtext[i*3+0]<<4) & 0x30) |
			((discinfo->cdtext[i*3+1]>>4) & 0x0f);
		converted_cdtext[i*4+2] = ((discinfo->cdtext[i*3+1]<<2) & 0x3c) |
			((discinfo->cdtext[i*3+2]>>6) & 0x03);
		converted_cdtext[i*4+3] = (discinfo->cdtext[i*3+2]>>0) & 0x3f;
	}

	lba = max_leadin;
	rest_blocks = total_blocks = (DWORD)(-150-lba);

	/*
	 * 1xɓ]łubNvZ(1ubN=96bytes)
	 * AAShCũobt@TCYƂB
	 */
	deflen = (drive->bufsize-1)/96;

	/* ʕ\ */
	UIMeter2Initialize("CD-TEXT");
	if(drive->type==CMDDRVTYPE_NET){
		NAUIMeter2Initialize(&drive->u.net, "CD-TEXT");
	}
	t1 = t2 = time(NULL);

	while(rest_blocks>0){
		t2 = time(NULL);
		if(t1!=t2){
			UIMeter2Update((float)(total_blocks-rest_blocks)*100/total_blocks);
			if(drive->type==CMDDRVTYPE_NET){
				NAUIMeter2Update(&drive->u.net,
								 (float)(total_blocks-rest_blocks)*100/total_blocks);
			}
			t1=t2;
		}
		if(UICheckAbort()){
			ret = RET_ABORT;
			break;
		}

		len = deflen < rest_blocks ? deflen : rest_blocks;
		for(index=0; index<num_drv; index++){
			MakeCDTextBuffer(drive[index].data_buf, len*96,
							 converted_cdtext, converted_cdtext_size, &cdtext_offset);
			ret = SendWrite10(&drive[index], lba, (WORD)len, len*96, TRUE);
			if(ret!=RET_OK){
				DispCommandError(&drive[index]);
				break;
			}
		}
		if(ret!=RET_OK){
			break;
		}
		lba += len;
		rest_blocks -= len;
	}

	MemFree(converted_cdtext);

	return ret;
}


/**
 * ǂݏ̃[v
 * @param[in]	src	ǎ摕u\
 * @param[in]	dst	u\̔z
 * @param[in]	num_dst	u\̔z
 * @param[in]	lba	JnAhX
 * @param[in]	blocks	ubN
 * @param[in]	deflen	ftHg]P(ubN)
 * @param[in]	blocksize ubNTCY(oCg)
 * @param[in]	vp_track  VariablePacketǂ
 * @param[in]	discinfo fBXN
 * @param[in]	sao	Session at once ǂ
 * @param[in]	leadin	Lead-in ̋L^ǂ
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int WriteLoop(CMDDRIVE *src, CMDDRIVE *dst, int num_dst,
					 DWORD lba, DWORD blocks, DWORD deflen,
					 DWORD blocksize, BOOL vp_track, CPDISCINFO *discinfo,
					 BOOL sao, BOOL leadin, BOOL zerodata)
{
	int ret;
	DWORD rest_blocks, total_blocks, len;
	DWORD long_read_rest=0;
	DWORD long_read_size=0;
	BOOL long_read=FALSE;
	BOOL long_read_now=FALSE;
	long t1, t2;
	float percent_total;
	int index;

	InitSpeedData();
	rest_blocks = total_blocks = blocks;

	if(src->type == CMDDRVTYPE_NET){
		/* LONG READ  */
		long_read_size = (0x00ffffffUL/deflen)*deflen;
		long_read = TRUE;
	}

	t1 = t2 = time(NULL);
	ret = RET_OK;
	while(rest_blocks>0 && ret==RET_OK){
		if(vp_track){
			ret = GetVPSize(src, lba, &blocks);
			if(ret!=RET_OK)
				break;
			for(index=0; index<num_dst; index++){
				ret = SetVPSize(&dst[index], blocks);
				if(ret!=RET_OK)
					break;
			}
			if(ret!=RET_OK)
				break;
		}
		else
			blocks = rest_blocks;

		while(blocks>0){
			t2 = time(NULL);
			if(t1!=t2){
				percent_total = (float)lba*100/discinfo->last_addr;
				if(GetOption()->on_the_fly==FALSE)
					percent_total = percent_total/2 +
						(dst->type!=CMDDRVTYPE_IMAGE ? 50 : 0);
				UIMeter1Update(percent_total);
				UIMeter2Update((float)(total_blocks-rest_blocks)*100/total_blocks);
				if(src->type==CMDDRVTYPE_NET){
					NAUIMeter1Update(&src->u.net, percent_total);
					NAUIMeter2Update(&src->u.net,
									 (float)(total_blocks-rest_blocks)*100/total_blocks);
				}
				/* xAc莞Ԃ\ */
				DispSpeed(lba, rest_blocks,
						  discinfo->tracks != 1 ? (discinfo->last_addr-lba) : 0,
						  src, dst);
				t1=t2;
			}
			if(UICheckAbort()){
				ret = RET_ABORT;
				break;
			}
			len = deflen>blocks ? blocks : deflen;
			if(long_read && !zerodata){
				long_read_now = FALSE;
				if(long_read_rest == 0){
					/* LONGREADM */
					long_read_now = TRUE;
					if(long_read_size > blocks){
						long_read_size = blocks;
					}
					long_read_rest = long_read_size;
				}
			}
			ret = ExecReadWrite(src, dst, num_dst, lba, blocksize, len,
								long_read, (long_read_now ? long_read_size : 0),
								leadin, zerodata);
			if(ret!=RET_OK)
				break;
			lba += len;
			blocks -= len;
			rest_blocks -= len;
			if(long_read){
				long_read_rest -= len;
			}
		}

		percent_total = (float)lba*100/discinfo->last_addr;
		if(GetOption()->on_the_fly==FALSE)
			percent_total = percent_total/2 +
				(dst->type!=CMDDRVTYPE_IMAGE ? 50 : 0);
		UIMeter1Update(percent_total);
		UIMeter2Update((float)(total_blocks-rest_blocks)*100/total_blocks);
		if(src->type==CMDDRVTYPE_NET){
			NAUIMeter1Update(&src->u.net, percent_total);
			NAUIMeter2Update(&src->u.net,
							 (float)(total_blocks-rest_blocks)*100/total_blocks);
		}
		if(ret==RET_OK){
			if(!sao){
				for(index=0; index<num_dst; index++){
					ret = SyncCache(&dst[index]);
					if(ret!=RET_OK)
						break;
				}
			}
		}

		if(vp_track){
			lba += 7;
			if(rest_blocks>7)
				rest_blocks -= 7;
			if(rest_blocks<7)
				rest_blocks=0;
		}
	}

	UIDispInfo("");
	if(src->type==CMDDRVTYPE_NET){
		NAUIDispInfo(&src->u.net, "");
	}
	return ret;
}

/**
 * 1gbN̕
 * @param[in]	src	ǎ摕u\
 * @param[in]	dst	u\̔z
 * @param[in]	num_dst	u\̔z
 * @param[in]	discinfo  fBXN
 * @param[in]	track_num gbNԍ
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int CopyTrack(CMDDRIVE *src, CMDDRIVE *dst, int num_dst,
					 CPDISCINFO *discinfo, WORD track_num)
{
	int ret;
	BOOL vp_track=FALSE;
	CPTRACKINFO *cpti = &discinfo->trackinfo[track_num-1];
	DWORD len;
	DWORD blocksize;
	DWORD blocks;
	DWORD lba;
	char msgbuf[80];
	int index;

	/* VariablePacketǂ */
	if(cpti->trackinfo.packet && Get4bytes(cpti->trackinfo.packet_size)==0)
		vp_track=TRUE;
	/* L^ubN */
	if(cpti->trackinfo.nwa_valid){
		blocks = Get4bytes(cpti->trackinfo.next_writable_addr) -
			Get4bytes(cpti->trackinfo.track_start);
	}
	else{
		blocks = Get4bytes(cpti->trackinfo.track_size) -
			Get4bytes(cpti->trackinfo.free_blocks);
	}
	/* ubNTCY */
	if(DT_DVD_FAMILY(dst->disc_type)){
		blocksize = 2048;
		/* 1ɓ]ubN */
		len = 16;
	}
	else{
		if(IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
			blocksize = cpti->mode2 ? 2332 : 2048;
		}
		else{
			blocksize = 2352;
		}
		/* 1ɓ]łubN */
		if(REALDRIVE(src)){
			len = src->bufsize / (blocksize==2048 ? 2048 : 2352);
		}
		else if(REALDRIVE(&dst[0])){
			len = dst->bufsize / (blocksize==2048 ? 2048 : 2352);
		}
		else{
			len = 16;
		}
	}
	if(blocksize*len >= 0x10000){
		/* wnaspi32.dll ł 64KB ]łȂ炵̂ */
		len = 0xffff/blocksize;
	}

	/* L^AhX */
	lba = Get4bytes(cpti->trackinfo.track_start);

	for(index=0; index<num_dst; index++){
		ret = OpenTrack(&dst[index], discinfo, track_num);
		if(ret!=RET_OK)
			return ret;
	}

	/* ʕ\ */
	sprintf(msgbuf, MSG_TRACK_ /*"gbN%d"*/, track_num);
	UIMeter2Initialize(msgbuf);
	if(src->type==CMDDRVTYPE_NET){
		NAUIMeter2Initialize(&src->u.net, msgbuf);
	}

	if(Get4bytes(cpti->trackinfo.free_blocks) > 0){
		for(index=0; index<num_dst; index++){
			ret = ReserveTrack(&dst[index],
							   Get4bytes(cpti->trackinfo.track_size));
			if(ret!=RET_OK)
				return ret;
		}
	}

	if(GetOption()->outside
	   && (discinfo->outside_offset > 0)
	   && (track_num == 1)){
		/* _~[1stgbN̋L^ */
		ret = WriteLoop(src, dst, num_dst, lba, blocks, len, blocksize,
						vp_track, discinfo, FALSE, FALSE, TRUE);
	}
	else{
		ret = WriteLoop(src, dst, num_dst, lba, blocks, len, blocksize,
						vp_track, discinfo, FALSE, FALSE, FALSE);
	}
	if(ret!=RET_OK){
		/* G[̏ꍇ́ASyncCacheďI */
		for(index=0; index<num_dst; index++){
			SyncCache(&dst[index]);
		}
	}
	else{
		ret = CloseTrack(dst, num_dst, discinfo, track_num);
	}

	return ret;
}


/**
 * SAOL^pCueSheet̍쐬
 * @param[in]	drive	u\
 * @param[in]	discinfo  fBXN
 * @param[in]	track_start JngbNԍ
 * @param[out]	cs_ret	쐬CueSheet
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int CreateCueSheet(CMDDRIVE *drive, CPDISCINFO *discinfo,
						  WORD track_start,
						  struct _CUESHEET **cs_ret)
{
	struct _CUESHEET *cs = NULL, *csp;
	int cur_cs = 0;
	int num_cs = 0;
	DWORD gap_len;
	WORD sess_num = 0;
	DWORD nwa;
	CPTRACKINFO *cpti=NULL, *lcpti=NULL;
	struct _TRACKINFO *ti;
	int ret;
	BOOL gap_2part;
	BOOL cdtext=FALSE;
	int retry;	/* CD-TEXTT|[ghCüׂ̃gC */
	WORD track_num;

	if(track_start==1 && discinfo->cdtext_size>0)
		cdtext = TRUE;

	for(retry=0; retry<2; retry++){
		track_num = track_start;
		cur_cs = 0;
		num_cs = 0;
		sess_num = 0;
		/* NWA擾 */
		if(!REALDRIVE(drive)){
			nwa = -150;
		}
		else{
			ret = SendReadTrackInfo(drive, track_num);
			if(ret!=RET_OK){
				DispCommandError(drive);
				return ret;
			}
			ti = (struct _TRACKINFO *)drive->data_buf;
			nwa = Get4bytes(ti->next_writable_addr);
			if(nwa == (DWORD)0){
			  nwa -= 150;
			}
		}

		if(strlen(discinfo->media_catalog_number)!=0){
			/* Media Catalog Number */
			DebugLog("CreateCueSheet: Media catalog number.\n");
			num_cs += 2;
			cs = (struct _CUESHEET *)MemResize(cs, num_cs * sizeof(struct _CUESHEET));
			if(cs==NULL)
				return RET_MEMERR;
			csp = &cs[cur_cs++];
			csp->ctladr = CSADR_MCN;
			memcpy(&csp->tno, discinfo->media_catalog_number, 7);
			csp = &cs[cur_cs++];
			csp->ctladr = CSADR_MCN;
			memcpy(&csp->tno, discinfo->media_catalog_number+7, 7);
		}

		cpti = NULL;
		lcpti = NULL;
		ret = RET_OK;
		for( ; track_num <= discinfo->tracks; track_num++){
			lcpti = cpti;
			cpti = &discinfo->trackinfo[track_num-1];
			gap_len = 0;
			if(sess_num==0){
				DebugLog("CreateCueSheet: Lead-in.\n");
				sess_num = (WORD)cpti->trackinfo.session_number_msb<<8 |
					(WORD)cpti->trackinfo.session_number_lsb;
				/* Lead-in */
				num_cs++;
				cs = (struct _CUESHEET *)MemResize(cs, num_cs * sizeof(struct _CUESHEET));
				if(cs==NULL)
					return RET_MEMERR;
				csp = &cs[cur_cs++];
				csp->ctladr = IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
				csp->ctladr |= CSADR_NORMAL;
				csp->tno = 0;
				csp->index = 0;
				csp->dataform = cdtext ? 0x41 : 0x01;
				csp->scms = 0;
				LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
				gap_len = Get4bytes(cpti->trackinfo.track_start) - nwa;
			}
			else if(sess_num != ((WORD)cpti->trackinfo.session_number_msb<<8 |
								 (WORD)cpti->trackinfo.session_number_lsb)){
				cpti = lcpti;
				break;
			}

			if(strlen(cpti->isrc)!=0){
				/* ISRC */
				DebugLog("CreateCueSheet: ISRC.\n");
				num_cs += 2;
				cs = (struct _CUESHEET *)MemResize(cs, num_cs * sizeof(struct _CUESHEET));
				if(cs==NULL)
					return RET_MEMERR;
				csp = &cs[cur_cs++];
				csp->ctladr = CSADR_ISRC;
				csp->tno = (BYTE)track_num;
				memcpy(&csp->index, cpti->isrc, 6);
				csp = &cs[cur_cs++];
				csp->ctladr = CSADR_ISRC;
				csp->tno = (BYTE)track_num;
				memcpy(&csp->index, cpti->isrc+6, 6);
			}
			gap_2part = FALSE;
			if(gap_len==0){
#if 1	/* ̕ǂ? */
				if(lcpti!=NULL){
					gap_len = Get4bytes(cpti->trackinfo.track_start) -
						(Get4bytes(lcpti->trackinfo.track_start) +
						 Get4bytes(lcpti->trackinfo.track_size));
					if(IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
						/* DATA */
						if(!IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode) ||
						   lcpti->mode2 != cpti->mode2){
							/* 2part */
							DebugLog("CreateCueSheet: Two part pregap.(cdda -> data)\n");
							gap_2part = TRUE;
						}
					}
					else{
						/* AUDIO */
						if(IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode)){
							/* ODATȀꍇ? */
							DebugLog("CreateCueSheet: Two part pregap.(data -> cdda)\n");
							gap_2part = TRUE;
						}
					}
				}
#else
				if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
					/* AUDIO */
					gap_len = cpti->pause_len;
				}
				else if(lcpti!=NULL){
					/* DATA  2nd ȍ~ */
					gap_len = 150;
					if(!IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode) ||
					   lcpti->mode2 != cpti->mode2){
						/* 2part */
						gap_len = 75+150;
						gap_2part = TRUE;
					}
				}
#endif
			}
			nwa = Get4bytes(cpti->trackinfo.track_start) - gap_len;
			DebugLog("CreateCueSheet: track=%d gap=%ld nwa=0x%08lX\n",
					 track_num, gap_len, nwa);
			if(gap_len>0){
				/* pre-gap */
				if(gap_2part && gap_len>150){
					num_cs++;
					cs = (struct _CUESHEET *)MemResize(cs, num_cs * sizeof(struct _CUESHEET));
					if(cs==NULL)
						return RET_MEMERR;
					csp = &cs[cur_cs++];
					csp->ctladr = IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
					csp->ctladr |= CSADR_NORMAL;
					csp->tno = (BYTE)track_num;
					csp->index = 0;
#if SEND_GAPDATA
					if(!IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode)){
						csp->dataform = 0x00;
					}
					else{
						csp->dataform = lcpti->mode2 ? 0x20 : 0x10;
					}
#else
					if(!IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode)){
						csp->dataform = 0x01;
					}
					else{
						csp->dataform = lcpti->mode2 ? 0x24 : 0x14;
					}
#endif
					csp->scms = lcpti->trackinfo.copy ? 0x80 : 0;
					LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
					nwa += (gap_len-150);
					gap_len = 150;
					DebugLog("CreateCueSheet: Pre-gap.\n");
				}
				num_cs++;
				cs = (struct _CUESHEET *)MemResize(cs, num_cs * sizeof(struct _CUESHEET));
				if(cs==NULL)
					return RET_MEMERR;
				csp = &cs[cur_cs++];
				csp->ctladr = IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
				csp->ctladr |= CSADR_NORMAL;
				csp->tno = (BYTE)track_num;
				csp->index = 0;
#if SEND_GAPDATA
				if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
					csp->dataform = 0x00;
				}
				else{
					csp->dataform = cpti->mode2 ? 0x20 : 0x10;
				}
#else
				if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
					csp->dataform = 0x01;
				}
				else{
					csp->dataform = cpti->mode2 ? 0x24 : 0x14;
				}
#endif
				csp->scms = cpti->trackinfo.copy ? 0x80 : 0;
				LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
	
				nwa += gap_len;
			}
			/* Audio/Data */
			num_cs++;
			cs = (struct _CUESHEET *)MemResize(cs, num_cs * sizeof(struct _CUESHEET));
			if(cs==NULL)
				return RET_MEMERR;
			csp = &cs[cur_cs++];
			csp->ctladr = IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
			csp->ctladr |= CSADR_NORMAL;
			csp->tno = (BYTE)track_num;
			csp->index = 1;
			if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode))
				csp->dataform = 0x00;
			else
				csp->dataform = cpti->mode2 ? 0x20 : 0x10;
			csp->scms = cpti->trackinfo.copy ? 0x80 : 0;
			LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
			nwa += Get4bytes(cpti->trackinfo.track_size);
			DebugLog("CreateCueSheet: Track%d.\n", track_num);
		}
		/* Lead-out */
		num_cs++;
		cs = (struct _CUESHEET *)MemResize(cs, num_cs * sizeof(struct _CUESHEET));
		if(cs==NULL)
			return RET_MEMERR;
		csp = &cs[cur_cs++];
		csp->ctladr = IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
		csp->ctladr |= CSADR_NORMAL;
		csp->tno = 0xAA;
		csp->index = 1;
		if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode))
			csp->dataform = 0x01;
		else
			csp->dataform = cpti->mode2 ? 0x24 : 0x14;
		csp->scms = cpti->trackinfo.copy ? 0x80 : 0;
		LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
		DebugLog("CreateCueSheet: Lead-out.\n", track_num);

		*cs_ret = cs;

		if(REALDRIVE(drive)){
			ret = SendSendCueSheet(drive, cs, num_cs*sizeof(struct _CUESHEET));
			if(ret!=RET_OK){
				if(!retry && cdtext){
					cdtext = FALSE;	/* CD-TEXT 𖳌ɂăgC */
					DebugLog("CreateCueSheet: Retry(CD-TEXT is ignored).\n");
				}
				else{
					DispCommandError(drive);
					*cs_ret = NULL;
					MemFree(cs);
					return ret;
				}
			}
		}
		if(ret==RET_OK)
			break;
	}

	DebugLog("CreateCueSheet: Done.\n", track_num);
	return RET_OK;
}


/**
 * 1ZbV
 * @param[in]	src	ǎ摕u\
 * @param[in]	dst	u\̔z
 * @param[in]	num_dst	u\̔z
 * @param[in]	discinfo  fBXN
 * @param[out]	track_num_ret ̃gbNԍ
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int CopySession(CMDDRIVE *src, CMDDRIVE *dst, int num_dst,
					   CPDISCINFO *discinfo,
					   WORD *track_num_ret)
{
	int ret=RET_OK;
	WORD track_num = *track_num_ret;
	struct _CUESHEET *cs=NULL, *csp;
	BOOL done=FALSE;
	DWORD lba, blocks;
	DWORD translen, blocksize;
	char msgbuf[80];
	int index;
	BOOL leadin=FALSE;

	for(index=0; index<num_dst; index++){
		if(cs!=NULL){
			MemFree(cs);
			cs=NULL;
		}
		ret = SetWriteParametersPage(&dst[index], discinfo, track_num, TRUE);
		if(ret!=RET_OK)
			return ret;

		ret = CreateCueSheet(&dst[index], discinfo, track_num, &cs);
		if(ret!=RET_OK)
			return ret;
	}

	for(csp=cs; !done; csp++){
		if((csp->ctladr & 0x0f)!=CSADR_NORMAL)
			continue;
		if(csp->tno==0xaa){
			done=TRUE;
			continue;
		}
		if(csp->dataform==0x24 || csp->dataform==0x14 || csp->dataform==0x01){
			/* f[^]iV */
			if(csp->dataform==0x01){
				if(REALDRIVE(dst)){
					UIDispInfo(MSG_WRITING_LEAD_IN /*"L^"*/);
					leadin = TRUE;
				}
			}
			continue;
		}
		if(csp->dataform==0x41){
			/* CD-TEXT */
			if(REALDRIVE(dst)){
				UIDispInfo(MSG_WRITING_CDTEXT /*"CD-TEXTL^"*/);
			}
			ret = WriteCDText(dst, num_dst, discinfo);
			if(ret!=RET_OK)
				break;
			continue;
		}
		lba = MSF2LBA(csp->min, csp->sec, csp->frame, FALSE);
#if 1
		if(csp->index==0){
			blocks = MSF2LBA((csp+1)->min, (csp+1)->sec, (csp+1)->frame, FALSE) -lba;
		}
		else{
			blocks = Get4bytes(discinfo->trackinfo[csp->tno-1].trackinfo.track_size);
		}
#else	/* CueSheet狁߂ꍇ́AISRC𖳎ėLMSGKv */
		blocks = MSF2LBA((csp+1)->min, (csp+1)->sec, (csp+1)->frame, FALSE) - lba;
#endif
		switch(csp->dataform){
		case 0x20:
			blocksize = 2336;
			break;
		case 0x10:
			blocksize = 2048;
			break;
		default:
			blocksize = 2352;
		}
		if(REALDRIVE(src))
			translen = src->bufsize / (blocksize==2048 ? 2048 : 2352);
		else
			translen = dst[0].bufsize / (blocksize==2048 ? 2048 : 2352);
		if(blocksize*translen >= 0x10000){
			/* wnaspi32.dll ł 64KB ]łȂ炵̂ */
			translen = 0xffff / (blocksize==2048 ? 2048 : 2352);
		}

		/* ʕ\ */
		sprintf(msgbuf, MSG_TRACK_ /*"gbN%d"*/, csp->tno);
		UIMeter2Initialize(msgbuf);
		if(src->type==CMDDRVTYPE_NET){
			NAUIMeter2Initialize(&src->u.net, msgbuf);
		}

		if(GetOption()->outside
		   && (discinfo->outside_offset > 0)
		   && (track_num == 1)
		   && !leadin
		   && csp->index == 1){
			/* _~[1stgbN̋L^ */
			ret = WriteLoop(src, dst, num_dst,
							lba, blocks, translen, blocksize,
							FALSE, discinfo, TRUE, FALSE, TRUE);
		}
		else{
			ret = WriteLoop(src, dst, num_dst,
							lba, blocks, translen, blocksize,
							FALSE, discinfo, TRUE, leadin,
							(csp->index==0));
		}
		if(ret!=RET_OK){
			break;
		}
		*track_num_ret = csp->tno;
		leadin = FALSE;
	}

	for(index=0; index<num_dst; index++){
		SyncCache(&dst[index]);
	}

	(*track_num_ret)++;

	MemFree(cs);
	return ret;
}


/**
 * DAO(Disc at once)ŕ
 * @param[in]	src	ǎ摕u\
 * @param[in]	dst	u\̔z
 * @param[in]	num_dst	u\̔z
 * @param[in]	discinfo  fBXN
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int CopyDAO(CMDDRIVE *src, CMDDRIVE *dst, int num_dst,
				   CPDISCINFO *discinfo)
{
	int disc_type;
	int ret;
	int index;

	if(!REALDRIVE(src) && !REALDRIVE(&dst[0]))
		return RET_NG;

	if(REALDRIVE(src))
		disc_type = src->disc_type;
	else
		disc_type = dst[0].disc_type;

	if(DT_CD_FAMILY(disc_type)){
		/* ͂₱ɂ͗Ȃ */
		UIDispMessage(MSG_CANT_WRITE_CD_DAO
					  /*"cOȂACD  DAO ͂ł܂B"*/,
					  UIDMT_ERROR);
		return RET_ABORT;
	}
	else{
		/* DVD-R/-RW */
		for(index=0; index<num_dst; index++){
			ret = SetWriteParametersPage(&dst[index], discinfo, 1,
										 GetOption()->dao);
			if(ret!=RET_OK)
				return ret;
			ret = ReserveTrack(&dst[index],
							   Get4bytes(discinfo->trackinfo[0].trackinfo.track_size));
			if(ret!=RET_OK)
				return ret;
		}

		ret = CopyTrack(src, dst, num_dst, discinfo, 1);
		if(ret!=RET_OK)
			return ret;
	}

	return RET_OK;
}


/**
 * ISOItZbgvZ
 * @param[in]	discinfo  fBXN
 * @param[in]	dst       u\̔z
 * @param[in]	num_dst   u\̔z
 * @note vZʂdiscinfo->outside_offsetɊi[B
 */
static void CalcOffset(CPDISCINFO *discinfo, CMDDRIVE *dst, int num_dst)
{
	int index;
	int ret;
	DWORD last_lout_min = 0xffffffff;
	DWORD last_lout;
	DWORD run_out = 2;

	discinfo->outside_offset = 0;

	if(discinfo->sessions != 1){
		return;
	}
	if(discinfo->tracks != 1){
		return;
	}
	if(!IS_TRACKMODE_DATA(discinfo->trackinfo[0].trackinfo.track_mode)){
		return;
	}

	for(index=0; index<num_dst; index++){
		ret = GetWritableSize(&dst[index], &last_lout);
		if(ret == RET_OK){
			if(last_lout < last_lout_min){
				last_lout_min = last_lout;
			}
		}
	}

	if(last_lout_min == 0xffffffff){
		return;
	}
  
	/*
	 * 1stSession Lead-out  60b?(60*75ubN)
	 * 2nsSession Lead-in  90b?(90*75ubN)
	 * pre-gap  2b(2*75ubN)
	 * 1stTrack(_~[)Œ 4b(4*75ubN)
	 */
	if(last_lout_min < discinfo->last_addr +run_out +156*75){
		return;
	}

	discinfo->outside_offset = last_lout_min - discinfo->last_addr;
	DebugLog("offset=0x%08lX\n", discinfo->outside_offset);
	DebugLog("last_lout_min = 0x%08lX\n", last_lout_min);
	DebugLog("last_addr = 0x%08lX\n", discinfo->last_addr);

	/* _~[1stgbNfBXNɒǉ */
	discinfo->trackinfo =
		(CPTRACKINFO *)MemResize(discinfo->trackinfo, sizeof(CPTRACKINFO)*2);
	if(discinfo->trackinfo == NULL){
		discinfo->outside_offset = 0;
		return;
	}
	memmove(discinfo->trackinfo+1, discinfo->trackinfo+0,
			sizeof(CPTRACKINFO));
	discinfo->trackinfo[1].trackinfo.track_number_lsb = 2;
	discinfo->trackinfo[1].trackinfo.session_number_lsb = 2;
	Set4bytes(discinfo->trackinfo[1].trackinfo.track_start,
			  Get4bytes(discinfo->trackinfo[1].trackinfo.track_start)
			  +discinfo->outside_offset);

	Set4bytes(discinfo->trackinfo[0].trackinfo.track_size,
			  discinfo->outside_offset-run_out-152*75);

	/* fBXNXV */
	discinfo->last_addr += discinfo->outside_offset;
	discinfo->sessions = 2;
	discinfo->tracks = 2;
}


/**
 * ʂ̎s
 * @param[in]	src	ǎ摕u\
 * @param[in]	dst	u\̔z
 * @param[in]	num_dst	u\̔z
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int ExecCopy(CMDDRIVE *src, CMDDRIVE *dst, int num_dst)
{
	int ret;
	CPDISCINFO discinfo;
	DWORD free_size;
	WORD track_num;
	WORD sess_num;
	CPTRACKINFO *cpti;
	BOOL sao=FALSE;
	int index;

	for(index=0; index<num_dst; index++){
		/* L^悤ƂfBXNBLANKłȂBLANKs */
		ret = Blanking(&dst[index]);
		if(ret!=RET_OK)
			return ret;
		/* L^fBA DVD+RW ŁAtH[}bgȂtH[}bgJn */
		ret = Formatting(&dst[index]);
		if(ret!=RET_OK)
			return ret;
	}
	
	/* \[XfBXN̏𓾂(ReadDiscInfo. & ReadTrackInfo.) */
	ret = GetDiscInformation(src, &discinfo);
	if(ret!=RET_OK)
		return ret;
  
	if(discinfo.last_addr==0){
		UIDispMessage(MSG_SOURCE_IS_BLANK
					  /*"ʌfBXN̓uNłBʂł܂B"*/,
					  UIDMT_INFORMATION);
		MemFree(discinfo.trackinfo);
		MemFree(discinfo.cdtext);
		return RET_ABORT;
	}

	/* L^zhCuȂAC[Wt@CɃfBXNo */
	if(num_dst==1){
		ret = SetDiscInformation(&dst[0], &discinfo);
		if(ret!=RET_OK){
			MemFree(discinfo.trackinfo);
			MemFree(discinfo.cdtext);
			return ret;
		}
	}

	for(index=0; index<num_dst; index++){
		if(REALDRIVE(&dst[index])){
			if(dst[index].disc_type!=DT_DVDRWO &&
			   dst[index].disc_type!=DT_DVDRWS &&
			   dst[index].disc_type!=DT_DVDPRW){
				/* DVD-RW/+RW łȂꍇAeʃ`FbN */
				/* WriteParametersPageݒɂăt[ubN
				   eĂ܂ */
				ret = SetWriteParametersPage(&dst[index], &discinfo, 1,
											 !discinfo.trackinfo[0].tao );
				if(ret!=RET_OK){
					MemFree(discinfo.trackinfo);
					MemFree(discinfo.cdtext);
					return ret;
				}

				/* L^fBXN̋󂫗eʂ𓾂 */
				ret = GetWritableSize(&dst[index], &free_size);
				if(ret!=RET_OK){
					MemFree(discinfo.trackinfo);
					MemFree(discinfo.cdtext);
					return ret;
				}
				if(free_size < discinfo.last_addr){
					ret = UIDispMessage(MSG_CAPACITY_IS_INSUFFICIENT
										/*"L^fBXNeʂsĂ܂B\nđs܂?"*/,
										UIDMT_QUESTION);
					if(ret==UIDMRET_CANCEL){
						MemFree(discinfo.trackinfo);
						MemFree(discinfo.cdtext);
						return RET_ABORT;
					}
				}
			}

			if(dst[0].disc_type!=DT_DVDR &&
			   dst[0].disc_type!=DT_DVDRWO &&
			   dst[0].disc_type!=DT_DVDRWS){
				/* DVD-R/-RW ȊO DAO  */
				GetOption()->dao = FALSE;
			}
		}
	}

	/* ISOOL^̂炵ubNvZ */
	if(GetOption()->outside){
		if(REALDRIVE(&dst[0])){
			CalcOffset(&discinfo, dst, num_dst);
			SetOffset(discinfo.outside_offset);
		}
	}

	/* Ǎxݒ */
	ret = SetSpeed(src, GetOption()->read_speed, 0);
	if(ret!=RET_OK){
		MemFree(discinfo.trackinfo);
		MemFree(discinfo.cdtext);
		SetOffset(0);
		return ret;
	}

	for(index=0; index<num_dst; index++){
		/* L^xݒ */
		ret = SetSpeed(&dst[index],
					   GetOption()->write_speed,
					   GetOption()->write_speed);
		if(ret!=RET_OK){
			MemFree(discinfo.trackinfo);
			MemFree(discinfo.cdtext);
			SetOffset(0);
			return ret;
		}
	}

	if(GetOption()->dao){
		ret = CopyDAO(src, dst, num_dst, &discinfo);
		if(ret!=RET_OK){
			MemFree(discinfo.trackinfo);
			MemFree(discinfo.cdtext);
			SetOffset(0);
			return ret;
		}
	}
	else{
		track_num=1;
		for(sess_num=1; sess_num<=discinfo.sessions; sess_num++){
			if(track_num > discinfo.tracks)
				break;
			if(track_num==discinfo.tracks &&
			   discinfo.trackinfo[track_num-1].trackinfo.blank){
				/* ŏIgbNBLANKȂ牽I */
				break;
			}
			if(discinfo.trackinfo[track_num-1].tao==FALSE){
				/* SAOL^ */
				sao = TRUE;
				ret = CopySession(src, dst, num_dst, &discinfo, &track_num);
				if(ret!=RET_OK){
					MemFree(discinfo.trackinfo);
					MemFree(discinfo.cdtext);
					SetOffset(0);
					return ret;
				}
				continue;
			}

			/* TAOL^ */
			sao = FALSE;
			for(; track_num <= discinfo.tracks; track_num++){
				cpti = &discinfo.trackinfo[track_num-1];
				if(sess_num !=
				   ((WORD)cpti->trackinfo.session_number_msb<<8 |
					(WORD)cpti->trackinfo.session_number_lsb)){
					/* ̃ZbV͏I */
					ret = CloseSession(dst, num_dst);
					if(ret!=RET_OK){
						MemFree(discinfo.trackinfo);
						MemFree(discinfo.cdtext);
						SetOffset(0);
						return ret;
					}
					break;
				}
				if(track_num==discinfo.tracks &&
				   discinfo.trackinfo[track_num-1].trackinfo.blank){
					/* ŏIgbNBLANKȂ牽I */
					break;;
				}
	      
				ret = CopyTrack(src, dst, num_dst, &discinfo, track_num);
				if(ret!=RET_OK){
					MemFree(discinfo.trackinfo);
					MemFree(discinfo.cdtext);
					SetOffset(0);
					return ret;
				}
			}
		}
	  
		if(discinfo.last_sess_stat==SESSSTAT_COMPLETE && sao==FALSE){
			ret = CloseSession(dst, num_dst);
			if(ret!=RET_OK){
				MemFree(discinfo.trackinfo);
				MemFree(discinfo.cdtext);
				SetOffset(0);
				return ret;
			}
		}
	}
	
	MemFree(discinfo.trackinfo);
	MemFree(discinfo.cdtext);
	SetOffset(0);
	
	return RET_OK;
}



/**
 * ㏈
 * @param[in]	retcode	sʃR[h
 * @param[in]	src	ǎ摕u\
 * @param[in]	dst	u\̔z
 * @param[in]	num_dst	u\̔z
 */
void PostProcess(int retcode, CMDDRIVE *src, CMDDRIVE *dstp, int num_dst)
{
	int ret;
	int index;
	BOOL socket_error = FALSE;

	if(retcode==RET_SOCKET){
		if(src->type==CMDDRVTYPE_NET)
			socket_error = DispSocketError(&src->u.net, retcode);
		else
			socket_error = DispSocketError(&dstp->u.net, retcode);
	}

	if(src->type == CMDDRVTYPE_NET){
		if(retcode==RET_OK){
			NASendComplete(&src->u.net);
		}
		else if(retcode==RET_ABORT){
			NASendAbort(&src->u.net);
		}
		FreeSOCKCB(&src->u.net);
	}
	if(dstp->type == CMDDRVTYPE_NET){
		if(retcode==RET_OK){
			NASendComplete(&dstp->u.net);
		}
		else if(retcode==RET_ABORT){
			NASendAbort(&dstp->u.net);
		}
		FreeSOCKCB(&dstp->u.net);
	}
  
	if(socket_error==FALSE){
		if(retcode==RET_ABORT){
			UIDispMessage(MSG_ABORTED/*"f܂B"*/, UIDMT_INFORMATION);
		}
		else if(retcode==RET_OK){
			if(!REALDRIVE(src) && !REALDRIVE(dstp)){
				UIDispMessage(MSG_COMPLETE_SUCCESS
							  /*"ɏI܂B"*/,
							  UIDMT_INFORMATION);
			}
			else{
				ret = UIDispMessage(MSG_COMPLETE_SUCCESS_AND_EJECT
									/*"ɏI܂Bro܂?"*/,
									UIDMT_QUESTION);
				if(ret==UIDMRET_OK){
					for(index=0; index<num_dst; index++){
						OpenTray(&dstp[index]);
					}
					OpenTray(src);
				}
			}
		}
		else{
			if(!REALDRIVE(src) && !REALDRIVE(dstp)){
				UIDispMessage(MSG_ERROR_OCCURRED
							  /* "G[܂B" */,
							  UIDMT_ERROR);
			}
			else{
				ret = UIDispMessage(MSG_ERROR_OCCURRED
									/*"G[܂BR}hO𐶐܂?"*/,
									UIDMT_QUESTION);
				if(ret==UIDMRET_OK){
					CreateLog(src, dstp, num_dst);
				}
			}
		}
	}
}

/**
 * ǎ摕ȕ
 * @param[in]	reader ǎ摕uID
 * @param[out]	drive hCu\
 * @param[in]	data_buf f[^obt@
 * @param[in]	bufsize f[^obt@TCY
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int OpenReader(DRIVEID *reader, CMDDRIVE *drive,
					  BYTE *data_buf, int bufsize)
{
	int ret;

	if(reader->hid == HID_VIRTUAL){
		if(reader->tid == CMDDRVTYPE_ISO){
			/* ISOC[W */
			ret = OpenISOImageDevice(drive, TRUE, data_buf, bufsize);
			if(ret != RET_OK){
				return ret;
			}
		}
		else if(reader->tid == CMDDRVTYPE_IMAGE){
			/* IWiC[W */
			ret = OpenEnbanImageDevice(drive, TRUE, data_buf, bufsize);
			if(ret != RET_OK){
				return ret;
			}
		}
		else if(reader->tid == CMDDRVTYPE_NET){
			/* lbg[Nڑꂽu */
			ret = OpenNetDevice(drive, FALSE, data_buf, bufsize);
			if(ret != RET_OK){
				return ret;
			}
		}
		else{
			return RET_NG;
		}
	}
	else{
		/* ʏ̃foCX */
		ret = OpenDevice(drive, reader->hid, reader->tid, TRUE, TRUE,
						 data_buf, bufsize);
		if(ret != RET_OK){
			return ret;
		}
	}
	return RET_OK;
}


/**
 * ǎ摕ǔЕt
 * @param[in/out] drive hCu\
 */
static void CloseReader(CMDDRIVE *drive)
{
	CloseDevice(drive);
}


/**
 * ȕ
 * @param[in]	writer uIDz
 * @param[in]	num_writer u
 * @param[out]	drive hCu\
 * @param[out]	num_writable_drive \hCu
 * @param[in]	data_buf f[^obt@
 * @param[in]	bufsize f[^obt@TCY
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int OpenWriter(DRIVEID *writer, int num_writer,
					  CMDDRIVE *drive, int *num_writable_drive,
					  BYTE *data_buf, int bufsize)
{
	int index;
	int ret;
	CMDDRIVE tmpdrive;

	if(writer->hid == HID_VIRTUAL){
		memset(&tmpdrive, 0, sizeof(tmpdrive));
		if(writer->tid == CMDDRVTYPE_ISO){
			/* ISOC[W */
			ret = OpenISOImageDevice(&tmpdrive, FALSE, data_buf, bufsize);
			if(ret != RET_OK){
				return ret;
			}
		}
		else if(writer->tid == CMDDRVTYPE_IMAGE){
			/* IWiC[W */
			ret = OpenEnbanImageDevice(&tmpdrive, FALSE, data_buf, bufsize);
			if(ret != RET_OK){
				return ret;
			}
		}
		else if(writer->tid == CMDDRVTYPE_NET){
			/* lbg[Nڑꂽu */
			ret = OpenNetDevice(&tmpdrive, TRUE, data_buf, bufsize);
			if(ret != RET_OK){
				return ret;
			}
		}
		else{
			return RET_NG;
		}
		memcpy(&drive[0], &tmpdrive, sizeof(CMDDRIVE));
		*num_writable_drive = 1;
	}
	else{
		/* ʏ̃foCX */
		for(index=0; index<num_writer; index++){
			memset(&tmpdrive, 0, sizeof(tmpdrive));
			ret = OpenDevice(&tmpdrive, writer[index].hid, writer[index].tid,
							 FALSE, (num_writer==1), data_buf, bufsize);
			if(ret != RET_OK){
				continue;
			}
			memcpy(&drive[*num_writable_drive], &tmpdrive, sizeof(CMDDRIVE));
			(*num_writable_drive)++;
		}
		if(*num_writable_drive == 0){
			return RET_NG;
		}
	}

	return RET_OK;
}


/**
 * ǔЕt
 * @param[in/out] drive hCu\̔z
 * @param[in]	num_drive hCu\̔z
 */
static void CloseWriter(CMDDRIVE *drive, int num_drive)
{
	int index;

	for(index=0; index<num_drive; index++){
		CloseDevice(&drive[index]);
	}
}

/**
 * ~Ղ𕡎
 * @param[in]	reader	ǎ摕uID
 * @param[in]	writer	uIDz
 * @param[in]	num_writer  u
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
int CopyDisc(DRIVEID *reader, DRIVEID *writer, int num_writer)
{
	BOOL bSameDrive=FALSE;
	BOOL bDVD=FALSE;
	CMDDRIVE src, virtual_drv, *dstp=NULL;
	int ret;
	OPTIONS *option;
	int index;
	int num_writable_drive=0;
	int disc_type;
	BYTE *data_buf;
	int bufsize;
	char tmpfile[_MAX_PATH];

	MemDebugStart();
  
	memset(&src, 0, sizeof(src));
	memset(&virtual_drv, 0, sizeof(virtual_drv));
  
	UICheckAbort();
  
	if(reader->hid != HID_VIRTUAL && writer->hid != HID_VIRTUAL){
		if(reader->hid == writer->hid &&
		   reader->tid == writer->tid){
			bSameDrive = TRUE;
		}
	}

	if(!bSameDrive){
		dstp = (CMDDRIVE *)MemNew(num_writer*sizeof(CMDDRIVE));
		if(dstp==NULL){
			UIDispMessage(MSG_MEM_ALLOC_ERROR
						  /*"mۂɎs܂B"*/, UIDMT_ERROR);
			MemDumpLeaks();
			MemDebugEnd();
			return RET_NG;
		}
		memset(dstp, 0, num_writer*sizeof(CMDDRIVE));
	}
	bufsize = 0x10000;
	data_buf = (BYTE *)MemNew(bufsize);
	if(data_buf==NULL){
		UIDispMessage(MSG_MEM_ALLOC_ERROR
					  /*"mۂɎs܂B"*/, UIDMT_ERROR);
		MemFree(dstp);
		MemDumpLeaks();
		MemDebugEnd();
		return RET_NG;
	}
	
	/* ǎ摕ũI[v */
	ret = OpenReader(reader, &src, data_buf, bufsize);
	if(ret!=RET_OK){
		MemFree(dstp);
		MemFree(data_buf);
		MemDumpLeaks();
		MemDebugEnd();
		return ret;
	}
	disc_type = src.disc_type;

	/* ũI[v */
	if(bSameDrive){
		ret = SetOption(&src, &src, src.disc_type);
		if(ret!=RET_OK){
			CloseReader(&src);
			MemFree(dstp);
			MemFree(data_buf);
			MemDumpLeaks();
			MemDebugEnd();
			return ret;
		}
		num_writable_drive = 1;
	}
	else{
		ret = OpenWriter(writer, num_writer, dstp, &num_writable_drive,
						 data_buf, bufsize);
		if(ret != RET_OK){
			CloseReader(&src);
			MemFree(dstp);
			MemFree(data_buf);
			MemDumpLeaks();
			MemDebugEnd();
			return ret;
		}

		if((writer->hid == HID_VIRTUAL) &&
		   (writer->tid == CMDDRVTYPE_NET)){
			/* lbg[Nڑꂽȕꍇ */
			/* T[o[hҋ@ */
			ret = WaitingNetCmd(&dstp[0], &src);
			PostProcess(ret, &src, &dstp[0], num_writable_drive);
			CloseReader(&src);
			CloseWriter(dstp, num_writable_drive);
			MemFree(dstp);
			MemFree(data_buf);
			MemDumpLeaks();
			MemDebugEnd();
			return ret;
		}
    
		if(disc_type==DT_UNKNOWN){
			disc_type = dstp[0].disc_type;
		}
    
		ret = SetOption(&src, &dstp[0], disc_type);
		if(ret!=RET_OK){
			CloseReader(&src);
			CloseWriter(dstp, num_writable_drive);
			MemFree(dstp);
			MemFree(data_buf);
			MemDumpLeaks();
			MemDebugEnd();
			return ret;
		}
	}
  
	/* ꎞt@C */
	strcpy(tmpfile, GetOption()->temppath);
	if(strlen(tmpfile)+1+7+1>=sizeof(tmpfile)){
		MemDumpLeaks();
		MemDebugEnd();
		return RET_NG;
	}
#ifdef WIN32
	if(strlen(tmpfile)>0){
		if(tmpfile[strlen(tmpfile)-1]=='\\')
			strcat(tmpfile, "tmp.img");
		else
			strcat(tmpfile, "\\tmp.img");
	}
	else
		strcat(tmpfile, "\\tmp.img");
#else
	strcat(tmpfile, "/tmp.img");
#endif
  
	UIMeter1Initialize(MSG_TOTAL /*"S"*/);
	if(src.type==CMDDRVTYPE_NET){
		NAUIMeter1Initialize(&src.u.net, MSG_TOTAL /*"S"*/);
	}

	option = GetOption();
	if(option->on_the_fly){
		/* On-The-Fly */
		bDVD = DT_DVD_FAMILY(disc_type);
		for(index=0; index<num_writable_drive; index++){
			if(!REALDRIVE(&dstp[index])){
				dstp[index].disc_type = disc_type;
			}
			else if((bDVD != DT_DVD_FAMILY(dstp[index].disc_type)) &&
					REALDRIVE(&src)){
				UIDispMessage(MSG_CANT_COPY_DIFFERENT_TYPE
							  /*"CD  DVD ADVD  CD ɂ̓Rs[ł܂B"*/,
							  UIDMT_ERROR);
				CloseReader(&src);
				CloseWriter(dstp, num_writable_drive);
				MemFree(dstp);
				MemFree(data_buf);
				MemDumpLeaks();
				MemDebugEnd();
				return RET_NG;
			}
		}
		ret = ExecCopy(&src, dstp, num_writable_drive);
		PostProcess(ret, &src, dstp, num_writable_drive);
		CloseReader(&src);
		CloseWriter(dstp, num_writable_drive);
		MemFree(dstp);
		MemFree(data_buf);
	}
	else{
		/* ꎞt@CoR */
		ret = OpenTempImageDevice(&virtual_drv, FALSE, data_buf, bufsize, tmpfile);
		if(ret!=RET_OK){
			CloseReader(&src);
			if(!bSameDrive){
				CloseWriter(dstp, num_writable_drive);
			}
			MemFree(dstp);
			MemFree(data_buf);
			MemDumpLeaks();
			MemDebugEnd();
			return ret;
		}
    
		virtual_drv.disc_type = src.disc_type;
    
		ret = ExecCopy(&src, &virtual_drv, 1);	/* DISC => Image file */
		if(ret==RET_OK){
			OpenTray(&src);
			if(src.type == CMDDRVTYPE_NET){
				NASendComplete(&src.u.net);
			}
		}
		else{
			PostProcess(ret, &src, &virtual_drv, 1);
		}
		if(bSameDrive){
			dstp = &src;
		}
		else{
			CloseReader(&src);
		}
		CloseDevice(&virtual_drv);
		if(ret!=RET_OK){ /* ExecCopy̖߂lmF */
			RemoveImageFile(tmpfile);
			CloseWriter(dstp, num_writable_drive);
			if(!bSameDrive){
				MemFree(dstp);
			}
			MemFree(data_buf);
			MemDumpLeaks();
			MemDebugEnd();
			return ret;
		}
    
		ret = OpenTempImageDevice(&virtual_drv, TRUE, data_buf, bufsize, tmpfile);
		if(ret!=RET_OK){
			CloseWriter(dstp, num_writable_drive);
			if(!bSameDrive){
				MemFree(dstp);
			}
			MemFree(data_buf);
			MemDumpLeaks();
			MemDebugEnd();
			return ret;
		}
		if(bSameDrive){
			/* fBXN}҂ */
			ret = GetDiscType(&dstp[0], &dstp[0].disc_type, TRUE);
			if(ret!=RET_OK){
				PostProcess(ret, &virtual_drv, dstp, num_writable_drive);
				CloseDevice(&virtual_drv);
				RemoveImageFile(tmpfile);
				CloseWriter(dstp, num_writable_drive);
				if(!bSameDrive){
					MemFree(dstp);
				}
				MemFree(data_buf);
				MemDumpLeaks();
				MemDebugEnd();
				return ret;
			}
		}
    
		/* Image file => DISC */
		ret = ExecCopy(&virtual_drv, dstp, num_writable_drive);
		PostProcess(ret, &virtual_drv, dstp, num_writable_drive);
		CloseDevice(&virtual_drv);
		RemoveImageFile(tmpfile);
		CloseWriter(dstp, num_writable_drive);
		if(!bSameDrive){
			MemFree(dstp);
		}
		MemFree(data_buf);
	}

	MemDumpLeaks();
	MemDebugEnd();
	return ret;
}

