/* ~Օʉ - EnbanKensa
 * Copyright (c) 2005 Kagetani Hideto
 * MainWindowControl.m - 呋
 * $Date: 2005/12/07 15:35:35 $
 * $Revision: 1.2 $
 */
#define COCOA
#import "MainWIndowControl.h"
#import "SettingDialogControl.h"
#import "ui.h"
#import <scan.h>
#import <check.h>


@implementation MainWIndowControl

static NSImage *g_drawAreaImage=NULL;
static NSFont *g_font=NULL;
static SCAN_t *g_ReaderList=NULL;
static BOOL g_bRunningCheck=FALSE;
static UIWIDGETINFO g_widgetInfo;

- (IBAction)exitProgram:(id)sender
{
  [NSApp terminate: self];
}

- (IBAction)scanDrive:(id)sender
{
	int i;

	g_ReaderList = ScanDrive(FALSE);

	[drive removeAllItems];
	for(i=0; strlen(g_ReaderList[i].inqdata)!=0; i++){
	  [drive addItemWithTitle: [NSString stringWithCString:
		g_ReaderList[i].inqdata]];
	}
	if(i==0){
	  [buttonStart setEnabled: NO];
	}
	else{
	  [buttonStart setEnabled: YES];
	}
}

- (IBAction)startCheck:(id)sender
{
  if(g_bRunningCheck){
	UISetAbort();
	[buttonStart setEnabled: NO];
	return;
  }

  int sel_drive;
  DRIVEID drvid;
  int ret;
  
	  /* IhCu擾 */
  sel_drive = [drive indexOfSelectedItem];

  drvid.hid = g_ReaderList[sel_drive].hid;
  drvid.tid = g_ReaderList[sel_drive].tid;

  UIClearAbort();
  g_bRunningCheck = TRUE;
  [drive setEnabled: NO];
  [buttonStart setTitle: [NSString stringWithCString: "f"]];

  ret = CheckDisc(&drvid);

  [buttonStart setTitle: [NSString stringWithCString: "Jn"]];
  [buttonStart setEnabled: YES];
  [drive setEnabled: YES];
  g_bRunningCheck = FALSE;
}

- (void)startUp
{
  [self scanDrive: self];
  NSRect rect = [drawArea bounds];
  g_drawAreaImage = [[NSImage alloc]initWithSize: rect.size];
  [drawArea setImage:g_drawAreaImage];
  [g_drawAreaImage lockFocus];
  [[NSColor blackColor] set];
  NSRectFill(NSMakeRect(0, 0, rect.size.width, rect.size.height));
  [g_drawAreaImage unlockFocus];
  [drawArea setNeedsDisplay:YES];
  g_font = [NSFont fontWithName:@"Osaka" size:16];
  g_widgetInfo.label = infoMessage;
  g_widgetInfo.view = drawArea;
  g_widgetInfo.settingPanel = settingPanel;
  g_widgetInfo.drawArea = g_drawAreaImage;
  g_widgetInfo.font = g_font;
  UISetWidgetInfo(&g_widgetInfo);
}


/*
 * delegate
 */
- (void) applicationDidFinishLaunching: (NSNotification *)aNotification
{
    [self startUp];
}

- (void) applicationWillTerminate: (NSNotification *)aNotification
{
    if(g_ReaderList!=NULL){
		free(g_ReaderList);
		g_ReaderList = NULL;
	}
	if(g_drawAreaImage!=NULL){
	  [g_drawAreaImage release];
	  g_drawAreaImage = NULL;
	}
}

- (void)windowWillClose:(NSNotification *)aNotification
{
    [NSApp terminate: self];
}

@end
