/* ʣ̲ - EnbanKensa
 * Copyright (c) 2005 Kagetani Hideto
 * mainwindow.c - 祦ɥ
 * $Date: 2005/05/17 15:42:28 $
 * $Revision: 1.1 $
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <malloc.h>

#include "aspi.h"
#include "TitleLogo.xpm"
#include "scan.h"
#include "cmd.h"
#include "check.h"
#include "ui.h"
#include "messagebox.h"

#define DRAWAREA_WIDTH 640
#define DRAWAREA_HEIGHT 400

#define FIXED16FONTSET "-*-fixed-medium-r-normal--16--*"

static GtkWidget *g_MainWindow=NULL;
static GtkWidget *g_btnStartKensa=NULL;
static GtkWidget *g_optMenu1=NULL;
static GtkWidget *g_labelInfo=NULL;
static GtkWidget *g_drawArea=NULL;
static GdkPixmap *g_pixmapDrawArea=NULL;
static GdkGC *g_gc=NULL;
static GdkFont *g_fontSet=NULL;
static SCAN_t *g_ReaderList=NULL;
static BOOL g_bRunningCheck=FALSE;
UIWIDGETINFO g_widgetInfo;


static int scan_drive(GtkWidget *optmenu)
{
  GtkWidget *menu;
  GtkWidget *menuitem;
  SCAN_t *drives;
  int count;

  drives = ScanDrive(FALSE);
  if(drives==NULL){
    return RET_NG;
  }

  gtk_option_menu_remove_menu(GTK_OPTION_MENU(optmenu));
  menu = gtk_menu_new();

  for(count=0; strlen(drives[count].inqdata)!=0; count++){
    menuitem = gtk_menu_item_new_with_label(drives[count].inqdata);
    gtk_object_set_user_data(GTK_OBJECT(menuitem), GINT_TO_POINTER(count));
    gtk_menu_append(GTK_MENU(menu), menuitem);
    gtk_widget_show(menuitem);
  }

  gtk_option_menu_set_menu(GTK_OPTION_MENU(optmenu), menu);

  g_ReaderList = drives;

  return RET_OK;
}

/*
 * Callbacks
 */
void
on_optionmenu1_map(GtkWidget *widget, gpointer user_data)
{
  scan_drive((GtkWidget *)user_data);
}

void
on_button1_clicked(GtkWidget *widget, gpointer user_data)
{
  DRIVEID drive;
  GtkWidget *menu;
  GtkWidget *menuitem;
  int sel_drive;
  int ret;

  if(g_bRunningCheck){
    UISetAbort();
    gtk_widget_set_sensitive(g_btnStartKensa, FALSE);
    return;
  }

	  /* ɥ饤ּ */
  menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(g_optMenu1));
  menuitem = gtk_menu_get_active(GTK_MENU(menu));
  sel_drive = GPOINTER_TO_INT(gtk_object_get_user_data(GTK_OBJECT(menuitem)));

  drive.hid = g_ReaderList[sel_drive].hid;
  drive.tid = g_ReaderList[sel_drive].tid;

  UIClearAbort();
  g_bRunningCheck = TRUE;
  gtk_widget_set_sensitive(g_optMenu1, FALSE);
  gtk_label_set_text(GTK_LABEL(GTK_BIN(g_btnStartKensa)->child), "");

  ret = CheckDisc(&drive);
  
  gtk_widget_set_sensitive(g_btnStartKensa, TRUE);
  gtk_widget_set_sensitive(g_optMenu1, TRUE);
  gtk_label_set_text(GTK_LABEL(GTK_BIN(g_btnStartKensa)->child), "");
  g_bRunningCheck = FALSE;
}

void
on_btnExit_clicked(GtkWidget *widget, gpointer user_data)
{
  gtk_widget_destroy((GtkWidget *)user_data);
}

void
on_mainwindow_destroy(GtkWidget *widget, gpointer user_data)
{
  if(g_ReaderList!=NULL)
    free(g_ReaderList);
  if(g_gc != NULL)
	gdk_gc_destroy(g_gc);

  gtk_main_quit();
}

gboolean
on_drawingarea1_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  gdk_draw_pixmap(g_drawArea->window,
                  g_drawArea->style->fg_gc[GTK_WIDGET_STATE (g_drawArea)],
                  g_pixmapDrawArea,
                  event->area.x, event->area.y,
                  event->area.x, event->area.y,
                  event->area.width, event->area.height);
  return FALSE;
}

gboolean
on_window1_configure_event             (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  if(g_gc == NULL){
		/* GC */
	g_gc = gdk_gc_new(g_drawArea->window);
	g_fontSet = gdk_fontset_load(FIXED16FONTSET);
	gdk_gc_set_font(g_gc, g_fontSet);
  }
  
  if(g_pixmapDrawArea == NULL){
		/* ԥޥå */
	g_pixmapDrawArea = gdk_pixmap_new(g_drawArea->window,
									  g_drawArea->allocation.width,
									  g_drawArea->allocation.height,
									  -1);
	gdk_draw_rectangle (g_pixmapDrawArea,
						g_drawArea->style->black_gc,
						TRUE,
						0, 0,
						g_drawArea->allocation.width,
						g_drawArea->allocation.height);

	g_widgetInfo.label = g_labelInfo;
	g_widgetInfo.draw_area = g_drawArea;
	g_widgetInfo.pixmap_draw_area = g_pixmapDrawArea;
	g_widgetInfo.gc = g_gc;
	g_widgetInfo.font = g_fontSet;
  
	UISetWidgetInfo(&g_widgetInfo);
  }

  return TRUE;
}


GtkWidget*
create_mainwindow(void)
{
  GtkWidget *window1;
  GtkWidget *table1;
  GtkWidget *optionmenu1;
  GtkWidget *optionmenu1_menu;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *button1;
  GtkWidget *pixmap1;
  GtkWidget *drawingarea1;
  GdkPixmap *gdkpixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
  char ver_buf[32];

	  /* ᥤ󥦥ɥ */
  window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (window1), "window1", window1);
  gtk_window_set_title (GTK_WINDOW (window1), "׸");
  gtk_window_set_policy(GTK_WINDOW(window1), FALSE, FALSE, FALSE);

	  /* ѥơ֥ */
  table1 = gtk_table_new(4, 4, FALSE);
  gtk_widget_ref(table1);
  gtk_object_set_data_full(GTK_OBJECT(window1), "table1", table1,
						   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(table1);
  gtk_container_add(GTK_CONTAINER(window1), table1);
  gtk_container_set_border_width(GTK_CONTAINER(table1), 10);
  gtk_table_set_row_spacings(GTK_TABLE(table1), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table1), 5);

	  /* ٥ */
  label1 = gtk_label_new("");
  gtk_widget_ref(label1);
  gtk_object_set_data_full(GTK_OBJECT(window1), "label1", label1,
						   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(label1);
  gtk_table_attach(GTK_TABLE(table1), label1, 0, 1, 1, 2,
				   (GtkAttachOptions)(GTK_FILL),
				   (GtkAttachOptions)(0), 0, 0);

	  /* ץ˥塼 */
  optionmenu1 = gtk_option_menu_new();
  gtk_widget_ref(optionmenu1);
  gtk_object_set_data_full(GTK_OBJECT(window1), "optionmenu1", optionmenu1,
						   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(optionmenu1);
  gtk_table_attach(GTK_TABLE(table1), optionmenu1, 1, 2, 1, 2,
				   (GtkAttachOptions)(GTK_FILL),
				   (GtkAttachOptions)(0), 0, 0);
  gtk_widget_set_usize (optionmenu1, 300, -2);
  optionmenu1_menu = gtk_menu_new();
  gtk_option_menu_set_menu(GTK_OPTION_MENU(optionmenu1), optionmenu1_menu);

	  /* ϥܥ */
  button1 = gtk_button_new_with_label("");
  gtk_widget_ref(button1);
  gtk_object_set_data_full(GTK_OBJECT(window1), "button1", button1,
						   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(button1);
  gtk_table_attach(GTK_TABLE(table1), button1, 2, 3, 1, 2,
				   (GtkAttachOptions)(GTK_FILL),
				   (GtkAttachOptions)(0), 0, 0);

	  /*  */
  colormap = gtk_widget_get_colormap (window1);
  gdkpixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask,
						    NULL, TitleLogo);
  pixmap1 = gtk_pixmap_new (gdkpixmap, mask);
  gdk_pixmap_unref (gdkpixmap);
  gdk_bitmap_unref (mask);

  gtk_widget_ref(pixmap1);
  gtk_object_set_data_full(GTK_OBJECT(window1), "pixmap1", pixmap1,
			   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(pixmap1);
  gtk_table_attach(GTK_TABLE(table1), pixmap1, 3, 4, 0, 2,
				   (GtkAttachOptions)(GTK_FILL),
				   (GtkAttachOptions)(0), 0, 0);

	  /* ΰ */
  drawingarea1 = gtk_drawing_area_new ();
  gtk_widget_ref (drawingarea1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "drawingarea1", drawingarea1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (drawingarea1);
  gtk_table_attach(GTK_TABLE(table1), drawingarea1, 0, 4, 2, 3,
				   (GtkAttachOptions)(GTK_FILL),
				   (GtkAttachOptions)(0), 0, 0);
  gtk_widget_set_usize(drawingarea1, DRAWAREA_WIDTH, DRAWAREA_HEIGHT);

	  /* åΰ */
  sprintf(ver_buf, "Version %s", VERSION);
  label2 = gtk_label_new (ver_buf);
  gtk_widget_ref (label2);
  gtk_object_set_data_full(GTK_OBJECT (window1), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_table_attach(GTK_TABLE(table1), label2, 0, 4, 3, 4,
				   (GtkAttachOptions)(GTK_FILL),
				   (GtkAttachOptions)(0), 0, 0);

  gtk_misc_set_alignment(GTK_MISC(label2), 0.5, 0.5);


  gtk_signal_connect(GTK_OBJECT(optionmenu1), "map",
		     GTK_SIGNAL_FUNC(on_optionmenu1_map),
		     optionmenu1);
  gtk_signal_connect(GTK_OBJECT(button1), "clicked",
		     GTK_SIGNAL_FUNC(on_button1_clicked),
		     NULL);
  gtk_signal_connect(GTK_OBJECT(window1), "destroy",
		     GTK_SIGNAL_FUNC(on_mainwindow_destroy),
		     NULL);
  gtk_signal_connect(GTK_OBJECT (drawingarea1), "expose_event",
					 GTK_SIGNAL_FUNC (on_drawingarea1_expose_event),
					 NULL);
  gtk_signal_connect (GTK_OBJECT (window1), "configure_event",
                      GTK_SIGNAL_FUNC (on_window1_configure_event),
                      NULL);

  g_btnStartKensa = button1;
  g_optMenu1 = optionmenu1;
  g_labelInfo = label2;
  g_MainWindow = window1;
  g_drawArea = drawingarea1;

  return window1;
}


