#ifndef __STRUCT_H__
#define __STRUCT_H__

/*
 * cdrecord/cdrtools Q
 * http://www.fokus.fhg.de/research/cc/glone/employees/joerg.schilling/private/cdrecord.html
 */

#include "aspi.h"

#if defined(WIN32) || defined(__i386__)
#define BIT_FIELDS_LTOH	/* Intel */
#endif

struct _MODEPAGE_HEADER {
#ifdef BIT_FIELDS_LTOH
	BYTE	p_code			: 6;
	BYTE	res				: 1;
	BYTE	parsave			: 1;
	BYTE	p_len;
#else
	BYTE	parsave			: 1;
	BYTE	res				: 1;
	BYTE	p_code			: 6;
	BYTE	p_len;
#endif
};

struct _MODEPAGE01 {		/* Error Recovery Parameters */
#ifdef BIT_FIELDS_LTOH
	struct _MODEPAGE_HEADER header;
	BYTE	disa_correction	: 1;	/* Byte 2 */
	BYTE	term_on_rec_err	: 1;
	BYTE	report_rec_err	: 1;
	BYTE	en_early_corr	: 1;
	BYTE	read_continuous	: 1;
	BYTE	tranfer_block	: 1;
	BYTE	en_auto_reall_r	: 1;
	BYTE	en_auto_reall_w	: 1;	/* Byte 2 */
	BYTE	rd_retry_count;		/* Byte 3 */
	BYTE	correction_span;
	BYTE	head_offset_count;
	BYTE	data_strobe_offset;
	BYTE	res;
	BYTE	wr_retry_count;
	BYTE	res_tape[2];
	BYTE	recov_timelim[2];
#else
	struct _MODEPAGE_HEADER header;
	BYTE	en_auto_reall_w	: 1;	/* Byte 2 */
	BYTE	en_auto_reall_r	: 1;
	BYTE	tranfer_block	: 1;
	BYTE	read_continuous	: 1;
	BYTE	en_early_corr	: 1;
	BYTE	report_rec_err	: 1;
	BYTE	term_on_rec_err	: 1;
	BYTE	disa_correction	: 1;	/* Byte 2 */
	BYTE	rd_retry_count;		/* Byte 3 */
	BYTE	correction_span;
	BYTE	head_offset_count;
	BYTE	data_strobe_offset;
	BYTE	res;
	BYTE	wr_retry_count;
	BYTE	res_tape[2];
	BYTE	recov_timelim[2];
#endif
};

struct _MODEPAGE05 {				/* Write Parameters */
#ifdef BIT_FIELDS_LTOH
	struct _MODEPAGE_HEADER header;
	BYTE	write_type		: 4;	/* Session write type (PACKET/TAO...)*/
	BYTE	test_write		: 1;	/* Do not actually write data	     */
	BYTE	LS_V			: 1;	/* Link size valid		     */
	BYTE	BUFE			: 1;	/* Enable Bufunderrun free rec.	     */
	BYTE	res_2_7			: 1;
	BYTE	track_mode		: 4;	/* Track mode (Q-sub control nibble) */
	BYTE	copy			: 1;	/* 1st higher gen of copy prot track ~*/
	BYTE	fp				: 1;	/* Fixed packed (if in packet mode)  */
	BYTE	multi_session	: 2;	/* Multi session write type	     */
	BYTE	dbtype			: 4;	/* Data block type		     */
	BYTE	res_4			: 4;	/* Reserved			     */
	BYTE	link_size;				/* Link Size (default is 7)	     */
	BYTE	res_6;					/* Reserved			     */
	BYTE	host_appl_code	: 6;	/* Host application code of disc     */
	BYTE	res_7			: 2;	/* Reserved			     */
	BYTE	session_format;			/* Session format (DA/CDI/XA)	     */
	BYTE	res_9;					/* Reserved			     */
	BYTE	packet_size[4];			/* # of user datablocks/fixed packet */
	BYTE	audio_pause_len[2];		/* # of blocks where index is zero   */
	BYTE	mc_val;					/* MCN valid */
	BYTE	media_cat_number[13];	/* Media catalog Number (MCN)	     */
	BYTE	res_30_31[2];
	BYTE	tc_val;					/* ISRC valid */
	BYTE	ISRC[12];				/* ISRC for this track		     */
	BYTE	res_45_47;
	BYTE	sub_header[4];
	BYTE	vendor_uniq[4];
#else
	struct _MODEPAGE_HEADER header;
	BYTE	res_2_7			: 1;
	BYTE	BUFE			: 1;	/* Enable Bufunderrun free rec.	     */
	BYTE	LS_V			: 1;	/* Link size valid		     */
	BYTE	test_write		: 1;	/* Do not actually write data	     */
	BYTE	write_type		: 4;	/* Session write type (PACKET/TAO...)*/
	BYTE	multi_session	: 2;	/* Multi session write type	     */
	BYTE	fp				: 1;	/* Fixed packed (if in packet mode)  */
	BYTE	copy			: 1;	/* 1st higher gen of copy prot track ~*/
	BYTE	track_mode		: 4;	/* Track mode (Q-sub control nibble) */
	BYTE	res_4			: 4;	/* Reserved			     */
	BYTE	dbtype			: 4;	/* Data block type		     */
	BYTE	link_size;				/* Link Size (default is 7)	     */
	BYTE	res_6;					/* Reserved			     */
	BYTE	res_7			: 2;	/* Reserved			     */
	BYTE	host_appl_code	: 6;	/* Host application code of disc     */
	BYTE	session_format;			/* Session format (DA/CDI/XA)	     */
	BYTE	res_9;					/* Reserved			     */
	BYTE	packet_size[4];			/* # of user datablocks/fixed packet */
	BYTE	audio_pause_len[2];		/* # of blocks where index is zero   */
	BYTE	mc_val;					/* MCN valid */
	BYTE	media_cat_number[13];	/* Media catalog Number (MCN)	     */
	BYTE	res_30_31[2];
	BYTE	tc_val;					/* ISRC valid */
	BYTE	ISRC[12];				/* ISRC for this track		     */
	BYTE	res_45_47;
	BYTE	sub_header[4];
	BYTE	vendor_uniq[4];
#endif
};

/* write_type */
#define MP05WT_PACKET	0
#define MP05WT_TAO		1
#define MP05WT_SAO		2
#define MP05WT_RAW		3
/* track_mode */
#define MP05TM_AUDIO	0
#define MP05TM_DATA		4
#define MP05TM_DATAINC	5
/* dbtype */
#define MP05DBT_CDDA_2352	0
#define MP05DBT_CDDA_2368	1
#define MP05DBT_CDDA_2448	2
#define MP05DBT_RAW			3
#define MP05DBT_MODE1		8
#define MP05DBT_MODE2		9
#define MP05DBT_XA1_2048	10
#define MP05DBT_XA1_2056	11
#define MP05DBT_XA2			12
#define MP05DBT_MIX			13
/* session_format */
#define MP05SF_CDDA_CDROM	0x00
#define MP05SF_CDI			0x10
#define MP05SF_CDROM_XA		0x20



struct _WRITESPEED_PERFOMANCE {
	BYTE	res0;					/* Reserved			     */
	BYTE	rot_ctl_sel	: 2;		/* Rotational control selected	     */
	BYTE	res_1_27	: 6;		/* Reserved			     */
	BYTE	wr_speed_supp[2];		/* Supported write speed	     */
};

struct _MODEPAGE2A {				/* Mechanical Status */
#ifdef BIT_FIELDS_LTOH
	struct _MODEPAGE_HEADER header;
	BYTE	cd_r_read		: 1;	/* Reads CD-R  media		     */
	BYTE	cd_rw_read		: 1;	/* Reads CD-RW media		     */
	BYTE	method2			: 1;	/* Reads fixed packet method2 media  */
	BYTE	dvd_rom_read	: 1;	/* Reads DVD ROM media		     */
	BYTE	dvd_r_read		: 1;	/* Reads DVD-R media		     */
	BYTE	dvd_ram_read	: 1;	/* Reads DVD-RAM media		     */
	BYTE	res_2_67		: 2;	/* Reserved			     */

	BYTE	cd_r_write		: 1;	/* Supports writing CD-R  media	     */
	BYTE	cd_rw_write		: 1;	/* Supports writing CD-RW media	     */
	BYTE	test_write		: 1;	/* Supports emulation write	     */
	BYTE	res_3_3			: 1;	/* Reserved			     */
	BYTE	dvd_r_write		: 1;	/* Supports writing DVD-R media	     */
	BYTE	dvd_ram_write	: 1;	/* Supports writing DVD-RAM media    */
	BYTE	res_3_67		: 2;	/* Reserved			     */

	BYTE	audio_play		: 1;	/* Supports Audio play operation     */
	BYTE	composite		: 1;	/* Deliveres composite A/V stream    */
	BYTE	digital_port_2	: 1;	/* Supports digital output on port 2 */
	BYTE	digital_port_1	: 1;	/* Supports digital output on port 1 */
	BYTE	mode_2_form_1	: 1;	/* Reads Mode-2 form 1 media (XA)    */
	BYTE	mode_2_form_2	: 1;	/* Reads Mode-2 form 2 media	     */
	BYTE	multi_session	: 1;	/* Reads multi-session media	     */
	BYTE	BUF				: 1;	/* Supports Buffer under. free rec.  */

	BYTE	cd_da_supported	: 1;	/* Reads audio data with READ CD cmd */
	BYTE	cd_da_accurate	: 1;	/* READ CD data stream is accurate   */
	BYTE	rw_supported	: 1;	/* Reads R-W sub channel information */
	BYTE	rw_deint_corr	: 1;	/* Reads de-interleved R-W sub chan  */
	BYTE	c2_pointers		: 1;	/* Supports C2 error pointers	     */
	BYTE	ISRC			: 1;	/* Reads ISRC information	     */
	BYTE	UPC				: 1;	/* Reads media catalog number (UPC)  */
	BYTE	read_bar_code	: 1;	/* Supports reading bar codes	     */

	BYTE	lock			: 1;	/* PREVENT/ALLOW may lock media	     */
	BYTE	lock_state		: 1;	/* Lock state 0=unlocked 1=locked    */
	BYTE	prevent_jumper	: 1;	/* State of prev/allow jumper 0=pres */
	BYTE	eject			: 1;	/* Ejects disc/cartr with STOP LoEj  */
	BYTE	res_6_4			: 1;	/* Reserved			     */
	BYTE	loading_type	: 3;	/* Loading mechanism type	     */

	BYTE	sep_chan_vol	: 1;	/* Vol controls each channel separat */
	BYTE	sep_chan_mute	: 1;	/* Mute controls each channel separat*/
	BYTE	disc_present_rep: 1;	/* Changer supports disc present rep */
	BYTE	sw_slot_sel		: 1;	/* Load empty slot in changer	     */
	BYTE	side_change		: 1;	/* Side change capable		     */
	BYTE	pw_in_lead_in	: 1;	/* Reads raw P-W sucode from lead in */
	BYTE	res_7			: 2;	/* Reserved			     */

	BYTE	max_read_speed[2];		/* Max. read speed in KB/s	     */
	BYTE	num_vol_levels[2];		/* # of supported volume levels	     */
	BYTE	buffer_size[2];			/* Buffer size for the data in KB    */
	BYTE	cur_read_speed[2];		/* Current read speed in KB/s	     */
	BYTE	res_16;					/* Reserved			     */
	BYTE	res_17_0		: 1;	/* Reserved			     */
	BYTE	BCK				: 1;	/* Data valid on falling edge of BCK */
	BYTE	RCK				: 1;	/* Set: HIGH high LRCK=left channel  */
	BYTE	LSBF			: 1;	/* Set: LSB first Clear: MSB first   */
	BYTE	length			: 2;	/* 0=32BCKs 1=16BCKs 2=24BCKs 3=24I2c*/
	BYTE	res_17			: 2;	/* Reserved			     */
	BYTE	max_write_speed[2];		/* Max. write speed supported in KB/s*/
	BYTE	cur_write_speed[2];		/* Current write speed in KB/s	     */

					/* Byte 22 ... Only in MMC-2	     */
	BYTE	copy_man_rev[2];		/* Copy management revision supported*/
	BYTE	res_24;					/* Reserved			     */
	BYTE	res_25;					/* Reserved			     */

					/* Byte 26 ... Only in MMC-3	     */
	BYTE	res_26;					/* Reserved			     */
	BYTE	res_27_27		: 6;	/* Reserved			     */
	BYTE	rot_ctl_sel		: 2;	/* Rotational control selected	     */
	BYTE	v3_cur_write_speed[2];	/* Current write speed in KB/s	     */
	BYTE	num_wr_speed_des[2];	/* # of wr speed perf descr. tables  */
	struct _WRITESPEED_PERFOMANCE	wr_speed_des[1];	/* wr speed performance descriptor   */
									/* Actually more (num_wr_speed_des)  */
#else
	struct _MODEPAGE_HEADER header;
	BYTE	res_2_67		: 2;	/* Reserved			     */
	BYTE	dvd_ram_read	: 1;	/* Reads DVD-RAM media		     */
	BYTE	dvd_r_read		: 1;	/* Reads DVD-R media		     */
	BYTE	dvd_rom_read	: 1;	/* Reads DVD ROM media		     */
	BYTE	method2			: 1;	/* Reads fixed packet method2 media  */
	BYTE	cd_rw_read		: 1;	/* Reads CD-RW media		     */
	BYTE	cd_r_read		: 1;	/* Reads CD-R  media		     */

	BYTE	res_3_67		: 2;	/* Reserved			     */
	BYTE	dvd_ram_write	: 1;	/* Supports writing DVD-RAM media    */
	BYTE	dvd_r_write		: 1;	/* Supports writing DVD-R media	     */
	BYTE	res_3_3			: 1;	/* Reserved			     */
	BYTE	test_write		: 1;	/* Supports emulation write	     */
	BYTE	cd_rw_write		: 1;	/* Supports writing CD-RW media	     */
	BYTE	cd_r_write		: 1;	/* Supports writing CD-R  media	     */

	BYTE	BUF				: 1;	/* Supports Buffer under. free rec.  */
	BYTE	multi_session	: 1;	/* Reads multi-session media	     */
	BYTE	mode_2_form_2	: 1;	/* Reads Mode-2 form 2 media	     */
	BYTE	mode_2_form_1	: 1;	/* Reads Mode-2 form 1 media (XA)    */
	BYTE	digital_port_1	: 1;	/* Supports digital output on port 1 */
	BYTE	digital_port_2	: 1;	/* Supports digital output on port 2 */
	BYTE	composite		: 1;	/* Deliveres composite A/V stream    */
	BYTE	audio_play		: 1;	/* Supports Audio play operation     */

	BYTE	read_bar_code	: 1;	/* Supports reading bar codes	     */
	BYTE	UPC				: 1;	/* Reads media catalog number (UPC)  */
	BYTE	ISRC			: 1;	/* Reads ISRC information	     */
	BYTE	c2_pointers		: 1;	/* Supports C2 error pointers	     */
	BYTE	rw_deint_corr	: 1;	/* Reads de-interleved R-W sub chan  */
	BYTE	rw_supported	: 1;	/* Reads R-W sub channel information */
	BYTE	cd_da_accurate	: 1;	/* READ CD data stream is accurate   */
	BYTE	cd_da_supported	: 1;	/* Reads audio data with READ CD cmd */

	BYTE	loading_type	: 3;	/* Loading mechanism type	     */
	BYTE	res_6_4			: 1;	/* Reserved			     */
	BYTE	eject			: 1;	/* Ejects disc/cartr with STOP LoEj  */
	BYTE	prevent_jumper	: 1;	/* State of prev/allow jumper 0=pres */
	BYTE	lock_state		: 1;	/* Lock state 0=unlocked 1=locked    */
	BYTE	lock			: 1;	/* PREVENT/ALLOW may lock media	     */

	BYTE	res_7			: 2;	/* Reserved			     */
	BYTE	pw_in_lead_in	: 1;	/* Reads raw P-W sucode from lead in */
	BYTE	side_change		: 1;	/* Side change capable		     */
	BYTE	sw_slot_sel		: 1;	/* Load empty slot in changer	     */
	BYTE	disc_present_rep: 1;	/* Changer supports disc present rep */
	BYTE	sep_chan_mute	: 1;	/* Mute controls each channel separat*/
	BYTE	sep_chan_vol	: 1;	/* Vol controls each channel separat */

	BYTE	max_read_speed[2];		/* Max. read speed in KB/s	     */
	BYTE	num_vol_levels[2];		/* # of supported volume levels	     */
	BYTE	buffer_size[2];			/* Buffer size for the data in KB    */
	BYTE	cur_read_speed[2];		/* Current read speed in KB/s	     */
	BYTE	res_16;					/* Reserved			     */
	BYTE	res_17			: 2;	/* Reserved			     */
	BYTE	length			: 2;	/* 0=32BCKs 1=16BCKs 2=24BCKs 3=24I2c*/
	BYTE	LSBF			: 1;	/* Set: LSB first Clear: MSB first   */
	BYTE	RCK				: 1;	/* Set: HIGH high LRCK=left channel  */
	BYTE	BCK				: 1;	/* Data valid on falling edge of BCK */
	BYTE	res_17_0		: 1;	/* Reserved			     */
	BYTE	max_write_speed[2];		/* Max. write speed supported in KB/s*/
	BYTE	cur_write_speed[2];		/* Current write speed in KB/s	     */

					/* Byte 22 ... Only in MMC-2	     */
	BYTE	copy_man_rev[2];		/* Copy management revision supported*/
	BYTE	res_24;					/* Reserved			     */
	BYTE	res_25;					/* Reserved			     */

					/* Byte 26 ... Only in MMC-3	     */
	BYTE	res_26;					/* Reserved			     */
	BYTE	rot_ctl_sel		: 2;	/* Rotational control selected	     */
	BYTE	res_27_27		: 6;	/* Reserved			     */
	BYTE	v3_cur_write_speed[2];	/* Current write speed in KB/s	     */
	BYTE	num_wr_speed_des[2];	/* # of wr speed perf descr. tables  */
	struct _WRITESPEED_PERFOMANCE	wr_speed_des[1];	/* wr speed performance descriptor   */
									/* Actually more (num_wr_speed_des)  */
#endif
};

struct _OPCTABLE {
	BYTE	opc_speed[2];
	BYTE	opc_val[6];
};

struct _DISCINFO {
#ifdef BIT_FIELDS_LTOH
	BYTE	data_len[2];			/* Data len without this info	*/
	BYTE	disc_status		: 2;	/* Status of the disc		*/
	BYTE	sess_status		: 2;	/* Status of last session	*/
	BYTE	erasable		: 1;	/* disc is erasable		*/
	BYTE	res2			: 3;	/* Reserved			*/
	BYTE	first_track;			/* # of first track on disc	*/
	BYTE	numsess_lsb;			/* # of sessions		*/
	BYTE	first_track_ls_lsb;		/* First track in last sessaion	*/
	BYTE	last_track_ls_lsb;		/* Last track in last sessaion	*/
	BYTE	bgformat_stat	: 2;	/* B.G. format status */
	BYTE	dbit			: 1;	/* dirty bit */
	BYTE	res7_3			: 1;	/* Reserved			*/
	BYTE	dac_v			: 1;	/* disc application code valid */
	BYTE	uru				: 1;	/* This is an unrestricted disc	*/
	BYTE	dbc_v			: 1;	/* disc bar code valid		*/
	BYTE	did_v			: 1;	/* disc id valid		*/
	BYTE	disc_type;				/* disc type			*/
	BYTE	numsess_msb;			/* # of session(high byte) */
	BYTE	first_track_ls_msb;		/* First track in last session(high byte) */
	BYTE	last_track_ls_msb;		/* Last track in last session(high byte) */
	BYTE	disc_id[4];				/* disc identification		*/
	BYTE	last_lead_in[4];		/* Last session lead in time	*/
	BYTE	last_lead_out[4];		/* Last session lead out time	*/
	BYTE	disc_barcode[8];		/* disc bar code		*/
	BYTE	disc_app_code;			/* disc application code */
	BYTE	num_opc_entries;		/* # of OPC table entries	*/
	struct _OPCTABLE opc_table[1];	/* OPC table 			*/
#else
	BYTE	data_len[2];			/* Data len without this info	*/
	BYTE	res2			: 3;	/* Reserved			*/
	BYTE	erasable		: 1;	/* disc is erasable		*/
	BYTE	sess_status		: 2;	/* Status of last session	*/
	BYTE	disc_status		: 2;	/* Status of the disc		*/
	BYTE	first_track;			/* # of first track on disc	*/
	BYTE	numsess_lsb;			/* # of sessions		*/
	BYTE	first_track_ls_lsb;		/* First track in last sessaion	*/
	BYTE	last_track_ls_lsb;		/* Last track in last sessaion	*/
	BYTE	did_v			: 1;	/* disc id valid		*/
	BYTE	dbc_v			: 1;	/* disc bar code valid		*/
	BYTE	uru				: 1;	/* This is an unrestricted disc	*/
	BYTE	dac_v			: 1;	/* disc application code valid */
	BYTE	res7_3			: 1;	/* Reserved			*/
	BYTE	dbit			: 1;	/* dirty bit */
	BYTE	bgformat_stat	: 2;	/* B.G. format status */
	BYTE	disc_type;				/* disc type			*/
	BYTE	numsess_msb;			/* # of session(high byte) */
	BYTE	first_track_ls_msb;		/* First track in last session(high byte) */
	BYTE	last_track_ls_msb;		/* Last track in last session(high byte) */
	BYTE	disc_id[4];				/* disc identification		*/
	BYTE	last_lead_in[4];		/* Last session lead in time	*/
	BYTE	last_lead_out[4];		/* Last session lead out time	*/
	BYTE	disc_barcode[8];		/* disc bar code		*/
	BYTE	disc_app_code;			/* disc application code */
	BYTE	num_opc_entries;		/* # of OPC table entries	*/
	struct _OPCTABLE opc_table[1];	/* OPC table 			*/
#endif
};

	/* disc_type */
#define DISCTYPE_CDDA_DATA	0x00
#define DISCTYPE_CDI		0x10
#define DISCTYPE_CDROM_XA	0x20
	/* disc_status */
#define DISCSTAT_EMPTY		0
#define DISCSTAT_INCOMPLETE	1
#define DISCSTAT_COMPLETE	2
#define DISCSTAT_OTHER		3	/* non-write protected Random Writable media */
	/* sess_status */
#define SESSSTAT_EMPTY			0
#define SESSSTAT_INCOMPLETE		1
#define SESSSTAT_COMPLETE		3
	/* bgformat_stat */
#define BGFSTAT_NOTFORMATTED	0
#define BGFSTAT_INACTIVE		1
#define BGFSTAT_ACTIVE			2
#define BGFSTAT_COMPLETED		3


struct _TRACKINFO {
#ifdef BIT_FIELDS_LTOH
	BYTE	data_len[2];			/* Data len without this info	*/
	BYTE	track_number_lsb;		/* Track number for this info	*/
	BYTE	session_number_lsb;		/* Session number for this info	*/
	BYTE	res4;					/* Reserved			*/
	BYTE	track_mode		: 4;	/* Track mode (Q-sub control)	*/
	BYTE	copy			: 1;	/* This track is a higher copy	*/
	BYTE	damage			: 1;	/* if 1 & nwa_valid 0: inc track*/
	BYTE	res5_67			: 2;	/* Reserved			*/
	BYTE	data_mode		: 4;	/* Data mode of this track	*/
	BYTE	fp				: 1;	/* This is a fixed packet track	*/
	BYTE	packet			: 1;	/* This track is in packet mode	*/
	BYTE	blank			: 1;	/* This is an invisible track	*/
	BYTE	rt				: 1;	/* This is a reserved track	*/
	BYTE	nwa_valid		: 1;	/* Next writable addr valid	*/
	BYTE	lra_valid		: 1;	/* Last recorded addr valid */
	BYTE	res7_16			: 6;	/* Reserved			*/
	BYTE	track_start[4];			/* Track start address		*/
	BYTE	next_writable_addr[4];	/* Next writable address	*/
	BYTE	free_blocks[4];			/* Free usr blocks in this track*/
	BYTE	packet_size[4];			/* Packet size if in fixed mode	*/
	BYTE	track_size[4];			/* # of user data blocks in trk	*/
	BYTE	last_rec_addr[4];		/* Last recorded addr */
	BYTE	track_number_msb;		/* Track number for this info(high byte) */
	BYTE	session_number_msb;		/* Session number for this info(high byte) */
	BYTE	res[2];					/* Reserved */
#else
	BYTE	data_len[2];			/* Data len without this info	*/
	BYTE	track_number_lsb;		/* Track number for this info	*/
	BYTE	session_number_lsb;		/* Session number for this info	*/
	BYTE	res4;					/* Reserved			*/
	BYTE	res5_67			: 2;	/* Reserved			*/
	BYTE	damage			: 1;	/* if 1 & nwa_valid 0: inc track*/
	BYTE	copy			: 1;	/* This track is a higher copy	*/
	BYTE	track_mode		: 4;	/* Track mode (Q-sub control)	*/
	BYTE	rt				: 1;	/* This is a reserved track	*/
	BYTE	blank			: 1;	/* This is an invisible track	*/
	BYTE	packet			: 1;	/* This track is in packet mode	*/
	BYTE	fp				: 1;	/* This is a fixed packet track	*/
	BYTE	data_mode		: 4;	/* Data mode of this track	*/
	BYTE	res7_16			: 6;	/* Reserved			*/
	BYTE	lra_valid		: 1;	/* Last recorded addr valid */
	BYTE	nwa_valid		: 1;	/* Next writable addr valid	*/
	BYTE	track_start[4];			/* Track start address		*/
	BYTE	next_writable_addr[4];	/* Next writable address	*/
	BYTE	free_blocks[4];			/* Free usr blocks in this track*/
	BYTE	packet_size[4];			/* Packet size if in fixed mode	*/
	BYTE	track_size[4];			/* # of user data blocks in trk	*/
	BYTE	last_rec_addr[4];		/* Last recorded addr */
	BYTE	track_number_msb;		/* Track number for this info(high byte) */
	BYTE	session_number_msb;		/* Session number for this info(high byte) */
	BYTE	res[2];					/* Reserved */
#endif
};


struct _FEATURE_HEADER {	/* for GET CONFIGURATION */
	BYTE	data_len[4];
	BYTE	res45[2];
	BYTE	cur_profile[2];
};



struct _FORMATLIST_HEADER {
#ifdef BIT_FIELDS_LTOH
	BYTE	res1;					/* Reserved */
	BYTE	vs				: 1;	/* Vendor Specific */
	BYTE	immed			: 1;	/* Immediate */
	BYTE	tryout			: 1;
	BYTE	ip				: 1;	/* Initialization Pattern */
	BYTE	stpf			: 1;	/* Stop format */
	BYTE	dcrt			: 1;	/* Disable Certification */
	BYTE	dpry			: 1;	/* Disable Primary */
	BYTE	fov				: 1;	/* Format option valid */
	BYTE	fmtdesc_len[2];			/* Format descriptor length */
#else
	BYTE	res1;					/* Reserved */
	BYTE	fov				: 1;	/* Format option valid */
	BYTE	dpry			: 1;	/* Disable Primary */
	BYTE	dcrt			: 1;	/* Disable Certification */
	BYTE	stpf			: 1;	/* Stop format */
	BYTE	ip				: 1;	/* Initialization Pattern */
	BYTE	tryout			: 1;
	BYTE	immed			: 1;	/* Immediate */
	BYTE	vs				: 1;	/* Vendor Specific */
	BYTE	fmtdesc_len[2];			/* Format descriptor length */
#endif
};

struct _CDRW_FORMATDESC {
#ifdef BIT_FIELDS_LTOH
	BYTE	res0_61			: 6;	/* Reserved */
	BYTE	grow			: 1;	/* Grow session */
	BYTE	session			: 1;	/* New session */
	BYTE	res1_3[3];				/* Reserved */
	BYTE	format_size[4];			/* Format size */
#else
	BYTE	session			: 1;	/* New session */
	BYTE	grow			: 1;	/* Grow session */
	BYTE	res0_61			: 6;	/* Reserved */
	BYTE	res1_3[3];				/* Reserved */
	BYTE	format_size[4];			/* Format size */
#endif
};

struct _FORMATDESC {
#ifdef BIT_FIELDS_LTOH
	BYTE	num_blocks[4];			/* # of blocks */
	BYTE	res4_21			: 2;	/* Reserved */
	BYTE	format_type		: 6;	/* Format type */
	BYTE	param[3];				/* Parameter */
#else
	BYTE	num_blocks[4];			/* # of blocks */
	BYTE	format_type		: 6;	/* Format type */
	BYTE	res4_21			: 2;	/* Reserved */
	BYTE	param[3];				/* Parameter */
#endif
};
/* format_type */
#define FDFT_FULL		0x10
#define FDFT_GROW		0x11
#define FDFT_ADD		0x12
#define FDFT_QUICKGROW	0x13
#define FDFT_QUICKADD	0x14
#define FDFT_QUICK		0x15
#define FDFT_CDMRW		0x24
#define FDFT_DVDPRW		0x26


/* for READ FORMAT CAPACITIES */
struct _FORMATCAPA_HEADER {
	BYTE	res[3];					/* Reserved */
	BYTE	list_len;				/* Capacity list length */
};

struct _FORMATCURMAXDESC {
#ifdef BIT_FIELDS_LTOH
	BYTE	num_blocks[4];			/* # of blocks */
	BYTE	desc_type		: 2;	/* Descriptor type */
	BYTE	res4_72			: 6;	/* Reserved */
	BYTE	param[3];				/* Parameter */
#else
	BYTE	num_blocks[4];			/* # of blocks */
	BYTE	res4_72			: 6;	/* Reserved */
	BYTE	desc_type		: 2;	/* Descriptor type */
	BYTE	param[3];				/* Parameter */
#endif
};


struct _PERFORMANCEDESC {
#ifdef BIT_FIELDS_LTOH
	BYTE	mrw				: 1;	/* Mix read write */
	BYTE	exact			: 1;	/* Exact */
	BYTE	rdd				: 1;	/* Restore drive default */
	BYTE	wrc				: 2;	/* Write rotation control */
	BYTE	res0_75			: 3;	/* Reserved */
	BYTE	res13[3];				/* Reserved */
	BYTE	start_lba[4];			/* Start LBA */
	BYTE	end_lba[4];				/* End LBA */
	BYTE	read_size[4];			/* Read size */
	BYTE	read_time[4];			/* Read time */
	BYTE	write_size[4];			/* Write size */
	BYTE	write_time[4];			/* Write time */
#else
	BYTE	res0_75			: 3;	/* Reserved */
	BYTE	wrc				: 2;	/* Write rotation control */
	BYTE	rdd				: 1;	/* Restore drive default */
	BYTE	exact			: 1;	/* Exact */
	BYTE	mrw				: 1;	/* Mix read write */
	BYTE	res13[3];				/* Reserved */
	BYTE	start_lba[4];			/* Start LBA */
	BYTE	end_lba[4];				/* End LBA */
	BYTE	read_size[4];			/* Read size */
	BYTE	read_time[4];			/* Read time */
	BYTE	write_size[4];			/* Write size */
	BYTE	write_time[4];			/* Write time */
#endif
};


struct _TOCHEADER {
	BYTE	len[2];
	BYTE	first;
	BYTE	last;
};

struct _FULLTOCDESC {
	BYTE	sess_num;
#ifdef BIT_FIELDS_LTOH
	BYTE	control			: 4;
	BYTE	adr				: 4;
#else
	BYTE	adr				: 4;
	BYTE	control			: 4;
#endif
	BYTE	track;
	BYTE	point;
	BYTE	amin;
	BYTE	asec;
	BYTE	aframe;
	BYTE	res7;
	BYTE	pmin;
	BYTE	psec;
	BYTE	pframe;
};


struct _CUESHEET {
	BYTE	ctladr;		/* CTL/ADR for this track	*/
	BYTE	tno;			/* This track number		*/
	BYTE	index;		/* Index within this track	*/
	BYTE	dataform;		/* Data form 			*/
	BYTE	scms;		/* Serial copy management	*/
	BYTE	min;			/* Absolute time minutes	*/
	BYTE	sec;			/* Absolute time seconds	*/
	BYTE	frame;		/* Absolute time frames		*/
};

#define CSCTL_AUDIO		0x00
#define CSCTL_DATA		0x40
#define CSADR_NORMAL	0x01
#define CSADR_MCN		0x02
#define CSADR_ISRC		0x03



/* fBXN^Cv */
#define DT_UNKNOWN	0x0000	/* mfBXN */
#define DT_CDROM	0x0008	/* CD-ROM */
#define DT_CDR		0x0009	/* CD-R */
#define DT_CDRW		0x000a	/* CD-RW */
#define DT_DVDROM	0x0010	/* DVD-ROM */
#define DT_DVDR		0x0011	/* DVD-R */
#define DT_DVDRAM	0x0012	/* DVD-RAM */
#define DT_DVDRWO	0x0013	/* DVD-RW(tH[}bg) */
#define DT_DVDRWS	0x0014	/* DVD-RW(V[PVL^) */
#define DT_DVDPRW	0x001A	/* DVD+RW */
#define DT_DVDPR	0x001B	/* DVD+R */

#define DT_CD_FAMILY(d)		(d==DT_CDROM||d==DT_CDR||d==DT_CDRW)
#define DT_DVD_FAMILY(d)	(d>=DT_DVDROM)
#define DT_WRITABLE(d)		\
	(d==DT_CDR||d==DT_CDRW||\
	d==DT_DVDR||d==DT_DVDRWO||d==DT_DVDRWS||d==DT_DVDPRW||d==DT_DVDPR)

#endif /* !__STRUCT_H__ */
