/**
 * ~Օʉ - EnbanKensa
 * Copyright (C) 2005 Kagetani Hideto
 * option.c - IvVݒ
 * $Date: 2005/12/11 15:25:30 $
 * $Revision: 1.3 $
 */
#include <string.h>
#include <stdlib.h>
#include "option.h"
#include "ui.h"

static OPTIONS g_Option;

/**
 * ǂݎ葬xz擾
 * @param[in]	drive	u
 * @param[out]	param	up[^\
 * @retval	RET_OK	I
 */
static int GetReadableSpeed(CMDDRIVE *drive, DRVPARAMS *param)
{
  BYTE speeds[] = { 1, 2, 4, 6, 8, 10, 12, 16, 20, 24, 32, 48, 52, 0xff };
  
  param->read_speeds = (BYTE *)malloc(sizeof(speeds));
  if(param->read_speeds == NULL){
	param->num_read_speed = 0;
  }
  else{
	param->num_read_speed = sizeof(speeds)/sizeof(BYTE);
	memcpy(param->read_speeds, speeds, sizeof(speeds));
  }

  return RET_OK;
}

/**
 * ũftHgǂݎ胊gC񐔂擾
 * @param[in]	drive	u
 * @note	擾łȂꍇ0ƂB
 *			ʂ g_Option.default_read_retry Ɋi[B
 */
static void GetDefaultReadRetry(CMDDRIVE *drive)
{
  int ret;
  struct _MODEPAGE01 *mp01;

  g_Option.default_read_retry = 0;
  ret = SendModeSense(drive, MSPC_DEFAULT, 1);
  if(ret != RET_OK){
	return;
  }
  mp01 = (struct _MODEPAGE01 *)
	(drive->data_buf + (drive->cmd_type==CMDDRVCTYPE_ATAPI ? 8 : 16));
  g_Option.default_read_retry = mp01->rd_retry_count;
}


/**
 * _CAO\ăIvVݒ[UɂĂ炤
 * @param[in]	drive	u
 * @param[in]	num_track	gbN
 */
int SetOption(CMDDRIVE *drive, WORD num_track)
{
  int ret;
  DRVPARAMS param;

  memset(&g_Option, 0, sizeof(g_Option));
  g_Option.flag |= OPFLG_RDRETRY;
  if(num_track == 1){
		/* 1track/1session̏ꍇAO瑪Lɂ */
	g_Option.flag |= OPFLG_OUT2IN;
  }
  memset(&param, 0, sizeof(param));

  param.dvd = DT_DVD_FAMILY(drive->disc_type);
  GetReadableSpeed(drive, &param);
  GetDefaultReadRetry(drive);
  
  ret = UISetting(&g_Option/*, &param*/);
  free(param.read_speeds);
  
  return ret;
}


/**
 * IvVݒ\̂擾
 * @return	IvVݒ\
 */
OPTIONS *GetOption()
{
  return &g_Option;
}
