#ifndef __UI_H__
#define __UI_H__

#include <aspi.h>
#include <option.h>

//#undef USE_THREAD
#define USE_THREAD

#ifdef __cplusplus
extern "C" {
#endif

#define WM_USER_UICTL	(WM_USER+1)
#define UICTL_METER1INIT	0
#define UICTL_METER2INIT	1
#define UICTL_METER1SETPOS	2
#define UICTL_METER2SETPOS	3
#define UICTL_SETTING		4

void UISetMWC(void *mwc);
BOOL UICheckAbort();
void UISetAbort();
void UIClearAbort();
int UIDispMessage(const char *message, int type);
/* type value */
#define UIDMT_INFORMATION	0
#define UIDMT_ERROR		1
#define UIDMT_QUESTION	2
/* return value */
#define UIDMRET_OK		0
#define UIDMRET_CANCEL	1

void UIMeter1Initialize(const char *message);
void UIMeter2Initialize(const char *message);
void UIMeter1Update(int percentage);
void UIMeter2Update(int percentage);
void UIDispInfo(const char *message);

int UISetting(OPTIONS *option);

#ifdef __cplusplus
}
#endif

#endif /* !__EVENT_H__ */
