#import "MainWindowControl.h"
#import "SettingDlgControl.h"
#import "ui.h"
#import "scan.h"
#import "cmd.h"
#import "copydisc.h"
#import "cmdlog.h"

@implementation MainWindowControl

static SCAN_t *g_Readers=NULL;
static SCAN_t *g_Writers=NULL;
static BOOL g_bRunningCopy=FALSE;

- (IBAction)exitProgram:(id)sender
{
	[NSApp terminate : self];
}

- (IBAction)scanDrive:(id)sender
{
	SCAN_t *scan;
	id combo;
	int i, j;

	g_Readers = ScanDrive(FALSE);
	g_Writers = ScanDrive(TRUE);

	for(i=0; i<2; i++){
		scan = i==0 ? g_Readers : g_Writers;
		combo = i==0 ? readerCombo : writerCombo;
		[combo removeAllItems];
		for(j=0; strlen(scan[j].inqdata)!=0; j++){
			// ComboBox̏ꍇ
			//[combo addItemWithObjectValue : [NSString stringWithCString : scan[j].inqdata]];
			// PopupButton ̏ꍇ
			[combo addItemWithTitle : [NSString stringWithCString : scan[j].inqdata]];
		}
	}
}

- (IBAction)startCopy:(id)sender
{

	if(g_bRunningCopy){
		UISetAbort();
		[buttonStartCopy setEnabled : NO];
		return;
	}
	UIClearAbort();
	g_bRunningCopy = TRUE;
	[buttonQuit setEnabled : NO];
	[readerCombo setEnabled : NO];
	[writerCombo setEnabled : NO];
	[buttonStartCopy setTitle : [NSString stringWithCString : "f"]];
#ifdef USE_THREAD
	[NSThread detachNewThreadSelector: @selector(startCopyThread:)
								toTarget: self
											 withObject: nil];
#else
	[self startCopyThread: nil];
#endif
	g_bRunningCopy = FALSE;
}

- (void)startCopyThread:(id)object
{
	NSAutoreleasePool *ap = [[NSAutoreleasePool alloc] init];
	DRIVE reader, writer;
	int sel_reader, sel_writer;
	DWORD timeout = 5*60;	/* R}h^CAEgT */
	int ret;
	int mbret;
	BOOL onedrive=FALSE;
	/* IhCu擾 */
	sel_reader = [readerCombo indexOfSelectedItem];
	sel_writer = [writerCombo indexOfSelectedItem];
	
	if(g_Readers[sel_reader].hid == g_Writers[sel_writer].hid &&
	g_Readers[sel_reader].tid == g_Writers[sel_writer].tid){
		onedrive=TRUE;
	}
	/* hCu\̏ */
	memset(&reader, 0, sizeof(DRIVE));
	memset(&writer, 0, sizeof(DRIVE));
	ret = InitializeDrive(&reader, 0x10000, 50);
	if(ret==RET_OK){
		ret = SetAspiSetting(&reader,
					   &g_Readers[sel_reader].hid,
					   &g_Readers[sel_reader].tid,
					   &timeout);
	}
	if(ret!=RET_OK){
		[self MessageBoxDlg : "ǍȕɎs܂B"
						 title : NULL
						 flags : MBF_TYPEOK|MBF_ICONSTOP];
		[buttonStartCopy setEnabled : YES];
		[buttonQuit setEnabled : YES];
		[readerCombo setEnabled : YES];
		[writerCombo setEnabled : YES];
		[buttonStartCopy setTitle : [NSString stringWithCString : "ʊJn"]];
		[ap release];
		return;
	}
	if(onedrive){
		memcpy(&writer, &reader, sizeof(DRIVE));
	}
	else{
		ret = InitializeDrive(&writer, 0, 50);
		if(ret==RET_OK){
			/* writer̃obt@reader̃obt@L */
			writer.data_buf = reader.data_buf;
			writer.bufsize = reader.bufsize;
			ret = SetAspiSetting(&writer,
						&g_Writers[sel_writer].hid,
						&g_Writers[sel_writer].tid,
						&timeout);
		}
		if(ret!=RET_OK){
			[self MessageBoxDlg : "ȕɎs܂B"
								   title : NULL
								   flags : MBF_TYPEOK|MBF_ICONSTOP];
			FreeDrive(&reader);
			[buttonStartCopy setEnabled : YES];
			[buttonQuit setEnabled : YES];
			[readerCombo setEnabled : YES];
			[writerCombo setEnabled : YES];
			[buttonStartCopy setTitle : [NSString stringWithCString : "ʊJn"]];
			[ap release];
			return;
		}
	}
	ret = CopyDisc(&reader, &writer);
	switch(ret){
	case RET_ABORT:
		mbret = [self MessageBoxDlg : "ʏ͒f܂B"
								 title : NULL
								 flags : MBF_TYPEOK|MBF_ICONINFORMATION];
		break;
	case RET_OK:
		mbret = [self MessageBoxDlg : "ʏ͐ɏI܂Bro܂H"
								 title : NULL
								 flags : MBF_TYPEYESNO|MBF_ICONINFORMATION];
		break;
	default:
		mbret = [self MessageBoxDlg : "G[܂BR}hOo͂܂H"
								 title : NULL
								 flags : MBF_TYPEYESNO|MBF_ICONSTOP];
	}
	if(mbret==MBR_YES){
		if(ret!=RET_OK){
			CreateLog(&reader, g_Readers[sel_reader].inqdata,
			 &writer, g_Writers[sel_writer].inqdata);
		}
		else{
			OpenTray(&writer);
		}
	}

	[buttonStartCopy setEnabled : YES];
	[buttonQuit setEnabled : YES];
	[readerCombo setEnabled : YES];
	[writerCombo setEnabled : YES];
	[buttonStartCopy setTitle : [NSString stringWithCString : "ʊJn"]];
	/* LĂobt@؂藣 */
	writer.bufsize = 0;
	writer.data_buf = NULL;
	/* hCuڑ */
	FreeDrive(&reader);
	if(!onedrive){
		FreeDrive(&writer);
	}
	UIMeter1Initialize(NULL);
	UIMeter2Initialize(NULL);
	[ap release];
}

- (void)startUp
{
	UISetMWC(self);
	[self scanDrive : self];
}

- (void)uiCtlMeter1Initialize:(const char *)string
{
	if(string==NULL){
		[meter1Label setStringValue : @""];	
	}
	else{
		[meter1Label setStringValue : [NSString stringWithCString : string]];
	}
	[meter1 setDoubleValue : 0.0];
}

- (void)uiCtlMeter2Initialize:(const char *)string
{
	if(string==NULL){
		[meter2Label setStringValue : @""];	
	}
	else{
		[meter2Label setStringValue : [NSString stringWithCString : string]];
	}
	[meter2 setDoubleValue : 0.0];
}

- (void)uiCtlMeter1Update:(int)percentage
{
	[meter1 setDoubleValue : (double)percentage];
}

- (void)uiCtlMeter2Update:(int)percentage
{
	[meter2 setDoubleValue : (double)percentage];
}

- (void)uiCtlDispInfo:(const char *)string
{
	if(string==NULL){
		[infoLabel setStringValue : @""];
	}
	else{
		[infoLabel setStringValue : [NSString stringWithCString : string]];
	}
}

- (int)uiCtlSetting:(OPTIONS *)option
{
	return [settingPanel openSettingDialog: option];
}

- (int)MessageBoxDlg : (const char *)messageKey
			   title : (const char *)titleKey
				flags : (int)flags
{
	NSAlert *alert;
	NSString *button1Label, *button2Label, *button3Label;
	NSString *message, *title=NULL;
	NSAlertStyle alertStyle;
	int retvalue[3], retcode;

	if(titleKey!=NULL)
		title = [NSString stringWithCString : titleKey];
	message = [NSString stringWithCString : messageKey];
	
	switch(flags & MBF_TYPEMASK){
	case MBF_TYPEABORTRETRYIGNORE:
		button1Label = [NSString stringWithCString : "f"];
		button2Label = [NSString stringWithCString : "Ďs"];
		button3Label = [NSString stringWithCString : ""];
		retvalue[0] = MBR_ABORT;
		retvalue[1] = MBR_RETRY;
		retvalue[2] = MBR_IGNORE;
		break;
	case MBF_TYPEOKCANCEL:
		button1Label = [NSString stringWithCString : ""];
		button2Label = [NSString stringWithCString : ""];
		button3Label = NULL;
		retvalue[0] = MBR_OK;
		retvalue[1] = MBR_CANCEL;
		retvalue[2] = 0;
		break;
	case MBF_TYPERETRYCANCEL:
		button1Label = [NSString stringWithCString : "Ďs"];
		button2Label = [NSString stringWithCString : ""];
		button3Label = NULL;
		retvalue[0] = MBR_RETRY;
		retvalue[1] = MBR_CANCEL;
		retvalue[2] = 0;
		break;
	case MBF_TYPEYESNO:
		button1Label = [NSString stringWithCString : "͂"];
		button2Label = [NSString stringWithCString : ""];
		button3Label = NULL;
		retvalue[0] = MBR_YES;
		retvalue[1] = MBR_NO;
		retvalue[2] = 0;
		break;
	case MBF_TYPEYESNOCANCEL:
		button1Label = [NSString stringWithCString : "͂"];
		button2Label = [NSString stringWithCString : ""];
		button3Label = [NSString stringWithCString : ""];
		retvalue[0] = MBR_YES;
		retvalue[1] = MBR_NO;
		retvalue[2] = MBR_CANCEL;
		break;
	case MBF_TYPEOK:
		button1Label = [NSString stringWithCString : ""];
		button2Label = NULL;
		button3Label = NULL;
		retvalue[0] = MBR_OK;
		retvalue[1] = 0;
		retvalue[2] = 0;
		break;
	default:
		return MBR_CANCEL;
	}
	
	switch(flags & MBF_ICONMASK){
	case MBF_ICONEXCLAMATION:
		alertStyle = NSWarningAlertStyle;
		break;
	case MBF_ICONQUESTION:
		alertStyle = NSInformationalAlertStyle;
		break;
	case MBF_ICONSTOP:
		alertStyle = NSCriticalAlertStyle;
		break;
	default:
		alertStyle = NSInformationalAlertStyle;
	}

	/* localize */
	if(button1Label!=NULL){
		button1Label = [[NSBundle mainBundle]
				localizedStringForKey : button1Label
								value : nil
								table : nil];
	}
	if(button2Label!=NULL){
		button2Label = [[NSBundle mainBundle]
				localizedStringForKey : button2Label
								value : nil
								table : nil];
	}
	if(button3Label!=NULL){
		button3Label = [[NSBundle mainBundle]
				localizedStringForKey : button3Label
								value : nil
								table : nil];
	}
	message = [[NSBundle mainBundle]
					localizedStringForKey : message
									value : nil
									table : nil];
	title = [[NSBundle mainBundle]
					localizedStringForKey : title
									value : nil
									table : nil];
	
	/* create alert panel */
	alert = [[NSAlert alloc] init];
	if(button1Label!=NULL)
		[alert addButtonWithTitle : button1Label];
	if(button2Label!=NULL)
		[alert addButtonWithTitle : button2Label];
	if(button3Label!=NULL)
		[alert addButtonWithTitle : button3Label];
	[alert setMessageText : message];
	[alert setInformativeText : title];
	[alert setAlertStyle : alertStyle];
	
	switch([alert runModal]){
	case NSAlertFirstButtonReturn:
		retcode = retvalue[0];
		break;
	case NSAlertSecondButtonReturn:
		retcode = retvalue[1];
		break;
	case NSAlertThirdButtonReturn:
		retcode = retvalue[2];
		break;
	default:
		retcode = MBR_CANCEL;		
	}
	[alert release];
	return retcode;
}

/*
 * delegate
 */
- (void) applicationDidFinishLaunching: (NSNotification *)aNotification
{
    [self startUp];
}

- (void) applicationWillTerminate: (NSNotification *)aNotification
{
    if(g_Readers!=NULL){
		free(g_Readers);
		g_Readers = NULL;
	}
	if(g_Writers!=NULL){
		free(g_Writers);
		g_Writers = NULL;
	}
}

- (void)windowWillClose:(NSNotification *)aNotification
{
    [NSApp terminate: self];
}

@end
