﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using MinorShift.Emuera.Sub;
using System.Drawing;
using MinorShift.Emuera.GameData.Expression;

namespace MinorShift.Emuera.GameView
{
	//TODO:1810～
	/* Emuera用Htmlもどきが実装すべき要素
	 * (できるだけhtmlとConsoleDisplayLineとの1:1対応を目指す。<b>と<strong>とか同じ結果になるタグを重複して実装しない)
	 * <p align=""></p> ALIGNMENT命令相当・行頭から行末のみ・行末省略可
	 * <nobr></nobr> PRINTSINGLE相当・行頭から行末のみ・行末省略可
	 * <b><i><u><s> フォント各種・オーバーラップ問題は保留
	 * <button value=""></button> ボタン化・htmlでは明示しない限りボタン化しない
	 * <font face="" color="" bcolor=""></font> フォント指定 色指定 ボタン選択中色指定
	 * font bcolor属性のみhtmlにないオリジナル
	 * 追加<!-- --> コメント
	 * エスケープ
	 * &amp; &gt; &lt; &quot; &apos; &<>"' ERBにおける利便性を考えると属性値の指定には"よりも'を使いたい。HTML4.1にはないがaposを入れておく
	 * &#nn; &#xnn; Unicode参照 #xFFFF以上は却下
	 */
	/* このクラスがサポートすべきもの
	 * html から ConsoleDisplayLine[] //主に表示用
	 * ConsoleDisplayLine[] から html //現在の表示をstr化して保存？
	 * html から ConsoleDisplayLine[] を経て html //表示を行わずに改行が入る位置のチェックができるかも
	 * html から PlainText(非エスケープ)//
	 * Text から エスケープ済Text
	 */
	/// <summary>
	/// EmueraConsoleのなんちゃってHtml解決用クラス
	/// </summary>
	internal static class HtmlManager
	{
		static HtmlManager()
		{
			repDic.Add('&', "&amp;");
			repDic.Add('>', "&gt;");
			repDic.Add('<', "&lt;");
			repDic.Add('\"', "&quot;");
			repDic.Add('\'', "&apos;");
		}
		static readonly char[] rep = new char[] { '&', '>', '<', '\"', '\'' };
		static readonly Dictionary<char, string> repDic = new Dictionary<char, string>();
		private sealed class HtmlAnalzeStateFontTag
		{
			public int Color = -1;
			public int BColor = -1;
			public string FontName = null;
		}

		private sealed class HtmlAnalzeState
		{
			public bool LineHead = true;//行頭フラグ。一度もテキストが出てきてない状態
			public FontStyle FontStyle = FontStyle.Regular;
			public bool ButtonString = false;//<button>内部
			public int ButtonValueInt;
			public string ButtonValueStr = null;
			public bool ButtonIsInteger = false;
			public List<HtmlAnalzeStateFontTag> FonttagList = new List<HtmlAnalzeStateFontTag>();
			public bool FlagNobr = false;//falseの時に</nobr>するとエラー
			public bool FlagP = false;//falseの時に</p>するとエラー
			public bool FlagNobrClosed = false;//trueの時に</nobr>するとエラー
			public bool FlagPClosed = false;//trueの時に</p>するとエラー
			public DisplayLineAlignment Alignment = DisplayLineAlignment.LEFT;


			public bool FlagBr = false;//<br>による強制改行の予約
			public bool FlagButton = false;//<button></button>によるボタン化の予約

			public StringStyle GetSS()
			{
				Color c = Config.ForeColor;
				Color b = Config.FocusColor;
				string fontname = null;
				bool colorChanged = false;
				if (FonttagList.Count > 0)
				{
					HtmlAnalzeStateFontTag font = FonttagList[FonttagList.Count - 1];
					fontname = font.FontName;
					if (font.Color >= 0)
					{
						colorChanged = true;
						c = Color.FromArgb(font.Color >> 16, (font.Color >> 8) & 0xFF, font.Color & 0xFF);
					}
					if (font.BColor >= 0)
					{
						b = Color.FromArgb(font.BColor >> 16, (font.BColor >> 8) & 0xFF, font.BColor & 0xFF);
					}
				}
				return new StringStyle(c, colorChanged, b, FontStyle, fontname);
			}
		}

		/// <summary>
		/// 表示行からhtmlへの変換
		/// </summary>
		/// <param name="lines"></param>
		/// <returns></returns>
		public static string DisplayLine2Html(ConsoleDisplayLine[] lines)
		{
			if (lines == null || lines.Length == 0)
				return "";
			StringBuilder b = new StringBuilder();
			switch (lines[0].Align)
			{
				case DisplayLineAlignment.LEFT:
					b.Append("<p align='left'>");
					break;
				case DisplayLineAlignment.CENTER:
					b.Append("<p align='center'>");
					break;
				case DisplayLineAlignment.RIGHT:
					b.Append("<p align='right'>");
					break;
			}
			b.Append("<nobr>");
			for (int dispCounter = 0; dispCounter < lines.Length; dispCounter++)
			{
				if (dispCounter != 0)
					b.Append("<br>");
				ConsoleButtonString[] buttons = lines[dispCounter].Buttons;
				for (int buttonCounter = 0; buttonCounter < buttons.Length; buttonCounter++)
				{
					if (buttons[buttonCounter].IsButton)
					{
						string attrValue = Escape(buttons[buttonCounter].Inputs);
						b.Append("<button value='" + attrValue + "'>");
					}
					ConsoleStyledString[] strs = buttons[buttonCounter].StrArray;
					for (int cssCounter = 0; cssCounter < strs.Length; cssCounter++)
					{

						b.Append(getStringStyleStartingTag(strs[cssCounter].StringStyle));
						b.Append(Escape(strs[cssCounter].Str));
						b.Append(getClosingStyleStartingTag(strs[cssCounter].StringStyle));
					}
					if (buttons[buttonCounter].IsButton)
						b.Append("</button>");
				}
			}
			b.Append("</nobr>");
			b.Append("</p>");
			return b.ToString();
		}

		/// <summary>
		/// htmlから表示行の作成
		/// </summary>
		/// <param name="str">htmlテキスト</param>
		/// <param name="sm"></param>
		/// <param name="console">実際の表示に使わないならnullにする</param>
		/// <returns></returns>
		public static ConsoleDisplayLine[] Html2DisplayLine(string str, StringMeasure sm, EmueraConsole console)
		{
			List<ConsoleStyledString> cssList = new List<ConsoleStyledString>();
			List<ConsoleButtonString> buttonList = new List<ConsoleButtonString>();
			int index = 0;
			int found;
			bool hasComment = str.IndexOf("<!--") >= 0;
			HtmlAnalzeState state = new HtmlAnalzeState();
			while (index < str.Length)
			{
				found = str.IndexOf('<', index);
				if (found < 0)
				{
					string txt = Unescape(str.Substring(index));
					cssList.Add(new ConsoleStyledString(txt, state.GetSS()));
					if (state.FlagPClosed)
						throw new CodeEE("</p>の後にテキストがあります");
					if (state.FlagNobrClosed)
						throw new CodeEE("</nobr>の後にテキストがあります");
					break;
				}
				else if (found > index)
				{
					string txt = Unescape(str.Substring(index, found - index));
					cssList.Add(new ConsoleStyledString(txt, state.GetSS()));
					state.LineHead = false;
					index = found;
				}
				//コメントタグのみ特別扱い
				if (hasComment && found == str.IndexOf("<!--"))
				{
					index += 4;
					found = str.IndexOf("-->",index);
					if (found < 0)
						throw new CodeEE("コメント終了タグ\"-->\"がみつかりません");
					index = found;
					continue;
				}
				found = str.IndexOf('>', index);
				if (found <= index + 1)
					throw new Exception();
				string tag = str.Substring(index + 1, found - index - 1);
				index = found + 1;
				tagAnalyze(state, new StringStream(tag));

				if (state.FlagBr)
				{
					if (cssList.Count > 0)
						buttonList.Add(cssToButton(cssList, state.ButtonString, state, console));
					buttonList.Add(null);
				}
				if (state.FlagButton && cssList.Count > 0)
				{
					//<button>による場合はstate.FlagButtonがtureだがこれまでの分は非ボタン
					//</button>による場合はstate.FlagButtonがfalseだがこれまでの分はボタン
					//フラグが逆になる
					buttonList.Add(cssToButton(cssList, !state.ButtonString, state, console));
				}
				state.FlagBr = false;
				state.FlagButton = false;
			}
			//</nobr></p>は省略許可
			if (state.ButtonString || state.FontStyle != FontStyle.Regular || state.FonttagList.Count > 0)
				throw new CodeEE("閉じられていないタグがあります");
			if (cssList.Count > 0)
				buttonList.Add(cssToButton(cssList, state.ButtonString, state, console));
			int pointX = 0;
			for (int i = 0; i < buttonList.Count; i++)
			{
				ConsoleButtonString button = buttonList[i];
				if (button == null)
				{//改行フラグ
					pointX = 0;
					continue;
				}
				button.SetWidth(sm);
				button.SetPointX(pointX);
				pointX += button.Width;
			}
			ConsoleDisplayLine[] ret = PrintStringBuffer.ButtonsToDisplayLines(buttonList, sm, state.FlagNobr, false);

			foreach (ConsoleDisplayLine dl in ret)
			{
				dl.SetAlignment(state.Alignment);
			}
			return ret;
		}

		public static string Html2PlainText(string str)
		{
			string ret = Regex.Replace(str, "\\<[^<]*\\>", "");
			return Unescape(ret);
		}

		public static string Escape(string str)
		{
			//Net4.5では便利なクラスがあるらしい
			//return System.Web.HttpUtility.HtmlEncode(str);

			int index = 0;
			int found = 0;
			StringBuilder b = new StringBuilder();
			while (index < str.Length)
			{
				found = str.IndexOfAny(rep, index);
				if (found < 0)//見つからなければ以降を追加して終了
				{
					b.Append(str.Substring(index));
					break;
				}
				if (found > index)//間に非エスケープ文字があるなら追加しておく
					b.Append(str.Substring(index, found - index));
				string repnew = repDic[str[found]];
				b.Append(repnew);
				index = found + 1;
			}
			return b.ToString();
		}

		public static string Unescape(string str)
		{
			int index = 0;
			int found = str.IndexOf('&', index);
			if (found < 0)
				return str;
			StringBuilder b = new StringBuilder();
			// &～; をひたすら置換するだけ
			while (index < str.Length)
			{
				found = str.IndexOf('&', index);
				if (found < 0)//見つからなければ以降を追加して終了
				{
					b.Append(str.Substring(index));
					break;
				}
				if (found > index)//間に非エスケープ文字があるなら追加しておく
					b.Append(str.Substring(index, found - index));
				index = found;
				found = str.IndexOf(';', index);
				if (found <= index + 1)
				{
					if (found < 0)
						throw new CodeEE("'&'に対応する';'がみつかりません");
					throw new CodeEE("'&'と';'が連続しています");
				}
				string escWordRow = str.Substring(index + 1, found - index - 1);
				index = found + 1;
				string escWord = escWordRow.ToLower();
				int unicode = 0;
				switch (escWord)
				{
					case "nbsp": b.Append(" "); break;
					case "amp": b.Append("&"); break;
					case "gt": b.Append(">"); break;
					case "lt": b.Append("<"); break;
					case "quot": b.Append("\""); break;
					case "apos": b.Append("\'"); break;
					default:
						{
							int iBbase = 10;
							if (escWord[0] != '#')
								throw new CodeEE("\"&" + escWordRow + ";\"は適切な文字参照ではありません");
							if (escWord.Length > 1 && escWord[1] == 'x')
							{
								iBbase = 16;
								escWord = escWord.Substring(2);
							}
							else
								escWord = escWord.Substring(1);
							try
							{
								unicode = Convert.ToInt32(escWord, iBbase);
							}
							catch
							{

								throw new CodeEE("\"&" + escWordRow + ";\"は適切な文字参照ではありません");
							}

							if (unicode < 0 || unicode > 0xFFFF)
								throw new CodeEE("\"&" + escWordRow + ";\"はUnicodeの範囲外です(サロゲートペアは使えません)");
							b.Append((char)unicode);
							break;
						}
				}
			}
			return b.ToString();
		}

		private static ConsoleButtonString cssToButton(List<ConsoleStyledString> cssList, bool isbutton, HtmlAnalzeState state, EmueraConsole console)
		{
			ConsoleStyledString[] css = new ConsoleStyledString[cssList.Count];
			cssList.CopyTo(css);
			cssList.Clear();
			if (!isbutton)
			{
				return new ConsoleButtonString(console, css);
			}
			else
			{
				if (state.ButtonIsInteger)
					return new ConsoleButtonString(console, css, state.ButtonValueInt, state.ButtonValueStr);
				else
					return new ConsoleButtonString(console, css, state.ButtonValueStr);
			}
		}

		private static string getStringStyleStartingTag(StringStyle style)
		{
			bool fontChanged = !((style.Fontname == null || style.Fontname == Config.FontName)&& !style.ColorChanged && (style.ButtonColor == Config.FocusColor));
			if (!fontChanged && style.FontStyle == FontStyle.Regular)
				return "";
			StringBuilder b = new StringBuilder();
			if (fontChanged)
			{
				b.Append("<font");
				if (style.Fontname != null && style.Fontname != Config.FontName)
				{
					b.Append(" face='");
					b.Append(HtmlManager.Escape(style.Fontname));
					b.Append("'");
				}
				if (style.ColorChanged)
				{
					b.Append(" color='#");
					int colorValue = style.Color.R * 0x10000 + style.Color.G * 0x100 + style.Color.B;
					b.Append(colorValue.ToString("X6"));
					b.Append("'");
				}
				if (style.ButtonColor != Config.FocusColor)
				{
					b.Append(" bcolor='#");
					int colorValue = style.ButtonColor.R * 0x10000 + style.ButtonColor.G * 0x100 + style.ButtonColor.B;
					b.Append(colorValue.ToString("X6"));
					b.Append("'");
				}
				b.Append(">");
			}
			if (style.FontStyle != FontStyle.Regular)
			{
				if ((style.FontStyle & FontStyle.Strikeout) != FontStyle.Regular)
					b.Append("<s>");
				if ((style.FontStyle & FontStyle.Underline) != FontStyle.Regular)
					b.Append("<u>");
				if ((style.FontStyle & FontStyle.Italic) != FontStyle.Regular)
					b.Append("<i>");
				if ((style.FontStyle & FontStyle.Bold) != FontStyle.Regular)
					b.Append("<b>");
			}

			return b.ToString();
		}

		private static string getClosingStyleStartingTag(StringStyle style)
		{
			bool fontChanged = !((style.Fontname == null || style.Fontname == Config.FontName) && !style.ColorChanged && (style.ButtonColor == Config.FocusColor));
			if (!fontChanged && style.FontStyle == FontStyle.Regular)
				return "";
			StringBuilder b = new StringBuilder();
			if (style.FontStyle != FontStyle.Regular)
			{
				if ((style.FontStyle & FontStyle.Bold) != FontStyle.Regular)
					b.Append("</b>");
				if ((style.FontStyle & FontStyle.Italic) != FontStyle.Regular)
					b.Append("</i>");
				if ((style.FontStyle & FontStyle.Underline) != FontStyle.Regular)
					b.Append("</u>");
				if ((style.FontStyle & FontStyle.Strikeout) != FontStyle.Regular)
					b.Append("</s>");
			}
			if (fontChanged)
				b.Append("</font>");
			return b.ToString();
		}

		private static void tagAnalyze(HtmlAnalzeState state, StringStream st)
		{
			bool tempUseMacro = LexicalAnalyzer.UseMacro;//一時的にマクロ展開をやめる
			LexicalAnalyzer.UseMacro = false;
			WordCollection wc = LexicalAnalyzer.Analyse(st, LexEndWith.EoL, LexAnalyzeFlag.AllowAssignment | LexAnalyzeFlag.AllowSingleQuotationStr);
			LexicalAnalyzer.UseMacro = tempUseMacro;
			IdentifierWord word;
			string tag;
			if (wc.Current is OperatorWord && ((OperatorWord)wc.Current).Code == OperatorCode.Div)
			{
				wc.ShiftNext();
				word = wc.Current as IdentifierWord;
				wc.ShiftNext();
				if (!wc.EOL || word == null)
					goto error;
				tag = word.Code.ToLower();
				FontStyle endStyle = FontStyle.Strikeout;
				switch (tag)
				{
					case "b": endStyle = FontStyle.Bold; goto case "s";
					case "i": endStyle = FontStyle.Italic; goto case "s";
					case "u": endStyle = FontStyle.Underline; goto case "s";
					case "s":
						if ((state.FontStyle & endStyle) == FontStyle.Regular)
							throw new CodeEE("</" + tag + ">の前に<" + tag + ">がありません");
						state.FontStyle ^= endStyle;
						return;
					case "p":
						if ((!state.FlagP) || (state.FlagPClosed))
							throw new CodeEE("</p>の前に<p>がありません");
						state.FlagPClosed = true;
						return;
					case "nobr":
						if ((!state.FlagNobr) || (state.FlagNobrClosed))
							throw new CodeEE("</nobr>の前に<nobr>がありません");
						state.FlagNobrClosed = true;
						return;
					case "font":
						if (state.FonttagList.Count == 0)
							throw new CodeEE("</font>の前に<font>がありません");
						state.FonttagList.RemoveAt(state.FonttagList.Count - 1);
						return;
					case "button":
						if (!state.ButtonString)
							throw new CodeEE("</button>の前に<button>がありません");
						state.ButtonString = false;
						state.FlagButton = true;
						return;
				}
				goto error;
			}
			word = wc.Current as IdentifierWord;
			if (word == null)
				goto error;

			wc.ShiftNext();
			tag = word.Code.ToLower();
			FontStyle newStyle = FontStyle.Strikeout;
			switch (tag)
			{
				case "b": newStyle = FontStyle.Bold; goto case "s";
				case "i": newStyle = FontStyle.Italic; goto case "s";
				case "u": newStyle = FontStyle.Underline; goto case "s";
				case "s":
					if (!wc.EOL)
						goto error;
					if ((state.FontStyle & newStyle) != FontStyle.Regular)
						throw new CodeEE("<" + tag + ">が二重に使われています");
					state.FontStyle |= newStyle;
					return;
				case "br":
					if (!wc.EOL)
						goto error;
					state.FlagBr = true;
					return;
				case "nobr":
					if (!wc.EOL)
						goto error;
					if (!state.LineHead)
						throw new CodeEE("<nobr>が行頭以外で使われています");
					if (state.FlagNobr)
						throw new CodeEE("<nobr>が2度以上使われています");
					state.FlagNobr = true;
					return;
				case "p":
					{
						if (wc.EOL)
							throw new CodeEE("<p>タグに属性が指定されていません");
						if (!state.LineHead)
							throw new CodeEE("<p>が行頭以外で使われています");
						if (state.FlagNobr)
							throw new CodeEE("<p>が2度以上使われています");
						word = wc.Current as IdentifierWord;
						wc.ShiftNext();
						OperatorWord op = wc.Current as OperatorWord;
						wc.ShiftNext();
						LiteralStringWord attr = wc.Current as LiteralStringWord;
						wc.ShiftNext();
						if (!wc.EOL || word == null || op == null || op.Code != OperatorCode.Assignment || attr == null)
							goto error;
						if (!word.Code.Equals("align", StringComparison.OrdinalIgnoreCase))
							throw new CodeEE("<p>タグの属性名" + word.Code + "は解釈できません");
						string attrValue = Unescape(attr.Str);
						switch (attrValue.ToLower())
						{
							case "left":
								state.Alignment = DisplayLineAlignment.LEFT;
								break;
							case "center":
								state.Alignment = DisplayLineAlignment.CENTER;
								break;
							case "right":
								state.Alignment = DisplayLineAlignment.RIGHT;
								break;
							default:
								throw new CodeEE("属性値" + attr.Str + "は解釈できません");
						}
						state.FlagP = true;
						return;
					}
				case "button":
					{
						if (wc.EOL)
							throw new CodeEE("<button>タグに属性が指定されていません");
						word = wc.Current as IdentifierWord;
						wc.ShiftNext();
						OperatorWord op = wc.Current as OperatorWord;
						wc.ShiftNext();
						LiteralStringWord attr = wc.Current as LiteralStringWord;
						wc.ShiftNext();
						if (!wc.EOL || word == null || op == null || op.Code != OperatorCode.Assignment || attr == null)
							goto error;
						if (!word.Code.Equals("value", StringComparison.OrdinalIgnoreCase))
							throw new CodeEE("<button>タグの属性名" + word.Code + "は解釈できません");
						int value = 0;
						string attrValue = Unescape(attr.Str);
						state.ButtonIsInteger = (int.TryParse(attrValue, out value));
						state.ButtonString = true;
						state.ButtonValueInt = value;
						state.ButtonValueStr = attrValue;
						state.FlagButton = true;
						return;
					}
				case "font":
					{
						if (wc.EOL)
							throw new CodeEE("<font>タグに属性が指定されていません");
						HtmlAnalzeStateFontTag font = new HtmlAnalzeStateFontTag();
						while (!wc.EOL)
						{
							word = wc.Current as IdentifierWord;
							wc.ShiftNext();
							OperatorWord op = wc.Current as OperatorWord;
							wc.ShiftNext();
							LiteralStringWord attr = wc.Current as LiteralStringWord;
							wc.ShiftNext();
							if (word == null || op == null || op.Code != OperatorCode.Assignment || attr == null)
								goto error;
							string attrValue = Unescape(attr.Str);
							switch (word.Code.ToLower())
							{
								case "color":
									if (font.Color >= 0)
										throw new CodeEE("<font>タグに属性" + word.Code + "が2度以上指定されています");
									font.Color = stringToColorInt32(attrValue);
									break;
								case "bcolor":
									if (font.BColor >= 0)
										throw new CodeEE("<font>タグに属性" + word.Code + "が2度以上指定されています");
									font.BColor = stringToColorInt32(attrValue);
									break;
								case "face":
									if (font.FontName != null)
										throw new CodeEE("<font>タグに属性" + word.Code + "が2度以上指定されています");
									font.FontName = attrValue;
									break;
								default:
									throw new CodeEE("<font>タグの属性名" + word.Code + "は解釈できません");
							}
						}
						//他のfontタグの内側であるなら未設定項目については外側のfontタグの設定を受け継ぐ
						if (state.FonttagList.Count > 0)
						{
							HtmlAnalzeStateFontTag oldFont = state.FonttagList[state.FonttagList.Count - 1];
							if (font.Color < 0)
								font.Color = oldFont.Color;
							if (font.BColor < 0)
								font.BColor = oldFont.BColor;
							if (font.FontName == null)
								font.FontName = oldFont.FontName;
						}
						state.FonttagList.Add(font);
						return;
					}
				default:
					goto error;
			}


		error:
			throw new CodeEE("タグ<" + st.RowString + ">は解釈できません");
		}

		private static int stringToColorInt32(string str)
		{
			int i = 0;
			if (str[0] == '#')
			{
				try
				{
					string colorvalue = str.Substring(1);
					i = Convert.ToInt32(colorvalue, 16);
					if (i < 0 || i > 0xFFFFFF)
						throw new CodeEE(str + "は適切な色指定の範囲外です");
				}
				catch
				{
					throw new CodeEE(str + "は数値として解釈できません");
				}
			}
			else
			{
				Color color = Color.FromName(str);
				if (color.A == 0)
					throw new CodeEE(str + "は解釈できません");
				i = color.R * 0x10000 + color.G * 0x100 + color.B;
			}
			return i;
		}

	}
}
