using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using MinorShift._Library;

namespace MinorShift.Emuera.GameView
{
	internal enum DisplayLineLastState
	{
		None = 0,
		Normal = 1,
		Selected = 2,
		BackLog = 3,
	}
	internal enum DisplayLineAlignment
	{
		LEFT = 0,
		CENTER = 1,
		RIGHT = 2,
	}
	/// <summary>
	/// 表示行。1つ以上のボタン（ConsoleButtonString）からなる
	/// </summary>
	internal sealed class ConsoleDisplayLine
	{
		
		public ConsoleDisplayLine(EmueraConsole parentWindow, ConsoleButtonString[] buttons, bool isLogical, bool temporary)
		{
			parent = parentWindow;
			if (buttons == null)
			{
				buttons = new ConsoleButtonString[0];
				return;
			}
			this.buttons = buttons;
			foreach (ConsoleButtonString button in buttons)
				button.ParentLine = this;
			IsLogicalLine = isLogical;
			IsTemporary = temporary;
		}
		public int LineNo = -1;
		
		///論理行の最初となる場合だけtrue。表示の都合で改行された2行目以降はfalse
		readonly public bool IsLogicalLine = true;
		readonly public bool IsTemporary = false;
		EmueraConsole parent;
		ConsoleButtonString[] buttons;

		public void SetAlignment(DisplayLineAlignment align)
		{
			//DisplayLineの幅
			int width = 0;
			foreach (ConsoleButtonString button in buttons)
				width += button.Width;
			//現在位置
			int pointX = buttons[0].PointX;

			//目標位置
			int movetoX = 0;
			if (align == DisplayLineAlignment.LEFT)
				movetoX = 0;
			else if (align == DisplayLineAlignment.CENTER)
				movetoX = Config.Instance.WindowX / 2 - width / 2;
			else if (align == DisplayLineAlignment.RIGHT)
				movetoX = Config.Instance.WindowX - width;

			//移動距離
			int shiftX = movetoX - pointX;
			if(shiftX != 0)
				this.ShiftPositionX(shiftX);
		}

		public void ShiftPositionX(int shiftX)
		{
			foreach (ConsoleButtonString button in buttons)
				button.ShiftPositionX(shiftX);
		}

		public void ChangeStr(ConsoleButtonString[] newButtons)
        {
            buttons = null;
			foreach (ConsoleButtonString button in newButtons)
				button.ParentLine = this;
			buttons = newButtons;
        }

		public void Clear(Brush brush, Graphics graph, int pointY)
		{
			Rectangle rect = new Rectangle(0, pointY, Config.Instance.WindowX, Config.Instance.LineHeight);
			graph.FillRectangle(brush, rect);
		}

		public ConsoleButtonString GetPointingButton(int pointX)
		{
			foreach (ConsoleButtonString button in buttons)
			{
				if ((button.PointX <= pointX) && (button.PointX + button.Width >= pointX))
					return button;
			}
			return null;
		}

		public void DrawTo(Graphics graph, int pointY, bool isBackLog, bool force)
		{
            foreach (ConsoleButtonString button in buttons)
                button.DrawTo(graph, pointY, isBackLog);
		}
		
		public void GDIDrawTo(int pointY, bool isBackLog)
		{
			int pointX = 0;
			foreach (ConsoleButtonString button in buttons)
			{
				if (pointX < button.PointX)
				{
					Rectangle rect = new Rectangle(pointX, pointY, button.PointX - pointX, Config.Instance.LineHeight);
					GDI.FillRect(rect);
				}
				button.GDIDrawTo(pointY, isBackLog);
				pointX = button.PointX + button.Width;
			}
			if (pointX < Config.Instance.WindowX)
			{
				Rectangle rect = new Rectangle(pointX, pointY, Config.Instance.WindowX - pointX, Config.Instance.LineHeight);
				GDI.FillRect(rect);
			}
		}
		
		public override string ToString()
		{
			if (buttons == null)
				return "";
			StringBuilder builder = new StringBuilder();
			foreach (ConsoleButtonString button in buttons)
				builder.Append(button.ToString());
			return builder.ToString();
		}
	}
}
