using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
using System.Windows.Forms;

namespace MinorShift.Emuera.GameProc
{

	internal sealed partial class Process
	{
		private Process(EmueraConsole view)
		{
			console = view;
		}

		//1.713 Processグローバル化
		//ExpressionEvaluatorとParserが利用する
		//1.731 ついでに一部のMethodが参照
		public static Process CreateProcess(EmueraConsole view)
		{
			//if (instance == null)
			//	instance.Dispose();
			instance = new Process(view);
			return instance;
		}
		static Process instance = null;
		public static Process Instance { get { return instance; } }
        public LogicalLine getCurrentLine { get { return state.CurrentLine; } }

        //ERBloaderに引数解析の結果を渡すための橋渡し変数
        public Dictionary<string, Int64> tempDic = new Dictionary<string, long>();
        public void PrintAnalysisWarning(string str, LogicalLine line, int level)
        {
            console.PrintWarning(str, line.Position, level);
        }

		/// <summary>
		/// @~~と$~~を集めたもの。CALL命令などで使う
		/// 実行順序はLogicalLine自身が保持する。
		/// </summary>
		LabelDictionary labelDic;
		public LabelDictionary LabelDic { get { return labelDic; } }

		/// <summary>
		/// 変数全部。スクリプト中で必要になる変数は（ユーザーが直接触れないものも含め）この中にいれる
		/// </summary>
		private VariableEvaluator vEvaluator;
		private ExpressionEvaluator eEvaluator;
		private GameBase gamebase;
		readonly EmueraConsole console;
		public EmueraConsole Console { get { return console; } }
		public ExpressionEvaluator EEvaluator { get { return eEvaluator; } }
		ProcessState state;
		ProcessState originalState;//リセットする時のために

        static List<string> loadedFileList = new List<string>();
        bool noError = false;

        public bool Initialize()
		{
			isInitialized = false;
			state = new ProcessState(console);
			originalState = state;
            bool load_Rename = false;
			string csvDir = Program.ExeDir + "csv\\";
			string erbDir = Program.ExeDir + "erb\\";
            try
            {
                if (Config.Instance.UseKeyMacro && !Program.AnalysisMode)
                {
                    if (File.Exists(Program.ExeDir + "macro.txt"))
                    {
                        if (Config.Instance.DisplayReport)
                            console.PrintLine("macro.txt読み込み中・・・");
                        Config.Instance.LoadMacroFile(Program.ExeDir + "macro.txt");
                    }
                }
                if (Config.Instance.UseReplaceFile && !Program.AnalysisMode)
                {
                    if (File.Exists(csvDir + "_Replace.csv"))
                    {
                        if (Config.Instance.DisplayReport)
                            console.PrintLine("_Replace.csv読み込み中・・・");
                        Config.Instance.LoadReplaceFile(csvDir + "_Replace.csv");
                        console.setStBar(Config.Instance.DrawLineString);
                    }
                    //else
                    //	console.PrintLine("csv\\_Replace.csvが見つかりません");
                }
                if (Config.Instance.UseRenameFile)
                {
                    if (File.Exists(csvDir + "_Rename.csv"))
                    {
                        if (Config.Instance.DisplayReport || Program.AnalysisMode)
                            console.PrintLine("_Rename.csv読み込み中・・・");
                        load_Rename = true;
                    }
                    else
                        console.PrintError("csv\\_Rename.csvが見つかりません");
                }
                if (!Config.Instance.DisplayReport)
                {
                    console.PrintLine(Config.Instance.LoadLabel);
                    console.RefreshStrings(true);
                }
                gamebase = new GameBase();
                gamebase.LoadGameBaseCsv(csvDir + "GAMEBASE.CSV");
                console.SetWindowTitle(gamebase.ScriptWindowTitle);

                ConstantData constant = new ConstantData(gamebase);
                constant.LoadData(csvDir, console);
                vEvaluator = new VariableEvaluator(gamebase, constant);
                //VariableEvaluator.SetTestData(VEvaluator);
                eEvaluator = new ExpressionEvaluator(vEvaluator);
                //if (File.Exists(csvDir + "_Rename.csv"))
                //    VarData.LoadEraExRenameFile(csvDir + "_Rename.csv");
                ErbLoader loader = new ErbLoader(console, vEvaluator);
                if (load_Rename)
                    loader.LoadEraExRenameFile(csvDir + "_Rename.csv");
                labelDic = new LabelDictionary();
                if (Program.AnalysisMode)
                    noError = loader.loadErbs(Program.AnalysisFiles, labelDic);
                else
                    noError = loader.LoadErbFiles(erbDir, Config.Instance.DisplayReport, labelDic);
                initSystemProcess();
            }
            catch (CodeEE e)
            {
                System.Media.SystemSounds.Hand.Play();
                if (e.Position != null)
				{
					console.forceUpdateGeneration();
					console.PrintErrorButton(e.Position.Filename + "の" + e.Position.LineNo.ToString() + "行目でエラーが発生しました", "openFileWithDebug", e.Position);
					console.NewLine();
                    console.PrintError(e.Position.RowLine);
                }
                console.PrintError(e.Message);
                return false;
            }
            catch (Exception)
            {
                System.Media.SystemSounds.Hand.Play();
                console.PrintError("初期化中に致命的なエラーが発生しました");
                return false;
            }
			if (labelDic == null)
			{
				return false;
			}
			isInitialized = true;
			state.Begin(BeginType.TITLE);
            return true;
		}

		//public bool InitialaizeWithoutLoad()
		//{
		//    VEvaluator = new VariableEvaluator(VEvaluator.Gamebase, VEvaluator.Constant);
		//    //VariableEvaluator.SetTestData(VEvaluator);
		//    eEvaluator = new ExpressionEvaluator(VEvaluator);
		//    VEvaluator.AddCharacter(0, false);
		//    if (VEvaluator.Gamebase.DefaultCharacter > 0)
		//        VEvaluator.AddCharacter(VEvaluator.Gamebase.DefaultCharacter, false);
		//    return true;
		//}

		public void ReloadErb()
		{
			saveCurrentState(false);
			state.ClearFunctionList();
			state.SystemState = SystemStateCode.System_Reloaderb;
			isInitialized = false;
			labelDic = null;
            string csvDir = Program.ExeDir + "csv\\"; 
            string erbDir = Program.ExeDir + "erb\\";
			ErbLoader loader = new ErbLoader(console, vEvaluator);
			labelDic = new LabelDictionary();
            if (Config.Instance.UseRenameFile)
            {
                if (File.Exists(csvDir + "_Rename.csv"))
                {
                    if (Config.Instance.DisplayReport || Program.AnalysisMode)
                        console.PrintLine("_Rename.csv読み込み中・・・");
                    loader.LoadEraExRenameFile(csvDir + "_Rename.csv");
                }
                else
                    console.PrintError("csv\\_Rename.csvが見つかりません");
            }
            loader.LoadErbFiles(erbDir, false, labelDic);
			isInitialized = true;
			console.ReadAnyKey();
		}

        public void ReloadPartialErb(List<string> path, bool addNewFiles)
        {
            saveCurrentState(false);
            state.ClearFunctionList();
            state.SystemState = SystemStateCode.System_Reloaderb;
            isInitialized = false;
            for (int i = 0; i < path.Count; i++)
            {
                if (!addNewFiles || (addNewFiles && checkFilePathExist(path[i])))
                    labelDic.RemoveLabelWithPath(path[i]);
                else if (addNewFiles)
                {
                    string fname;
                    if (path[i].StartsWith(Program.ExeDir))
                        fname = path[i].Substring(Program.ExeDir.Length + "erb\\".Length);
                    else
                        fname = path[i];
                  
                    loadedFileList.Add(fname);
                }
            }
            ErbLoader loader = new ErbLoader(console, vEvaluator);
            string csvDir = Program.ExeDir + "csv\\";
            if (Config.Instance.UseRenameFile)
            {
                if (File.Exists(csvDir + "_Rename.csv"))
                {
                    if (Config.Instance.DisplayReport || Program.AnalysisMode)
                        console.PrintLine("_Rename.csv読み込み中・・・");
                    loader.LoadEraExRenameFile(csvDir + "_Rename.csv");
                }
                else
                    console.PrintError("csv\\_Rename.csvが見つかりません");
            }
            loader.loadErbs(path, labelDic);
            isInitialized = true;
            console.ReadAnyKey();
        }

        private bool checkFilePathExist(string path)
        {
            string fname;
            if (path.StartsWith(Program.ExeDir))
                fname = path.Substring(Program.ExeDir.Length + "erb\\".Length);
            else
                fname = path;
            if (!loadedFileList.Contains(fname))
                return false;
            return true;
        }

        public bool checkFilePathsExist(List<string> path)
        {
            foreach (string fpath in path)
            {
                if (!checkFilePathExist(fpath))
                    return false;
            }
            return true;
        }

		public void SetCommnds(Int64 count)
		{
			coms = new List<long>((int)count);
			isCTrain = true;
			for (int i = 0; i < (int)count; i++)
			{
				string comStr = string.Format("SELECTCOM:{0}", (i + 1));
				StringStream aSt = new StringStream(comStr);
				Int64 comNum = eEvaluator.GetInteger(ExpressionParser.ReduceIntegerTerm(aSt, null));
				coms.Add(comNum);
			}
		}

		public void InputInteger(Int64 i)
		{
			vEvaluator.RESULT = i;
		}
		public void InputSystemInteger(Int64 i)
		{
			systemResult = i;
		}
		public void InputString(string s)
		{
			vEvaluator.RESULTS = s;
		}

		public bool isInitialized = false;
		private long lineCount = 0;
		private uint startTime = 0;
		public void DoScript()
		{
			startTime = _Library.WinmmTimer.TickCount;
			lineCount = 0;
			while (true)
			{
				methodStack = 0;
				while (state.ScriptEnd && console.IsRunning)
					runSystemProcWithCatch();
				if (!console.IsRunning)
				{
					//    if (console.hasWaitRefresh || console.needRefresh)
					//        console.RefreshStrings(true);
					break;
				}
				runScriptProcWithCatch();
				//if (console.needRefresh)
				//    console.RefreshStrings(true);
			}
			return;
		}

		private void runSystemProcWithCatch()
		{
			try
			{
				runSystemProc();
			}
			catch (Exception e)
			{
                System.Media.SystemSounds.Hand.Play();
                if (e is CodeEE)
                    console.PrintError("関数の終端でエラーが発生しました");
				else if (e is ExeEE)
                    console.PrintError("関数の終端でEmueraのエラーが発生しました");
				else
                    console.PrintError("関数の終端で予期しないエラーが発生しました");
                console.PrintError(e.Message);
				console.ThrowError();
			}
		}

		public void BeginTitle()
		{
			vEvaluator.ResetData();
			state = originalState;
			state.Begin(BeginType.TITLE);
		}

		private void checkInfiniteLoop()
		{
            //lineCount++;
            ////WinmmTimerから時間を取得するのはそれ自体結構なコストがかかるので10000行に一回くらいで。
            //if (lineCount % 10000 != 0)
            //    return;
            //if (Config.Instance.InfiniteLoopAlertTime <= 0)
            //    return;

			//うまく動かない。BEEP音が鳴るのを止められないのでこの処理なかったことに（1.51）
			////フリーズ防止。処理中でも履歴を見たりできる
			//System.Windows.Forms.Application.DoEvents();
			////System.Threading.Thread.Sleep(0);

			//if (!console.Enabled)
			//{
			//    //DoEvents()の間にウインドウが閉じられたらおしまい。
			//    console.ReadAnyKey();
			//    return;
			//}
			uint time = _Library.WinmmTimer.TickCount - startTime;
			if (time < Config.Instance.InfiniteLoopAlertTime)
				return;
			LogicalLine currentLine = state.CurrentLine;
			if ((currentLine == null) || (currentLine is NullLine))
				return;//現在の行が特殊な状態ならスルー
			if (!console.Enabled)
				return;//クローズしてるとMessageBox.Showができないので。
			string caption = string.Format("無限ループの可能性があります");
			string text = string.Format(
				"現在、{0}の{1}行目を実行中です。\n最後の入力から{3}ミリ秒経過し{2}行が実行されました。\n処理を中断し強制終了しますか？",
				currentLine.Position.Filename, currentLine.Position.LineNo, lineCount, time);
			DialogResult result = MessageBox.Show(text, caption, MessageBoxButtons.YesNo);
			if (result == DialogResult.Yes)
			{
				throw new CodeEE("無限ループの疑いにより強制終了が選択されました");
			}
			else
			{
				lineCount = 0;
				startTime = _Library.WinmmTimer.TickCount;
			}
		}

		///DoScript()の一部。エラー処理が長くなったので分割。
		private void runScriptProcWithCatch()
		{
			try
			{
				runScriptProc();
				//checkInfiniteLoop();
			}
			catch (Exception ec)
			{
                System.Media.SystemSounds.Hand.Play();
				LogicalLine currentLine = state.ErrorLine;
				if ((currentLine == null) || (currentLine is NullLine))
					currentLine = null;
				ScriptPosition positon = null;

				if((ec is EmueraException) &&( ((EmueraException)ec).Position != null))
					positon = ((EmueraException)ec).Position; 
				else if ((currentLine != null) && (currentLine.Position != null))
					positon = currentLine.Position;
                console.UseUserStyle = false;
                if(positon != null)
				{
                    if (ec is CodeEE)//*.ERB等の問題と思われる例外
                    {
                        //console.PrintLine(currentLine.Position.Filename + "の" + currentLine.Position.LineNo.ToString() + "行目でエラーが発生しました");
                        console.forceUpdateGeneration();
						console.PrintErrorButton(currentLine.Position.Filename + "の" + currentLine.Position.LineNo.ToString() + "行目でエラーが発生しました", "openFileWithDebug", positon);  
                        console.NewLine();
                    }
                    else if (ec is ExeEE)//emuera.exe本体に起因すると思われる例外。バグ。
                        console.PrintError(currentLine.Position.Filename + "の" + currentLine.Position.LineNo.ToString() + "行目でEmuera.exeのエラーが発生しました");
                    else//SystemException。予期しない例外
                        console.PrintError(currentLine.Position.Filename + "の" + currentLine.Position.LineNo.ToString() + "行目で予期しないエラーが発生しました");
                    console.PrintError(currentLine.Position.RowLine);
				}
				else
				{
					if (ec is CodeEE)//*.ERB等の問題と思われる例外
                        console.PrintError("エラーが発生しました");
					else if (ec is ExeEE)//emuera.exe本体に起因すると思われる例外。バグ。
                        console.PrintError("Emuera.exeのエラーが発生しました");
					else//SystemException。予期しない例外
                        console.PrintError("予期しないエラーが発生しました");
                    console.PrintError("発生箇所を特定できませんでした");
				}
                if (ec is EmueraException)
                    console.PrintError(ec.Message);
                else//SystemException。エラー内容を知るためにはMessageよりむしろTypeの方が重要
                    console.PrintError(ec.GetType().ToString() + ":" + ec.Message);
				console.ThrowError();
			}
			return;
		}

		int methodStack = 0;
		public SingleTerm GetValue(string funcname, IOperandTerm[] args)
		{
			methodStack++;
			if (methodStack > 100)
			{
				//StackOverflowExceptionはcatchできない上に再現性がないので発生前に一定数で打ち切る。
				//環境によっては100以前にStackOverflowExceptionがでるかも？
				throw new CodeEE("関数の呼び出しスタックが溢れました(無限に再帰呼び出しされていませんか？)");
			}
			CalledFunction call = CalledFunction.CallFunctionMethod(this, funcname);
			if ((call == null) || (call.Count == 0) || (call.NextLine == null))
				throw new ExeEE("関数\"@" + funcname + "\"が見つかりません");
			if (call.Count > 1)
				throw new ExeEE("関数\"@" + funcname + "\"の候補が複数返された");
			assignArgs(call.LabelList[0], args);
			SingleTerm ret = null;
			ProcessState temp_state = state;
			state = state.CloneForFunctionMethod();
			state.AddFunction(call);
			//do whileの中でthrow されたエラーはここではキャッチされない。
			//#functionを全て抜けてrunScriptProcWithCatchでキャッチされる。
			//state = temp_state;が行われないため、エラー行は正しく判定される。
			do
			{
				runScriptProc();
				//if (console.IsError)
				//    break;
				if (!console.IsRunning && !console.RunERBFromMemory)
					throw new ExeEE("コンソール状態がRunningでない");//コンソール状態を変化させる命令は__METHOD_SAFE__を外しているはず
			} while (state.CurrentLine != null);

			ret = state.MethodReturnValue;
			state = temp_state;
            if (!(console.RunERBFromMemory && (methodStack == 1) && (state.SystemState != SystemStateCode.Title_Begin)))
                eEvaluator.VEvaluator.Scope = state.Scope;
            else if (state.SystemState == SystemStateCode.Title_Begin)
                eEvaluator.VEvaluator.Scope = "";
			//if (console.IsError)
			//{
			//    throw new CodeEE("関数@" + funcname + "の呼び出し中にエラーが発生しました");
			//}
			methodStack--;
			return ret;
		}

        public void clearMethodStack()
        {
            methodStack = 0;
        }

		public ScriptPosition GetRunningPosition()
		{
			LogicalLine line = state.ErrorLine;
			if (line == null)
				return null;
			return line.Position;
		}
	}
}
