using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.GameProc;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData.Expression;

namespace MinorShift.Emuera.GameData.Variable
{
	internal static class VariableParser
	{
		
		public static bool IsVariable(string ids)
		{
			if (string.IsNullOrEmpty(ids))
				return false;
			string[] idlist = ids.Split(':');
			//idlist = synonym.ApplySynonym(idlist);
			VariableIdentifier id = VariableIdentifier.GetVariableId(idlist[0]);
			return id != null;
		}

		public static bool IsInteger(string ids)
		{
			if (string.IsNullOrEmpty(ids))
				return false;
			string[] idlist = ids.Split(':');
			//idlist = synonym.ApplySynonym(idlist);
			VariableIdentifier id = VariableIdentifier.GetVariableId(idlist[0]);
			return id.IsInteger;
		}

		private static  SingleTerm getZeroToken()
		{
			return new SingleTerm(0);
		}

		private static VariableToken getTergetToken()
		{
			VariableIdentifier id = VariableIdentifier.GetVariableId(VariableCode.TARGET);
			return new VariableToken(id, new SingleTerm(0), null, null);
		}

		/// <summary>
		/// まだ最初の識別子を読んでいない状態から決め打ちで変数を解読する
		/// </summary>
		/// <param name="st"></param>
		/// <returns></returns>
		public static VariableToken ReduceVariable(StringStream st)
		{
			string idStr = TokenReader.ReadSingleIdentifer(st);
			return ReduceVariable(idStr, st);
		}

		/// <summary>
		/// 識別子を読み終えた状態からの解析
		/// </summary>
		/// <param name="st"></param>
		/// <returns></returns>
		public static VariableToken ReduceVariable(string idStr, StringStream st)
		{
			VariableIdentifier id = VariableIdentifier.GetVariableId(idStr);
            if (id == null)
            {
                throw new CodeEE("\"" + idStr + "\"は解釈できない識別子です");
            }
			IOperandTerm op1 = null;
			IOperandTerm op2 = null;
            IOperandTerm op3 = null;
			int i = 0;
			while (true)
			{
				TokenReader.SkipWhiteSpace(st);
				if (st.Current != ':')
					break;
				if (i >= 3)
					throw new CodeEE(id.ToString() + "の引数が多すぎます");

                st.ShiftNext();
				TokenReader.SkipWhiteSpace(st);
                if (i == 0)
                    op1 = ExpressionParser.ReduceVariableArgument(st, id.Code);
                else if (i == 1)
                    op2 = ExpressionParser.ReduceVariableArgument(st, id.Code);
                else if (i == 2)
                    op3 = ExpressionParser.ReduceVariableArgument(st, id.Code);
				i++;
			}
			return ReduceVariable(id, op1, op2, op3);

		}

		public static VariableToken ReduceVariable(VariableIdentifier id, IOperandTerm p1, IOperandTerm p2, IOperandTerm p3)
		{
			IOperandTerm op1 = p1;
			IOperandTerm op2 = p2;
            IOperandTerm op3 = p3;
			//引数の推測
			if (id.IsCharacterData)
			{
				if (id.IsArray1D)
				{
                    if (op3 != null)
                        throw new CodeEE("キャラクタ変数" + id.ToString() + "の引数が多すぎます");
					if (op2 == null)
					{
						if (op1 == null)
							op1 = getZeroToken();
						op2 = op1;
						op1 = getTergetToken();
					}
				}
				else
				{
					if (op2 != null)
						throw new CodeEE("一次元配列変数" + id.ToString() + "の引数が多すぎます");
					if (op1 == null)
						op1 = getTergetToken();
				}
			}
            else if (id.IsArray3D)
            {
                if ((op1 == null) || (op2 == null) || (op3 == null))
                    throw new CodeEE("三次元配列変数" + id.ToString() + "の引数は省略できません");
            }
            else if (id.IsArray2D)
            {
                if ((op1 == null) || (op2 == null))
                    throw new CodeEE("二次元配列変数" + id.ToString() + "の引数は省略できません");
                if (op3 != null)
                    throw new CodeEE("二次元配列" + id.ToString() + "の引数が多すぎます");
            }
            else if (id.IsArray1D)
            {
                if (op2 != null)
                    throw new CodeEE("一次元配列変数" + id.ToString() + "の引数が多すぎます");
                if (op1 == null)
                    op1 = getZeroToken();
            }
            else if (op1 != null)
                throw new CodeEE("配列でない変数" + id.ToString() + "を引数付きで呼び出しています");
			

			if (id.IsCharacterData)
			{
				if (id.IsArray1D)
				{
					if (op1.GetOperandType() == typeof(string))
						throw new CodeEE("キャラクタ変数の第１引数に文字列を指定することはできません");
				}
			}

			//if ( ((op1 != null) && (op1.IsConstant) && (op1.GetOperandType() == typeof(Int64)) && (op2 == null) )
			//    || ((op2 != null) && (op2.IsConstant) && (op2.GetOperandType() == typeof(Int64))) )
			//{//唯一の引数が定数、又は第２引数だけでも定数
			//    ExpressionEvaluator eEv = new ExpressionEvaluator(null);
			//    FixedVariablePointer fixVar = new FixedVariablePointer();
			//    fixVar.ID = id;
			//    if ((op1 == null) || (op1.IsConstant))
			//        fixVar.Index1 = eEv.GetInteger(op1);
			//    else
			//        fixVar.Index1 = 0;

			//    fixVar.Index2 = eEv.GetInteger(op2);
			//    if (!VariableEvaluator.CheckConstElement(fixVar))
			//    {
			//        throw new CodeEE("配列\"" + id.ToString() + "\"の境界外を参照しています");
			//    }
			//}
			VariableToken varToken = new VariableToken(id, op1, op2, op3);
			return varToken;
		}
		public static string ErrorMes = null;
		public static void ResetError()
		{
			ErrorMes = null;
		}

	}
}
