using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Windows.Forms;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera.GameData.Variable
{
	/// <summary>
	/// 変数全部
	/// </summary>
	internal sealed class VariableData : IDisposable
	{

		readonly Int64[] dataInteger;
		readonly string[] dataString;
		readonly Int64[][] dataIntegerArray;
		readonly string[][] dataStringArray;
		readonly Int64[][,] dataIntegerArray2D;
		readonly string[][,] dataStringArray2D;
        readonly Int64[][,,] dataIntegerArray3D;
        readonly string[][,,] dataStringArray3D;
        readonly VariableLocal<Int64> localVars;
		readonly VariableLocal<string> localString;
		readonly VariableLocal<Int64> argVars;
		readonly VariableLocal<string> argString;
        public Int64[] DataInteger { get { return dataInteger; } }
		public string[] DataString { get { return dataString; } }
		public Int64[][] DataIntegerArray { get { return dataIntegerArray; } }
		public string[][] DataStringArray { get { return dataStringArray; } }
		public Int64[][,] DataIntegerArray2D { get { return dataIntegerArray2D; } }
		public string[][,] DataStringArray2D { get { return dataStringArray2D; } }
        public Int64[][,,] DataIntegerArray3D { get { return dataIntegerArray3D;} }
        public string[][,,] DataStringArray3D { get { return dataStringArray3D; } }
        public VariableLocal<Int64> LocalVars { get { return localVars; } }
		public VariableLocal<string> LocalString { get { return localString; } }
		public VariableLocal<Int64> ArgVars { get { return argVars; } }
		public VariableLocal<string> ArgString { get { return argString; } }

		public Int64 LastLoadVersion = -1;
		public Int64 LastLoadNo = -1;
		public string LastLoadText = "";

		public VariableData(GameBase gamebase, ConstantData constant)
		{

			localVars = new VariableLocal<Int64>(constant.VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.LOCAL)]);
			localString = new VariableLocal<string>(constant.VariableStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.LOCALS)]);
			argVars = new VariableLocal<Int64>(constant.VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ARG)]);
			argString = new VariableLocal<string>(constant.VariableStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ARGS)]);
			dataInteger = new Int64[(int)VariableCode.__COUNT_INTEGER__];

			dataIntegerArray = new Int64[(int)VariableCode.__COUNT_INTEGER_ARRAY__][];
			for (int i = 0; i < dataIntegerArray.Length; i++)
				dataIntegerArray[i] = new Int64[constant.VariableIntArrayLength[i]];

			dataString = new string[(int)VariableCode.__COUNT_STRING__];

			dataStringArray = new string[(int)VariableCode.__COUNT_STRING_ARRAY__][];

			for (int i = 0; i < dataStringArray.Length; i++)
				dataStringArray[i] = new string[constant.VariableStrArrayLength[i]];


			dataIntegerArray2D = new Int64[(int)VariableCode.__COUNT_INTEGER_ARRAY_2D__][,];
			for (int i = 0; i < dataIntegerArray2D.Length; i++)
			{
				Int64 length64 = constant.VariableIntArray2DLength[i];
				int length = (int)(length64 >> 32);
				int length2 = (int)(length64 & 0x7FFFFFFF);
				dataIntegerArray2D[i] = new Int64[length, length2];
			}
			dataStringArray2D = new string[(int)VariableCode.__COUNT_STRING_ARRAY_2D__][,];
			for (int i = 0; i < dataStringArray2D.Length; i++)
			{
				Int64 length64 = constant.VariableStrArray2DLength[i];
				int length = (int)(length64 >> 32);
				int length2 = (int)(length64 & 0x7FFFFFFF);
				dataStringArray2D[i] = new string[length, length2];
			}
            dataIntegerArray3D = new Int64[(int)VariableCode.__COUNT_INTEGER_ARRAY_3D__][,,];
            for (int i = 0; i < dataIntegerArray3D.Length; i++)
            {
                Int64 length64 = constant.VariableIntArray3DLength[i];
                int length = (int)(length64 >> 32);
                int length2 = (int)((length64 >> 16) & 0xFFFF);
                int length3 = (int)(length64 & 0xFFFF);
                dataIntegerArray3D[i] = new Int64[length, length2, length3];
            }
            dataStringArray3D = new string[(int)VariableCode.__COUNT_STRING_ARRAY_3D__][, ,];
            for (int i = 0; i < dataStringArray3D.Length; i++)
            {
                Int64 length64 = constant.VariableStrArray3DLength[i];
                int length = (int)(length64 >> 32);
                int length2 = (int)((length64 >> 16) & 0xFFFF);
                int length3 = (int)(length64 & 0xFFFF);
                dataStringArray3D[i] = new string[length, length2, length3];
            }
            SetDefalutValue(constant);
		}

		public void SetDefalutGlobalValue()
		{

			Int64[] globalInt = dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.GLOBAL];
			string[] globalStr = dataStringArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.GLOBALS];
			for (int i = 0; i < globalInt.Length; i++)
				globalInt[i] = 0;
			for (int i = 0; i < globalStr.Length; i++)
				globalStr[i] = null;
		}

		public void SetDefalutLocalValue()
		{
			localVars.Clear();
			localString.Clear();
			argVars.Clear();
			argString.Clear();
		}

		/// <summary>
		/// ローカルとグローバル以外初期化
		/// </summary>
		public void SetDefalutValue(ConstantData constant)
		{

			for(int i = 0;i<dataInteger.Length;i++)
				dataInteger[i] = 0;

			for (int i = 0; i < dataIntegerArray.Length; i++)
			{
				switch (i)
				{
					case (int)(VariableCode.__LOWERCASE__ & VariableCode.GLOBAL):
						break;
					case (int)(VariableCode.__LOWERCASE__ & VariableCode.ITEMPRICE):
						constant.ItemPrice.CopyTo(dataIntegerArray[i], 0);
						break;
					default:
					for (int j = 0; j < dataIntegerArray[i].Length; j++)
						dataIntegerArray[i][j] = 0;
					break;
				}
			}

			for (int i = 0; i < dataString.Length; i++)
				dataString[i] = null;

			for (int i = 0; i < dataStringArray.Length; i++)
			{
				switch (i)
				{
					case (int)(VariableCode.__LOWERCASE__ & VariableCode.GLOBALS):
						break;
					case (int)(VariableCode.__LOWERCASE__ & VariableCode.STR):
						constant.Str.CopyTo(dataStringArray[i], 0);
						break;
					default:
						for (int j = 0; j < dataStringArray[i].Length; j++)
							dataStringArray[i][j] = null;
						break;
				}
			}
			for (int i = 0; i < dataIntegerArray2D.Length; i++)
			{
				Int64[,] array2D = dataIntegerArray2D[i];
				for (int x = 0; x < array2D.GetLength(0); x++)
					for (int y = 0; y < array2D.GetLength(1); y++)
						array2D[x, y] = 0;
			}
			for (int i = 0; i < dataStringArray2D.Length; i++)
			{
				string[,] array2D = dataStringArray2D[i];
				for (int x = 0; x < array2D.GetLength(0); x++)
					for (int y = 0; y < array2D.GetLength(1); y++)
						array2D[x, y] = null;
			}
            for (int i = 0; i < dataIntegerArray3D.Length; i++)
            {
                Int64[,,] array3D = dataIntegerArray3D[i];
                for (int x = 0; x < array3D.GetLength(0); x++)
                    for (int y = 0; y < array3D.GetLength(1); y++)
                        for (int z = 0; z < array3D.GetLength(2); z++)
                            array3D[x, y, z] = 0;
            }
            for (int i = 0; i < dataStringArray3D.Length; i++)
            {
                string[, ,] array3D = dataStringArray3D[i];
                for (int x = 0; x < array3D.GetLength(0); x++)
                    for (int y = 0; y < array3D.GetLength(1); y++)
                        for (int z = 0; z < array3D.GetLength(2); z++)
                            array3D[x, y, z] = null;
            }

            Int64[] palamlv = dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.PALAMLV];
            Config.Instance.PalamLvDef.CopyTo(0, palamlv, 0, Math.Min(palamlv.Length, Config.Instance.PalamLvDef.Count));
            //palamlv[0] = 0;
            //palamlv[1] = 100;
            //palamlv[2] = 500;
            //palamlv[3] = 3000;
            //palamlv[4] = 10000;
            //palamlv[5] = 30000;
            //palamlv[6] = 60000;
            //palamlv[7] = 100000;
            //palamlv[8] = 150000;
            //palamlv[9] = 250000;

			Int64[] explv = dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.EXPLV];
            Config.Instance.ExpLvDef.CopyTo(0, explv, 0, Math.Min(explv.Length, Config.Instance.ExpLvDef.Count));
            //explv[0] = 0;
            //explv[1] = 1;
            //explv[2] = 4;
            //explv[3] = 20;
            //explv[4] = 50;
            //explv[5] = 200;

			//dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.ASSIPLAY][0] = 0;
			//dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.MASTER][0] = 0;
			dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.ASSI][0] = -1;
			dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.TARGET][0] = 1;
			dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.PBAND][0] = Config.Instance.PbandDef;
			dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.EJAC][0] = 10000;

			LastLoadVersion = -1;
			LastLoadNo = -1;
			LastLoadText = "";
		}


		const int strCount = (int)VariableCode.__COUNT_SAVE_STRING__;
		const int intCount = (int)VariableCode.__COUNT_SAVE_INTEGER__;
		const int intArrayCount = (int)VariableCode.__COUNT_SAVE_INTEGER_ARRAY__;
		const int strArrayCount = (int)VariableCode.__COUNT_SAVE_STRING_ARRAY__;
		public void SaveToStream(EraDataWriter writer)
		{

			for (int i = 0; i < strCount; i++)
				writer.Write(dataString[i]);
			for (int i = 0; i < intCount; i++)
				writer.Write(dataInteger[i]);
			for (int i = 0; i < intArrayCount; i++)
				writer.Write(dataIntegerArray[i]);
			for (int i = 0; i < strArrayCount; i++)
				writer.Write(dataStringArray[i]);
		}

		public void LoadFromStream(EraDataReader reader)
		{

			for (int i = 0; i < strCount; i++)
				dataString[i] = reader.ReadString();
			for (int i = 0; i < intCount; i++)
				dataInteger[i] = reader.ReadInt64();
			for (int i = 0; i < intArrayCount; i++)
				reader.ReadInt64Array(dataIntegerArray[i]);
			for (int i = 0; i < strArrayCount; i++)
				reader.ReadStringArray(dataStringArray[i]);
		}
		public void SaveToStreamExtended(EraDataWriter writer)
		{
            List<VariableCode> codeList = null;
			
			//dataString
			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__STRING__);
			foreach (VariableCode code in codeList)
				writer.WriteExtended(code.ToString(), dataString[(int)VariableCode.__LOWERCASE__ & (int)code]);
			writer.EmuSeparete();

			//datainteger
			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__INTEGER__);
			foreach (VariableCode code in codeList)
				writer.WriteExtended(code.ToString(), dataInteger[(int)VariableCode.__LOWERCASE__ & (int)code]);
			writer.EmuSeparete();

			//dataStringArray
			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__ARRAY_1D__ | VariableCode.__STRING__);
			foreach (VariableCode code in codeList)
				writer.WriteExtended(code.ToString(), dataStringArray[(int)VariableCode.__LOWERCASE__ & (int)code]);
			writer.EmuSeparete();

			//dataIntegerArray
			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__ARRAY_1D__ | VariableCode.__INTEGER__);
			foreach (VariableCode code in codeList)
				writer.WriteExtended(code.ToString(), dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)code]);
			writer.EmuSeparete();

            //dataStringArray2D
			//StringArray2Dの保存は未実装
			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__ARRAY_2D__ | VariableCode.__STRING__);
			foreach (VariableCode code in codeList)
				writer.WriteExtended(code.ToString(), dataStringArray2D[(int)VariableCode.__LOWERCASE__ & (int)code]);
			writer.EmuSeparete();

			//dataIntegerArray2D
			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__ARRAY_2D__ | VariableCode.__INTEGER__);
			foreach (VariableCode code in codeList)
				writer.WriteExtended(code.ToString(), dataIntegerArray2D[(int)VariableCode.__LOWERCASE__ & (int)code]);
			writer.EmuSeparete();

            //dataStringArray3D
            //StringArray3Dの保存は未実装
            codeList = VariableIdentifier.GetExtSaveList(VariableCode.__ARRAY_3D__ | VariableCode.__STRING__);
            foreach (VariableCode code in codeList)
                writer.WriteExtended(code.ToString(), dataStringArray3D[(int)VariableCode.__LOWERCASE__ & (int)code]);
            writer.EmuSeparete();

            //dataIntegerArray3D
            codeList = VariableIdentifier.GetExtSaveList(VariableCode.__ARRAY_3D__ | VariableCode.__INTEGER__);
            foreach (VariableCode code in codeList)
                writer.WriteExtended(code.ToString(), dataIntegerArray3D[(int)VariableCode.__LOWERCASE__ & (int)code]);
            writer.EmuSeparete();
        }


		public void LoadFromStreamExtended(EraDataReader reader)
		{
			Dictionary<string, string> strDic = reader.ReadStringExtended();
			Dictionary<string, Int64> intDic = reader.ReadInt64Extended();
			Dictionary<string, List<string>> strListDic = reader.ReadStringArrayExtended();
			Dictionary<string, List<Int64>> intListDic = reader.ReadInt64ArrayExtended();
			Dictionary<string, List<string[]>> str2DListDic = reader.ReadStringArray2DExtended();
			Dictionary<string, List<Int64[]>> int2DListDic = reader.ReadInt64Array2DExtended();
            Dictionary<string, List<List<string[]>>> str3DListDic = reader.ReadStringArray3DExtended();
            Dictionary<string, List<List<Int64[]>>> int3DListDic = reader.ReadInt64Array3DExtended();
            List<VariableCode> codeList = null;

			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__STRING__);
			foreach (VariableCode code in codeList)
				if (strDic.ContainsKey(code.ToString()))
					dataString[(int)VariableCode.__LOWERCASE__ & (int)code] = strDic[code.ToString()];

			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__INTEGER__);
			foreach (VariableCode code in codeList)
				if (intDic.ContainsKey(code.ToString()))
					dataInteger[(int)VariableCode.__LOWERCASE__ & (int)code] = intDic[code.ToString()];


			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__ARRAY_1D__ | VariableCode.__STRING__);
			foreach (VariableCode code in codeList)
				if (strListDic.ContainsKey(code.ToString()))
					copyListToArray(strListDic[code.ToString()], dataStringArray[(int)VariableCode.__LOWERCASE__ & (int)code]);

			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__ARRAY_1D__ | VariableCode.__INTEGER__);
			foreach (VariableCode code in codeList)
				if (intListDic.ContainsKey(code.ToString()))
					copyListToArray(intListDic[code.ToString()], dataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)code]);

			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__ARRAY_2D__ | VariableCode.__STRING__);
			foreach (VariableCode code in codeList)
				if (str2DListDic.ContainsKey(code.ToString()))
					copyListToArray2D(str2DListDic[code.ToString()], dataStringArray2D[(int)VariableCode.__LOWERCASE__ & (int)code]);

			codeList = VariableIdentifier.GetExtSaveList(VariableCode.__ARRAY_2D__ | VariableCode.__INTEGER__);
			foreach (VariableCode code in codeList)
				if (int2DListDic.ContainsKey(code.ToString()))
					copyListToArray2D(int2DListDic[code.ToString()], dataIntegerArray2D[(int)VariableCode.__LOWERCASE__ & (int)code]);

            codeList = VariableIdentifier.GetExtSaveList(VariableCode.__ARRAY_3D__ | VariableCode.__STRING__);
            foreach (VariableCode code in codeList)
                if (str3DListDic.ContainsKey(code.ToString()))
                    copyListToArray3D(str3DListDic[code.ToString()], dataStringArray3D[(int)VariableCode.__LOWERCASE__ & (int)code]);

            codeList = VariableIdentifier.GetExtSaveList(VariableCode.__ARRAY_3D__ | VariableCode.__INTEGER__);
            foreach (VariableCode code in codeList)
                if (int3DListDic.ContainsKey(code.ToString()))
                    copyListToArray3D(int3DListDic[code.ToString()], dataIntegerArray3D[(int)VariableCode.__LOWERCASE__ & (int)code]);
        }

		private void copyListToArray<T>(List<T> srcList, T[] destArray)
		{
			int count = Math.Min(srcList.Count, destArray.Length);
			for (int i = 0; i < count; i++)
			{
				destArray[i] = srcList[i];
			}
		}
		private void copyListToArray2D<T>(List<T[]> srcList, T[,] destArray)
		{
			int countX = Math.Min(srcList.Count, destArray.GetLength(0));
			for (int x = 0; x < countX; x++)
			{
				T[] srcArray = srcList[x];
				int countY = Math.Min(srcArray.Length, destArray.GetLength(1));
				for (int y = 0; y < countY; y++)
				{
					destArray[x,y] = srcArray[y];
				}
			}
		}
        private void copyListToArray3D<T>(List<List<T[]>> srcList, T[,,] destArray)
        {
            int countX = Math.Min(srcList.Count, destArray.GetLength(0));
            for (int x = 0; x < countX; x++)
            {
                List<T[]> srcArray = srcList[x];
                int countY = Math.Min(srcArray.Count, destArray.GetLength(1));
                for (int y = 0; y < countY; y++)
                {
                    T[] baseArray = srcArray[y];
                    int countZ = Math.Min(baseArray.Length, destArray.GetLength(2));
                    for (int z = 0; z < countZ; z++)
                    {
                        destArray[x, y, z] = baseArray[z];
                    }
                }
            }
        }


		public void SaveGlobalToStream(EraDataWriter writer)
		{
			writer.Write(dataIntegerArray[(int)(VariableCode.__LOWERCASE__ & VariableCode.GLOBAL)]);
			writer.Write(dataStringArray[(int)(VariableCode.__LOWERCASE__ & VariableCode.GLOBALS)]);
		}

		public void LoadGlobalFromStream(EraDataReader reader)
		{
			reader.ReadInt64Array(dataIntegerArray[(int)(VariableCode.__LOWERCASE__ & VariableCode.GLOBAL)]);
			reader.ReadStringArray(dataStringArray[(int)(VariableCode.__LOWERCASE__ & VariableCode.GLOBALS)]);
		}

		#region IDisposable メンバ

		public void Dispose()
		{
			for (int i = 0; i < dataIntegerArray.Length; i++)
				dataIntegerArray[i] = null;
			for (int i = 0; i < dataStringArray.Length; i++)
				dataStringArray[i] = null;

		}

		#endregion

	}
}