using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.GameData.Expression;

namespace MinorShift.Emuera.GameData.Function
{
	internal abstract class FunctionMethod
	{
		public Type ReturnType { get; protected set; }
		protected Type[] argumentTypeArray;

		//引数の数・型が一致するかどうかのテスト
		//正しくない場合はエラーメッセージを返す。
		//引数の数が不定である場合や引数の省略を許す場合にはoverrideすること。
		public virtual string CheckArgumentType(string name, IOperandTerm[] arguments)
		{
			if (arguments.Length != argumentTypeArray.Length)
				return name + "関数の引数の数が正しくありません";
			for (int i = 0; i < argumentTypeArray.Length; i++)
			{
				if (arguments[i] == null)
					return name + "関数の" + (i + 1).ToString() + "番目の引数は省略できません";
				if (argumentTypeArray[i] != arguments[i].GetOperandType())
					return name + "関数の" +(i+1).ToString()+ "番目の引数の型が正しくありません";
			}
			return null;
		}

		//実際の計算。
		public abstract SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments);

	}
}
