using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera.GameData.Expression
{

    internal sealed class NullTerm : IOperandTerm
    {
        public NullTerm(Int64 i)
        {
            type = typeof(Int64);
        }
        readonly Type type;

        public NullTerm(string s)
        {
            type = typeof(string);
        }
    
        #region IOperandTerm メンバ
        public bool IsConstant { get { return true; } }
        public Type GetOperandType() { return type; }
        #endregion

    }

	/// <summary>
	/// 項。一単語だけ。
	/// </summary>
	internal sealed class SingleTerm : IOperandTerm
	{
		public SingleTerm(Int64 i, int fBase)
		{
			type = typeof(Int64);
			iValue = i;
			fromBase = fBase;

		}

		public SingleTerm(bool i)
		{
			type = typeof(Int64);
			if (i)
				iValue = 1;
			else
				iValue = 0;
		}
		public SingleTerm(Int64 i)
		{
			type = typeof(Int64);
			iValue = i;
		}
		public SingleTerm(string s)
		{
			type = typeof(string);
			sValue = s;
		}
		readonly Type type;
		readonly int fromBase = 10;
		readonly Int64 iValue;
		string sValue;

		public string Str
		{
			get
			{
				if (type != typeof(string))
					throw new ExeEE("項の種別が異常");
				return sValue;
			}
		}

		public Int64 Int
		{
			get
			{
				if (type != typeof(Int64))
					throw new ExeEE("項の種別が異常");
				return iValue;
			}
		}
		public override string ToString()
		{
			if (type == typeof(Int64))
				return iValue.ToString();
			if (type == typeof(string))
				return sValue.ToString();
			return base.ToString();
		}

		#region IOperandTerm メンバ
		public bool IsConstant { get { return true; } }
		public Type GetOperandType() { return type; }
		#endregion


	}
	
	/// <summary>
	/// 項。一単語だけ。
	/// </summary>
	internal sealed class StringFormTerm : IOperandTerm
	{
		public StringFormTerm(StringForm sf)
		{
			sfValue = sf;
		}
		readonly StringForm sfValue;

		public StringForm StrForm
		{
			get
			{
				return sfValue;
			}
		}

		#region IOperandTerm メンバ

		public bool IsConstant
		{
			get { return false; }
		}

		public Type GetOperandType()
		{
			return typeof(string);
		}

		public int KiriScriptPriority
		{
			get { throw new NotImplementedException(); }
		}

		#endregion

		#region IDeparse メンバ

		public string ToKiriScript()
		{
			throw new NotImplementedException();
		}

		public string ToErbScript()
		{
			throw new NotImplementedException();
		}

		#endregion
	}

    internal sealed class TernaryExpressionTerm : IOperandTerm
    {
        public TernaryExpressionTerm(IOperandTerm leftOp, IOperandTerm rightOp1, IOperandTerm rightOp2, OperatorCode opCode, TernaryMethod method)
        {
            Left = leftOp;
            Right1 = rightOp1;
            Right2 = rightOp2;
            Operator = opCode;
            Method = method;
            type = OperatorMethod.GetReturnType(Left.GetOperandType(), Right1.GetOperandType(), Right2.GetOperandType(), Operator);
            isConstant = Left.IsConstant && Right1.IsConstant && Right2.IsConstant;
        }
        readonly public IOperandTerm Left;
        readonly public IOperandTerm Right1;
        readonly public IOperandTerm Right2;
        readonly public OperatorCode Operator;
        readonly public TernaryMethod Method;
        readonly Type type;
        readonly bool isConstant;

        #region IOperandTerm メンバ

        public bool IsConstant
        {
            get { return isConstant; }
        }

        public Type GetOperandType()
        {
            return type;
        }

        #endregion

    }

	internal sealed class BinaryExpressionTerm : IOperandTerm
	{
		public BinaryExpressionTerm(IOperandTerm leftOp, IOperandTerm rightOp, OperatorCode opCode, BinaryMethod method)
		{
			Left = leftOp;
			Right = rightOp;
			Operator = opCode;
			Method = method;
			type = OperatorMethod.GetReturnType(Left.GetOperandType(), Right.GetOperandType(), Operator);
			isConstant = Left.IsConstant && Right.IsConstant;
		}
		readonly public IOperandTerm Left;
		readonly public IOperandTerm Right;
		readonly public OperatorCode Operator;
		readonly public BinaryMethod Method;
		readonly Type type;
		readonly bool isConstant;

		#region IOperandTerm メンバ

		public bool IsConstant
		{
			get { return isConstant; }
		}

		public Type GetOperandType()
		{
			return type;
		}

		#endregion


	}

	internal sealed class UnaryExpressionTerm : IOperandTerm
	{
		public UnaryExpressionTerm(IOperandTerm operandTerm, OperatorCode opCode, UnaryMethod method)
		{
			Operand = operandTerm;
			Operator = opCode;
			Method = method;
			type = OperatorMethod.GetReturnType(Operand.GetOperandType(), Operator);
		}
		readonly public IOperandTerm Operand;
		readonly public OperatorCode Operator;
		readonly public UnaryMethod Method;
		readonly Type type;

		#region IOperandTerm メンバ


		public bool IsConstant
		{
			get { return Operand.IsConstant; }
		}

		public Type GetOperandType()
		{
			return type;
		}

		#endregion

	}

    internal sealed class UnaryAfterExpressionTerm : IOperandTerm
    {
        public UnaryAfterExpressionTerm(IOperandTerm operandTerm, OperatorCode opCode, UnaryAfterMethod method)
        {
            Operand = operandTerm;
            Operator = opCode;
            Method = method;
            type = OperatorMethod.GetReturnType(Operand.GetOperandType(), Operator);
        }
        readonly public IOperandTerm Operand;
        readonly public OperatorCode Operator;
        readonly public UnaryAfterMethod Method;
        readonly Type type;

        #region IOperandTerm メンバ


        public bool IsConstant
        {
            get { return Operand.IsConstant; }
        }

        public Type GetOperandType()
        {
            return type;
        }

        #endregion

    }

}
