using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData.Variable;
using MinorShift.Emuera.GameData.Function;
using MinorShift.Emuera.GameProc;

namespace MinorShift.Emuera.GameData.Expression
{
	internal sealed class ExpressionEvaluator
	{
		public ExpressionEvaluator(VariableEvaluator vev)
		{
			VEvaluator = vev;
		}
		public readonly VariableEvaluator VEvaluator;
		
		public FixedVariablePointer GetFixedVariable(VariableToken token)
		{
			FixedVariablePointer p = new FixedVariablePointer();
			p.ID = token.Identifier;
			SingleTerm s1 = GetValue(token.Element1);
			SingleTerm s2 = GetValue(token.Element2);
            SingleTerm s3 = GetValue(token.Element3);
			if (s1 == null)
				return p;
			if (s1.GetOperandType() == typeof(Int64))
				p.Index1 = s1.Int;
			else
				p.Index1 = VEvaluator.Constant.KeywordToInteger(token.Identifier.Code, s1.Str);
			if (s2 == null)
				return p;
			if (s2.GetOperandType() == typeof(Int64))
				p.Index2 = s2.Int;
			else
				p.Index2 = VEvaluator.Constant.KeywordToInteger(token.Identifier.Code, s2.Str);
            if (s3 == null)
                return p;
            if (s3.GetOperandType() == typeof(Int64))
                p.Index3 = s3.Int;
            else
                p.Index3 = VEvaluator.Constant.KeywordToInteger(token.Identifier.Code, s3.Str);
			return p;
		}

		public Int64 GetInteger(IOperandTerm term)
		{
			SingleTerm sTerm = GetValue(term);
			if (sTerm == null)
				return 0;
			if (sTerm.GetOperandType() != typeof(Int64))
				throw new ExeEE("型が違う");
			return sTerm.Int;
		}

		public string GetString(IOperandTerm term)
		{
			SingleTerm sTerm = GetValue(term);
			if (sTerm == null)
				return null;
			if (sTerm.GetOperandType() != typeof(string))
				throw new ExeEE("型が違う");
			return sTerm.Str;
		}

		public SingleTerm GetValue(IOperandTerm term)
		{
			if (term == null)
				return null;
			if (term is SingleTerm)
			{
				return (SingleTerm)term;
			}
			else if (term is StringFormTerm)
			{
				return new SingleTerm(((StringFormTerm)term).StrForm.GetString(this));
			}
			else if (term is VariableToken)
			{
				VariableToken varTerm = (VariableToken)term;
				if (varTerm.IsInteger)
					return new SingleTerm(VEvaluator.GetInteger(this.GetFixedVariable(varTerm)));
				else
					return new SingleTerm(VEvaluator.GetString(this.GetFixedVariable(varTerm)));
			}
			else if (term is UnaryExpressionTerm)
			{
				UnaryExpressionTerm ueTerm = (UnaryExpressionTerm)term;
                if ((ueTerm.Operator == OperatorCode.Increment) || ueTerm.Operator == OperatorCode.Decrement)
                {
                    FixedVariablePointer p = GetFixedVariable((VariableToken)ueTerm.Operand);
                    if (ueTerm.Operator == OperatorCode.Increment)
                        VEvaluator.SetValue(p, GetInteger(ueTerm.Operand) + 1);
                    else
                        VEvaluator.SetValue(p, GetInteger(ueTerm.Operand) - 1);
                }
                SingleTerm ueret = ueTerm.Method(ueTerm.Operand, GetValue);
                return ueret;
			}
            else if (term is UnaryAfterExpressionTerm)
            {
                UnaryAfterExpressionTerm uaeTerm = (UnaryAfterExpressionTerm)term;
                SingleTerm uaeret = uaeTerm.Method(uaeTerm.Operand, GetValue);
                FixedVariablePointer p = GetFixedVariable((VariableToken)uaeTerm.Operand);
                if (uaeTerm.Operator == OperatorCode.Increment)
                    VEvaluator.SetValue(p, GetInteger(uaeTerm.Operand) + 1);
                else
                    VEvaluator.SetValue(p, GetInteger(uaeTerm.Operand) - 1);
                return uaeret;
            }
            else if (term is BinaryExpressionTerm)
            {
                BinaryExpressionTerm beTerm = (BinaryExpressionTerm)term;
                return beTerm.Method(beTerm.Left, beTerm.Right, GetValue);
            }
            else if (term is TernaryExpressionTerm)
            {
                TernaryExpressionTerm teTerm = (TernaryExpressionTerm)term;
                return teTerm.Method(teTerm.Left, teTerm.Right1, teTerm.Right2, GetValue);
            }
            else if (term is FunctionMethodTerm)
            {
                FunctionMethodTerm mTerm = (FunctionMethodTerm)term;
                return mTerm.GetValue(this);
            }
            else if (term is UserDefinedMethodTerm)
            {
                UserDefinedMethodTerm umTerm = (UserDefinedMethodTerm)term;
                SingleTerm ret = Process.Instance.GetValue(umTerm.Funcname, umTerm.Arguments);
                if (ret == null)
                {
                    if (umTerm.GetOperandType() == typeof(Int64))
                        return new SingleTerm(0);
                    else
                        return new SingleTerm("");
                }
                return ret;
            }
			throw new ExeEE("変なオペランド");
		}


		//1753 廃止 無駄が多すぎた
		//public bool GetCase(CaseExpression caseExp, SingleTerm Is)
		//{
		//    if (caseExp.CaseType == CaseExpressionType.To)
		//    {
		//        return ((OperatorMethod.GetBinaryMethod(OperatorCode.GreaterEqual))(Is, caseExp.LeftTerm, GetValue).Int != 0)
		//            && ((OperatorMethod.GetBinaryMethod(OperatorCode.LessEqual))(Is, caseExp.RightTerm, GetValue).Int != 0);
		//    }
		//    OperatorCode op = OperatorCode.Equal;
		//    if (caseExp.CaseType == CaseExpressionType.Is)
		//        op = caseExp.Operator;
		//    return ((OperatorMethod.GetBinaryMethod(op))(Is, caseExp.LeftTerm, GetValue).Int != 0);
		//}


		public bool GetCase(CaseExpression caseExp, Int64 Is)
		{
			if (caseExp.CaseType == CaseExpressionType.To)
				return GetInteger(caseExp.LeftTerm) <= Is && Is <= GetInteger(caseExp.RightTerm);
			if (caseExp.CaseType == CaseExpressionType.Is)
				return ((OperatorMethod.GetBinaryMethod(caseExp.Operator))(new SingleTerm(Is), caseExp.LeftTerm, GetValue).Int != 0);
			return GetInteger(caseExp.LeftTerm) == Is;
		}
		public bool GetCase(CaseExpression caseExp, string Is)
		{
			if (caseExp.CaseType == CaseExpressionType.To)
			{
				return string.Compare(GetString(caseExp.LeftTerm), Is, StringComparison.CurrentCulture) <= 0
					&& string.Compare(Is, GetString(caseExp.RightTerm), StringComparison.CurrentCulture) <= 0;
			}
			if (caseExp.CaseType == CaseExpressionType.Is)
				return ((OperatorMethod.GetBinaryMethod(caseExp.Operator))(new SingleTerm(Is), caseExp.LeftTerm, GetValue).Int != 0);
			return GetString(caseExp.LeftTerm) == Is;
		}
	}
}
