﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameData.Variable;

namespace MinorShift.Emuera.GameProc
{
	//1.713 LogicalLine.csから分割
	/// <summary>
	/// ラベルのジャンプ先の辞書。Erbファイル読み込み時に作成
	/// </summary>
	internal sealed class LabelDictionary
	{
		Dictionary<string, List<FunctionLabelLine>> labelAtDic = new Dictionary<string, List<FunctionLabelLine>>();
		List<GotoLabelLine> labelDollarList = new List<GotoLabelLine>();
		int count;

		public int Count { get { return count; } }
		public bool IsOverride(FunctionLabelLine point)
		{
			string id = point.LabelName;
			if (!labelAtDic.ContainsKey(id))
				return false;
			switch (id)
			{
				case "EVENTTRAIN":
				case "EVENTFIRST":
				case "EVENTCOM":
				case "EVENTCOMEND":
				case "EVENTEND":
				case "EVENTSHOP":
				case "EVENTBUY":
				case "EVENTTURNEND":

				case "EVENTLOAD":
					return false;
			}
			List<FunctionLabelLine> labelList = labelAtDic[id];
			return labelList.Count > 1;
		}

		public void AddLabel(FunctionLabelLine point)
		{
			string id = point.LabelName;
			if (labelAtDic.ContainsKey(id))
			{
				labelAtDic[id].Add(point);
			}
			else
			{
				List<FunctionLabelLine> labelList = new List<FunctionLabelLine>();
				labelAtDic.Add(id, labelList);
				labelAtDic[id].Add(point);
			}
			point.Index = count;
			count++;
		}

		public bool AddLabelDollar(GotoLabelLine point)
		{
			string id = point.LabelName;
			foreach (GotoLabelLine label in labelDollarList)
			{
				if (label == point)
					return false;
			}
			labelDollarList.Add(point);
			return true;
		}

		public List<FunctionLabelLine> GetLabels(string key)
		{
			if (labelAtDic.ContainsKey(key))
				return labelAtDic[key];
			return new List<FunctionLabelLine>();
		}

		public FunctionLabelLine GetLabel(string key)
		{
			if (labelAtDic.ContainsKey(key))
				return labelAtDic[key][0];
			return null;
		}

		public List<FunctionLabelLine> GetAllLabels()
		{
			List<FunctionLabelLine> ret = new List<FunctionLabelLine>();
			foreach (List<FunctionLabelLine> list in labelAtDic.Values)
				ret.AddRange(list);
			return ret;
		}

		public GotoLabelLine GetLabelDollar(string key, FunctionLabelLine labelAtLine)
		{
			foreach (GotoLabelLine label in labelDollarList)
				if ((label.LabelName == key) && (label.ParentFunction == labelAtLine))
					return label;
			return null;
		}

        public void RemoveLabelWithPath(string path)
        {
            string fname;
            if (path.StartsWith(Program.ExeDir))
                fname = path.Substring(Program.ExeDir.Length + "erb\\".Length);
            else
                fname = path;
            List<FunctionLabelLine> labelLines;
            List<FunctionLabelLine> removeLine = new List<FunctionLabelLine>();
            List<string> removeKey = new List<string>();
            foreach (string key in labelAtDic.Keys)
            {
                labelLines = labelAtDic[key];
                foreach (FunctionLabelLine labelLine in labelLines)
                {
                    if (string.Equals(labelLine.Position.Filename, fname, StringComparison.CurrentCultureIgnoreCase))
                        removeLine.Add(labelLine);
                }
                foreach (FunctionLabelLine remove in removeLine)
                {
                    labelAtDic[key].Remove(remove);
                    if (labelAtDic[key].Count == 0)
                        removeKey.Add(key);
                }
            }
            foreach (string rKey in removeKey)
            {
                labelAtDic.Remove(rKey);
            }
        }

        public void checkLabelList(string path, List<string> fileList)
        {
            List<int> target = new List<int>();
            List<FunctionLabelLine> labelLines;
            List<FunctionLabelLine> new_Line = new List<FunctionLabelLine>();
            List<string> keyList = new List<string>();
            foreach (string key in labelAtDic.Keys)
            {
                keyList.Add(key);
            }
            foreach (string key in keyList)
            {
                labelLines = labelAtDic[key];
                if (labelLines.Count == 1)
                    continue;
                target.Clear();
                for (int i = 0; i < labelLines.Count; i++)
                {
                    target.Add(fileList.IndexOf(labelLines[i].Position.Filename));
                }
                labelAtDic[key] = new List<FunctionLabelLine>();
                for (int j = 0; j < fileList.Count; j++)
                {
                    for (int k = 0; k < labelLines.Count; k++)
                    {
                        if (j == target[k])
                        {
                            labelAtDic[key].Add(labelLines[k]);
                        }
                    }
                }
            }
        }
	}
}
