﻿using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameProc;
using MinorShift._Library;
using MinorShift.Emuera.GameData.Variable;
using System.Drawing;

namespace MinorShift.Emuera.GameData.Function
{

	internal static partial class FunctionMethodCreator
	{

		private sealed class GetcharaMethod : FunctionMethod 
		{
			public GetcharaMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = new Type[] { typeof(Int64) };
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				Int64 integer = eev.GetInteger(arguments[0]);
				return new SingleTerm(eev.VEvaluator.GetChara(integer, false));
			}
		}
		
		private sealed class GetspcharaMethod : FunctionMethod
		{
			public GetspcharaMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = new Type[] { typeof(Int64) };
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				Int64 integer = eev.GetInteger(arguments[0]);
				return new SingleTerm(eev.VEvaluator.GetChara(integer, true));
			}
		}
        
		private sealed class CsvnameMethod : FunctionMethod
		{
			public CsvnameMethod()
			{
				ReturnType = typeof(string);
				argumentTypeArray = new Type[] { typeof(Int64),typeof(Int64) };
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				long x = eev.GetInteger(arguments[0]);
				long y = eev.GetInteger(arguments[1]);
				return new SingleTerm( eev.VEvaluator.GetCharacterStrfromCSVData(x, CharacterStrData.NAME, (y != 0), 0));
			}
		}
		private sealed class CsvcallnameMethod : FunctionMethod
		{
			public CsvcallnameMethod()
			{
				ReturnType = typeof(string);
				argumentTypeArray = new Type[] { typeof(Int64),typeof(Int64) };
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				long x = eev.GetInteger(arguments[0]);
				long y = eev.GetInteger(arguments[1]);
                return new SingleTerm(eev.VEvaluator.GetCharacterStrfromCSVData(x, CharacterStrData.CALLNAME, (y != 0), 0));
			}
		}

        private sealed class CsvnicknameMethod : FunctionMethod
        {
            public CsvnicknameMethod()
            {
                ReturnType = typeof(string);
                argumentTypeArray = new Type[] { typeof(Int64), typeof(Int64) };
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                long x = eev.GetInteger(arguments[0]);
                long y = eev.GetInteger(arguments[1]);
                return new SingleTerm(eev.VEvaluator.GetCharacterStrfromCSVData(x, CharacterStrData.NICKNAME, (y != 0), 0));
            }
        }

        private sealed class CsvmasternameMethod : FunctionMethod
        {
            public CsvmasternameMethod()
            {
                ReturnType = typeof(string);
                argumentTypeArray = new Type[] { typeof(Int64), typeof(Int64) };
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                long x = eev.GetInteger(arguments[0]);
                long y = eev.GetInteger(arguments[1]);
                return new SingleTerm(eev.VEvaluator.GetCharacterStrfromCSVData(x, CharacterStrData.MASTERNAME, (y != 0), 0));
            }
        }

        private sealed class CsvcstrMethod : FunctionMethod
        {
            public CsvcstrMethod()
            {
                ReturnType = typeof(string);
                argumentTypeArray = new Type[] { typeof(Int64), typeof(Int64), typeof(Int64) };
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                long x = eev.GetInteger(arguments[0]);
                long y = eev.GetInteger(arguments[1]);
                long z = eev.GetInteger(arguments[2]);
                return new SingleTerm(eev.VEvaluator.GetCharacterStrfromCSVData(x, CharacterStrData.CSTR, (z != 0), y));
            }
        }

        private sealed class CsvbaseMethod : FunctionMethod
        {
            public CsvbaseMethod()
            {
                ReturnType = typeof(Int64);
                argumentTypeArray = new Type[] { typeof(Int64), typeof(Int64), typeof(Int64) };
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                long x = eev.GetInteger(arguments[0]);
                long y = eev.GetInteger(arguments[1]);
                long z = eev.GetInteger(arguments[2]);
                return new SingleTerm(eev.VEvaluator.GetCharacterIntfromCSVData(x, CharacterIntData.BASE, (z != 0), y));
            }
        }

        private sealed class CsvablMethod : FunctionMethod
        {
            public CsvablMethod()
            {
                ReturnType = typeof(Int64);
                argumentTypeArray = new Type[] { typeof(Int64), typeof(Int64), typeof(Int64) };
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                long x = eev.GetInteger(arguments[0]);
                long y = eev.GetInteger(arguments[1]);
                long z = eev.GetInteger(arguments[2]);
                return new SingleTerm(eev.VEvaluator.GetCharacterIntfromCSVData(x, CharacterIntData.ABL, (z != 0), y));
            }
        }

        private sealed class CsvmarkMethod : FunctionMethod
        {
            public CsvmarkMethod()
            {
                ReturnType = typeof(Int64);
                argumentTypeArray = new Type[] { typeof(Int64), typeof(Int64), typeof(Int64) };
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                long x = eev.GetInteger(arguments[0]);
                long y = eev.GetInteger(arguments[1]);
                long z = eev.GetInteger(arguments[2]);
                return new SingleTerm(eev.VEvaluator.GetCharacterIntfromCSVData(x, CharacterIntData.MARK, (z != 0), y));
            }
        }

        private sealed class CsvexpMethod : FunctionMethod
        {
            public CsvexpMethod()
            {
                ReturnType = typeof(Int64);
                argumentTypeArray = new Type[] { typeof(Int64), typeof(Int64), typeof(Int64) };
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                long x = eev.GetInteger(arguments[0]);
                long y = eev.GetInteger(arguments[1]);
                long z = eev.GetInteger(arguments[2]);
                return new SingleTerm(eev.VEvaluator.GetCharacterIntfromCSVData(x, CharacterIntData.EXP, (z != 0), y));
            }
        }

        private sealed class CsvrelationMethod : FunctionMethod
        {
            public CsvrelationMethod()
            {
                ReturnType = typeof(Int64);
                argumentTypeArray = new Type[] { typeof(Int64), typeof(Int64), typeof(Int64) };
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                long x = eev.GetInteger(arguments[0]);
                long y = eev.GetInteger(arguments[1]);
                long z = eev.GetInteger(arguments[2]);
                return new SingleTerm(eev.VEvaluator.GetCharacterIntfromCSVData(x, CharacterIntData.RELATION, (z != 0), y));
            }
        }

        private sealed class CsvtalentMethod : FunctionMethod
        {
            public CsvtalentMethod()
            {
                ReturnType = typeof(Int64);
                argumentTypeArray = new Type[] { typeof(Int64), typeof(Int64), typeof(Int64) };
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                long x = eev.GetInteger(arguments[0]);
                long y = eev.GetInteger(arguments[1]);
                long z = eev.GetInteger(arguments[2]);
                return new SingleTerm(eev.VEvaluator.GetCharacterIntfromCSVData(x, CharacterIntData.TALENT, (z != 0), y));
            }
        }

        private sealed class CsvcflagMethod : FunctionMethod
        {
            public CsvcflagMethod()
            {
                ReturnType = typeof(Int64);
                argumentTypeArray = new Type[] { typeof(Int64), typeof(Int64), typeof(Int64) };
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                long x = eev.GetInteger(arguments[0]);
                long y = eev.GetInteger(arguments[1]);
                long z = eev.GetInteger(arguments[2]);
                return new SingleTerm(eev.VEvaluator.GetCharacterIntfromCSVData(x, CharacterIntData.CFLAG, (z != 0), y));
            }
        }

        private sealed class CsvequipMethod : FunctionMethod
        {
            public CsvequipMethod()
            {
                ReturnType = typeof(Int64);
                argumentTypeArray = new Type[] { typeof(Int64), typeof(Int64), typeof(Int64) };
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                long x = eev.GetInteger(arguments[0]);
                long y = eev.GetInteger(arguments[1]);
                long z = eev.GetInteger(arguments[2]);
                return new SingleTerm(eev.VEvaluator.GetCharacterIntfromCSVData(x, CharacterIntData.EQUIP, (z != 0), y));
            }
        }

        private sealed class CsvjuelMethod : FunctionMethod
        {
            public CsvjuelMethod()
            {
                ReturnType = typeof(Int64);
                argumentTypeArray = new Type[] { typeof(Int64), typeof(Int64), typeof(Int64) };
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                long x = eev.GetInteger(arguments[0]);
                long y = eev.GetInteger(arguments[1]);
                long z = eev.GetInteger(arguments[2]);
                return new SingleTerm(eev.VEvaluator.GetCharacterIntfromCSVData(x, CharacterIntData.JUEL, (z != 0), y));
            }
        }

        private sealed class StrlenMethod : FunctionMethod
		{
			public StrlenMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = new Type[] { typeof(string) };
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				string str = eev.GetString(arguments[0]);
				return new SingleTerm(ShiftJisManager.GetStrlenShiftJis(str));
			}
		}

        private sealed class StrlenuMethod : FunctionMethod
        {
            public StrlenuMethod()
            {
                ReturnType = typeof(Int64);
                argumentTypeArray = new Type[] { typeof(string) };
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                string str = eev.GetString(arguments[0]);
                return new SingleTerm(str.Length);
            }
        }
        
        private sealed class SubstringMethod : FunctionMethod
		{
			public SubstringMethod()
			{
				ReturnType = typeof(string);
				argumentTypeArray = null;
			}

			public override string CheckArgumentType(string name, IOperandTerm[] arguments)
			{
				//通常３つ、２つ省略可能で１～３の引数が必要。
				if (arguments.Length < 1)
					return name + "関数には少なくとも1つの引数が必要です";
				if (arguments.Length > 3)
					return name + "関数の引数が多すぎます";

				if (arguments[0] == null)
					return name + "関数の1番目の引数は省略できません";
				if (arguments[0].GetOperandType() != typeof(string))
					return name + "関数の1番目の引数の型が正しくありません";
				//2、３は省略可能
				if ((arguments.Length >= 2) && (arguments[1] != null) && (arguments[1].GetOperandType() != typeof(Int64)))
					return name + "関数の2番目の引数の型が正しくありません";
				if ((arguments.Length >= 3) && (arguments[2] != null) && (arguments[2].GetOperandType() != typeof(Int64)))
					return name + "関数の3番目の引数の型が正しくありません";
				return null;
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				string str = eev.GetString(arguments[0]);
				int start = 0;
				int length = -1;
				if ((arguments.Length >= 2) && (arguments[1] != null))
					start = (int)eev.GetInteger(arguments[1]);
				if ((arguments.Length >= 3) && (arguments[2] != null))
					length = (int)eev.GetInteger(arguments[2]);

				return new SingleTerm(ShiftJisManager.GetSubStringShiftJis(str, start, length));
			}
		}

        private sealed class SubstringuMethod : FunctionMethod
        {
            public SubstringuMethod()
            {
                ReturnType = typeof(string);
                argumentTypeArray = null;
            }

            public override string CheckArgumentType(string name, IOperandTerm[] arguments)
            {
                //通常３つ、２つ省略可能で１～３の引数が必要。
                if (arguments.Length < 1)
                    return name + "関数には少なくとも1つの引数が必要です";
                if (arguments.Length > 3)
                    return name + "関数の引数が多すぎます";

                if (arguments[0] == null)
                    return name + "関数の1番目の引数は省略できません";
                if (arguments[0].GetOperandType() != typeof(string))
                    return name + "関数の1番目の引数の型が正しくありません";
                //2、３は省略可能
                if ((arguments.Length >= 2) && (arguments[1] != null) && (arguments[1].GetOperandType() != typeof(Int64)))
                    return name + "関数の2番目の引数の型が正しくありません";
                if ((arguments.Length >= 3) && (arguments[2] != null) && (arguments[2].GetOperandType() != typeof(Int64)))
                    return name + "関数の3番目の引数の型が正しくありません";
                return null;
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                string str = eev.GetString(arguments[0]);
                int start = 0;
                int length = -1;
                if ((arguments.Length >= 2) && (arguments[1] != null))
                    start = (int)eev.GetInteger(arguments[1]);
                if ((arguments.Length >= 3) && (arguments[2] != null))
                    length = (int)eev.GetInteger(arguments[2]);
                if ((start >= str.Length) || (length == 0))
                    return new SingleTerm("");
                if ((length < 0) || (length > str.Length))
                    length = str.Length;
                if (start <= 0)
                {
                    if (length == str.Length)
                        return new SingleTerm(str);
                    else
                        start = 0;
                }
                if ((start + length) > str.Length)
                    length = str.Length - start;

                return new SingleTerm(str.Substring(start, length));
            }
        }

		private sealed class StrfindMethod : FunctionMethod 
		{
			public StrfindMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = null;
			}
			public override string CheckArgumentType(string name, IOperandTerm[] arguments)
			{
				//通常３つ、１つ省略可能で２～３の引数が必要。
				if (arguments.Length < 2)
					return name + "関数には少なくとも2つの引数が必要です";
				if (arguments.Length > 3)
					return name + "関数の引数が多すぎます";
				if (arguments[0] == null)
					return name + "関数の1番目の引数は省略できません";
				if (arguments[0].GetOperandType() != typeof(string))
					return name + "関数の1番目の引数の型が正しくありません";
				if (arguments[1] == null)
					return name + "関数の2番目の引数は省略できません";
				if (arguments[1].GetOperandType() != typeof(string))
					return name + "関数の2番目の引数の型が正しくありません";
				//3つ目は省略可能
				if ((arguments.Length >= 3) && (arguments[2] != null) && (arguments[2].GetOperandType() != typeof(Int64)))
					return name + "関数の3番目の引数の型が正しくありません";
				return null;
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{

				string target = eev.GetString(arguments[0]);
				string word = eev.GetString(arguments[1]);
				int JISstart = 0;
				if ((arguments.Length >= 3) && (arguments[2] != null))
					JISstart = (int)eev.GetInteger(arguments[2]);
				int UFTstart = ShiftJisManager.GetUFTIndex(target, JISstart);
				if (UFTstart >= target.Length)
				{
					return new SingleTerm(-1);
				}
				int index = target.IndexOf(word, UFTstart);
				if (index > 0)
				{
					string subStr = target.Substring(0, index);
					index = ShiftJisManager.GetStrlenShiftJis(subStr);
				}
				return new SingleTerm(index);
			}
		}
		private sealed class VarsizeMethod : FunctionMethod
		{
			public VarsizeMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = new Type[] { typeof(string) };
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				VariableIdentifier varID = VariableIdentifier.GetVariableId(eev.GetString(arguments[0]));
				return new SingleTerm(eev.VEvaluator.GetVariableSize(varID));
			}

		}
		private sealed class GettimeMethod : FunctionMethod
		{
			public GettimeMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = new Type[] { };
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				long date = DateTime.Now.Year;
				date = date * 100 + DateTime.Now.Month;
				date = date * 100 + DateTime.Now.Day;
				date = date * 100 + DateTime.Now.Hour;
				date = date * 100 + DateTime.Now.Minute;
				date = date * 100 + DateTime.Now.Second;
				date = date * 1000 + DateTime.Now.Millisecond;
				return new SingleTerm(date);//17桁。2京くらい。
			}
		}
		private sealed class GettimesMethod : FunctionMethod
		{
			public GettimesMethod()
			{
				ReturnType = typeof(string);
				argumentTypeArray = new Type[] { };
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				return new SingleTerm(DateTime.Now.ToString());
			}
		}
		private sealed class GetmsMethod : FunctionMethod
		{
			public GetmsMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = new Type[] { };
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				//西暦0001年1月1日からの経過時間をミリ秒で。
				//Ticksは100ナノ秒単位であるが実際にはそんな精度はないので無駄。
				return new SingleTerm(DateTime.Now.Ticks / 10000);
			}
		}

		private sealed class CheckfontMethod : FunctionMethod
		{
			public CheckfontMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = new Type[] {typeof(string) };
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				string str = eev.GetString(arguments[0]);
				System.Drawing.Text.InstalledFontCollection ifc = new System.Drawing.Text.InstalledFontCollection();
				Int64 isInstalled = 0;
				foreach (System.Drawing.FontFamily ff in ifc.Families)
				{
					if (ff.Name == str)
					{
						isInstalled = 1;
						break;
					}
				}
				return new SingleTerm(isInstalled);
			}

		}
		private sealed class CheckdataMethod : FunctionMethod
		{
			public CheckdataMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = new Type[] {typeof(Int64) };
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				throw new NotImplementedException();
			}
		}
		
		private sealed class FindcharaMethod : FunctionMethod
		{
			public FindcharaMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = null;
			}
			public override string CheckArgumentType(string name, IOperandTerm[] arguments)
			{
				//通常3つ、1つ省略可能で2～3の引数が必要。
				if (arguments.Length < 2)
					return name + "関数には少なくとも2つの引数が必要です";
				if (arguments.Length > 3)
					return name + "関数の引数が多すぎます";

				if (arguments[0] == null)
					return name + "関数の1番目の引数は省略できません";
				if (!(arguments[0] is VariableToken))
					return name + "関数の1番目の引数の型が正しくありません";
				if (arguments[1] == null)
					return name + "関数の2番目の引数は省略できません";
				if (arguments[1].GetOperandType() != arguments[0].GetOperandType())
					return name + "関数の2番目の引数の型が正しくありません";
				//3番目は省略可能
				if ((arguments.Length >= 3) && (arguments[2] != null) && (arguments[2].GetOperandType() != typeof(Int64)))
					return name + "関数の3番目の引数の型が正しくありません";
				return null;
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				VariableToken vToken = (VariableToken)arguments[0];
				VariableIdentifier varID = vToken.Identifier;
				Int64 elem = 0;
				if (vToken.Element2 != null)
					elem = eev.GetInteger(vToken.Element2);
				Int64 startindex = 0;
				if(arguments.Length == 3)
					startindex = eev.GetInteger(arguments[2]);
				Int64 ret = -1;
				if (varID.IsString)
				{
					string word = eev.GetString(arguments[1]);
					ret = eev.VEvaluator.FindChara(varID, elem, word, startindex);
				}
				else
				{
					Int64 word = eev.GetInteger(arguments[1]);
					ret = eev.VEvaluator.FindChara(varID, elem, word, startindex);
				}
				return new SingleTerm(ret);
			}
		}

		private sealed class PowerMethod : FunctionMethod
		{
			public PowerMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = new Type[] {typeof(Int64),typeof(Int64) };
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				Int64 x = eev.GetInteger(arguments[0]);
				Int64 y = eev.GetInteger(arguments[1]);
				double pow = Math.Pow(x, y);
				if (double.IsNaN(pow))
					throw new CodeEE("累乗結果が非数値です");
				else if (double.IsInfinity(pow))
					throw new CodeEE("累乗結果が無限大です");
				else if ((pow >= Int64.MaxValue) || (pow <= Int64.MinValue))
					throw new CodeEE("累乗結果(" + pow.ToString() + ")が64ビット符号付き整数の範囲外です");
				return new SingleTerm((long)pow);
			}
		}

		private sealed class RandMethod : FunctionMethod
		{
			public RandMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = null;
			}

			public override string CheckArgumentType(string name, IOperandTerm[] arguments)
			{
				//通常2つ、1つ省略可能で1～2の引数が必要。
				if (arguments.Length < 1)
					return name + "関数には少なくとも1つの引数が必要です";
				if (arguments.Length > 2)
					return name + "関数の引数が多すぎます";
				if (arguments.Length == 1)
				{
					if (arguments[0] == null)
						return name + "関数には少なくとも1つの引数が必要です";
					if ((arguments[0].GetOperandType() != typeof(Int64)))
						return name + "関数の1番目の引数の型が正しくありません";
					return null;
				}
				//1番目は省略可能
				if ((arguments[0] != null) && (arguments[0].GetOperandType() != typeof(Int64)))
					return name + "関数の1番目の引数の型が正しくありません";
				if ((arguments[1] == null) || (arguments[1].GetOperandType() != typeof(Int64)))
					return name + "関数の2番目の引数の型が正しくありません";
				return null;
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				Int64 max = 0;
				Int64 min = 0;
				if (arguments.Length == 1)
					max = eev.GetInteger(arguments[0]);
				else
				{
					if(arguments[0] != null)
						min = eev.GetInteger(arguments[0]);
					max = eev.GetInteger(arguments[1]);
				}
				if(max <= min)
				{
					if(min == 0)
						throw new CodeEE("RANDの最大値に0以下の値(" + max.ToString() + ")が指定されました");
					else
						throw new CodeEE("RANDの最大値に最小値以下の値(" + max.ToString() + ")が指定されました");
				}
				return new SingleTerm(eev.VEvaluator.GetNextRand(max - min) + min);
			}
		}

		private sealed class SignMethod : FunctionMethod
		{

			public SignMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = new Type[] { typeof(Int64) };
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				Int64 ret = eev.GetInteger(arguments[0]);
				return new SingleTerm(Math.Sign(ret));
			}
		}

		private sealed class GetbitMethod : FunctionMethod
		{
			public GetbitMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = new Type[] { typeof(Int64),typeof(Int64)};
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				Int64 n = eev.GetInteger(arguments[0]);
				Int64 m = eev.GetInteger(arguments[1]);
				if ((m < 0) || (m > 63))
					throw new CodeEE("GETBIT関数の第２引数に範囲外の値(" + m.ToString() + ")が渡されました");
				int mi = (int)m;
				return new SingleTerm((n >> mi) & 1);
			}
		}

		private sealed class AbsMethod : FunctionMethod
		{
			public AbsMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = new Type[] { typeof(Int64) };
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				Int64 ret = eev.GetInteger(arguments[0]);
				return new SingleTerm(Math.Abs(ret));
			}
		}

		private sealed class SqrtMethod : FunctionMethod
		{
			public SqrtMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = new Type[] { typeof(Int64) };
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				Int64 ret = eev.GetInteger(arguments[0]);
				if (ret < 0)
					throw new CodeEE("SQRT関数の引数に負の値が指定されました");
				return new SingleTerm((Int64)Math.Sqrt(ret));
			}
		}

		private sealed class MaxMethod : FunctionMethod
		{
			public MaxMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = null;
			}

			public override string CheckArgumentType(string name, IOperandTerm[] arguments)
			{
				if (arguments.Length < 1)
					return name + "関数には少なくとも1つの引数が必要です";
				for (int i = 0; i < arguments.Length; i++)
				{
					if (arguments[i] == null)
						return name + "関数の" + (i + 1).ToString() + "番目の引数は省略できません";
					if (arguments[i].GetOperandType() != typeof(Int64))
						return name + "関数の" + (i + 1).ToString() + "番目の引数の型が正しくありません";
				}
				return null;
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				Int64 ret = eev.GetInteger(arguments[0]);

				for (int i = 1; i < arguments.Length; i++)
				{
					Int64 newRet = eev.GetInteger(arguments[i]);
					if (ret < newRet)
						ret = newRet;
				}
				return new SingleTerm(ret);
			}
		}

		private sealed class MinMethod : FunctionMethod
		{
			public MinMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = null;
			}

			public override string CheckArgumentType(string name, IOperandTerm[] arguments)
			{
				if (arguments.Length < 1)
					return name + "関数には少なくとも1つの引数が必要です";
				for (int i = 0; i < arguments.Length; i++)
				{
					if (arguments[i] == null)
						return name + "関数の" + (i + 1).ToString() + "番目の引数は省略できません";
					if (arguments[i].GetOperandType() != typeof(Int64))
						return name + "関数の" + (i + 1).ToString() + "番目の引数の型が正しくありません";
				}
				return null;
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				Int64 ret = eev.GetInteger(arguments[0]);

				for (int i = 1; i < arguments.Length; i++)
				{
					Int64 newRet = eev.GetInteger(arguments[i]);
					if (ret > newRet)
						ret = newRet;
				}
				return new SingleTerm(ret);
			}
		}

		private sealed class GetnumMethod : FunctionMethod
		{
			public GetnumMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = null;
			}
			public override string CheckArgumentType(string name, IOperandTerm[] arguments)
			{
				if (arguments.Length != 2)
					return name + "関数には2つの引数が必要です";
				if (arguments[0] == null)
					return name + "関数の1番目の引数は省略できません";
				if (!(arguments[0] is VariableToken))
					return name + "関数の1番目の引数の型が正しくありません";
				if (arguments[1] == null)
					return name + "関数の2番目の引数は省略できません";
				if (arguments[1].GetOperandType() != typeof(string))
					return name + "関数の2番目の引数の型が正しくありません";
				return null;
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				VariableToken vToken = (VariableToken)arguments[0];
				VariableCode varCode = vToken.Identifier.Code;
				string key = eev.GetString(arguments[1]);
				Int64 ret = 0;
				try
				{
					ret = eev.VEvaluator.Constant.KeywordToInteger(varCode, key);
				}
				catch
				{
					ret = -1;
				}
				return new SingleTerm(ret);
			}
		}

        private sealed class GetLimitMethod : FunctionMethod
        {
            public GetLimitMethod()
            {
                ReturnType = typeof(Int64);
                argumentTypeArray = new Type[] { typeof(Int64), typeof(Int64), typeof(Int64) };
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                Int64 value = eev.GetInteger(arguments[0]);
                Int64 min = eev.GetInteger(arguments[1]);
                Int64 max = eev.GetInteger(arguments[2]);
                Int64 ret = 0;
                if (value < min)
                    ret = min;
                else if (value > max)
                    ret = max;
                else
                    ret = value;
                return new SingleTerm(ret);
            }
        }

        private sealed class GetPrintCPerLineMethod : FunctionMethod
        {
            public GetPrintCPerLineMethod()
            {
                ReturnType = typeof(Int64);
                argumentTypeArray = new Type[] { };
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                return new SingleTerm(Config.Instance.PrintCPerLine);
            }
        }

        private sealed class ExistCsvMethod : FunctionMethod
        {
            public ExistCsvMethod()
            {
                ReturnType = typeof(Int64);
                argumentTypeArray = new Type[] { typeof(Int64), typeof(Int64) };
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                Int64 no = eev.GetInteger(arguments[0]);
                bool isSp = (eev.GetInteger(arguments[1]) != 0) ? true : false;
                   
                return new SingleTerm(eev.VEvaluator.ExistCsv(no, isSp));
            }
        }
        private sealed class UnicodeMethod : FunctionMethod
        {
            public UnicodeMethod()
            {
                ReturnType = typeof(string);
                argumentTypeArray = new Type[] { typeof(Int64) };
            }
            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
				Int64 i = eev.GetInteger(arguments[0]);
				if ((i < 0) || (i > 0xFFFF))
					throw new CodeEE("UNICODE関数に範囲外の値(" + i.ToString() + ")が渡されました");

				string s = new string(new char[]{(char)i});// char.ConvertFromUtf32(i);
                   
                return new SingleTerm(s);
            }
		}

		private sealed class GetFontMethod : FunctionMethod
		{
			public GetFontMethod()
			{
				ReturnType = typeof(string);
				argumentTypeArray = new Type[] { };
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				return new SingleTerm(Process.Instance.Console.StringStyle.Fontname);
			}
		}
		private sealed class GetColorMethod : FunctionMethod
		{
			public GetColorMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = new Type[] { };
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				Color color = Process.Instance.Console.StringStyle.Color;
				return new SingleTerm(color.ToArgb() & 0xFFFFFF);
			}
		}
		private sealed class GetStyleMethod : FunctionMethod
		{
			public GetStyleMethod()
			{
				ReturnType = typeof(Int64);
				argumentTypeArray = new Type[] { };
			}

			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				FontStyle fontstyle = Process.Instance.Console.StringStyle.FontStyle;
				long ret = 0;
				if ((fontstyle & FontStyle.Bold) == FontStyle.Bold)
					ret |= 1;
				if ((fontstyle & FontStyle.Italic) == FontStyle.Italic)
					ret |= 2;
				if ((fontstyle & FontStyle.Strikeout) == FontStyle.Strikeout)
					ret |= 4;
				if ((fontstyle & FontStyle.Underline) == FontStyle.Underline)
					ret |= 8;
				return new SingleTerm(ret);
			}
		}

		private sealed class ToStrMethod : FunctionMethod
		{
			public ToStrMethod()
			{
				ReturnType = typeof(string);
				argumentTypeArray = null;
			}

			public override string CheckArgumentType(string name, IOperandTerm[] arguments)
			{
				//通常2つ、1つ省略可能で1～2の引数が必要。
				if (arguments.Length < 1)
					return name + "関数には少なくとも1つの引数が必要です";
				if (arguments.Length > 2)
					return name + "関数の引数が多すぎます";
				if (arguments[0].GetOperandType() != typeof(Int64))
					return name + "関数の1番目の引数の型が正しくありません";
				if ((arguments.Length >= 2) && (arguments[1] == null) && (arguments[1].GetOperandType() != typeof(string)))
					return name + "関数の2番目の引数の型が正しくありません";
				return null;
			}
			public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
			{
				Int64 i = eev.GetInteger(arguments[0]);
				if ((arguments.Length < 2) || (arguments[1] == null))
					return new SingleTerm(i.ToString());
				string format = eev.GetString(arguments[1]);
				string ret;
				try{
				    ret = i.ToString(format);
				}
				catch(FormatException)
				{
					throw new CodeEE("TOSTR関数の書式指定が間違っています");
				}
				return new SingleTerm(ret);
			}
		}

        private sealed class ToIntMethod : FunctionMethod
        {
            public ToIntMethod()
            {
                ReturnType = typeof(Int64);
                argumentTypeArray = new Type[] { typeof(string) };
            }

            public override SingleTerm GetReturnValue(ExpressionEvaluator eev, IOperandTerm[] arguments)
            {
                string str = eev.GetString(arguments[0]);
                if (str == null || str == "")
                    return new SingleTerm(0);
                StringStream st = new StringStream(str);
                SingleTerm ret = TokenReader.ReadInt64(st);
                if (!st.EOS)
                {
                    if (st.Current == '.')
                    {
                        st.ShiftNext();
                        while (!st.EOS)
                        {
                            if (!char.IsDigit(st.Current))
                                return new SingleTerm(0);
                            st.ShiftNext();
                        }
                    }
                    else
                        return new SingleTerm(0);
                }
                return ret;
            }
        }
    }
}