using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera.GameData.Expression
{
	delegate SingleTerm GetValueMethod(IOperandTerm operand);
	delegate SingleTerm UnaryMethod(IOperandTerm operand, GetValueMethod getValueMethod);
    delegate SingleTerm UnaryAfterMethod(IOperandTerm operand, GetValueMethod getValueMethod);
	delegate SingleTerm BinaryMethod(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod);
    delegate SingleTerm TernaryMethod(IOperandTerm left, IOperandTerm right1, IOperandTerm right2, GetValueMethod getValueMethod);
    //delegate SingleTerm UnaryMethod(SingleTerm operand);
	//delegate SingleTerm BinaryMethod(SingleTerm left, SingleTerm right);
	internal static class OperatorMethod
	{
		readonly static Dictionary<OperatorCode, UnaryMethod> unaryDic = new Dictionary<OperatorCode, UnaryMethod>();
		readonly static Dictionary<OperatorCode, UnaryAfterMethod> unaryAfterDic = new Dictionary<OperatorCode, UnaryAfterMethod>();
		readonly static Dictionary<OperatorCode, BinaryMethod> binaryDic = new Dictionary<OperatorCode, BinaryMethod>();
        readonly static Dictionary<OperatorCode, TernaryMethod> ternaryDic = new Dictionary<OperatorCode, TernaryMethod>();
        static OperatorMethod()
		{
			unaryDic[OperatorCode.Plus] = Plus;
			unaryDic[OperatorCode.Minus] = Minus;
			unaryDic[OperatorCode.Not] = Not;
			unaryDic[OperatorCode.BitNot] = BitNot;
            unaryDic[OperatorCode.Increment] = Increment;
            unaryDic[OperatorCode.Decrement] = Decrement;

            unaryAfterDic[OperatorCode.Increment] = Increment;
            unaryAfterDic[OperatorCode.Decrement] = Decrement;

			binaryDic[OperatorCode.Plus] = Plus;
			binaryDic[OperatorCode.Minus] = Minus;
			binaryDic[OperatorCode.Mult] = Mult;
			binaryDic[OperatorCode.Div] = Div;
			binaryDic[OperatorCode.Mod] = Mod;
			binaryDic[OperatorCode.Equal] = Equal;
			binaryDic[OperatorCode.Greater] = Greater;
			binaryDic[OperatorCode.Less] = Less;
			binaryDic[OperatorCode.GreaterEqual] = GreaterEqual;
			binaryDic[OperatorCode.LessEqual] = LessEqual;
			binaryDic[OperatorCode.NotEqual] = NotEqual;
			binaryDic[OperatorCode.And] = And;
			binaryDic[OperatorCode.Or] = Or;
            binaryDic[OperatorCode.Xor] = Xor;
            binaryDic[OperatorCode.Nand] = Nand;
            binaryDic[OperatorCode.Nor] = Nor;
            binaryDic[OperatorCode.BitAnd] = BitAnd;
			binaryDic[OperatorCode.BitOr] = BitOr;
			binaryDic[OperatorCode.BitXor] = BitXor;
			binaryDic[OperatorCode.RightShift] = RightShift;
			binaryDic[OperatorCode.LeftShift] = LeftShift;

            ternaryDic[OperatorCode.Ternary_a] = Ternary;
		}

		public static UnaryMethod GetUnaryMethod(OperatorCode op)
		{
			if (unaryDic.ContainsKey(op))
				return unaryDic[op];
			return null;
		}

        public static UnaryAfterMethod GetUnaryAfterMethod(OperatorCode op)
        {
            if (unaryAfterDic.ContainsKey(op))
                return unaryAfterDic[op];
            return null;
        }

		public static BinaryMethod GetBinaryMethod(OperatorCode op)
		{
			if (binaryDic.ContainsKey(op))
				return binaryDic[op];
			return null;
		}

        public static TernaryMethod GetTernaryMethod(OperatorCode op)
        {
            if (ternaryDic.ContainsKey(op))
                return ternaryDic[op];
            return null;
        }


		public static Type GetReturnType(Type operand, OperatorCode op)
		{
			if (operand == typeof(Int64))
			{
				switch (op)
				{
					case OperatorCode.Plus:
					case OperatorCode.Minus:
					case OperatorCode.Not:
					case OperatorCode.BitNot:
                    case OperatorCode.Increment:
                    case OperatorCode.Decrement:
						return typeof(Int64);
				}
			}
			return typeof(void);
		}

		public static Type GetReturnType(Type right, Type left, OperatorCode op)
		{
			if ((left == typeof(Int64)) && (right == typeof(Int64)))
				return typeof(Int64);
			else if ((left == typeof(string)) && (right == typeof(string)))
			{
				switch (op)
				{
					case OperatorCode.Plus:
						return typeof(string);
					case OperatorCode.Equal:
					case OperatorCode.NotEqual:
					case OperatorCode.Greater:
					case OperatorCode.GreaterEqual:
					case OperatorCode.Less:
					case OperatorCode.LessEqual:
						return typeof(Int64);
					default:
						return typeof(void);
				}
			}
			else if (((left == typeof(Int64)) && (right == typeof(string)))
				 || ((left == typeof(string)) && (right == typeof(Int64))))
			{
				if(op == OperatorCode.Mult)
						return typeof(string);
			}
			return typeof(void);
		}

        public static Type GetReturnType(Type left, Type right1, Type right2, OperatorCode op)
        {
            if ((left == typeof(Int64)) && (right1 == typeof(Int64)) && (right2 == typeof(Int64)))
                return typeof(Int64);
            else if ((left == typeof(Int64)) && (right1 == typeof(string)) && (right2 == typeof(string)))
                return typeof(string);
            return typeof(void);
        }

		private static SingleTerm Plus(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				unchecked { return new SingleTerm(getValueMethod(left).Int + getValueMethod(right).Int); }
			}
			else if ((left.GetOperandType() == typeof(string)) && (right.GetOperandType() == typeof(string)))
			{
				return new SingleTerm(getValueMethod(left).Str + getValueMethod(right).Str);
			}
			throw new ExeEE("s\ȉZ");
		}

		private static SingleTerm Minus(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				unchecked { return new SingleTerm(getValueMethod(left).Int - getValueMethod(right).Int); }
			}
			throw new ExeEE("s\ȉZ");
		}

		private static SingleTerm Mult(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				unchecked { return new SingleTerm(getValueMethod(left).Int * getValueMethod(right).Int); }
			}
			else if ((left.GetOperandType() == typeof(string)) && (right.GetOperandType() == typeof(Int64)))
			{
				long value = getValueMethod(right).Int;
				string str = getValueMethod(left).Str;
				if (value < 0)
					throw new CodeEE("ɕ̒l(" + value.ToString() + ")Z悤Ƃ܂");
				if (value >= 10000)
					throw new CodeEE("10000ȏ̒l(" + value.ToString() + ")Z悤Ƃ܂");
				if ((str == "") || (value == 0))
					return new SingleTerm("");
				StringBuilder builder = new StringBuilder();
				builder.Capacity = str.Length * (int)value;
				for (int i = 0; i < value; i++)
				{
					builder.Append(str);
				}
				return new SingleTerm(builder.ToString());
			}
			else if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(string)))
			{
				long value = getValueMethod(left).Int;
				string str = getValueMethod(right).Str;
				if (value < 0)
					throw new CodeEE("ɕ̒l(" + value.ToString() + ")Z悤Ƃ܂");
				if (value >= 10000)
					throw new CodeEE("10000ȏ̒l(" + value.ToString() + ")Z悤Ƃ܂");
				if ((str == "") || (value == 0))
					return new SingleTerm("");
				StringBuilder builder = new StringBuilder();
				builder.Capacity = str.Length * (int)value;
				for (int i = 0; i < value; i++)
				{
					builder.Append(str);
				}
				return new SingleTerm(builder.ToString());
			}
			throw new ExeEE("s\ȉZ");
		}

		private static SingleTerm Div(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				if (getValueMethod(right).Int == 0)
					throw new CodeEE("0ɂ鏜ZsȂ܂");
				unchecked { return new SingleTerm(getValueMethod(left).Int / getValueMethod(right).Int); }
			}
			throw new ExeEE("s\ȉZ");
		}

		private static SingleTerm Mod(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				if (getValueMethod(right).Int == 0)
					throw new CodeEE("0ɂ鏜ZsȂ܂");
				unchecked { return new SingleTerm(getValueMethod(left).Int % getValueMethod(right).Int); }
			}
			throw new ExeEE("s\ȉZ");
		}


		private static SingleTerm Equal(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(getValueMethod(left).Int == getValueMethod(right).Int);
			}
			else if ((left.GetOperandType() == typeof(string)) && (right.GetOperandType() == typeof(string)))
			{
				return new SingleTerm(getValueMethod(left).Str == getValueMethod(right).Str);
			}
			throw new ExeEE("s\ȉZ");
		}

		private static SingleTerm NotEqual(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(getValueMethod(left).Int != getValueMethod(right).Int);
			}
			else if ((left.GetOperandType() == typeof(string)) && (right.GetOperandType() == typeof(string)))
			{
				return new SingleTerm(getValueMethod(left).Str != getValueMethod(right).Str);
			}
			throw new ExeEE("s\ȉZ");
		}

		private static SingleTerm Greater(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(getValueMethod(left).Int > getValueMethod(right).Int);
			}
			else if ((left.GetOperandType() == typeof(string)) && (right.GetOperandType() == typeof(string)))
			{
				int c = string.Compare(getValueMethod(left).Str, getValueMethod(right).Str, StringComparison.CurrentCulture);
				return new SingleTerm(c > 0);
			}
			throw new ExeEE("s\ȉZ");
		}

		private static SingleTerm Less(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(getValueMethod(left).Int < getValueMethod(right).Int);
			}
			else if ((left.GetOperandType() == typeof(string)) && (right.GetOperandType() == typeof(string)))
			{
				int c = string.Compare(getValueMethod(left).Str, getValueMethod(right).Str, StringComparison.CurrentCulture);
				return new SingleTerm(c < 0);
			}
			throw new ExeEE("s\ȉZ");
		}

		private static SingleTerm GreaterEqual(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(getValueMethod(left).Int >= getValueMethod(right).Int);
			}
			else if ((left.GetOperandType() == typeof(string)) && (right.GetOperandType() == typeof(string)))
			{
				int c = string.Compare(getValueMethod(left).Str, getValueMethod(right).Str, StringComparison.CurrentCulture);
				return new SingleTerm(c >= 0);
			}
			throw new ExeEE("s\ȉZ");
		}

		private static SingleTerm LessEqual(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(getValueMethod(left).Int <= getValueMethod(right).Int);
			}
			else if ((left.GetOperandType() == typeof(string)) && (right.GetOperandType() == typeof(string)))
			{
				int c = string.Compare(getValueMethod(left).Str, getValueMethod(right).Str, StringComparison.CurrentCulture);
				return new SingleTerm(c <= 0);
			}
			throw new ExeEE("s\ȉZ");
		}


		private static SingleTerm And(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
                return new SingleTerm(getValueMethod(left).Int != 0 && getValueMethod(right).Int != 0);
			}
			throw new ExeEE("s\ȉZ");
		}

		private static SingleTerm Or(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(getValueMethod(left).Int != 0 || getValueMethod(right).Int != 0);
			}
			throw new ExeEE("s\ȉZ");
		}

        private static SingleTerm Xor(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
        {
            if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
            {
                return new SingleTerm((getValueMethod(left).Int == 0 && getValueMethod(right).Int != 0) || (getValueMethod(left).Int != 0 && getValueMethod(right).Int == 0));
            }
            throw new ExeEE("s\ȉZ");
        }

        private static SingleTerm Nand(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
        {
            if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
            {
                return new SingleTerm(getValueMethod(left).Int == 0 || getValueMethod(right).Int == 0);
            }
            throw new ExeEE("s\ȉZ");
        }

        private static SingleTerm Nor(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
        {
            if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
            {
                return new SingleTerm(getValueMethod(left).Int == 0 && getValueMethod(right).Int == 0);
            }
            throw new ExeEE("s\ȉZ");
        }
        
        private static SingleTerm BitAnd(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(getValueMethod(left).Int & getValueMethod(right).Int);
			}
			throw new ExeEE("s\ȉZ");
		}

		private static SingleTerm BitOr(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(getValueMethod(left).Int | getValueMethod(right).Int);
			}
			throw new ExeEE("s\ȉZ");
		}

		private static SingleTerm BitXor(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				return new SingleTerm(getValueMethod(left).Int ^ getValueMethod(right).Int);
			}
			throw new ExeEE("s\ȉZ");
		}

		private static SingleTerm RightShift(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				unchecked { return new SingleTerm(getValueMethod(left).Int >> (int)getValueMethod(right).Int); }
			}
			throw new ExeEE("s\ȉZ");
		}

		private static SingleTerm LeftShift(IOperandTerm left, IOperandTerm right, GetValueMethod getValueMethod)
		{
			if ((left.GetOperandType() == typeof(Int64)) && (right.GetOperandType() == typeof(Int64)))
			{
				unchecked { return new SingleTerm(getValueMethod(left).Int << (int)getValueMethod(right).Int); }
			}
			throw new ExeEE("s\ȉZ");
		}


		private static SingleTerm Plus(IOperandTerm term, GetValueMethod getValueMethod)
		{
			if (term.GetOperandType() == typeof(Int64))
			{
				return new SingleTerm(getValueMethod(term).Int);
			}
			throw new ExeEE("s\ȉZ");
		}

		private static SingleTerm Minus(IOperandTerm term, GetValueMethod getValueMethod)
		{
			if (term.GetOperandType() == typeof(Int64))
			{
				unchecked { return new SingleTerm(-(getValueMethod(term).Int)); }
			}
			throw new ExeEE("s\ȉZ");
		}

        private static SingleTerm Increment(IOperandTerm term, GetValueMethod getValueMethod)
        {
            if (term.GetOperandType() == typeof(Int64))
            {
                unchecked { return new SingleTerm(getValueMethod(term).Int); }
            }
            throw new ExeEE("sȉZ");
        }

        private static SingleTerm Decrement(IOperandTerm term, GetValueMethod getValueMethod)
        {
            if (term.GetOperandType() == typeof(Int64))
            {
                unchecked { return new SingleTerm(getValueMethod(term).Int); }
            }
            throw new ExeEE("sȉZ");
        }
        
        private static SingleTerm Not(IOperandTerm term, GetValueMethod getValueMethod)
		{
			if (term.GetOperandType() == typeof(Int64))
			{
				return new SingleTerm(getValueMethod(term).Int == 0);
			}
			throw new ExeEE("s\ȉZ");
		}

		private static SingleTerm BitNot(IOperandTerm term, GetValueMethod getValueMethod)
		{
			if (term.GetOperandType() == typeof(Int64))
			{
				return new SingleTerm(~(getValueMethod(term).Int));
			}
			throw new ExeEE("s\ȉZ");
		}

        private static SingleTerm Ternary(IOperandTerm left, IOperandTerm right1, IOperandTerm right2, GetValueMethod getValueMethod)
        {
            if (left.GetOperandType() == typeof(Int64))
            {
                Int64 check = getValueMethod(left).Int;
                if (check == 0)
                {
                    if (right2.GetOperandType() == typeof(Int64))
                        return new SingleTerm(getValueMethod(right2).Int);
                    else
                        return new SingleTerm(getValueMethod(right2).Str);
                }
                else
                {
                    if (right1.GetOperandType() == typeof(Int64))
                        return new SingleTerm(getValueMethod(right1).Int);
                    else
                        return new SingleTerm(getValueMethod(right1).Str);
                }
                    
            }
            throw new ExeEE("s\ȉZ");
        }
	}
}
