using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameProc;
using MinorShift._Library;

namespace MinorShift.Emuera.GameData.Variable
{
	internal sealed class FixedVariablePointer
	{
		public VariableIdentifier ID;
		public Int64 Index1;
		public Int64 Index2;
        public Int64 Index3;
		public override string ToString()
		{
			if (ID == null)
				return base.ToString();
            if (!ID.IsArray3D)
                return string.Format("{0}:{1}:{2}", ID, Index1, Index2);
            else
                return string.Format("{0}:{1}:{2}:{3}", ID, Index1, Index2, Index3);
		}
	}

	internal sealed class VariableEvaluator : IDisposable
	{
		readonly GameBase gamebase;
		readonly ConstantData constant;
		//readonly SysnonymManager synonym = new SysnonymManager();
		readonly VariableData varData;
		readonly List<CharacterData> characterList;
		//Random rand = new Random();
		MTRandom rand = new MTRandom();
		internal GameBase Gamebase { get { return gamebase; } }
		internal ConstantData Constant { get { return constant; } }
		string scope = "";
		internal string Scope { set { scope = value; } }

		public VariableEvaluator(GameBase gamebase, ConstantData constant)
		{
			this.gamebase = gamebase;
			this.constant = constant;
			varData = new VariableData(gamebase, constant);
			characterList = new List<CharacterData>();

		}
		#region set/get

		private void checkElement(FixedVariablePointer p)
		{
			if (p.ID.IsCalc)
				return;
			if (p.ID.IsCharacterData)
			{
				if ((p.Index1 < 0) || (p.Index1 >= characterList.Count))
					throw new CodeEE("LN^zϐ" + p.ID.ToString() + "̑P(" + p.Index1.ToString() + ")̓Lo^ԍ͈̔͊Oł");
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray1D)
				{
					if (p.ID.IsInteger)
					{
						Int64[] dataList = chara.DataIntegerArray[p.ID.CodeInt];
						if ((p.Index2 < 0) || (p.Index2 >= dataList.Length))
							throw new CodeEE("LN^zϐ" + p.ID.ToString() + "̑Q(" + p.Index2.ToString() + ")͔z͈̔͊Oł");
					}
					else
					{
						string[] dataList = chara.DataStringArray[p.ID.CodeInt];
						if ((p.Index2 < 0) || (p.Index2 >= dataList.Length))
							throw new CodeEE("LN^zϐ" + p.ID.ToString() + "̑Q(" + p.Index2.ToString() + ")͔z͈̔͊Oł");
					}
				}
			}
            else if (p.ID.IsArray3D)
            {
                if (p.ID.IsInteger)
                {
                    Int64[,,] dataList = varData.DataIntegerArray3D[p.ID.CodeInt];
                    if ((p.Index1 < 0) || (p.Index1 >= dataList.GetLength(0)))
                        throw new CodeEE("Oz" + p.ID.ToString() + "̑P(" + p.Index1.ToString() + ")͔z͈̔͊Oł");
                    if ((p.Index2 < 0) || (p.Index2 >= dataList.GetLength(1)))
                        throw new CodeEE("Oz" + p.ID.ToString() + "̑Q(" + p.Index2.ToString() + ")͔z͈̔͊Oł");
                    if ((p.Index3 < 0) || (p.Index3 >= dataList.GetLength(2)))
                        throw new CodeEE("Oz" + p.ID.ToString() + "̑R(" + p.Index3.ToString() + ")͔z͈̔͊Oł");
                }
                else
                {
                    string[, ,] dataList = varData.DataStringArray3D[p.ID.CodeInt];
                    if ((p.Index1 < 0) || (p.Index1 >= dataList.GetLength(0)))
                        throw new CodeEE("Oz" + p.ID.ToString() + "̑P(" + p.Index1.ToString() + ")͔z͈̔͊Oł");
                    if ((p.Index2 < 0) || (p.Index2 >= dataList.GetLength(1)))
                        throw new CodeEE("Oz" + p.ID.ToString() + "̑Q(" + p.Index2.ToString() + ")͔z͈̔͊Oł");
                    if ((p.Index3 < 0) || (p.Index3 >= dataList.GetLength(2)))
                        throw new CodeEE("Oz" + p.ID.ToString() + "̑R(" + p.Index3.ToString() + ")͔z͈̔͊Oł");
                }
            }
            else if (p.ID.IsArray2D)
            {
                if (p.ID.IsInteger)
                {
                    Int64[,] dataList = varData.DataIntegerArray2D[p.ID.CodeInt];
                    if ((p.Index1 < 0) || (p.Index1 >= dataList.GetLength(0)))
                        throw new CodeEE("񎟌z" + p.ID.ToString() + "̑P(" + p.Index1.ToString() + ")͔z͈̔͊Oł");
                    if ((p.Index2 < 0) || (p.Index2 >= dataList.GetLength(1)))
                        throw new CodeEE("񎟌z" + p.ID.ToString() + "̑Q(" + p.Index2.ToString() + ")͔z͈̔͊Oł");
                }
                else
                {
                    string[,] dataList = varData.DataStringArray2D[p.ID.CodeInt];
                    if ((p.Index1 < 0) || (p.Index1 >= dataList.GetLength(0)))
                        throw new CodeEE("񎟌z" + p.ID.ToString() + "̑P(" + p.Index1.ToString() + ")͔z͈̔͊Oł");
                    if ((p.Index2 < 0) || (p.Index2 >= dataList.GetLength(1)))
                        throw new CodeEE("񎟌z" + p.ID.ToString() + "̑Q(" + p.Index2.ToString() + ")͔z͈̔͊Oł");
                }
            }
            else if (p.ID.IsArray1D)
            {
                if (p.ID.IsInteger)
                {
                    Int64[] dataList = varData.DataIntegerArray[p.ID.CodeInt];
                    if ((p.Index1 < 0) || (p.Index1 >= dataList.Length))
                        throw new CodeEE("zϐ" + p.ID.ToString() + "̑P(" + p.Index1.ToString() + ")͔z͈̔͊Oł");
                }
                else
                {
                    string[] dataList = varData.DataStringArray[p.ID.CodeInt];
                    if ((p.Index1 < 0) || (p.Index1 >= dataList.Length))
                        throw new CodeEE("zϐ" + p.ID.ToString() + "̑P(" + p.Index1.ToString() + ")͔z͈̔͊Oł");
                }
            }
		}


		//1.60ŊSɔp~BCheckConstElementQB
		//萔łϐɂāAz͈͓̔ǂ[hɃ`FbN悤ƂӊOƍB
		//private CharacterData createTestChara() { return new CharacterData(constant); }
		//public static void SetTestData(VariableEvaluator vEv)
		//{
		//    //testData = vEv.varData;
		//    //testChara = vEv.createTestChara();
		//}
		//static VariableData testData;
		//static CharacterData testChara;
		//public static bool CheckConstElement(FixedVariablePointer p)
		//{
		//    if (p.ID.IsCalc)
		//    {
		//        if (p.ID.Code == VariableCode.RAND)
		//            if (p.Index1 <= 0)
		//                return false;
		//        if (p.ID.Code == VariableCode.CHARANUM)
		//            return true;
		//        return true;
		//    }
		//    else if (p.ID.IsCharacterData)
		//    {
		//        if (p.ID.IsArray1D)
		//        {
		//            if (p.ID.IsInteger)
		//            {
		//                Int64[] dataList = testChara.DataIntegerArray[p.ID.CodeInt];
		//                if ((p.Index2 < 0) || (p.Index2 >= dataList.Length))
		//                    return false;
		//            }
		//        }
		//    }
		//    else if (p.ID.IsArray1D)
		//    {
		//        if (p.ID.IsInteger)
		//        {
		//            Int64[] dataList = testData.DataIntegerArray[p.ID.CodeInt];
		//            if ((p.Index1 < 0) || (p.Index1 >= dataList.Length))
		//                    return false;
		//        }
		//        else
		//        {
		//            string[] dataList = testData.DataStringArray[p.ID.CodeInt];
		//            if ((p.Index1 < 0) || (p.Index1 >= dataList.Length))
		//                    return false;
		//        }
		//    }
		//    return true;
		//}

		public void Randomize(Int64 seed)
		{
			rand = new MTRandom(seed);
		}

		public void InitRanddata()
		{
			rand.SetRand(this.RANDDATA);
		}

		public void DumpRanddata()
		{
			rand.GetRand(this.RANDDATA);
		}
		public Int64 GetNextRand(Int64 max)
		{
			return rand.NextInt64(max);
		}

		public Int64 GetInteger(FixedVariablePointer p)
		{
			if (!p.ID.IsInteger)
				throw new CodeEE("^łȂϐ" + p.ID.ToString() + "𐮐^ƂČĂяo܂");
			checkElement(p);
			if (p.ID.IsCalc)
			{
				switch (p.ID.Code)
				{
					case VariableCode.RAND:
							if (p.Index1 <= 0)
								throw new CodeEE("RAND̈0ȉ̒l(" + p.Index1.ToString() + ")w肳܂");
							//if (p.Index1 > Int32.MaxValue)
							//    throw new CodeEE("RAND̈ɑ傫l(" + p.Index1.ToString() + ")w肳܂");

							return GetNextRand(p.Index1);

					case VariableCode.CHARANUM:
						return characterList.Count;
					case VariableCode.GAMEBASE_GAMECODE: return gamebase.ScriptUniqueCode;
					case VariableCode.GAMEBASE_VERSION: return gamebase.ScriptVersion;
					case VariableCode.GAMEBASE_ALLOWVERSION: return gamebase.ScriptCompatibleMinVersion;
					case VariableCode.GAMEBASE_DEFAULTCHARA: return gamebase.DefaultCharacter;
					case VariableCode.GAMEBASE_NOITEM: return gamebase.DefaultNoItem;
					case VariableCode.LASTLOAD_NO: return varData.LastLoadNo;
					case VariableCode.LASTLOAD_VERSION: return varData.LastLoadVersion;
					default:
						throw new ExeEE("`̕ϐ" + p.ID.ToString());
				}
			}
			else if (p.ID.IsLocal)
			{
				if (p.ID.Code == VariableCode.LOCAL)
				{
					string varScope = p.ID.Scope;
					if (varScope == null)
						varScope = this.scope;
					return varData.LocalVars.GetValue(varScope, p.Index1);
				}
				if (p.ID.Code == VariableCode.ARG)
				{
					string varScope = p.ID.Scope;
					if (varScope == null)
						varScope = this.scope;
					return varData.ArgVars.GetValue(varScope, p.Index1);
				}
				throw new ExeEE("`̕ϐ" + p.ID.ToString());
			}
			else if (p.ID.IsCharacterData)
			{
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray1D)
					return chara.DataIntegerArray[p.ID.CodeInt][p.Index2];
				else
					return chara.DataInteger[p.ID.CodeInt];
			}
            else if (p.ID.IsArray3D)
                return varData.DataIntegerArray3D[p.ID.CodeInt][p.Index1, p.Index2, p.Index3];
            else if (p.ID.IsArray2D)
				return varData.DataIntegerArray2D[p.ID.CodeInt][p.Index1, p.Index2];
			else if (p.ID.IsArray1D)
				return varData.DataIntegerArray[p.ID.CodeInt][p.Index1];
			else
				return varData.DataInteger[p.ID.CodeInt];
		}

		public string GetString(FixedVariablePointer p)
		{
			string ret = m_GetString(p);
			if (ret == null)
				return "";
			return ret;
		}

		private string m_GetString(FixedVariablePointer p)
		{
			if (!p.ID.IsString)
				throw new CodeEE("^łȂϐ" + p.ID.ToString() + "𕶎^ƂČĂяo܂");
			if (p.ID.IsCalc)
			{
				string[] array = null;
				switch (p.ID.Code)
				{
					case VariableCode.ABLNAME:
						array = constant.AblName;
						break;
					case VariableCode.TALENTNAME:
						array = constant.TalentName;
						break;
					case VariableCode.EXPNAME:
						array = constant.ExpName;
						break;
					case VariableCode.MARKNAME:
						array = constant.MarkName;
						break;
					case VariableCode.PALAMNAME:
						array = constant.ParamName;
						break;
					case VariableCode.ITEMNAME:
						array = constant.ItemName;
						break;
					case VariableCode.TRAINNAME:
						array = constant.TrainName;
						break;
					case VariableCode.BASENAME:
						array = constant.BaseName;
						break;
					case VariableCode.SOURCENAME:
						array = constant.SourceName;
						break;
					case VariableCode.EXNAME:
						array = constant.ExName;
						break;
					case VariableCode.EQUIPNAME:
						array = constant.EquipName;
						break;
					case VariableCode.TEQUIPNAME:
						array = constant.TequipName;
						break;
					case VariableCode.FLAGNAME:
						array = constant.FlagName;
						break;
					case VariableCode.TFLAGNAME:
						array = constant.TFlagName;
						break;
					case VariableCode.CFLAGNAME:
						array = constant.CFlagName;
						break;
					case VariableCode.GAMEBASE_AUTHER: return gamebase.ScriptAutherName;
					case VariableCode.GAMEBASE_AUTHOR: return gamebase.ScriptAutherName;
					case VariableCode.GAMEBASE_INFO: return gamebase.ScriptDetail;
					case VariableCode.GAMEBASE_TITLE: return gamebase.ScriptTitle;
					case VariableCode.GAMEBASE_YEAR: return gamebase.ScriptYear;
					case VariableCode.LASTLOAD_TEXT: return varData.LastLoadText;
					case VariableCode.WINDOW_TITLE: return Process.Instance.Console.GetWindowTitle();
				}
				if (array == null)
					throw new ExeEE(p.ID.Code.ToString() + "IsCalc̕^ƂĎw肳ꂽ");
				if ((p.Index1 < 0) || (p.Index1 >= array.Length))
					return null;
				return array[p.Index1];
			}
			checkElement(p);
			if (p.ID.IsLocal)
			{
				if (p.ID.Code == VariableCode.LOCALS)
				{
					string varScope = p.ID.Scope;
					if (varScope == null)
						varScope = this.scope;
					return varData.LocalString.GetValue(varScope, p.Index1);
				}
				else if (p.ID.Code == VariableCode.ARGS)
				{
					string varScope = p.ID.Scope;
					if (varScope == null)
						varScope = this.scope;
					return varData.ArgString.GetValue(varScope, p.Index1);
				}
				throw new ExeEE("`̃[Jϐ");
			}
			else if (p.ID.IsCharacterData)
			{
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray1D)
					return chara.DataStringArray[p.ID.CodeInt][p.Index2];
				else
					return chara.DataString[p.ID.CodeInt];
			}
            else if (p.ID.IsArray3D)
                return varData.DataStringArray3D[p.ID.CodeInt][p.Index1, p.Index2, p.Index3];
            else if (p.ID.IsArray2D)
				return varData.DataStringArray2D[p.ID.CodeInt][p.Index1, p.Index2];
			else if (p.ID.IsArray1D)
				return varData.DataStringArray[p.ID.CodeInt][p.Index1];
			else
				return varData.DataString[p.ID.CodeInt];
		}

		public void SetValueAll(FixedVariablePointer p, Int64 srcValue)
		{
			if (!p.ID.IsInteger)
				throw new CodeEE("^łȂϐ" + p.ID.ToString() + "ɐl悤Ƃ܂");
			if (p.ID.Readonly)
				throw new CodeEE("ǂݎp̕ϐ" + p.ID.ToString() + "ɑ悤Ƃ܂");
			if (p.ID.IsCalc)
			{
				throw new ExeEE("READONLYłȂCALCϐ̑ݒ肳ĂȂ");
			}
			checkElement(p);
			long[] array = null;
			if (p.ID.Code == VariableCode.LOCAL)
			{
				string varScope = p.ID.Scope;
				if (varScope == null)
					varScope = this.scope;
				array = varData.LocalVars.GetVarList(varScope);
			}
			else if (p.ID.Code == VariableCode.ARG)
			{
				string varScope = p.ID.Scope;
				if (varScope == null)
					varScope = this.scope;
				array = varData.ArgVars.GetVarList(varScope);
			}
			else if (p.ID.IsCharacterData)
			{
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray1D)
					array = chara.DataIntegerArray[p.ID.CodeInt];
				else
				{
					chara.DataInteger[p.ID.CodeInt] = srcValue;
					return;
				}
			}
			else if (p.ID.IsArray1D)
				array = varData.DataIntegerArray[p.ID.CodeInt];
			else if (p.ID.IsArray3D)
			{
				long[,,] a3 = varData.DataIntegerArray3D[p.ID.CodeInt];
				for (int x = 0; x < a3.GetLength(0); x++)
					for (int y = 0; y < a3.GetLength(1); y++)
						for (int z = 0; z < a3.GetLength(2); z++)
							a3[x,y,z] = srcValue;
				return;
			}
			else if (p.ID.IsArray2D)
			{
				long[, ] a2 = varData.DataIntegerArray2D[p.ID.CodeInt];
				for (int x = 0; x < a2.GetLength(0); x++)
					for (int y = 0; y < a2.GetLength(1); y++)
							a2[x, y] = srcValue;
				return;
			}
			else
			{
				varData.DataInteger[p.ID.CodeInt] = srcValue;
				return;
			}
			for (int i = 0; i < array.Length; i++)
				array[i] = srcValue;
		}

		public void SetValueAll(FixedVariablePointer p, string srcValue)
		{
			if (!p.ID.IsString)
				throw new CodeEE("^łȂϐ" + p.ID.ToString() + "ɕ^悤Ƃ܂");
			if (p.ID.Readonly)
				throw new CodeEE("ǂݎp̕ϐ" + p.ID.ToString() + "ɑ悤Ƃ܂");
			if (p.ID.IsCalc)
			{
				if (p.ID.Code == VariableCode.WINDOW_TITLE)
				{
					Process.Instance.Console.SetWindowTitle(srcValue);
					return;
				}
				throw new ExeEE("READONLYłȂCALCϐ̑ݒ肳ĂȂ");
			}
			checkElement(p);
			string[] array = null;
			if (p.ID.Code == VariableCode.LOCALS)
			{
				string varScope = p.ID.Scope;
				if (varScope == null)
					varScope = this.scope;
				array = varData.LocalString.GetVarList(varScope);
			}
			else if (p.ID.Code == VariableCode.ARGS)
			{
				string varScope = p.ID.Scope;
				if (varScope == null)
					varScope = this.scope;
				array = varData.ArgString.GetVarList(varScope);
			}
			else if (p.ID.IsCharacterData)
			{
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray1D)
					array = chara.DataStringArray[p.ID.CodeInt];
				else
				{
					chara.DataString[p.ID.CodeInt] = srcValue;
					return;
				}
			}
			else if (p.ID.IsArray1D)
				array = varData.DataStringArray[p.ID.CodeInt];
			else if (p.ID.IsArray3D)
			{
				string[, ,] a3 = varData.DataStringArray3D[p.ID.CodeInt];
				for (int x = 0; x < a3.GetLength(0); x++)
					for (int y = 0; y < a3.GetLength(1); y++)
						for (int z = 0; z < a3.GetLength(2); z++)
							a3[x, y, z] = srcValue;
				return;
			}
			else if (p.ID.IsArray2D)
			{
				string[,] a2 = varData.DataStringArray2D[p.ID.CodeInt];
				for (int x = 0; x < a2.GetLength(0); x++)
					for (int y = 0; y < a2.GetLength(1); y++)
						a2[x, y] = srcValue;
				return;
			}
			else
			{
				varData.DataString[p.ID.CodeInt] = srcValue;
				return;
			}
			for (int i = 0; i < array.Length; i++)
				array[i] = srcValue;
		}


		public void SetValue(FixedVariablePointer p, Int64 srcValue)
		{
			if (!p.ID.IsInteger)
				throw new CodeEE("^łȂϐ" + p.ID.ToString() + "ɐl悤Ƃ܂");
			if (p.ID.Readonly)
				throw new CodeEE("ǂݎp̕ϐ" + p.ID.ToString() + "ɑ悤Ƃ܂");
			if (p.ID.IsCalc)
			{
				throw new ExeEE("READONLYłȂCALCϐ̑ݒ肳ĂȂ");
			}
			checkElement(p);

			if (p.ID.Code == VariableCode.LOCAL)
			{
				string varScope = p.ID.Scope;
				if (varScope == null)
					varScope = this.scope;
				varData.LocalVars.SetValue(varScope, p.Index1, srcValue);
			}
            else if (p.ID.Code == VariableCode.ARG)
            {
                string varScope = p.ID.Scope;
                if (varScope == null)
                    varScope = this.scope;
                varData.ArgVars.SetValue(varScope, p.Index1, srcValue);
            }
            else if (p.ID.IsCharacterData)
			{
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray1D)
					chara.DataIntegerArray[p.ID.CodeInt][p.Index2] = srcValue;
				else
					chara.DataInteger[p.ID.CodeInt] = srcValue;

			}
            else if (p.ID.IsArray3D)
                varData.DataIntegerArray3D[p.ID.CodeInt][p.Index1, p.Index2, p.Index3] = srcValue;
            else if (p.ID.IsArray2D)
				varData.DataIntegerArray2D[p.ID.CodeInt][p.Index1, p.Index2] = srcValue;
			else if (p.ID.IsArray1D)
				varData.DataIntegerArray[p.ID.CodeInt][p.Index1] = srcValue;
			else
				varData.DataInteger[p.ID.CodeInt] = srcValue;
		}

		public void SetValue(FixedVariablePointer p, string srcValue)
		{
			if (!p.ID.IsString)
				throw new CodeEE("^łȂϐ" + p.ID.ToString() + "ɕ^悤Ƃ܂");
			if (p.ID.Readonly)
				throw new CodeEE("ǂݎp̕ϐ" + p.ID.ToString() + "ɑ悤Ƃ܂");
			if (p.ID.IsCalc)
			{
				if (p.ID.Code == VariableCode.WINDOW_TITLE)
				{
					Process.Instance.Console.SetWindowTitle(srcValue);
					return;
				}
				throw new ExeEE("READONLYłȂCALCϐ̑ݒ肳ĂȂ");
			}
			checkElement(p);
            if (p.ID.Code == VariableCode.LOCALS)
            {
                string varScope = p.ID.Scope;
                if (varScope == null)
                    varScope = this.scope;
                varData.LocalString.SetValue(varScope, p.Index1, srcValue);
            }
            else if (p.ID.Code == VariableCode.ARGS)
            {
                string varScope = p.ID.Scope;
                if (varScope == null)
                    varScope = this.scope;
                varData.ArgString.SetValue(varScope, p.Index1, srcValue);
            }
            else if (p.ID.IsCharacterData)
			{
				CharacterData chara = characterList[(int)p.Index1];
				if (p.ID.IsArray1D)
					chara.DataStringArray[p.ID.CodeInt][p.Index2] = srcValue;
				else
					chara.DataString[p.ID.CodeInt] = srcValue;
			}
            else if (p.ID.IsArray3D)
                varData.DataStringArray3D[p.ID.CodeInt][p.Index1, p.Index2, p.Index3] = srcValue;
            else if (p.ID.IsArray2D)
				varData.DataStringArray2D[p.ID.CodeInt][p.Index1, p.Index2] = srcValue;
			else if (p.ID.IsArray1D)
				varData.DataStringArray[p.ID.CodeInt][p.Index1] = srcValue;
			else
				varData.DataString[p.ID.CodeInt] = srcValue;
		}

		public string GetTrainComString(int trainCode, int comNo)
		{
			string trainName = constant.TrainName[trainCode];
			return string.Format("{0}[{1,3}]", trainName, comNo);
		}


		public string GetHavingItemsString()
		{
			Int64[] array = varData.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.ITEM];
			string[] itemnames = this.ITEMNAME;
			int count = 0;
			StringBuilder builder = new StringBuilder();
			builder.Append("ACeF");
			for (int i = 0; i < array.Length; i++)
			{
				if (array[i] == 0)
					continue;
				if (i >= itemnames.Length)
					break;
				count++;
				if (itemnames[i] != null)
					builder.Append(itemnames[i]);
				builder.Append("(");
				builder.Append(array[i].ToString());
				builder.Append(") ");
			}
			if (count == 0)
				builder.Append("Ȃ");
			return builder.ToString();
		}

		public string GetItemSalesString()
		{
			Int64[] array = varData.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.ITEMSALES];
			StringBuilder builder = new StringBuilder();
			for (int i = 0; i < array.Length; i++)
			{
				if (array[i] != 0)
					continue;
				builder.Append(constant.ItemName[i]);
				builder.Append("(");
				builder.Append(array[i].ToString());
				builder.Append(")");
			}
			return builder.ToString();
		}

		public string GetCharacterDataString(Int64 target, BuiltInFunctionCode func)
		{
			StringBuilder builder = new StringBuilder();
			if ((target < 0) || (target >= characterList.Count))
				throw new CodeEE("݂Ȃo^LN^QƂ悤Ƃ܂");
			CharacterData chara = characterList[(int)target];
			Int64[] array = null;
			int i = 0;
			switch (func)
			{
				case BuiltInFunctionCode.PRINT_ABL:
					array = chara.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.ABL];
					for (i = 0; i < array.Length; i++)
					{
						if (i >= constant.AblName.Length)
							break;
						if (array[i] == 0)
							continue;
						if (string.IsNullOrEmpty(constant.AblName[i]))
							continue;
						builder.Append(constant.AblName[i]);
						builder.Append("LV");
						builder.Append(array[i].ToString());
						builder.Append(" ");

					}
					break;
				case BuiltInFunctionCode.PRINT_TALENT:
					array = chara.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.TALENT];
					for (i = 0; i < array.Length; i++)
					{
						if (i >= constant.TalentName.Length)
							break;
						if (array[i] == 0)
							continue;
						if (string.IsNullOrEmpty(constant.TalentName[i]))
							continue;
						builder.Append("[");
						builder.Append(constant.TalentName[i]);
						builder.Append("]");
					}
					break;
				case BuiltInFunctionCode.PRINT_MARK:
					array = chara.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.MARK];
					for (i = 0; i < array.Length; i++)
					{
						if (i >= constant.MarkName.Length)
							break;
						if (array[i] == 0)
							continue;
						if (string.IsNullOrEmpty(constant.MarkName[i]))
							continue;
						builder.Append(constant.MarkName[i]);
						builder.Append("LV");
						builder.Append(array[i].ToString());
						builder.Append(" ");
					}
					break;
				case BuiltInFunctionCode.PRINT_EXP:
					array = chara.DataIntegerArray[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.EXP];
					for (i = 0; i < array.Length; i++)
					{
						if (i >= constant.ExpName.Length)
							break;
						if (array[i] == 0)
							continue;
						if (string.IsNullOrEmpty(constant.ExpName[i]))
							continue;
						builder.Append(constant.ExpName[i]);
						builder.Append(array[i].ToString());
						builder.Append(" ");
					}
					break;
				default:
					throw new ExeEE("`̊֐");
			}
			return builder.ToString();
		}
		public string GetCharacterParamString(Int64 target, int paramCode)
		{
			if ((target < 0) || (target >= characterList.Count))
				throw new CodeEE("݂Ȃo^LN^QƂ悤Ƃ܂");
			if ((paramCode < 0) || (paramCode >= constant.ParamName.Length))
				throw new ExeEE("݂Ȃ̂擾悤Ƃ");
			CharacterData chara = characterList[(int)target];
			Int64 param = chara.DataIntegerArray[(int)(VariableCode.PALAM & VariableCode.__LOWERCASE__)][paramCode];
			Int64[] paramlv = varData.DataIntegerArray[(int)(VariableCode.PALAMLV & VariableCode.__LOWERCASE__)];
			string paramName = constant.ParamName[paramCode];
			if ((param == 0) && (string.IsNullOrEmpty(paramName)))
				return null;
			if (paramName == null)
				paramName = "";
			char c = '-';
			Int64 border = paramlv[1];
			if (param >= border)
			{
				c = '=';
				border = paramlv[2];
			}
			if (param >= border)
			{
				c = '>';
				border = paramlv[3];
			}
			if (param >= border)
			{
				c = '*';
				border = paramlv[4];
			}
			StringBuilder bar = new StringBuilder();
			bar.Append('[');
			if ((border <= 0) || (border <= param))
				bar.Append(c, 10);
			else if (param <= 0)
				bar.Append('.', 10);
			else
			{
				unchecked
				{
					int count = (int)(param * 10 / border);
					bar.Append(c, count);
					bar.Append('.', 10 - count);
				}
			}
			bar.Append(']');
			return string.Format("{0}{1}{2,6}", paramName, bar.ToString(), ToKmgtString(param));

		}

		public void AddCharacter(Int64 charaTmplNo, bool isSp)
		{
			CharacterTemplate tmpl = constant.GetCharacterTemplate(charaTmplNo, isSp);
			if (tmpl == null)
				throw new CodeEE("`ĂȂLN^쐬悤Ƃ܂");
			CharacterData chara = new CharacterData(constant, tmpl);
			characterList.Add(chara);
		}

		public void DelCharacter(Int64 charaNo)
		{
			if ((charaNo < 0) || (charaNo >= characterList.Count))
				throw new CodeEE("݂Ȃo^LN^폜悤Ƃ܂");
			characterList[(int)charaNo].Dispose();
			characterList.RemoveAt((int)charaNo);
		}

		public void DelAllCharacter()
		{
			if (characterList.Count == 0)
				return;
			foreach (CharacterData chara in characterList)
				chara.Dispose();
			characterList.Clear();
		}
		public void ResetData()
		{
			//O[o͏Ȃs悢B
			//varData.SetDefalutGlobalValue();
			varData.SetDefalutLocalValue();
			varData.SetDefalutValue(constant);
			foreach (CharacterData chara in characterList)
				chara.Dispose();
			characterList.Clear();
		}

		public void ResetGlobalData()
		{
			varData.SetDefalutGlobalValue();
		}

		public void SwapChara(Int64 x, Int64 y)
		{
			if (((x < 0) || (x >= characterList.Count)) || ((y < 0) || (y >= characterList.Count)))
				throw new CodeEE("݂Ȃo^LN^ւ悤Ƃ܂");
			if (x == y)
				return;
			CharacterData data = characterList[(int)y];
			characterList[(int)y] = characterList[(int)x];
			characterList[(int)x] = data;
		}

		public void SortChara(VariableIdentifier sortkey, Int64 elem, SortOrder sortorder,bool fixMaster)
		{
			if (characterList.Count <= 1)
				return;
            if (sortorder == SortOrder.UNDEF)
                sortorder = SortOrder.ASCENDING;
			if (sortkey == null)
				sortkey = VariableIdentifier.GetVariableId("NO");
			CharacterData masterChara = null;
			CharacterData targetChara = null;
			CharacterData assiChara = null;
			if (this.MASTER >= 0 && this.MASTER < characterList.Count)
				masterChara = characterList[(int)this.MASTER];
			if (this.TARGET >= 0 && this.TARGET < characterList.Count)
				targetChara = characterList[(int)this.TARGET];
			if (this.ASSI >= 0 && this.ASSI < characterList.Count)
				assiChara = characterList[(int)this.ASSI];

			for (int i = 0; i < characterList.Count; i++)
			{
				characterList[i].temp_CurrentOrder = i;
				characterList[i].SetSortKey(sortkey, elem);
			}
			if ((fixMaster) && (masterChara != null))
			{
				if (characterList.Count <= 2)
					return;
				characterList.Remove(masterChara);
			}
            if (sortorder == SortOrder.ASCENDING)
				characterList.Sort(CharacterData.AscCharacterComparison);
            else if (sortorder == SortOrder.DESENDING)
				characterList.Sort(CharacterData.DescCharacterComparison);
			else
				throw new ExeEE("\[gs");

			if ((fixMaster) && (masterChara != null))
			{
				characterList.Insert((int)this.MASTER, masterChara);
			}
			for (int i = 0; i < characterList.Count; i++)
				characterList[i].temp_CurrentOrder = i;
			if ((masterChara != null) && (!fixMaster))
				this.MASTER = masterChara.temp_CurrentOrder;
			if (targetChara != null)
				this.TARGET = targetChara.temp_CurrentOrder;
			if (assiChara != null)
				this.ASSI = assiChara.temp_CurrentOrder;
		}


		internal Int64 FindChara(VariableIdentifier varID, Int64 elem, string word, Int64 startIndex)
		{
			if (characterList.Count <= startIndex)
				return -1;
			FixedVariablePointer fvp = new FixedVariablePointer();
			fvp.ID = varID;
			fvp.Index2 = elem;
			for (Int64 i = startIndex; i < characterList.Count; i++)
			{
				fvp.Index1 = i;
				if(word == GetString(fvp))
					return i;
			}
			return -1;
		}

		internal Int64 FindChara(VariableIdentifier varID, Int64 elem, Int64 word, Int64 startIndex)
		{
			if (characterList.Count <= startIndex)
				return -1;
			FixedVariablePointer fvp = new FixedVariablePointer();
			fvp.ID = varID;
			fvp.Index2 = elem;
			for (Int64 i = startIndex; i < characterList.Count; i++)
			{
				fvp.Index1 = i;
				if (word == GetInteger(fvp))
					return i;
			}
			return -1;
		}

		//1.54u܂
		//public Int64[] SortChara(bool flag, Int64 target, Int64 assi)
		//{
		//    Int64[] ret = new Int64[2];
		//    ret[0] = target;
		//    ret[1] = assi;
		//    if (characterList.Count <= 1)
		//        return ret;
		//    List<KeyValuePair<Int64, CharacterData>> keyset = new List<KeyValuePair<long, CharacterData>>(characterList.Count);
		//    for (int i = 1; i < characterList.Count; i++)
		//    {
		//        keyset.Add(new KeyValuePair<Int64, CharacterData>((Int64)i, characterList[i]));
		//    }
		//    if (flag)
		//    {
		//        keyset.Sort(delegate(KeyValuePair<Int64, CharacterData> x, KeyValuePair<Int64, CharacterData> y)
		//        {

		//            Int64 noA = x.Value.DataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO];
		//            Int64 noB = y.Value.DataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO];

		//            if (noA - noB != 0)
		//                return (int)(noA - noB);
		//            else
		//                return x.Key.CompareTo(y.Key);
		//        });
		//    }
		//    else
		//    {
		//        keyset.Sort(delegate(KeyValuePair<Int64, CharacterData> x, KeyValuePair<Int64, CharacterData> y)
		//        {
		//            Int64 noA = x.Value.DataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO];
		//            Int64 noB = y.Value.DataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO];

		//            if (noA - noB != 0)
		//                return (int)(noB - noA);
		//            else
		//                return x.Key.CompareTo(y.Key);
		//        });
		//    }
		//    for (int i = 1; i < characterList.Count; i++)
		//    {
		//        characterList[i] = keyset[i - 1].Value;
		//        if (keyset[i - 1].Key == target)
		//            ret[0] = i;
		//        else if (keyset[i - 1].Key == assi)
		//            ret[1] = i;
		//    }
		//    return ret;
		//}
        
        public Int64 GetChara(Int64 charaNo, bool getSp)
        {
		   //VINOύXꍇlAchara*.csvŒ`Ă邩ǂׂ͒ȂB
			//CharacterTemplate tmpl = constant.GetCharacterTemplate(charaNo, false);
			//if (tmpl == null)
			//    return -1;
            int i;
            for (i = 0; i < characterList.Count; i++)
            {
				if (characterList[i].NO == charaNo)
				{
					bool isSp = characterList[i].CFlag[0] != 0;
					if(isSp == getSp)
	                    return (Int64)i;
				}
            }
            return -1;
        }

        public Int64 ExistCsv(Int64 charaNo, bool getSp)
        {
            CharacterTemplate tmpl = constant.GetCharacterTemplate(charaNo, false);
            if (tmpl == null)
                return 0;
            else
                return 1;
        }

        public string GetCharacterStrfromCSVData(Int64 charaTmplNo, CharacterStrData type, bool isSp, Int64 arg2)
        {
            CharacterTemplate tmpl = constant.GetCharacterTemplate(charaTmplNo, isSp);
            if (tmpl == null)
                throw new CodeEE("`ĂȂLN^QƂ悤Ƃ܂");
            switch (type)
            {
                case CharacterStrData.CALLNAME:
                    return tmpl.Callname;
                case CharacterStrData.NAME:
                    return tmpl.Name;
                case CharacterStrData.NICKNAME:
                    return tmpl.Nickname;
                case CharacterStrData.MASTERNAME:
                    return tmpl.Mastername;
                case CharacterStrData.CSTR:
                    if (arg2 >= tmpl.cstrArrayLength())
                        throw new CodeEE("CSTR̎QƉ\͈͊OQƂ܂");
                    return tmpl.CStr[arg2];
                default:
                    throw new CodeEE("݂Ȃf[^QƂ悤Ƃ܂");
            }
        }

        public Int64 GetCharacterIntfromCSVData(Int64 charaTmplNo, CharacterIntData type, bool isSp, Int64 arg2)
        {
            CharacterTemplate tmpl = constant.GetCharacterTemplate(charaTmplNo, isSp);
            if (tmpl == null)
                throw new CodeEE("`ĂȂLN^QƂ悤Ƃ܂");
            if (arg2 >= tmpl.ArrayLength(type))
                throw new CodeEE("QƉ\͈͊OQƂ܂");
            switch (type)
            {
                case CharacterIntData.BASE:
                    return tmpl.Maxbase[arg2];
                case CharacterIntData.MARK:
                    return tmpl.Mark[arg2];
                case CharacterIntData.ABL:
                    return tmpl.Abl[arg2];
                case CharacterIntData.EXP:
                    return tmpl.Exp[arg2];
                case CharacterIntData.RELATION:
                    return tmpl.Relation[arg2];
                case CharacterIntData.TALENT:
                    return tmpl.Talent[arg2];
                case CharacterIntData.CFLAG:
                    return tmpl.CFlag[arg2];
                default:
                    throw new CodeEE("݂Ȃf[^QƂ悤Ƃ܂");
            }
        }

        public void UpdateInBeginTrain()
		{
			ASSIPLAY = 0;
			PREVCOM = -1;
			NEXTCOM = -1;
			Int64[] array;
			array = varData.DataIntegerArray[(int)(VariableCode.TFLAG & VariableCode.__LOWERCASE__)];
			for (int i = 0; i < array.Length; i++)
				array[i] = 0;
			//{Ƃ̎dlɂ킹AI𒆈ȊÕLN^SZbgB
			foreach (CharacterData chara in characterList)
			{
				array = chara.DataIntegerArray[(int)(VariableCode.GOTJUEL & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
				array = chara.DataIntegerArray[(int)(VariableCode.TEQUIP & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
				array = chara.DataIntegerArray[(int)(VariableCode.EX & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
				array = chara.DataIntegerArray[(int)(VariableCode.STAIN & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
				//W̉
				array[2] = 2;
				array[3] = 1;
				array[4] = 8;
				array = chara.DataIntegerArray[(int)(VariableCode.PALAM & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
				//1.728 ̃^C~OSOURCEXVĂ
				array = chara.DataIntegerArray[(int)(VariableCode.SOURCE & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
				//1.728 NOWEX͂ł͍XVĂȂ

			}
		}

		public void UpdateAfterShowUsercom()
		{
			//UP = 0,DOWN = 0,LOSEBASE = 0
			Int64[] array;
			array = varData.DataIntegerArray[(int)(VariableCode.UP & VariableCode.__LOWERCASE__)];
			for (int i = 0; i < array.Length; i++)
				array[i] = 0;
			array = varData.DataIntegerArray[(int)(VariableCode.DOWN & VariableCode.__LOWERCASE__)];
			for (int i = 0; i < array.Length; i++)
				array[i] = 0;
			array = varData.DataIntegerArray[(int)(VariableCode.LOSEBASE & VariableCode.__LOWERCASE__)];
			for (int i = 0; i < array.Length; i++)
				array[i] = 0;
            //SOURCE̓Zbg^C~OႤ̂ŏ
			//1.728 NOWEXɈႤ̂ňړ
		}

		//1.728 NOWEXZbg^C~OႤ̂ňړ
		//UP,DOWN,LOSEBASEUSERCOMɈړꍇɂZbg邪NOWEXCOMsꍇ̂ݍXV
		//Ȃ̂EVENTCOMOɌĂ
		public void UpdateAfterInputCom()
		{
			//{Ƃ̎dlɂ킹AI𒆈ȊÕLN^SZbgB
			Int64[] array;
			foreach (CharacterData chara in characterList)
			{
				array = chara.DataIntegerArray[(int)(VariableCode.NOWEX & VariableCode.__LOWERCASE__)];
				for (int i = 0; i < array.Length; i++)
					array[i] = 0;
			}
		}

        //SOURCẼZbg^C~OUPADOWNALOSEBASEANOWEXƈႢSOURCECHECKIȂ̂Ő؂蕪
        public void UpdateAfterSourceCheck()
		{
			//{Ƃ̎dlɂ킹AI𒆈ȊÕLN^SZbgB
            Int64[] array;
            foreach (CharacterData chara in characterList)
            {
                array = chara.DataIntegerArray[(int)(VariableCode.SOURCE & VariableCode.__LOWERCASE__)];
                for (int i = 0; i < array.Length; i++)
                    array[i] = 0;
            }
        }

		//PREVCOM͍XVȂBXNvg̕ōXVKvB
		//DataEmueraConsole𑀍삷̂͂B
		public void UpdateInUpcheck(EmueraConsole window)
		{
			Int64[] up, down, param;
			up = varData.DataIntegerArray[(int)(VariableCode.UP & VariableCode.__LOWERCASE__)];
			down = varData.DataIntegerArray[(int)(VariableCode.DOWN & VariableCode.__LOWERCASE__)];
			Int64 target = TARGET;
			if ((target < 0) || (target >= characterList.Count))
				goto end;
			CharacterData chara = characterList[(int)target];
			param = chara.DataIntegerArray[(int)(VariableCode.PALAM & VariableCode.__LOWERCASE__)];
			int length = param.Length;
			if (param.Length > up.Length)
				length = up.Length;
			if (param.Length > down.Length)
				length = down.Length;

			for (int i = 0; i < length; i++)
			{
				//{Ƃ̎dlł͕̒l͖B
				if ((up[i] <= 0) && (down[i] <= 0))
					continue;
				StringBuilder builder = new StringBuilder();
				builder.Append(constant.ParamName[i]);
				builder.Append(' ');
				builder.Append(ToKmgtString(param[i]));
				if (up[i] > 0)
				{
					builder.Append('+');
					builder.Append(ToKmgtString(up[i]));
				}
				if (down[i] > 0)
				{
					builder.Append('-');
					builder.Append(ToKmgtString(down[i]));
				}
				unchecked { param[i] += up[i] - down[i]; }
				builder.Append('=');
				builder.Append(ToKmgtString(param[i]));
				window.Print(builder.ToString());
				window.NewLine();

			}
		end:

			for (int i = 0; i < up.Length; i++)
				up[i] = 0;
			for (int i = 0; i < down.Length; i++)
				down[i] = 0;
		}

		private static readonly string[] kMGT = { "", "k", "M", "G", "T", "P" };
		public static string ToKmgtString(Int64 integer)
		{
#if NOTUSE
			////TODO:
			////Ă͌ǂ悤B
			//ERB̕őΉ悤Ȃ̂ŔpB
			StringBuilder builer = new StringBuilder();
			if (integer < 0)
			{
				builer.Append('-');
				integer = -integer;
			}
			int i = 0;
			for (i = 0; i < kMGT.Length; i++)
			{
				if (integer < 100000)
					break;
				integer /= 1000;
			}
			builer.Append(integer.ToString());
			builer.Append(kMGT[i]);
			return builer.ToString();
#else
			return integer.ToString();
#endif
		}

		/// <summary>
		/// RESULTɔz̃TCYB񎟌zȂRESULT:1ɓԖڂ̃TCYBOzȂRESULT:1ɓԖځARESULT:2ɎOԖڂ̃TCY
		/// </summary>
		/// <param name="varID"></param>
		/// <returns></returns>
		public void VarSize(VariableIdentifier varID)
		{
			if (varID.IsArray2D)
			{
				Int64 length64;
				Int64[] resultArray = varData.DataIntegerArray[(int)(VariableCode.RESULT & VariableCode.__LOWERCASE__)];
				if (varID.IsInteger)
				{
					length64 = constant.VariableIntArray2DLength[varID.CodeInt];
				}
				else
				{
					length64 = constant.VariableStrArray2DLength[varID.CodeInt];
				}
				resultArray[0] = length64 >> 32;
				resultArray[1] = length64 & 0xFFFFFFFF;
			}
            else if (varID.IsArray3D)
            {
                Int64 length64;
                Int64[] resultArray = varData.DataIntegerArray[(int)(VariableCode.RESULT & VariableCode.__LOWERCASE__)];
                if (varID.IsInteger)
                {
                    length64 = constant.VariableIntArray3DLength[varID.CodeInt];
                }
                else
                {
                    length64 = constant.VariableStrArray3DLength[varID.CodeInt];
                }
                resultArray[0] = length64 >> 32;
                resultArray[1] = length64 >> 16;
                resultArray[2] = length64 & 0xFFFFFFFF;
            }
            else
            {
                this.RESULT = GetVariableSize(varID);
            }
		}

		public Int64 GetVariableSize(VariableIdentifier varID)
		{
            if (varID.IsArray3D)
            {
                throw new CodeEE("3zϐ\"" + varID.Code.ToString() + "\"̒擾悤Ƃ܂");
            }
            if (varID.IsArray2D)
			{
				throw new CodeEE("2zϐ\"" + varID.Code.ToString() + "\"̒擾悤Ƃ܂");
			}
			if ((!varID.IsArray1D) || (varID.Code == VariableCode.RAND))
			{
				throw new CodeEE("zϐ\"" + varID.Code.ToString() + "\"̒擾悤Ƃ܂");
			}
			if (varID.IsCalc)
			{
				switch (varID.Code)
				{
					//case CHARANUM:
					//case RAND:
					//case VariableCode.ITEMPRICE:
					//	return constant.ItemPrice.Length;
					case VariableCode.ABLNAME:
						return constant.AblName.Length;
					case VariableCode.TALENTNAME:
						return constant.TalentName.Length;
					case VariableCode.EXPNAME:
						return constant.ExpName.Length;
					case VariableCode.MARKNAME:
						return constant.MarkName.Length;
					case VariableCode.PALAMNAME:
						return constant.ParamName.Length;
					case VariableCode.ITEMNAME:
						return constant.ItemName.Length;
					case VariableCode.TRAINNAME:
						return constant.TrainName.Length;
					case VariableCode.BASENAME:
						return constant.BaseName.Length;
					case VariableCode.SOURCENAME:
						return constant.SourceName.Length;
					case VariableCode.EXNAME:
						return constant.ExName.Length;
                    case VariableCode.EQUIPNAME:
                        return constant.EquipName.Length;
                    case VariableCode.TEQUIPNAME:
                        return constant.TequipName.Length;
                    default:
						break;
				}
			}
			else if (varID.IsCharacterData)
			{
				if (varID.IsInteger)
					return constant.CharacterIntArrayLength[varID.CodeInt];
				else
					return constant.CharacterStrArrayLength[varID.CodeInt];
			}
			else
			{
				if (varID.IsInteger)
					return constant.VariableIntArrayLength[varID.CodeInt];
				else
					return constant.VariableStrArrayLength[varID.CodeInt];
			}
			throw new ExeEE("\"" + varID.Code.ToString() + "\"̒擾֐ُ̈");
		}

		public bool ItemSales(Int64 itemNo)
		{
			Int64[] itemSales = ITEMSALES;
			string[] itemNames = constant.ItemName;
			if ((itemNo < 0) || (itemNo >= itemSales.Length) || (itemNo >= itemNames.Length))
				return false;
			int index = (int)itemNo;
			return ((itemSales[index] != 0) && (itemNames[index] != null));
		}

		public bool BuyItem(Int64 itemNo)
		{

			if (!ItemSales(itemNo))
				return false;

			Int64[] itemPrice = constant.ItemPrice;
			if (itemNo >= itemPrice.Length)
				return false;
			int index = (int)itemNo;
			if (MONEY < itemPrice[index])
				return false;
			MONEY -= itemPrice[index];
			ITEM[index]++;
			BOUGHT = itemNo;
			return true;
		}

		#endregion

		//[
		public void IamaMunchkin()
		{
			if ((MASTER < 0) || (MASTER >= characterList.Count))
				return;
			if (Config.Instance.ChangeMasterNameIfDebug)
            {
                characterList[(int)MASTER].DataString[(int)(VariableCode.NAME & VariableCode.__LOWERCASE__)] = "CJT}";
				characterList[(int)MASTER].DataString[(int)(VariableCode.CALLNAME & VariableCode.__LOWERCASE__)] = "CJT}";
				characterList[(int)MASTER].DataString[(int)(VariableCode.NICKNAME & VariableCode.__LOWERCASE__)] = "CJT}";
            }
		}


		#region File
		public void SaveToStream(EraDataWriter writer, string saveDataText)
		{
			writer.Write(gamebase.ScriptUniqueCode);
			writer.Write(gamebase.ScriptVersion);
			writer.Write(saveDataText);
			writer.Write(characterList.Count);
			for (int i = 0; i < characterList.Count; i++)
			{
				characterList[i].SaveToStream(writer);
			}
			varData.SaveToStream(writer);
			writer.EmuStart();
			for (int i = 0; i < characterList.Count; i++)
			{
				characterList[i].SaveToStreamExtended(writer);
			}
			varData.SaveToStreamExtended(writer);
		}

		public void LoadFromStream(EraDataReader reader, int dataIndex)
		{
			if (reader.ReadInt64() != gamebase.ScriptUniqueCode)
				throw new FileEE("قȂQ[̃Z[uf[^ł");
			Int64 version = reader.ReadInt64();
			if ( ((gamebase.ScriptVersion != version) && (gamebase.ScriptVersionDefined || version != 1000)) 
				&& (gamebase.ScriptCompatibleMinVersion > version))
				throw new FileEE("Z[uf[^̃o[VقȂ܂");
			string text = reader.ReadString();//PUTFORM
			varData.SetDefalutValue(constant);
			varData.SetDefalutLocalValue();
			varData.LastLoadVersion = version;
			varData.LastLoadNo = dataIndex;
			varData.LastLoadText = text;

			int charaCount = (int)reader.ReadInt64();
			characterList.Clear();
			for (int i = 0; i < charaCount; i++)
			{
				CharacterData chara = new CharacterData(constant);
				characterList.Add(chara);
				chara.LoadFromStream(reader);
			}
			varData.LoadFromStream(reader);
			if (reader.SeekEmuStart())
			{

				for (int i = 0; i < charaCount; i++)
				{
					characterList[i].LoadFromStreamExtended(reader);
				}
				varData.LoadFromStreamExtended(reader);
			}
        }

		public void SaveGlobalToStream(EraDataWriter writer)
		{
			writer.Write(gamebase.ScriptUniqueCode);
			writer.Write(gamebase.ScriptVersion);
			varData.SaveGlobalToStream(writer);
		}

		public bool LoadGlobalFromStream(EraDataReader reader)
		{
			try
			{
				if (reader.ReadInt64() != gamebase.ScriptUniqueCode)
					return false;
				//	throw new FileEE("قȂQ[̃Z[uf[^ł");
				Int64 version = reader.ReadInt64();
				if (((gamebase.ScriptVersion != version) && (gamebase.ScriptVersionDefined || version != 1000))
					&& (gamebase.ScriptCompatibleMinVersion > version))
					return false;
				//	throw new FileEE("Z[uf[^̃o[VقȂ܂");
				varData.LoadGlobalFromStream(reader);
				return true;
			}
			catch
			{
				return false;
			}
		}
		#endregion
		#region IDisposable o

		public void Dispose()
		{


			varData.Dispose();

			for (int i = 0; i < characterList.Count; i++)
				characterList[i].Dispose();
			characterList.Clear();
		}

		#endregion
		#region Property
		public Int64 RESULT
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.RESULT & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.RESULT & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 COUNT
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.COUNT & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.COUNT & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public string RESULTS
		{
			get
			{
				string ret = varData.DataStringArray[(int)(VariableCode.RESULTS & VariableCode.__LOWERCASE__)][0];
				if (ret == null)
					return "";
				return ret;
			}
			set { varData.DataStringArray[(int)(VariableCode.RESULTS & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 TARGET
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.TARGET & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.TARGET & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 MASTER
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.MASTER & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.MASTER & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 ASSI
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.ASSI & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.ASSI & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 ASSIPLAY
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.ASSIPLAY & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.ASSIPLAY & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 PREVCOM
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.PREVCOM & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.PREVCOM & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 SELECTCOM
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.SELECTCOM & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.SELECTCOM & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public Int64 NEXTCOM
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.NEXTCOM & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.NEXTCOM & VariableCode.__LOWERCASE__)][0] = value; }
		}

		public string[] ITEMNAME
		{
			get { return constant.ItemName; }
		}

		public Int64[] ITEMSALES
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.ITEMSALES & VariableCode.__LOWERCASE__)]; }
		}

		public Int64[] ITEMPRICE
		{
			get { return constant.ItemPrice; }
		}

		private Int64[] ITEM
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.ITEM & VariableCode.__LOWERCASE__)]; }
		}

		public Int64[] RANDDATA
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.RANDDATA & VariableCode.__LOWERCASE__)]; }
		}

		private Int64 MONEY
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.MONEY & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.MONEY & VariableCode.__LOWERCASE__)][0] = value; }
		}

		private Int64 BOUGHT
		{
			get { return varData.DataIntegerArray[(int)(VariableCode.BOUGHT & VariableCode.__LOWERCASE__)][0]; }
			set { varData.DataIntegerArray[(int)(VariableCode.BOUGHT & VariableCode.__LOWERCASE__)][0] = value; }
		}
		public string SAVEDATA_TEXT
		{
			get { return varData.DataString[(int)(VariableCode.SAVEDATA_TEXT & VariableCode.__LOWERCASE__)]; }
			set { varData.DataString[(int)(VariableCode.SAVEDATA_TEXT & VariableCode.__LOWERCASE__)] = value; }
		}
		#endregion

	}

	//public class ForwardSort : IComparer
	//{
	//    int IComparer.Compare(Object x, Object y)
	//    {
	//        CharacterData charaA = (CharacterData)x;
	//        CharacterData charaB = (CharacterData)y;
	//        return (int)(charaA.DataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO] - charaB.DataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO]);
	//    }
	//}

	//public class InverseSort : IComparer
	//{
	//    int IComparer.Compare(Object x, Object y)
	//    {
	//        CharacterData charaA = (CharacterData)x;
	//        CharacterData charaB = (CharacterData)y;
	//        return (int)(charaB.DataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO] - charaA.DataInteger[(int)VariableCode.__LOWERCASE__ & (int)VariableCode.NO]);
	//    }
	//}
}
