﻿using System;
using System.Collections.Generic;
using System.Text;

namespace MinorShift.Emuera.GameData.Expression
{
	internal enum CaseExpressionType
	{
		Normal = 1,
		To = 2,
		Is = 3,
	}
	internal sealed class CaseExpression
	{
		public CaseExpressionType CaseType = CaseExpressionType.Normal;
		public IOperandTerm LeftTerm;
		public IOperandTerm RightTerm;

		public OperatorCode Operator;
		public Type GetOperandType()
		{
			if(LeftTerm != null)
			return LeftTerm.GetOperandType();
			return typeof(void);
		}
		public override string ToString()
		{
			switch (CaseType)
			{
				case CaseExpressionType.Normal:
					return LeftTerm.ToString();
				case CaseExpressionType.Is:
					return "Is " + Operator.ToString() + " " + LeftTerm.ToString();
				case CaseExpressionType.To:
					return LeftTerm.ToString() + " To " + RightTerm.ToString();
			}

			return base.ToString();
		}

	}
}

