using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Text.RegularExpressions;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
namespace MinorShift.Emuera.GameProc
{

	internal sealed partial class Process
	{
		private sealed class ErbLoader
		{
			public ErbLoader(EmueraConsole main, VariableEvaluator var)
			{
				output = main;
				varData = var;
			}
			readonly EmueraConsole output;
			readonly VariableEvaluator varData;
			Dictionary<string, int> ignoredWarningCount = new Dictionary<string, int>();
			List<string> ignoredFNFWarningFileList = new List<string>();
			int ignoredFNFWarningCount = 0;

			int enabledLineCount = 0;
			int lineCount = 0;
			LabelDictionary labelDic;


			/// <summary>
			/// ̃t@Cǂ
			/// </summary>
			/// <param name="filepath"></param>
			public void LoadErbFiles(string erbDir, bool displayReport, LabelDictionary labelDictionary)
			{
				//1.713 labelDicnewʒuύXB
				//checkScript();̎_ExpressionPerserProcess.instance.LabelDicKvƂ邩B
				labelDic = labelDictionary;
				List<KeyValuePair<string, string>> erbFiles = Config.Instance.GetFiles(erbDir, "*.ERB");
				int first = Environment.TickCount;
				try
				{
					for (int i = 0; i < erbFiles.Count; i++)
					{
						string file = erbFiles[i].Value;
						string filename = erbFiles[i].Key;
#if DEBUG
						if (Config.Instance.DisplayReport)
							output.PrintLine(filename + "ǂݍݒEEE" + (Environment.TickCount - first).ToString() + ":");
#else
						if (displayReport)
							output.PrintLine(filename + "ǂݍݒEEE");
#endif
						System.Windows.Forms.Application.DoEvents();
						loadErb(file, filename);
					}
					checkScript();
				}
				catch (CodeEE e)
				{
					if (e.Position != null)
					{
						output.PrintLine(e.Position.Filename + "" + e.Position.LineNo.ToString() + "sڂŃG[܂");
						output.PrintLine(e.Position.RowLine);
					}
					output.PrintLine(e.Message);
					return;
				}
				catch (Exception e)
				{
					output.PrintLine("\ȂG[܂");
					output.PrintLine(e.GetType().ToString() + ":" + e.Message);
					return;
				}
				return;
			}

			/// <summary>
			/// t@Cǂ
			/// </summary>
			/// <param name="filepath"></param>
			private void loadErb(string filepath, string filename)
			{
				EraStreamReader eReader = new EraStreamReader();
				if (!eReader.Open(filepath, filename))
				{
					output.PrintLine(eReader.Filename + "̃I[vɎs܂");
					return;
				}
				try
				{
					string line = null;
					LogicalLine lastLine = new NullLine();
					FunctionLabelLine lastLabelLine = null;
					StringStream st = null;
					bool skip = false;
					string rowLine = null;
					while ((line = eReader.ReadLine()) != null)
					{
						lineCount++;
						if (line.Length == 0)
							continue;
						rowLine = line;
						st = new StringStream(line);
						TokenReader.SkipWhiteSpace(st);
						if (st.Current == ';')
						{
							if (!st.CurrentEqualTo(";!;"))
								continue;
							st.ShiftNext();
							st.ShiftNext();
							st.ShiftNext();
							TokenReader.SkipWhiteSpace(st);
							if (st.Current == ';')
								continue;
						}
						if (st.EOS)
							continue;
						line = st.Substring();
						if (Config.Instance.UseRenameFile)
							line = applyRename(line);
						st = new StringStream(line);
						ScriptPosition position = new ScriptPosition(eReader.Filename, eReader.LineNo, rowLine);
						if (st.Current == '[')
						{
							st.ShiftNext();
							if (TokenReader.GetNextTokenType(st) != TokenType.Identifer)
								output.PrintWarning("[]̎gsł", position, 1);
							string token = TokenReader.ReadSingleIdentifer(st);
							if ((token == null) || (st.Current != ']'))
								output.PrintWarning("[]̎gsł", position, 1);
							switch (token)
							{
								case "SKIPSTART":
									if (skip)
										output.PrintWarning("[SKIPSTART]dĎgpĂ܂", position, 1);
									skip = true;
									break;
								case "SKIPEND":
									if (!skip)
										output.PrintWarning("[SKIPSTART]ƑΉȂ[SKIPEND]ł", position, 1);
									skip = false;
									break;
								default:
									output.PrintWarning("FłȂvvZbTł", position, 1);
									break;
							}
							continue;
						}
						if (skip == true)
							continue;
						//܂ŃvvZbT

						if (st.Current == '#')
						{
							if (!(lastLine is FunctionLabelLine))
							{
								output.PrintWarning("֐錾̒ȊO#sgĂ܂", position, 1);
								continue;
							}
							FunctionLabelLine label = (FunctionLabelLine)lastLine;
							st.ShiftNext();
							string token = TokenReader.ReadSingleIdentifer(st);
							if (token == null)
							{
								output.PrintWarning("߂łȂ#sł", position, 1);
								continue;
							}
							if (Config.Instance.IgnoreCase)
								token = token.ToUpper();
							switch (token)
							{
								case "SINGLE": label.IsSingle = true; break;
								case "LATER": label.Priority++; break;
								case "PRI": label.Priority--; break;
								case "FUNCTION": label.IsMethod = true; label.Depth = 0; label.MethodType = typeof(Int64); break;
								case "FUNCTIONS": label.IsMethod = true; label.Depth = 0; label.MethodType = typeof(string); break;
								default:
									output.PrintWarning("߂łȂ#sł", position, 1);
									break;
							}
							continue;
						}
						LogicalLine nextLine = LogicalLineParser.ParseLine(st, position, output);

						if (nextLine == null)
							continue;
						if (nextLine is InvalidLine)
						{
							output.PrintWarning(nextLine.ErrMes, position, 2);
						}
						else if (nextLine is FunctionLabelLine)
						{
							FunctionLabelLine label = (FunctionLabelLine)nextLine;
							labelDic.AddLabel(label);
							lastLabelLine = label;
							//if (labelDic.IsOverride(label))
							//    output.PrintWarning("Cxg֐d`Ă܂", position, 0);
						}
						else if (nextLine is GotoLabelLine)
						{
							GotoLabelLine gotoLabel = (GotoLabelLine)nextLine;
							gotoLabel.SetParentFunction(lastLabelLine);
							if (!labelDic.AddLabelDollar((GotoLabelLine)nextLine))
								output.PrintWarning("x$" + line + "͊ɂ̊֐ŎgpĂ܂", position, 2);
						}
						if (lastLabelLine == null)
							output.PrintWarning("֐`Oɍs܂", position, 1);
						else
							lastLine = addLine(nextLine, lastLine);
					}
					addLine(new NullLine(), lastLine);
				}
				finally
				{
					eReader.Close();
				}
				return;
			}


			private LogicalLine addLine(LogicalLine nextLine, LogicalLine lastLine)
			{
				if (nextLine == null)
					return null;
				enabledLineCount++;
				nextLine.PrevLine = lastLine;
				lastLine.NextLine = nextLine;
				return nextLine;
			}

			Dictionary<string, string> renameDic = null;
			internal void LoadEraExRenameFile(string filepath)
			{
				EraStreamReader eReader = new EraStreamReader();
				if ((!File.Exists(filepath)) || (!eReader.Open(filepath)))
				{
					return;
				}

				renameDic = new Dictionary<string, string>();
				string line = null;
				ScriptPosition pos = null;
				try
				{
					while ((line = eReader.ReadLine()) != null)
					{
						if (line.Length == 0)
							continue;
						if (line.StartsWith(";"))
							continue;
						string[] tokens = line.Split(',');
						if (tokens.Length < 2)
							continue;
						pos = new ScriptPosition(eReader.Filename, eReader.LineNo, line);
						//EERB̕\LAϊɂȂB
						string value = tokens[0].Trim();
						string key = string.Format("[[{0}]]", tokens[1].Trim());
						renameDic[key] = value;
						pos = null;
					}
				}
				catch (Exception e)
				{
					if (pos != null)
						throw new CodeEE(e.Message, pos);
					else
						throw new CodeEE(e.Message);

				}
				finally
				{
					eReader.Close();
				}

			}

			private string applyRename(string rowLine)
			{
				if ((rowLine.IndexOf("[[") < 0) || (rowLine.IndexOf("]]") < 0))
					return rowLine;
				if (renameDic == null)
					return rowLine;
				string ret = rowLine;
				foreach (KeyValuePair<string, string> pair in renameDic)
					ret = ret.Replace(pair.Key, pair.Value);
				return ret;
			}

			public bool useCallForm = false;
			/// <summary>
			/// ǍIt@C`FbN
			/// </summary>
			private void checkScript()
			{
				int usedLabelCount = 0;
				int labelDepth = -1;
				List<FunctionLabelLine> labelList = labelDic.GetAllLabels();
				while (true)
				{
					labelDepth++;
					int countInDepth = 0;
					foreach (FunctionLabelLine label in labelList)
					{
						if (label.Depth != labelDepth)
							continue;
						usedLabelCount++;
						countInDepth++;
						checkFunction(label);
					}
					if (countInDepth == 0)
						break;
				}
				labelDepth = -1;
				List<string> ignoredFNCWarningFileList = new List<string>();
				int ignoredFNCWarningCount = 0;

				bool ignoreAll = false;
				switch (Config.Instance.FunctionNotCalledWarning)
				{
					case DisplayWarningFlag.IGNORE:
					case DisplayWarningFlag.LATER:
						ignoreAll = true;
						break;
				}
				if (useCallForm)
				{//callformngꂽSĂ̊֐ĂяoꂽƂ݂ȂB
					foreach (FunctionLabelLine label in labelList)
					{
						if (label.Depth != labelDepth)
							continue;
						checkFunction(label);
					}
				}
				else
				{
					foreach (FunctionLabelLine label in labelList)
					{
						if (label.Depth != labelDepth)
							continue;
						bool ignore = false;
						if (Config.Instance.FunctionNotCalledWarning == DisplayWarningFlag.ONCE)
						{
							string filename = label.Position.Filename.ToUpper();

							if (!string.IsNullOrEmpty(filename))
							{
								if (ignoredFNCWarningFileList.Contains(filename))
								{
									ignore = true;
								}
								else
								{
									ignore = false;
									ignoredFNCWarningFileList.Add(filename);
								}
							}
							break;
						}
						if (ignoreAll || ignore)
							ignoredFNCWarningCount++;
						else
							printWarning("֐@" + label.LabelName + "͒`Ă܂xĂяo܂", label, 1, false);
						if (!Config.Instance.IgnoreUncalledFunction)
							checkFunction(label);
						else
						{
							if (!(label.NextLine is NullLine) && !(label.NextLine is FunctionLabelLine))
							{
								if (!label.NextLine.IsError)
								{
									label.NextLine.IsError = true;
									label.NextLine.ErrMes = "ĂяoȂ͂̊֐Ă΂ꂽ";
								}
							}
						}
					}
				}
				if ((ignoredFNCWarningCount > 0) && (Config.Instance.DisplayWarningLevel <= 1) && (Config.Instance.FunctionNotCalledWarning != DisplayWarningFlag.IGNORE))
					output.PrintLine(string.Format("xLv1:`ꂽ֐xĂяoĂȂɊւx{0}܂", ignoredFNCWarningCount));
				if ((ignoredFNFWarningCount > 0) && (Config.Instance.DisplayWarningLevel <= 2) && (Config.Instance.FunctionNotCalledWarning != DisplayWarningFlag.IGNORE))
					output.PrintLine(string.Format("xLv2:`ĂȂ֐ĂяoɊւx{0}܂", ignoredFNFWarningCount));
				foreach (KeyValuePair<string, int> pair in ignoredWarningCount)
				{
					output.PrintLine(string.Format("xLv{0}ȏ:{1}:{2}̃G[𖳎܂", Config.Instance.DisplayWarningLevel, pair.Key, pair.Value));
				}
				if (Config.Instance.DisplayReport)
					output.PrintLine(string.Format("Ss:{0}, Rgs:{1}, S֐v:{2}, ďo֐v:{3}", lineCount, enabledLineCount, labelDic.Count, usedLabelCount));

			}

			/// <summary>
			/// 
			/// </summary>
			/// <param name="str"></param>
			/// <param name="line"></param>
			/// <param name="level">xx.0:yȃ~X.1:łs.2:ssȂΖQ.3:vI</param>
			private void printWarning(string str, LogicalLine line, int level, bool isError)
			{
				if (isError)
				{
					line.IsError = true;
					line.ErrMes = str;
				}
				if (level < Config.Instance.DisplayWarningLevel)
					return;
				if ((line.Position != null) && (line.Position.Filename != null))
				{
					string filename = line.Position.Filename.ToUpper();
					if (!string.IsNullOrEmpty(filename))
					{
						if (Config.Instance.IgnoreWarningFiles.Contains(filename))
						{
							if (ignoredWarningCount.ContainsKey(filename))
								ignoredWarningCount[filename]++;
							else
								ignoredWarningCount.Add(filename, 1);
							return;
						}
					}
				}
				output.PrintWarning(str, line.Position, level);
			}

			private void printFunctionNotFoundWarning(string str, LogicalLine line, int level, bool isError)
			{
				if (isError)
				{
					line.IsError = true;
					line.ErrMes = str;
				}
				if (level < Config.Instance.DisplayWarningLevel)
					return;
				bool ignore = false;
				if (Config.Instance.FunctionNotFoundWarning == DisplayWarningFlag.IGNORE)
					ignore = true;
				else if (Config.Instance.FunctionNotFoundWarning == DisplayWarningFlag.DISPLAY)
					ignore = false;
				else if (Config.Instance.FunctionNotFoundWarning == DisplayWarningFlag.ONCE)
				{

					string filename = line.Position.Filename.ToUpper();
					if (!string.IsNullOrEmpty(filename))
					{
						if (ignoredFNFWarningFileList.Contains(filename))
						{
							ignore = true;
						}
						else
						{
							ignore = false;
							ignoredFNFWarningFileList.Add(filename);
						}
					}
				}
				if (ignore)
				{
					ignoredFNFWarningCount++;
					return;
				}
				printWarning(str, line, level, isError);
			}

			private void checkFunction(FunctionLabelLine label)
			{
				System.Windows.Forms.Application.DoEvents();
				int depth = label.Depth;
				if (depth < 0)
					depth = -2;
				LogicalLine nextLine = label;
				string filename = null;
				if (label.Position.Filename != null)
					filename = label.Position.Filename.ToUpper();
				bool ignoreWarning = false;
				if (!string.IsNullOrEmpty(filename))
					ignoreWarning = Config.Instance.IgnoreWarningFiles.Contains(filename);
				//1/3
				//̉͂Ƃ
				while (true)
				{
					nextLine = nextLine.NextLine;
					if ((nextLine is NullLine) || (nextLine is FunctionLabelLine))
						break;
					if (!(nextLine is InstructionLine))
						continue;
					InstructionLine func = (InstructionLine)nextLine;
					if (label.IsMethod)
					{
						if ((func.Function & BuiltInFunctionCode.__METHOD_SAFE__) != BuiltInFunctionCode.__METHOD_SAFE__)
						{
							printWarning(func.Function.ToString() + "߂#FUNCTIONŎgƂ͂ł܂", nextLine, 2, true);
							break;
						}
					}
					if (Config.Instance.NeedReduceArgumentOnLoad)
						LogicalLineParser.SetArgumentTo(func, this.printWarning);
				}

				//2/3
				//IF-ELSEIF-ENDIFAREPEAT-REND̑Ή`FbNȂ
				nextLine = label;
				Stack<InstructionLine> nestStack = new Stack<InstructionLine>();
				InstructionLine pairLine = null;
				while (true)
				{
					nextLine = nextLine.NextLine;
					if ((nextLine is NullLine) || (nextLine is FunctionLabelLine))
						break;
					if (!(nextLine is InstructionLine))
						continue;
					InstructionLine func = (InstructionLine)nextLine;
					switch (func.Function)
					{
						case BuiltInFunctionCode.REPEAT:
							foreach (InstructionLine iLine in nestStack)
							{
								if (iLine.Function == BuiltInFunctionCode.REPEAT)
								{
									printWarning("REPEATqɂĂ܂", func, 2, true);
									break;
								}
							}
							if (func.IsError)
								break;
							nestStack.Push(func);
							break;
						case BuiltInFunctionCode.IF:
							nestStack.Push(func);
							func.IfList = new List<InstructionLine>();
							func.IfList.Add(func);
							break;
						case BuiltInFunctionCode.FOR:
						case BuiltInFunctionCode.WHILE:
						case BuiltInFunctionCode.TRYCGOTO:
						case BuiltInFunctionCode.TRYCJUMP:
						case BuiltInFunctionCode.TRYCCALL:
						case BuiltInFunctionCode.TRYCGOTOFORM:
						case BuiltInFunctionCode.TRYCJUMPFORM:
						case BuiltInFunctionCode.TRYCCALLFORM:
							nestStack.Push(func);
							break;
						case BuiltInFunctionCode.BREAK:
						case BuiltInFunctionCode.CONTINUE:
							pairLine = null;
							InstructionLine[] array = nestStack.ToArray();
							for (int i = 0; i < array.Length; i++)
							{
								if ((array[i].Function == BuiltInFunctionCode.REPEAT)
									|| (array[i].Function == BuiltInFunctionCode.FOR)
									|| (array[i].Function == BuiltInFunctionCode.WHILE))
								{
									pairLine = array[i];
									break;
								}
							}
							if (pairLine == null)
							{
								printWarning("REPEAT, FOR, WHILE̒ȊO" + func.Function.ToString() + "g܂", func, 2, true);
								break;
							}
							func.JumpTo = pairLine;
							break;

						case BuiltInFunctionCode.ELSEIF:
						case BuiltInFunctionCode.ELSE:
							{
								InstructionLine ifLine = nestStack.Peek();
								if ((ifLine == null) || (ifLine.Function != BuiltInFunctionCode.IF))
								{
									printWarning("IF`ENDIF̊O" + func.Function.ToString() + "g܂", func, 2, true);
									break;
								}
								if (ifLine.IfList[ifLine.IfList.Count - 1].Function == BuiltInFunctionCode.ELSE)
									printWarning("ELSE" + func.Function.ToString() + "g܂", func, 1, false);
								else
									ifLine.IfList.Add(func);
							}
							break;
						case BuiltInFunctionCode.ENDIF:
							{
								InstructionLine ifLine = nestStack.Peek();
								if ((ifLine == null) || (ifLine.Function != BuiltInFunctionCode.IF))
								{
									printWarning("ΉIF̖ENDIFł", func, 2, true);
									break;
								}
								foreach (InstructionLine ifelseifLine in ifLine.IfList)
								{
									ifelseifLine.JumpTo = func;
									if ((!ifelseifLine.IsError) && (ifelseifLine.Argument == null))
										LogicalLineParser.SetArgumentTo(ifelseifLine, this.printWarning);
								}
								nestStack.Pop();
							}
							break;
						case BuiltInFunctionCode.REND:
							if ((nestStack.Count == 0)
								|| (nestStack.Peek().Function != BuiltInFunctionCode.REPEAT))
							{
								printWarning("ΉREPEAT̖RENDł", func, 2, true);
								break;
							}
							pairLine = nestStack.Pop();//REPEAT
							func.JumpTo = pairLine;
							pairLine.JumpTo = func;
							break;
						case BuiltInFunctionCode.NEXT:
							if ((nestStack.Count == 0)
								|| (nestStack.Peek().Function != BuiltInFunctionCode.FOR))
							{
								printWarning("ΉFOR̖NEXTł", func, 2, true);
								break;
							}
							pairLine = nestStack.Pop();//FOR
							func.JumpTo = pairLine;
							pairLine.JumpTo = func;
							break;
						case BuiltInFunctionCode.WEND:
							if ((nestStack.Count == 0)
								|| (nestStack.Peek().Function != BuiltInFunctionCode.WHILE))
							{
								printWarning("ΉWHILE̖WENDł", func, 2, true);
								break;
							}
							pairLine = nestStack.Pop();//WHILE
							func.JumpTo = pairLine;
							pairLine.JumpTo = func;
							break;
						case BuiltInFunctionCode.CATCH:
							pairLine = nestStack.Peek();
							if ((pairLine == null)
								|| ((pairLine.Function != BuiltInFunctionCode.TRYCGOTO)
								&& (pairLine.Function != BuiltInFunctionCode.TRYCCALL)
								&& (pairLine.Function != BuiltInFunctionCode.TRYCJUMP)
								&& (pairLine.Function != BuiltInFunctionCode.TRYCGOTOFORM)
								&& (pairLine.Function != BuiltInFunctionCode.TRYCCALLFORM)
								&& (pairLine.Function != BuiltInFunctionCode.TRYCJUMPFORM)))
							{
								printWarning("ΉTRYCn߂܂", func, 2, true);
								break;
							}
							pairLine = nestStack.Pop();//TRYC
							pairLine.JumpToEndCatch = func;//TRYCCATCḦʒu
							nestStack.Push(func);
							break;
						case BuiltInFunctionCode.ENDCATCH:
							if ((nestStack.Count == 0)
								|| (nestStack.Peek().Function != BuiltInFunctionCode.CATCH))
							{
								printWarning("ΉCATCĤȂENDCATCHł", func, 2, true);
								break;
							}
							pairLine = nestStack.Pop();//CATCH
							pairLine.JumpToEndCatch = func;//CATCHENDCATCḦʒu
							break;
					}

				}

				while (nestStack.Count != 0)
				{
					InstructionLine func = nestStack.Pop();
					string funcName = func.Function.ToString();
					switch (func.Function)
					{
						case BuiltInFunctionCode.REPEAT:
							printWarning(funcName + "ɑΉREND܂", func, 2, true);
							break;
						case BuiltInFunctionCode.IF:
							printWarning(funcName + "ɑΉENDIF܂", func, 2, true);
							break;
						case BuiltInFunctionCode.FOR:
							printWarning(funcName + "ɑΉNEXT܂", func, 2, true);
							break;
						case BuiltInFunctionCode.WHILE:
							printWarning(funcName + "ɑΉWEND܂", func, 2, true);
							break;
						case BuiltInFunctionCode.TRYCGOTO:
						case BuiltInFunctionCode.TRYCJUMP:
						case BuiltInFunctionCode.TRYCCALL:
						case BuiltInFunctionCode.TRYCGOTOFORM:
						case BuiltInFunctionCode.TRYCJUMPFORM:
						case BuiltInFunctionCode.TRYCCALLFORM:
							printWarning(funcName + "ɑΉCATCH܂", func, 2, true);
							break;
						case BuiltInFunctionCode.CATCH:
							printWarning(funcName + "ɑΉENDCATCH܂", func, 2, true);
							break;
						default:
							printWarning("fBtHgG[iEmueraݒRj", func, 2, true);
							break;
					}
				}

				//3/3
				//t[䖽߂̃Wvݒ
				nextLine = label;
				LogicalLine jumpto = null;
				while (true)
				{
					nextLine = nextLine.NextLine;
					if ((nextLine is NullLine) || (nextLine is FunctionLabelLine))
						break;
					if (!(nextLine is InstructionLine))
						continue;
					if (nextLine.IsError)
						continue;
					InstructionLine func = (InstructionLine)nextLine;
					switch (func.Function)
					{
						case BuiltInFunctionCode.SIF:

							jumpto = func.NextLine;

							if ((jumpto == null) || (jumpto.NextLine == null) ||
							(jumpto is FunctionLabelLine) || (jumpto is NullLine))
								printWarning("SIF̃Xe[gg܂", nextLine, 2, true);
							else if (jumpto is InstructionLine)
							{
								InstructionLine sifFunc = (InstructionLine)jumpto;
								switch (sifFunc.Function)
								{
									case BuiltInFunctionCode.SIF:
									case BuiltInFunctionCode.IF:
									case BuiltInFunctionCode.ELSEIF:
									case BuiltInFunctionCode.ELSE:
									case BuiltInFunctionCode.ENDIF:
									case BuiltInFunctionCode.REPEAT:
									case BuiltInFunctionCode.REND:
									case BuiltInFunctionCode.FOR:
									case BuiltInFunctionCode.NEXT:
									case BuiltInFunctionCode.WHILE:
									case BuiltInFunctionCode.WEND:
									case BuiltInFunctionCode.CATCH:
									case BuiltInFunctionCode.ENDCATCH:
										printWarning("SIF̎̍s" + sifFunc.Function.ToString() + "ɂ邱Ƃ͂ł܂", nextLine, 2, true);
										break;
									default:
										func.JumpTo = func.NextLine.NextLine;
										break;
								}
							}
							else
								func.JumpTo = func.NextLine.NextLine;
							break;
						case BuiltInFunctionCode.GOTO://$xփWv
						case BuiltInFunctionCode.TRYGOTO:
                        case BuiltInFunctionCode.TRYCGOTO:
                            {
								string labelName = func.ArgumentStr.Trim();
								if (Config.Instance.IgnoreCase)
									labelName = labelName.ToUpper();
								jumpto = labelDic.GetLabelDollar(labelName, label);
								if ((jumpto == null) && (func.Function == BuiltInFunctionCode.GOTO))
									printWarning("w肳ꂽx\"$" + labelName + "\"݂͌̊֐ɑ݂܂", nextLine, 2, true);
                                else if (jumpto != null)
                                {
                                    func.JumpTo = jumpto;
                                }
                            }
							break;
                        case BuiltInFunctionCode.JUMP:
                        case BuiltInFunctionCode.TRYJUMP:
                        case BuiltInFunctionCode.TRYCJUMP:
						case BuiltInFunctionCode.CALL://֐ɈړBړLARETURNŋAB
						case BuiltInFunctionCode.TRYCALL:
                        case BuiltInFunctionCode.TRYCCALL:
                            {
                                if (func.Argument == null)
                                    LogicalLineParser.SetArgumentTo(func, this.printWarning);
                                SpCallArgment callArg = (SpCallArgment)func.Argument;
                                string labelName = callArg.Str;
                                if (Config.Instance.IgnoreCase)
                                    labelName = labelName.ToUpper();
                                FunctionLabelLine targetLabel = labelDic.GetLabel(labelName);
								if ((targetLabel == null)
									&& ((func.Function == BuiltInFunctionCode.CALL)
									|| (func.Function == BuiltInFunctionCode.JUMP)))
								{
									printFunctionNotFoundWarning("w肳ꂽ֐\"@" + labelName + "\"݂͑܂", nextLine, 2, true);
									break;
								}
								if (targetLabel != null)
								{
									func.JumpTo = targetLabel;
									if (targetLabel.Depth < 0)
										targetLabel.Depth = depth + 1;
									checkArgs(targetLabel, callArg.Args, nextLine);
								}

                             }
                            break;
						case BuiltInFunctionCode.RESTART:
							func.JumpTo = label;
							break;

						case BuiltInFunctionCode.JUMPFORM:
						case BuiltInFunctionCode.CALLFORM:
						//case BuiltInFunctionCode.GOTOFORM:
						case BuiltInFunctionCode.TRYJUMPFORM:
						case BuiltInFunctionCode.TRYCALLFORM:
						//case BuiltInFunctionCode.TRYGOTOFORM:
                        case BuiltInFunctionCode.TRYCJUMPFORM:
                        case BuiltInFunctionCode.TRYCCALLFORM:
                        //case BuiltInFunctionCode.TRYCGOTOFORM:
                            useCallForm = true;
							break;
						case BuiltInFunctionCode.RETURNF:
							{
								if (!label.IsMethod)
								{
									printWarning("RETURNF#FUCNTIONȊOł͎gpł܂", nextLine, 2, true);
								}
								if ((func.Argument != null) && (!func.IsError))
								{
									ExpressionArgument expArg = (ExpressionArgument)func.Argument;
									IOperandTerm term = ((ExpressionArgument)func.Argument).Term;
									if (term != null)
									{
										if (label.MethodType != term.GetOperandType())
										{
											if (label.MethodType == typeof(Int64))
												printWarning("#FUCNTIONŎn܂֐̖߂lɕ^w肳܂", nextLine, 2, true);
											else if (label.MethodType == typeof(string))
												printWarning("#FUCNTIONSŎn܂֐̖߂lɐl^w肳܂", nextLine, 2, true);
											else if (label.MethodType == typeof(string))
												printWarning("֐̌^Ɩ߂ľ^v܂", nextLine, 2, true);
										}
										break;
									}
								}
							}
							break;
					}
				}
			}

			private bool checkArgs(FunctionLabelLine targetLabel, IOperandTerm[] args, LogicalLine nextLine)
			{
				if (args.Length == 0)
					return true;
				if (targetLabel.Arg.Length < args.Length)
				{
					printWarning("̐֐\"@" + targetLabel.LabelName + "\"ɐݒ肳ꂽ𒴂Ă܂", nextLine, 2, true);
					return false;
				}

				for (int i = 0; i < args.Length; i++)
				{
					if (args[i] == null)
						continue;
					if ((args[i].GetOperandType() == typeof(string)) && (targetLabel.Arg[i].GetOperandType() == typeof(Int64)))
					{
						printWarning((i + 1).ToString() + "Ԗڂ̈̌^֐\"@" + targetLabel.LabelName + "\"ɐݒ肳ꂽ̌^ƈv܂", nextLine, 2, true);
						return false;
					}
				}
				return true;
			}
		}
	}
}
