﻿using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameData.Variable;

namespace MinorShift.Emuera.GameProc
{
	//1.713 LogicalLine.csから分割
	/// <summary>
	/// ラベルのジャンプ先の辞書。Erbファイル読み込み時に作成
	/// </summary>
	internal sealed class LabelDictionary
	{
		Dictionary<string, List<FunctionLabelLine>> labelAtDic = new Dictionary<string, List<FunctionLabelLine>>();
		List<GotoLabelLine> labelDollarList = new List<GotoLabelLine>();
		int count;

		public int Count { get { return count; } }
		public bool IsOverride(FunctionLabelLine point)
		{
			string id = point.LabelName;
			if (!labelAtDic.ContainsKey(id))
				return false;
			switch (id)
			{
				case "EVENTTRAIN":
				case "EVENTFIRST":
				case "EVENTCOM":
				case "EVENTCOMEND":
				case "EVENTEND":
				case "EVENTSHOP":
				case "EVENTBUY":
				case "EVENTTURNEND":

				case "EVENTLOAD":
					return false;
			}
			List<FunctionLabelLine> labelList = labelAtDic[id];
			return labelList.Count > 1;
		}

		public void AddLabel(FunctionLabelLine point)
		{
			string id = point.LabelName;
			if (labelAtDic.ContainsKey(id))
			{
				labelAtDic[id].Add(point);
			}
			else
			{
				List<FunctionLabelLine> labelList = new List<FunctionLabelLine>();
				labelAtDic.Add(id, labelList);
				labelAtDic[id].Add(point);
			}
			point.Index = count;
			count++;
		}

		public bool AddLabelDollar(GotoLabelLine point)
		{
			string id = point.LabelName;
			foreach (GotoLabelLine label in labelDollarList)
			{
				if (label == point)
					return false;
			}
			labelDollarList.Add(point);
			return true;
		}

		public List<FunctionLabelLine> GetLabels(string key)
		{
			if (labelAtDic.ContainsKey(key))
				return labelAtDic[key];
			return new List<FunctionLabelLine>();
		}

		public FunctionLabelLine GetLabel(string key)
		{
			if (labelAtDic.ContainsKey(key))
				return labelAtDic[key][0];
			return null;
		}

		public List<FunctionLabelLine> GetAllLabels()
		{
			List<FunctionLabelLine> ret = new List<FunctionLabelLine>();
			foreach (List<FunctionLabelLine> list in labelAtDic.Values)
				ret.AddRange(list);
			return ret;
		}

		public GotoLabelLine GetLabelDollar(string key, FunctionLabelLine labelAtLine)
		{
			foreach (GotoLabelLine label in labelDollarList)
				if ((label.LabelName == key) && (label.ParentFunction == labelAtLine))
					return label;
			return null;
		}
	}




}
