using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Variable;
using System.Windows.Forms;

namespace MinorShift.Emuera.GameData
{
	internal sealed class ConstantData
	{
		public static int MaxAbl { get; private set; }
		public static int MaxTalent { get; private set; }
		public static int MaxExp { get; private set; }
		public static int MaxMark { get; private set; }
		public static int MaxTrain { get; private set; }
		public static int MaxParam { get; private set; }
		public static int MaxItem { get; private set; }
		public static int MaxBasedata { get; private set; }
		public static int MaxSource { get; private set; }
		public static int MaxEx { get; private set; }
		public static int MaxEquip { get; private set; }
		public static int MaxTequip { get; private set; }
		public static int MaxFlag { get; private set; }
		public static int MaxTFlag { get; private set; }
		public static int MaxCFlag { get; private set; }

		public static int MaxStr { get; private set; }

		static ConstantData()
		{
			MaxAbl = 100;
			MaxTalent = 1000;
			MaxExp = 100;
			MaxMark = 100;
			MaxTrain = 1000;
			MaxParam = 200;
			MaxItem = 1000;
			MaxBasedata = 100;
			MaxSource = 1000;
			MaxEx = 100;
			MaxEquip = 100;
			MaxTequip = 100;
			MaxFlag = 10000;
			MaxTFlag = 1000;
			MaxCFlag = 1000;

			MaxStr = 20000;
		}

		public int[] VariableIntArrayLength;
		public int[] VariableStrArrayLength;
		public int[] CharacterIntArrayLength;
		public int[] CharacterStrArrayLength;
		public Int64[] VariableIntArray2DLength;
		public Int64[] VariableStrArray2DLength;

		private void setArray()
		{
			AblName = new string[MaxAbl];
			BaseName = new string[MaxBasedata];
			TalentName = new string[MaxTalent];
			ExpName = new string[MaxExp];
			ParamName = new string[MaxParam];
			TrainName = new string[MaxTrain];
			MarkName = new string[MaxMark];
			SourceName = new string[MaxSource];
			ExName = new string[MaxEx];
			EquipName = new string[MaxEquip];
			TequipName = new string[MaxTequip];
			FlagName = new string[MaxFlag];
			TFlagName = new string[MaxTFlag];
			CFlagName = new string[MaxCFlag];

			ItemName = new string[MaxItem];
			ItemPrice = new Int64[MaxItem];

			Str = new string[MaxStr];
		}

		public ConstantData(GameBase gamebase)
		{
			this.gamebase = gamebase;
			setDefaultArrayLength();

			CharacterTmplList = new List<CharacterTemplate>();
		}

		private void setDefaultArrayLength()
		{

			VariableIntArrayLength = new int[(int)VariableCode.__COUNT_INTEGER_ARRAY__];
			VariableStrArrayLength = new int[(int)VariableCode.__COUNT_STRING_ARRAY__];
			CharacterIntArrayLength = new int[(int)VariableCode.__COUNT_CHARACTER_INTEGER_ARRAY__];
			CharacterStrArrayLength = new int[(int)VariableCode.__COUNT_CHARACTER_STRING_ARRAY__];
			VariableIntArray2DLength = new Int64[(int)VariableCode.__COUNT_INTEGER_ARRAY_2D__];
			VariableStrArray2DLength = new Int64[(int)VariableCode.__COUNT_STRING_ARRAY_2D__];
			for (int i = 0; i < VariableIntArrayLength.Length; i++)
				VariableIntArrayLength[i] = 1000;
			VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.FLAG)] = 10000;
			VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ITEMPRICE)] = ConstantData.MaxItem;

			VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.RANDDATA)] = 625;
			
			for (int i = 0; i < VariableStrArrayLength.Length; i++)
				VariableStrArrayLength[i] = 100;
			VariableStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.STR)] = ConstantData.MaxStr;

			for (int i = 0; i < CharacterIntArrayLength.Length; i++)
				CharacterIntArrayLength[i] = 100;
			CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)] = 1000;
			CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)] = 1000;
			CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.JUEL)] = 200;
			CharacterIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.GOTJUEL)] = 200;

			for (int i = 0; i < CharacterStrArrayLength.Length; i++)
				CharacterStrArrayLength[i] = 100;

			for (int i = 0; i < VariableIntArray2DLength.Length; i++)
				VariableIntArray2DLength[i] = (100L << 32) + 100L;
			for (int i = 0; i < VariableStrArray2DLength.Length; i++)
				VariableStrArray2DLength[i] = (100L << 32) + 100L;

		}

		private void loadVariableSizeData(string csvPath)
		{
			if (!File.Exists(csvPath))
				return;
			EraStreamReader eReader = new EraStreamReader();
			if (!eReader.Open(csvPath))
			{
				output.PrintLine(eReader.Filename + "̃I[vɎs܂");
				return;
			}
			ScriptPosition position = null;
			if (Config.Instance.DisplayReport)
				output.PrintLine(eReader.Filename + "ǂݍݒEEE");
			try
			{
				string line = null;
				while ((line = eReader.ReadLine()) != null)
				{
					//ÕzCgXy[Xǂݎ̂
					StringStream st = new StringStream(line);
					TokenReader.SkipWhiteSpace(st);
					if ((st.EOS) || (st.Current == ';'))
						continue;
					line = st.Substring();
					position = new ScriptPosition(eReader.Filename, eReader.LineNo, line);
					changeVariableSizeData(line, position);
				}
			}
			catch
			{
				if (position != null)
					output.PrintWarning("\ȂG[܂", position, 3);
				else
					output.PrintLine("\ȂG[܂");
				return;
			}
			finally
			{
				eReader.Close();
			}
		}

		private void changeVariableSizeData(string line, ScriptPosition position)
		{
			string[] tokens = line.Split(',');
			if (tokens.Length < 2)
			{
				output.PrintWarning("\",\"Kvł", position, 1);
				return;
			}
			string idtoken = tokens[0].Trim();
			VariableIdentifier id = VariableIdentifier.GetVariableId(idtoken);
			if (id == null)
			{
				output.PrintWarning("ڂ̒lϐƂĔFł܂", position, 1);
				return;
			}
			if ((!id.IsArray1D) && (!id.IsArray2D))
			{
				output.PrintWarning("zϐłȂϐ" + id.ToString() + "̃TCYύXł܂", position, 1);
				return;
			}
			int length = 0;
			int length2 = 0;
			if (!int.TryParse(tokens[1], out length))
			{
				output.PrintWarning("ڂ̒l𐮐lƂĔFł܂", position, 1);
				return;
			}
			if (length < 100)
			{
				output.PrintWarning("zTCY100ȉɂ͏o܂", position, 1);
				return;
			}
			if (id.IsArray2D)
			{
				if (tokens.Length < 3)
				{
					output.PrintWarning("񎟌z̃TCYwɂ2̐lKvł", position, 1);
					return;
				}
				if (!int.TryParse(tokens[2], out length2))
				{
					output.PrintWarning("Oڂ̒l𐮐lƂĔFł܂", position, 1);
					return;
				}
				if (length2 < 10)
				{
					output.PrintWarning("zTCY10ȉɂ͏o܂", position, 1);
					return;
				}
			}
			switch (id.Code)
			{
				case VariableCode.ITEMNAME:
				case VariableCode.ITEMPRICE:
					VariableIntArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.ITEMPRICE)] = length;
					ConstantData.MaxItem = length; break;
				case VariableCode.ABLNAME:
					ConstantData.MaxAbl = length; break;
				case VariableCode.TALENTNAME:
					ConstantData.MaxTalent = length; break;
				case VariableCode.EXPNAME:
					ConstantData.MaxExp = length; break;
				case VariableCode.MARKNAME:
					ConstantData.MaxMark = length; break;
				case VariableCode.PALAMNAME:
					ConstantData.MaxParam = length; break;
				case VariableCode.TRAINNAME:
					ConstantData.MaxTrain = length; break;
				case VariableCode.BASENAME:
					ConstantData.MaxBasedata = length; break;
				case VariableCode.SOURCENAME:
					ConstantData.MaxSource = length; break;
				case VariableCode.EXNAME:
					ConstantData.MaxEx = length; break;
				case VariableCode.EQUIPNAME:
					ConstantData.MaxEquip = length; break;
				case VariableCode.TEQUIPNAME:
					ConstantData.MaxTequip = length; break;
				case VariableCode.FLAGNAME:
					ConstantData.MaxFlag = length; break;
				case VariableCode.TFLAGNAME:
					ConstantData.MaxTFlag = length; break;
				case VariableCode.CFLAGNAME:
					ConstantData.MaxCFlag = length; break;
				case VariableCode.STR:
					VariableStrArrayLength[id.CodeInt] = length;
					ConstantData.MaxStr = length; break;
				default:
					{
						if ((id.IsCalc) || (id.Code == VariableCode.RANDDATA))
						{
							output.PrintWarning(id.ToString() + "̃TCY͕ύXł܂", position, 1);
						}
						else if (id.IsArray2D)
						{
							Int64 length64 = (((Int64)length) << 32) + ((Int64)length2);
							if (id.IsInteger)
								VariableIntArray2DLength[id.CodeInt] = length64;
							else if (id.IsString)
								VariableStrArray2DLength[id.CodeInt] = length64;
						}
						else if (id.IsCharacterData)
						{
							if (id.IsInteger)
								CharacterIntArrayLength[id.CodeInt] = length;
							else if (id.IsString)
								CharacterStrArrayLength[id.CodeInt] = length;
						}
						else
						{
							if (id.IsInteger)
								VariableIntArrayLength[id.CodeInt] = length;
							else if (id.IsString)
								VariableStrArrayLength[id.CodeInt] = length;
						}
					}
					break;

			}
		}

		private readonly GameBase gamebase;
		private string[][] names = new string[16][];
		public string[] AblName { get { return names[0]; } private set { names[0] = value; } }
		public string[] ExpName { get { return names[1]; } private set { names[1] = value; } }
		public string[] TalentName { get { return names[2]; } private set { names[2] = value; } }
		public string[] ParamName { get { return names[3]; } private set { names[3] = value; } }
		public string[] TrainName { get { return names[4]; } private set { names[4] = value; } }
		public string[] MarkName { get { return names[5]; } private set { names[5] = value; } }
		public string[] ItemName { get { return names[6]; } private set { names[6] = value; } }
		public string[] BaseName { get { return names[7]; } private set { names[7] = value; } }
		public string[] SourceName { get { return names[8]; } private set { names[8] = value; } }
		public string[] ExName { get { return names[9]; } private set { names[9] = value; } }
		public string[] Str { get { return names[10]; } private set { names[10] = value; } }
		public string[] EquipName { get { return names[11]; } private set { names[11] = value; } }
		public string[] TequipName { get { return names[12]; } private set { names[12] = value; } }
		public string[] FlagName { get { return names[13]; } private set { names[13] = value; } }
		public string[] TFlagName { get { return names[14]; } private set { names[14] = value; } }
		public string[] CFlagName { get { return names[15]; } private set { names[15] = value; } }
		public Int64[] ItemPrice;

		private readonly List<CharacterTemplate> CharacterTmplList;

		private EmueraConsole output;
		public void LoadData(string csvDir, EmueraConsole console)
		{
			output = console;
			loadVariableSizeData(csvDir + "VariableSize.CSV");
			setArray();
			loadDataTo(csvDir + "ABL.CSV", AblName, null);
			loadDataTo(csvDir + "EXP.CSV", ExpName, null);
			loadDataTo(csvDir + "TALENT.CSV", TalentName, null);
			loadDataTo(csvDir + "PALAM.CSV", ParamName, null);
			loadDataTo(csvDir + "TRAIN.CSV", TrainName, null);
			loadDataTo(csvDir + "MARK.CSV", MarkName, null);
			loadDataTo(csvDir + "ITEM.CSV", ItemName, ItemPrice);
			loadDataTo(csvDir + "BASE.CSV", BaseName, null);
			loadDataTo(csvDir + "SOURCE.CSV", SourceName, null);
			loadDataTo(csvDir + "EX.CSV", ExName, null);
			loadDataTo(csvDir + "EQUIP.CSV", EquipName, null);
			loadDataTo(csvDir + "TEQUIP.CSV", TequipName, null);
			loadDataTo(csvDir + "FLAG.CSV", FlagName, null);
			loadDataTo(csvDir + "TFLAG.CSV", TFlagName, null);
			loadDataTo(csvDir + "CFLAG.CSV", CFlagName, null);
			loadDataTo(csvDir + "STR.CSV", Str, null);
			loadCharacterData(csvDir);
			definedNames.Clear();
			foreach (string[] strs in names)
				foreach (string str in strs)
					definedNames.Add(str);
			foreach (CharacterTemplate chara in CharacterTmplList)
			{
				definedNames.Add(chara.Name);
				definedNames.Add(chara.Callname);
			}
		}

		private static readonly List<string> definedNames = new List<string>();
		public static bool isDefined(string str)
		{
			if (string.IsNullOrEmpty(str))
				return false;
			return definedNames.Contains(str);
		}
		public int KeywordToInteger(VariableCode code, string key)
		{
			if (string.IsNullOrEmpty(key))
				throw new CodeEE("L[[hɂ͏o܂");
			int p1 = -1;
			string errPos = null;
			switch (code)
			{
				case VariableCode.ITEM:
				case VariableCode.ITEMSALES:
					p1 = ((IList<string>)ItemName).IndexOf(key);
					errPos = "Item.csv";
					break;
				case VariableCode.LOSEBASE:
				case VariableCode.BASE:
				case VariableCode.MAXBASE:
					p1 = ((IList<string>)BaseName).IndexOf(key);
					errPos = "base.csv";
					break;

				case VariableCode.ABL:
					p1 = ((IList<string>)AblName).IndexOf(key);
					errPos = "abl.csv";
					break;

				case VariableCode.TALENT:
					p1 = ((IList<string>)TalentName).IndexOf(key);
					errPos = "talent.csv";
					break;

				case VariableCode.EXP:
					p1 = ((IList<string>)ExpName).IndexOf(key);
					errPos = "exp.csv";
					break;
				case VariableCode.MARK:
					p1 = ((IList<string>)MarkName).IndexOf(key);
					errPos = "mark.csv";
					break;
				case VariableCode.SOURCE:
					p1 = ((IList<string>)SourceName).IndexOf(key);
					errPos = "source.csv";
					break;
				case VariableCode.EX:
				case VariableCode.NOWEX:
					p1 = ((IList<string>)ExName).IndexOf(key);
					errPos = "ex.csv";
					break;
				case VariableCode.EQUIP:
					p1 = ((IList<string>)EquipName).IndexOf(key);
					errPos = "equip.csv";
					break;
				case VariableCode.TEQUIP:
					p1 = ((IList<string>)TequipName).IndexOf(key);
					errPos = "tequip.csv";
					break;
				case VariableCode.FLAG:
					p1 = ((IList<string>)FlagName).IndexOf(key);
					errPos = "flag.csv";
					break;
				case VariableCode.TFLAG:
					p1 = ((IList<string>)TFlagName).IndexOf(key);
					errPos = "tflag.csv";
					break;
				case VariableCode.CFLAG:
					p1 = ((IList<string>)CFlagName).IndexOf(key);
					errPos = "cflag.csv";
					break;
				case VariableCode.RELATION:
					for (int i = 0; i < CharacterTmplList.Count; i++)
					{
						if ((CharacterTmplList[i].Name == key) 
							|| (CharacterTmplList[i].Callname == key)
							|| (CharacterTmplList[i].Nickname == key))
						{
							p1 = (int)CharacterTmplList[i].No;
							break;
						}
					}
					errPos = "chara*.csv";
					break;


				case VariableCode.UP:
				case VariableCode.DOWN:
				case VariableCode.PALAM:
				case VariableCode.JUEL:
				case VariableCode.GOTJUEL:
					p1 = ((IList<string>)ParamName).IndexOf(key);
					errPos = "palam.csv";
					break;



				//case VariableCode.STAIN:
			}
			if (p1 < 0)
			{
				if (errPos == null)
					throw new CodeEE("zϐ" + code.ToString() + "̗vf𕶎Ŏw肷邱Ƃ͂ł܂");
				else
					throw new CodeEE(errPos + "̒\"" + key + "\"̒`܂");
			}
			return p1;
		}

		public CharacterTemplate GetCharacterTemplate(Int64 index, bool sp)
		{
			foreach (CharacterTemplate chara in CharacterTmplList)
			{
				if (chara.No != index)
					continue;
				if (sp == (chara.CFlag[0] != 0))
					return chara;
			}
			return null;
		}


		private void loadCharacterData(string csvDir)
		{
			if (!Directory.Exists(csvDir))
				return;
			List<KeyValuePair<string, string>> csvPaths = Config.Instance.GetFiles(csvDir, "CHARA*.CSV");
			for (int i = 0; i < csvPaths.Count; i++)
			{
				loadCharacterDataFile(csvPaths[i].Value, csvPaths[i].Key);
			}
		}

		private void loadCharacterDataFile(string csvPath, string csvName)
		{
			CharacterTemplate tmpl = null;
			EraStreamReader eReader = new EraStreamReader();
			if (!eReader.Open(csvPath, csvName))
			{
				output.PrintLine(eReader.Filename + "̃I[vɎs܂");
				return;
			}
			ScriptPosition position = null;
			if (Config.Instance.DisplayReport)
				output.PrintLine(eReader.Filename + "ǂݍݒEEE");
			try
			{
				Int64 index = -1;
				string line = null;
				while ((line = eReader.ReadLine()) != null)
				{
					//ÕzCgXy[Xǂݎ̂
					StringStream st = new StringStream(line);
					TokenReader.SkipWhiteSpace(st);
					if ((st.EOS) || (st.Current == ';'))
						continue;
					line = st.Substring();
					string[] tokens = line.Split(',');
					position = new ScriptPosition(eReader.Filename, eReader.LineNo, line);
					if (tokens.Length < 2)
					{
						output.PrintWarning("\",\"Kvł", position, 1);
						continue;
					}
					if (tokens[0].Length == 0)
					{
						output.PrintWarning("\",\"Ŏn܂Ă܂", position, 1);
						continue;
					}
					if ((tokens[0].Equals("NO", StringComparison.CurrentCultureIgnoreCase))
						|| (tokens[0].Equals("ԍ", StringComparison.CurrentCultureIgnoreCase)))
					{
						if (tmpl != null)
						{
							output.PrintWarning("ԍdɒ`܂", position, 1);
							continue;
						}
						if (!Int64.TryParse(tokens[1], out index))
						{
							output.PrintWarning(tokens[1] + "𐮐lɕϊł܂", position, 1);
							continue;
						}
						tmpl = new CharacterTemplate(index, this);
						CharacterTmplList.Add(tmpl);
						continue;
					}
					if (tmpl == null)
					{
						output.PrintWarning("ԍ`Oɑ̃f[^n܂܂", position, 1);
						continue;
					}
					toCharacterTemplate(gamebase, position, tmpl, tokens);
				}
			}
			catch
			{
				if (position != null)
					output.PrintWarning("\ȂG[܂", position, 3);
				else
					output.PrintLine("\ȂG[܂");
				return;
			}
			finally
			{
				eReader.Dispose();
			}
		}

		private bool tryToInt64(string str, out Int64 p)
		{
			p = -1;
			if (string.IsNullOrEmpty(str))
				return false;
			StringStream st = new StringStream(str);
            if (TokenReader.GetNextTokenType(st) != TokenType.Numeric)
            {
                //t̒lnĂ\̂ŁA𔻒
                if (st.Current != '+' && st.Current != '-')
                    return false;
            }
			try
			{
				p = (TokenReader.ReadInt64(st)).Int;
			}
			catch
			{
				return false;
			}
			return true;
		}

		private void toCharacterTemplate(GameBase gamebase, ScriptPosition position, CharacterTemplate chara, string[] tokens)
		{
			if (chara == null)
				return;
			Int64 p1 = -1;
			Int64 p2 = -1;
			Int64[] intArray = null;
			string[] strArray = null;
			string[] namearray = null;
			switch (tokens[0].ToUpper())
			{
				case "NAME":
				case "O":
					chara.Name = tokens[1];
					return;
				case "CALLNAME":
				case "Ăі":
					chara.Callname = tokens[1];
					return;
				case "NICKNAME":
				case "":
					chara.Nickname = tokens[1];
					return;
				case "MASTERNAME":
				case "ľĂѕ":
					chara.Mastername = tokens[1];
					return;
				case "MARK":
				case "":
					intArray = chara.Mark;
					namearray = MarkName;
					break;
				case "EXP":
				case "o":
					intArray = chara.Exp;
					namearray = ExpName;
					break;
				case "ABL":
				case "\":
					intArray = chara.Abl;
					namearray = AblName;
					break;
				case "BASE":
				case "b":
					intArray = chara.Maxbase;
					namearray = BaseName;
					break;
				case "TALENT":
				case "f":
					intArray = chara.Talent;
					namearray = TalentName;
					break;
				case "RELATION":
				case "":
					intArray = chara.Relation;
					namearray = null;
					break;
				case "CFLAG":
				case "tO":
					intArray = chara.CFlag;
					namearray = CFlagName;
					break;
				case "CSTR":
					strArray = chara.CStr;
					namearray = null;
					break;
				default:
					output.PrintWarning("\"" + tokens[0] + "\"͉߂łȂʎqł", position, 1);
					return;
			}
			int length = -1;
			if(intArray != null)
				length = intArray.Length;
			else if(strArray != null)
				length = strArray.Length;
			if (length < 0)
			{
				output.PrintWarning("vO~X", position, 3);
				return;
			}
			bool p1isNumeric = tryToInt64(tokens[1], out p1);
			if ((!p1isNumeric) && (namearray != null))
				p1 = ((IList<string>)namearray).IndexOf(tokens[1]);

			if ((p1 < 0) || (p1 >= length))
			{
				if (p1isNumeric)
					output.PrintWarning(p1.ToString() + "͔z͈̔͊Oł", position, 1);
				else if (tokens[1].Length == 0)
					output.PrintWarning("ڂ̎ʎq܂", position, 1);
				else
					output.PrintWarning("\"" + tokens[1] + "\"͉߂łȂʎqł", position, 1);
				return;
			}
			if (strArray != null)
			{
				if (tokens.Length < 3)
					output.PrintWarning("Oڂ̎ʎq܂", position, 1);
				strArray[p1] = tokens[2];
			}
			else
			{
				if ((tokens.Length < 3) || !tryToInt64(tokens[2], out p2))
					p2 = 1;
                intArray[p1] = p2;
			}
		}


		private void loadDataTo(string csvPath, string[] target, Int64[] targetI)
		{

			if (!File.Exists(csvPath))
				return;
			if (target == null)
				return;

			EraStreamReader eReader = new EraStreamReader();
			if (!eReader.Open(csvPath))
			{
				output.PrintLine(eReader.Filename + "̃I[vɎs܂");
				return;
			}
			ScriptPosition position = null;

			if (Config.Instance.DisplayReport)
				output.PrintLine(eReader.Filename + "ǂݍݒEEE");
			try
			{
				string line = null;
				while ((line = eReader.ReadLine()) != null)
				{
					//ÕzCgXy[Xǂݎ̂
					StringStream st = new StringStream(line);
					TokenReader.SkipWhiteSpace(st);
					if ((st.EOS) || (st.Current == ';'))
						continue;
					line = st.Substring();
					position = new ScriptPosition(eReader.Filename, eReader.LineNo, line);
					string[] tokens = line.Split(',');
					if (tokens.Length < 2)
					{
						output.PrintWarning("\",\"Kvł", position, 1);
						continue;
					}
					int index = 0;
					if (!Int32.TryParse(tokens[0], out index))
					{
						output.PrintWarning("ڂ̒l𐮐lɕϊł܂", position, 1);
						continue;
					}
					if ((index < 0) || (target.Length <= index))
					{
						output.PrintWarning(index.ToString() + "͔z͈̔͊Oł", position, 1);
						continue;
					}
					target[index] = tokens[1];
					if ((targetI != null) && (tokens.Length >= 3))
					{
						Int64 price;

						if (!Int64.TryParse(tokens[2], out price))
						{
							output.PrintWarning("zǂݎ܂", position, 1);
							continue;
						}

						targetI[index] = price;
					}
				}
			}
			catch
			{
				if (position != null)
					output.PrintWarning("\ȂG[܂", position, 3);
				else
					output.PrintLine("\ȂG[܂");
				return;
			}
			finally
			{
				eReader.Close();
			}


		}
	}

	internal sealed class CharacterTemplate
	{
		public CharacterTemplate(Int64 index, ConstantData constant)
		{
			int[] arraySize = constant.CharacterIntArrayLength;
			No = index;
			Abl = new Int64[arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.ABL)]];
			Mark = new Int64[arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.MARK)]];
			Exp = new Int64[arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.EXP)]];
			Talent = new Int64[arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.TALENT)]];
			Relation = new Int64[arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.RELATION)]];
			CFlag = new Int64[arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.CFLAG)]];
			int baseSize = arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.MAXBASE)];
			baseSize = Math.Min(baseSize, arraySize[(int)(VariableCode.__LOWERCASE__ & VariableCode.BASE)]);
			Maxbase = new Int64[baseSize];

			CStr = new string[
					constant.CharacterStrArrayLength[(int)(VariableCode.__LOWERCASE__ & VariableCode.CSTR)]
				];

		}
		public string Name;
		public string Callname;
		public string Nickname;
		public string Mastername;
		public readonly Int64 No;
		public readonly Int64[] Maxbase;
		public readonly Int64[] Mark;
		public readonly Int64[] Exp;
		public readonly Int64[] Abl;
		public readonly Int64[] Talent;
		public readonly Int64[] Relation;
		public readonly Int64[] CFlag;
		public readonly string[] CStr;
	}
}
