﻿using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.GameData.Expression;

namespace MinorShift.Emuera.GameData.Function
{
	internal sealed class FunctionMethodTerm : IOperandTerm
	{
		public FunctionMethodTerm(FunctionMethod method, IOperandTerm[] args)
		{
			Method = method;
			Arguments = args;
		}
		public FunctionMethod Method{get; private set;}
		public IOperandTerm[] Arguments { get; private set; }

		public SingleTerm GetValue(ExpressionEvaluator eev)
		{
			return Method.GetReturnValue(eev, Arguments);
		}

		#region IOperandTerm メンバ

		public bool IsConstant
		{
			get { return false; }
		}

		public Type GetOperandType()
		{
			return Method.ReturnType;
		}

		public int KiriScriptPriority
		{
			get { throw new NotImplementedException(); }
		}

		#endregion

		#region IDeparse メンバ

		public string ToKiriScript()
		{
			throw new NotImplementedException();
		}

		public string ToErbScript()
		{
			throw new NotImplementedException();
		}

		#endregion
	}
}
