﻿using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.GameData.Expression;

namespace MinorShift.Emuera.GameData.Function
{
	internal sealed class UserDefinedMethodTerm : IOperandTerm
	{
		public UserDefinedMethodTerm(string funcname, IOperandTerm[] args, Type returnType)
		{
			Funcname = funcname;
			Arguments = args;
			ReturnType = returnType;
		}
		public string Funcname { get; private set; }
		public IOperandTerm[] Arguments { get; private set; }
		public Type ReturnType { get; private set; }

		#region IOperandTerm メンバ

		public bool IsConstant
		{
			get { return false; }
		}

		public Type GetOperandType()
		{
			return ReturnType;
		}

		public int KiriScriptPriority
		{
			get { throw new NotImplementedException(); }
		}

		#endregion

		#region IDeparse メンバ

		public string ToKiriScript()
		{
			throw new NotImplementedException();
		}

		public string ToErbScript()
		{
			throw new NotImplementedException();
		}

		#endregion
	}
}
