using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData.Expression;

namespace MinorShift.Emuera.GameData.Variable
{
	internal static class VariableParser
	{
		
		public static bool IsVariable(string ids)
		{
			if (string.IsNullOrEmpty(ids))
				return false;
			string[] idlist = ids.Split(':');
			//idlist = synonym.ApplySynonym(idlist);
			VariableIdentifier id = VariableIdentifier.GetVariableId(idlist[0]);
			return id != null;
		}

		public static bool IsInteger(string ids)
		{
			if (string.IsNullOrEmpty(ids))
				return false;
			string[] idlist = ids.Split(':');
			//idlist = synonym.ApplySynonym(idlist);
			VariableIdentifier id = VariableIdentifier.GetVariableId(idlist[0]);
			return id.IsInteger;
		}

		private static  SingleTerm getZeroToken()
		{
			return new SingleTerm(0);
		}

		private static VariableToken getTergetToken()
		{
			VariableIdentifier id = VariableIdentifier.GetVariableId(VariableCode.TARGET);
			return new VariableToken(id, new SingleTerm(0), null);
		}




		public static VariableToken ReduceVariable(StringStream st)
		{
			string idStr = TokenReader.ReadSingleIdentifer(st);
			VariableIdentifier id = VariableIdentifier.GetVariableId(idStr);
			if (id == null)
				throw new CodeEE("\"" + idStr + "\"͉߂łȂʎqł");
			IOperandTerm op1 = null;
			IOperandTerm op2 = null;
			int i = 0;
			while (true)
			{
				TokenReader.SkipWhiteSpace(st);
				if (st.Current != ':')
					break;
				if (i >= 2)
					throw new CodeEE(id.ToString() + "̈܂");
				st.ShiftNext();
				TokenReader.SkipWhiteSpace(st);
				if (i == 0)
					op1 = ExpressionParser.ReduceVariableArgument(st);
				else if (i == 1)
					op2 = ExpressionParser.ReduceVariableArgument(st);
				i++;
			}
			return ReduceVariable(id, op1, op2);

		}

		public static VariableToken ReduceVariable(VariableIdentifier id, IOperandTerm p1, IOperandTerm p2)
		{
			IOperandTerm op1 = p1;
			IOperandTerm op2 = p2;
			//̐
			if (id.IsCharacterData)
			{
				if (id.IsArray)
				{
					if (op2 == null)
					{
						if (op1 == null)
							op1 = getZeroToken();
						op2 = op1;
						op1 = getTergetToken();
					}
				}
				else
				{
					if (op2 != null)
						throw new CodeEE("ꎟzϐ" + id.ToString() + "̈܂");
					if (op1 == null)
						op1 = getTergetToken();
				}
			}
			else
			{
				if (id.IsArray)
				{
					if (op2 != null)
						throw new CodeEE("ꎟzϐ" + id.ToString() + "̈܂");
					if (op1 == null)
						op1 = getZeroToken();
				}
				else
					if (op1 != null)
						throw new CodeEE("złȂϐ" + id.ToString() + "tŌĂяoĂ܂");
			}

			if (id.IsCharacterData)
			{
				if (id.IsArray)
				{
					if (op1.GetOperandType() == typeof(string))
						throw new CodeEE("LN^ϐ̑Pɕw肷邱Ƃ͂ł܂");
				}
			}

			//if ( ((op1 != null) && (op1.IsConstant) && (op1.GetOperandType() == typeof(Int64)) && (op2 == null) )
			//    || ((op2 != null) && (op2.IsConstant) && (op2.GetOperandType() == typeof(Int64))) )
			//{//B̈萔A͑Qł萔
			//    ExpressionEvaluator eEv = new ExpressionEvaluator(null);
			//    FixedVariablePointer fixVar = new FixedVariablePointer();
			//    fixVar.ID = id;
			//    if ((op1 == null) || (op1.IsConstant))
			//        fixVar.Index1 = eEv.GetInteger(op1);
			//    else
			//        fixVar.Index1 = 0;

			//    fixVar.Index2 = eEv.GetInteger(op2);
			//    if (!VariableEvaluator.CheckConstElement(fixVar))
			//    {
			//        throw new CodeEE("z\"" + id.ToString() + "\"̋EOQƂĂ܂");
			//    }
			//}
			VariableToken varToken = new VariableToken(id, op1, op2);
			return varToken;
		}
		public static string ErrorMes = null;
		public static void ResetError()
		{
			ErrorMes = null;
		}

	}
}
