using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera.GameData.Variable
{
	/// <summary>
	/// VariableCodẽbp[
	/// </summary>
	internal sealed class VariableIdentifier
	{
		private VariableIdentifier(VariableCode code)
		{ this.code = code; }
		private VariableIdentifier(VariableCode code, string scope)
		{ this.code = code; this.scope = scope;}
		readonly VariableCode code;
		readonly string scope;
		public VariableCode Code
		{ get { return code; } }
		public string Scope
		{ get { return scope; } }
		public int CodeInt
		{ get { return (int)(code & VariableCode.__LOWERCASE__); } }
		public VariableCode CodeFlag
		{ get { return code & VariableCode.__UPPERCASE__; } }
		public int Dimension
		{
			get
			{
				int dim = 0;
				if ((code & VariableCode.__ARRAY_1D__) == VariableCode.__ARRAY_1D__)
					dim++;
				if ((code & VariableCode.__CHARACTER_DATA__) == VariableCode.__CHARACTER_DATA__)
					dim++;
				return dim;
			}
		}

		public bool IsNull
		{
			get
			{
				return code == VariableCode.__NULL__;
			}
		}
		public bool IsCharacterData
		{
			get
			{
				return ((code & VariableCode.__CHARACTER_DATA__) == VariableCode.__CHARACTER_DATA__);
			}
		}
		public bool IsInteger
		{
			get
			{
				return ((code & VariableCode.__INTEGER__) == VariableCode.__INTEGER__);
			}
		}
		public bool IsString
		{
			get
			{
				return ((code & VariableCode.__STRING__) == VariableCode.__STRING__);
			}
		}
		public bool IsArray
		{
			get
			{
				return ((code & VariableCode.__ARRAY_1D__) == VariableCode.__ARRAY_1D__);
			}
		}
		public bool Readonly
		{
			get
			{
				return ((code & VariableCode.__UNCHANGEABLE__) == VariableCode.__UNCHANGEABLE__);
			}
		}
		public bool IsCalc
		{
			get
			{
				return ((code & VariableCode.__CALC__) == VariableCode.__CALC__);
			}
		}
		public bool IsLocal
		{
			get
			{
				return ((code & VariableCode.__LOCAL__) == VariableCode.__LOCAL__);
			}
		}
		readonly static Dictionary<string, VariableCode> nameDic = new Dictionary<string, VariableCode>();
		readonly static Dictionary<string, VariableCode> localvarNameDic = new Dictionary<string, VariableCode>();
		static VariableIdentifier()
		{
			Array array = Enum.GetValues(typeof(VariableCode));
			foreach (object name in array)
			{
				VariableCode code = (VariableCode)name;
				string key = code.ToString();
				if ((key == null) || (key.StartsWith("__") && key.EndsWith("__")))
					continue;
				if (Config.Instance.IgnoreCase)
					key = key.ToUpper();
				if (nameDic.ContainsKey(key))
					continue;
				nameDic.Add(key, code);
				if ((code & VariableCode.__LOCAL__) == VariableCode.__LOCAL__)
					localvarNameDic.Add(key, code);
			}
		}

		public static VariableIdentifier GetVariableId(VariableCode code)
		{
			return new VariableIdentifier(code);
		}
		public static VariableIdentifier GetVariableId(string str)
		{
			string key = str;
			if (string.IsNullOrEmpty(key))
				return null;
			if (Config.Instance.IgnoreCase)
				key = key.ToUpper();
			if (nameDic.ContainsKey(key))
			return new VariableIdentifier(nameDic[key]);

			if (key.Contains("@"))
			{
				string[] keys = key.Split('@');
				if ((keys.Length == 2) && (keys[1].Length > 0) && localvarNameDic.ContainsKey(keys[0]))
				{
					return new VariableIdentifier(localvarNameDic[keys[0]], keys[1]);
				}
			}
			return null;
		}
		public override string ToString()
		{
			return code.ToString();
		}
	}
}