using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Windows.Forms;
using System.Drawing;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera
{
	public class StrIgnoreCaseComparer : IComparer<string>
	{
		public int Compare(string x, string y)
		{
			return string.Compare(x, y, StringComparison.OrdinalIgnoreCase);
		}
	}

	/// <summary>
	/// vOŜŎgplWindow쐬Oɐݒ肵ĈȌύXȂ
	/// (Ƃ\肾͈Ⴄ)
	/// </summary>
	internal class Config
	{
		readonly static string configPath = Program.ExeDir + "emuera.config";
		readonly static string defaultConfigPath = Program.ExeDir + "csv\\default.config";
		readonly static string fixedConfigPath = Program.ExeDir + "csv\\fixed.config";

		static Config() { }
		private static Config instance = new Config();
		public static Config Instance { get { return instance; } }
		public readonly static Encoding Encode = Encoding.GetEncoding("SHIFT-JIS");

		private Config() { setDefault(); }

		//Kɑ傫ڂ̔zĂB
		private AConfigItem[] configArray = new AConfigItem[50];
		private AConfigItem[] replaceArray = new AConfigItem[50];

		private void setDefault()
		{
			int i = 0;
			configArray[i++] = new ConfigItem<bool>(ConfigCode.IgnoreCase, "啶̈Ⴂ𖳎", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.UseRenameFile, "_Rename.csv𗘗p", false);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.UseReplaceFile, "_Replace.csv𗘗p", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.UseMouse, "}EXgp", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.UseMenu, "j[gp", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.UseDebugCommand, "fobOR}hgp", false);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.AllowMultipleInstances, "dN", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.AutoSave, "I[gZ[usȂ", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.SizableWindow, "EBhE̍ςɂ", true);
			configArray[i++] = new ConfigItem<TextDrawingMode>(ConfigCode.TextDrawingMode, "`C^[tF[X", TextDrawingMode.GRAPHICS);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.UseImageBuffer, "C[Wobt@gp", true);
			configArray[i++] = new ConfigItem<int>(ConfigCode.WindowX, "EBhE", 760);
			configArray[i++] = new ConfigItem<int>(ConfigCode.WindowY, "EBhE", 480);
			configArray[i++] = new ConfigItem<int>(ConfigCode.MaxLog, "O̍s", 5000);
			configArray[i++] = new ConfigItem<int>(ConfigCode.PrintCPerLine, "PRINTCׂ鐔", 3);
			configArray[i++] = new ConfigItem<int>(ConfigCode.PrintCLength, "PRINTC̕", 25);
			configArray[i++] = new ConfigItem<string>(ConfigCode.FontName, "tHg", "lr SVbN");
			configArray[i++] = new ConfigItem<int>(ConfigCode.FontSize, "tHgTCY", 18);
			configArray[i++] = new ConfigItem<int>(ConfigCode.LineHeight, "s̍", 19);
			configArray[i++] = new ConfigItem<Color>(ConfigCode.ForeColor, "F", Color.FromArgb(192, 192, 192));//LIGHTGRAY
			configArray[i++] = new ConfigItem<Color>(ConfigCode.BackColor, "wiF", Color.FromArgb(0, 0, 0));//BLACK
			configArray[i++] = new ConfigItem<Color>(ConfigCode.FocusColor, "I𒆕F", Color.FromArgb(255, 255, 0));//YELLOW
			configArray[i++] = new ConfigItem<Color>(ConfigCode.LogColor, "𕶎F", Color.FromArgb(192, 192, 192));//LIGHTGRAY//Color.FromArgb(128, 128, 128);//GRAY
			configArray[i++] = new ConfigItem<int>(ConfigCode.FPS, "t[b", 15);
			configArray[i++] = new ConfigItem<int>(ConfigCode.SkipFrame, "őXLbvt[", 3);
			configArray[i++] = new ConfigItem<int>(ConfigCode.InfiniteLoopAlertTime, "[vx܂ł̃~b", 5000);
			configArray[i++] = new ConfigItem<int>(ConfigCode.DisplayWarningLevel, "\Œxx", 1);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.DisplayReport, "[hɃ|[g\", false);
			configArray[i++] = new ConfigItem<ReduceArgumentOnLoadFlag>(ConfigCode.ReduceArgumentOnLoad, "[hɈ͂", ReduceArgumentOnLoadFlag.NO);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.ReduceFormattedStringOnLoad, "[hFORM͂", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.IgnoreUncalledFunction, "ĂяoȂ֐𖳎", true);
			configArray[i++] = new ConfigItem<DisplayWarningFlag>(ConfigCode.FunctionNotFoundWarning, "֐Ȃẍ", DisplayWarningFlag.IGNORE);
			configArray[i++] = new ConfigItem<DisplayWarningFlag>(ConfigCode.FunctionNotCalledWarning, "֐ĂяoȂẍ", DisplayWarningFlag.IGNORE);
			configArray[i++] = new ConfigItem<List<string>>(ConfigCode.IgnoreWarningFiles, "w肵t@Čx𖳎", new List<string>());
			configArray[i++] = new ConfigItem<bool>(ConfigCode.ChangeMasterNameIfDebug, "fobOR}hgpMASTER̖OύX", true);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.ButtonWrap, "{^̓rōs܂肩Ȃ", false);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.SearchSubdirectory, "TufBNg", false);
			configArray[i++] = new ConfigItem<bool>(ConfigCode.SortWithFilename, "ǂݍݏt@CɃ\[g", false);
			configArray[i++] = new ConfigItem<long>(ConfigCode.LastKey, "ŏIXVR[h", 0);
			
			i = 0;
			replaceArray[i++] = new ConfigItem<string>(ConfigCode.MoneyLabel, "̒P", "$");
			replaceArray[i++] = new ConfigItem<bool>(ConfigCode.MoneyFirst, "Pʂ̈ʒu", true);
			replaceArray[i++] = new ConfigItem<string>(ConfigCode.LoadLabel, "Nȗ\", "Now Loading...");
			replaceArray[i++] = new ConfigItem<int>(ConfigCode.MaxShopItem, "̔ACe", 100);
			replaceArray[i++] = new ConfigItem<string>(ConfigCode.DrawLineString, "DRAWLINE", "-");
			replaceArray[i++] = new ConfigItem<char>(ConfigCode.BarChar1, "BAR1", '*');
			replaceArray[i++] = new ConfigItem<char>(ConfigCode.BarChar2, "BAR2", '.');
			replaceArray[i++] = new ConfigItem<string>(ConfigCode.TitleMenuString0, "VXej[0", "ŏ͂߂");
			replaceArray[i++] = new ConfigItem<string>(ConfigCode.TitleMenuString1, "VXej[1", "[hĂ͂߂");
		}
		public Config Copy()
		{
			Config config = new Config();
			//for(int i = 0; i< configArray.Length;i++)
			//    config.configArray[i] = AConfigItem.Copy(this.configArray[i]);
			//for(int i = 0; i< replaceArray.Length;i++)
			//    config.replaceArray[i] = AConfigItem.Copy(this.replaceArray[i]);
			for (int i = 0; i < configArray.Length; i++)
				if ((this.configArray[i] != null) && (config.configArray[i] != null))
					this.configArray[i].CopyTo(config.configArray[i]);
			for (int i = 0; i < replaceArray.Length; i++)
				if ((this.replaceArray[i] != null) && (config.replaceArray[i] != null))
					this.replaceArray[i].CopyTo(config.replaceArray[i]);
			return config;
		}

		public T GetConfigValue<T>(ConfigCode code)
		{
			AConfigItem item = GetItem(code);
			if ((item != null) && (item is ConfigItem<T>))
				return ((ConfigItem<T>)item).Value;
			throw new ExeEE("GetConfigValueCode܂͌^sK");
		}

#region getitem
		public AConfigItem GetItem(ConfigCode code)
		{
			AConfigItem item = GetConfigItem(code);
			if (item == null)
				return GetReplaceItem(code);
			return item;
		}
		public AConfigItem GetItem(string key)
		{
			AConfigItem item = GetConfigItem(key);
			if (item == null)
				return GetReplaceItem(key);
			return item;
		}

		public AConfigItem GetConfigItem(ConfigCode code)
		{
			foreach (AConfigItem item in configArray)
			{
				if (item == null)
					continue;
				if (item.Code == code)
					return item;
			}
			return null;
		}
		public AConfigItem GetConfigItem(string key)
		{
			foreach (AConfigItem item in configArray)
			{
				if (item == null)
					continue;
				if (item.Name == key)
					return item;
				if (item.Text == key)
					return item;
			}
			return null;
		}

		public AConfigItem GetReplaceItem(ConfigCode code)
		{
			foreach (AConfigItem item in replaceArray)
			{
				if (item == null)
					continue;
				if (item.Code == code)
					return item;
			}
			return null;
		}
		public AConfigItem GetReplaceItem(string key)
		{
			foreach (AConfigItem item in replaceArray)
			{
				if (item == null)
					continue;
				if (item.Name == key)
					return item;
				if (item.Text == key)
					return item;
			}
			return null;
		}
#endregion

#region vpeB

		public bool IgnoreCase { get { return GetConfigValue<bool>(ConfigCode.IgnoreCase); } }
		public bool UseRenameFile { get { return GetConfigValue<bool>(ConfigCode.UseRenameFile); } }
		public bool UseReplaceFile { get { return GetConfigValue<bool>(ConfigCode.UseReplaceFile); } }
		public bool UseMouse { get { return GetConfigValue<bool>(ConfigCode.UseMouse); } }
		public bool UseMenu { get { return GetConfigValue<bool>(ConfigCode.UseMenu); } }
		public bool UseDebugCommand { get { return GetConfigValue<bool>(ConfigCode.UseDebugCommand); } }
		public bool AllowMultipleInstances { get { return GetConfigValue<bool>(ConfigCode.AllowMultipleInstances); } }
		public bool AutoSave { get { return GetConfigValue<bool>(ConfigCode.AutoSave); } }
		public bool SizableWindow { get { return GetConfigValue<bool>(ConfigCode.SizableWindow); } }
		public bool UseImageBuffer { get { return GetConfigValue<bool>(ConfigCode.UseImageBuffer); } }
		public TextDrawingMode TextDrawingMode { get { return GetConfigValue<TextDrawingMode>(ConfigCode.TextDrawingMode); } }
		public int WindowX { get { return GetConfigValue<int>(ConfigCode.WindowX); } }
		public int WindowY { get { return GetConfigValue<int>(ConfigCode.WindowY); } }
		public int MaxLog { get { return GetConfigValue<int>(ConfigCode.MaxLog); } }
		public int PrintCPerLine { get { return GetConfigValue<int>(ConfigCode.PrintCPerLine); } }
		public int PrintCLength { get { return GetConfigValue<int>(ConfigCode.PrintCLength); } }
		public Color ForeColor { get { return GetConfigValue<Color>(ConfigCode.ForeColor); } }
		public Color BackColor { get { return GetConfigValue<Color>(ConfigCode.BackColor); } }
		public Color FocusColor { get { return GetConfigValue<Color>(ConfigCode.FocusColor); } }
		public Color LogColor { get { return GetConfigValue<Color>(ConfigCode.LogColor); } }
		public int Fontsize { get { return GetConfigValue<int>(ConfigCode.FontSize); } }
		public string Fontname { get { return GetConfigValue<string>(ConfigCode.FontName); } }
		public int LineHeight { get { return GetConfigValue<int>(ConfigCode.LineHeight); } }
		public int FPS { get { return GetConfigValue<int>(ConfigCode.FPS); } }
		public int SkipFrame { get { return GetConfigValue<int>(ConfigCode.SkipFrame); } }
		public int InfiniteLoopAlertTime { get { return GetConfigValue<int>(ConfigCode.InfiniteLoopAlertTime); } }

		public int DisplayWarningLevel { get { return GetConfigValue<int>(ConfigCode.DisplayWarningLevel); } }
		public bool DisplayReport { get { return GetConfigValue<bool>(ConfigCode.DisplayReport); } }
		public ReduceArgumentOnLoadFlag ReduceArgumentOnLoad { get { return GetConfigValue<ReduceArgumentOnLoadFlag>(ConfigCode.ReduceArgumentOnLoad); } }
		public bool ReduceFormattedStringOnLoad { get { return GetConfigValue<bool>(ConfigCode.ReduceFormattedStringOnLoad); } }
		public bool IgnoreUncalledFunction { get { return GetConfigValue<bool>(ConfigCode.IgnoreUncalledFunction); } }
		public DisplayWarningFlag FunctionNotFoundWarning { get { return GetConfigValue<DisplayWarningFlag>(ConfigCode.FunctionNotFoundWarning); } }
		public DisplayWarningFlag FunctionNotCalledWarning { get { return GetConfigValue<DisplayWarningFlag>(ConfigCode.FunctionNotCalledWarning); } }
		public List<string> IgnoreWarningFiles { get { return GetConfigValue<List<string>>(ConfigCode.IgnoreWarningFiles); } }

		public bool ChangeMasterNameIfDebug { get { return GetConfigValue<bool>(ConfigCode.ChangeMasterNameIfDebug); } }
		public long LastKey { get { return GetConfigValue<long>(ConfigCode.LastKey); } }
		public bool ButtonWrap { get { return GetConfigValue<bool>(ConfigCode.ButtonWrap); } }

		public string MoneyLabel { get { return GetConfigValue<string>(ConfigCode.MoneyLabel); } }
		public bool MoneyFirst { get { return GetConfigValue<bool>(ConfigCode.MoneyFirst); } }
		public string LoadLabel { get { return GetConfigValue<string>(ConfigCode.LoadLabel); } }
		public int MaxShopItem { get { return GetConfigValue<int>(ConfigCode.MaxShopItem); } }
		public string DrawLineString { get { return GetConfigValue<string>(ConfigCode.DrawLineString); } }
		public char BarChar1 { get { return GetConfigValue<char>(ConfigCode.BarChar1); } }
		public char BarChar2 { get { return GetConfigValue<char>(ConfigCode.BarChar2); } }
		public string TitleMenuString0 { get { return GetConfigValue<string>(ConfigCode.TitleMenuString0); } }
		public string TitleMenuString1 { get { return GetConfigValue<string>(ConfigCode.TitleMenuString1); } }
#endregion
		bool updated = false;

		Dictionary<FontStyle, Font> fontDic = new Dictionary<FontStyle, Font>();
		public Font Font { get { return GetFont(FontStyle.Regular); } }
		public Font GetFont(FontStyle style)
		{
			if (!fontDic.ContainsKey(style))
			{
				string fontname = GetConfigValue<string>(ConfigCode.FontName);
				int fontsize = GetConfigValue<int>(ConfigCode.FontSize);
				try
				{
					fontDic.Add(style, new Font(fontname, fontsize, style, GraphicsUnit.Pixel));
				}
				catch
				{
					fontDic.Add(style, new Font(fontname, fontsize, FontStyle.Regular, GraphicsUnit.Pixel));
				}
			}
			return fontDic[style];
		}

		public void ClearFont()
		{
			foreach (KeyValuePair<FontStyle, Font> pair in fontDic)
			{
				pair.Value.Dispose();
			}
			fontDic.Clear();
		}
		public List<KeyValuePair<string, string>> GetFiles(string rootdir, string pattern)
		{
			bool toponly = !GetConfigValue<bool>(ConfigCode.SearchSubdirectory);
			bool sort = GetConfigValue<bool>(ConfigCode.SortWithFilename);
			return getFiles(rootdir, rootdir, pattern, toponly, sort);
		}

		private List<KeyValuePair<string, string>> getFiles(string dir, string rootdir, string pattern,bool toponly, bool sort)
		{
			List<KeyValuePair<string, string>> retList = new List<KeyValuePair<string, string>>();
			if (!toponly)
			{
				string[] dirList = Directory.GetDirectories(dir, "*", SearchOption.TopDirectoryOnly);
				if (dirList.Length > 0)
				{
					if (sort)
						Array.Sort(dirList, new StrIgnoreCaseComparer());
					for (int i = 0; i < dirList.Length; i++)
						retList.AddRange(getFiles(dirList[i], rootdir,pattern,toponly, sort));
				}
			}
			string RelativePath = "";
			if (string.Equals(dir, rootdir, StringComparison.CurrentCultureIgnoreCase))
				RelativePath = "";
			else
			{
				if (!dir.StartsWith(rootdir, StringComparison.CurrentCultureIgnoreCase))
					RelativePath = dir;
				else
					RelativePath = dir.Substring(rootdir.Length);
				if (!RelativePath.EndsWith("\\") && !RelativePath.EndsWith("/"))
					RelativePath += "\\";
			}
			string[] erbFiles = Directory.GetFiles(dir, pattern, SearchOption.TopDirectoryOnly);
			if (sort)
				Array.Sort(erbFiles, new StrIgnoreCaseComparer());
			for (int i = 0; i < erbFiles.Length; i++)
				retList.Add(new KeyValuePair<string, string>(RelativePath + Path.GetFileName(erbFiles[i]), erbFiles[i]));
			return retList;
		}

		public bool NeedReduceArgumentOnLoad
		{
			get
			{

				ReduceArgumentOnLoadFlag flag = GetConfigValue<ReduceArgumentOnLoadFlag>(ConfigCode.ReduceArgumentOnLoad);
				if (flag == ReduceArgumentOnLoadFlag.ONCE)
					return updated;
				if (flag == ReduceArgumentOnLoadFlag.YES)
					return true;
				//if (flag == ReduceArgumentOnLoadFlag.NO)
				return false;
			}
		}

		private long getUpdateKey()
		{
			string csvDir = Program.ExeDir + "csv\\";
			string erbDir = Program.ExeDir + "erb\\";
			string[] erbFiles = Directory.GetFiles(erbDir, "*.ERB", SearchOption.TopDirectoryOnly);
			string[] csvFiles = Directory.GetFiles(erbDir, "*.csv", SearchOption.TopDirectoryOnly);
			long[] writetimes = new long[erbFiles.Length + csvFiles.Length];
			for (int i = 0; i < erbFiles.Length; i++)
				writetimes[i] = System.IO.File.GetLastWriteTime(erbFiles[i]).ToBinary();
			for (int i = 0; i < csvFiles.Length; i++)
				writetimes[i + erbFiles.Length] = System.IO.File.GetLastWriteTime(csvFiles[i]).ToBinary();
			long key = 0;
			for (int i = 0; i < writetimes.Length; i++)
			{
				unchecked
				{
					key ^= writetimes[i] * 1103515245 + 12345;
				}
			}
			return key;
		}

		private void checkUpdate()
		{
			ReduceArgumentOnLoadFlag flag = GetConfigValue<ReduceArgumentOnLoadFlag>(ConfigCode.ReduceArgumentOnLoad);
			if (flag != ReduceArgumentOnLoadFlag.ONCE)
				return;
			long lastKey = GetConfigValue<long>(ConfigCode.LastKey);
			updated = true;
			if (lastKey == 0)
			{
				return;
			}
			long key = getUpdateKey();
			updated = lastKey != key;
			GetItem(ConfigCode.LastKey).SetValue(key);
			if (updated)
				SaveConfig();
		}

		public bool SaveConfig()
		{
			StreamWriter writer = null;

			try
			{
				writer = new StreamWriter(configPath, false, Encode);
				for (int i = 0; i < configArray.Length; i++)
				{
					AConfigItem item = configArray[i];
					if (item == null)
						continue;
					if ((item.Code == ConfigCode.ChangeMasterNameIfDebug) && (item.GetValue<bool>()))
						continue;
					if ((item.Code == ConfigCode.LastKey) && !(item.GetValue<long>() == 0))
						continue;
					if (item.Code == ConfigCode.IgnoreWarningFiles)
					{
						List<string> files = item.GetValue<List<string>>();
						foreach (string filename in files)
							writer.WriteLine(item.Text + ":" + filename.ToString());
						continue;
					}
					writer.WriteLine(item.ToString());
				}
			}
			catch (Exception)
			{
				return false;
			}
			finally
			{
				if (writer != null)
					writer.Close();
			}
			return true;
		}

		public bool LoadConfig()
		{
			ClearFont();
			LoadConfig(defaultConfigPath, false);
			LoadConfig(configPath, false);
			LoadConfig(fixedConfigPath, true);
			if (!File.Exists(configPath))
				SaveConfig();
			checkUpdate();
			return true;
		}

		public bool LoadConfig(string confPath, bool fix)
		{
			if (!File.Exists(confPath))
				return false;
			EraStreamReader eReader = new EraStreamReader();
			if (!eReader.Open(confPath))
				return false;
			try
			{
				string line = null;
				bool defineIgnoreWarningFiles = false;
				while ((line = eReader.ReadLine()) != null)
				{
					if ((line.Length == 0) || (line[0] == ';'))
						continue;
					string[] tokens = line.Split(new char[] { ':' });
					if (tokens.Length < 2)
						continue;
					AConfigItem item = GetConfigItem(tokens[0].Trim());
					if (item != null)
					{
						if ((item.Code == ConfigCode.IgnoreWarningFiles))
						{ 
							if (!defineIgnoreWarningFiles)
								(item.GetValue<List<string>>()).Clear();
							defineIgnoreWarningFiles = true;
							if ((item.Fixed) && (fix))
								item.Fixed = false;
						}
						if ((item.TryParse(tokens[1])) && (fix))
							item.Fixed = true;
					}
#if DEBUG
					//else
					//	throw new Exception("RtBOt@C");
#endif
				}
			}
			catch { return false; }
			finally { eReader.Dispose(); }
			return true;
		}

		// 1.52aϕ@iPʂ̍ւёOuAû߂̃RtBOj
		public void LoadReplaceFile(string filename)
		{
			EraStreamReader eReader = new EraStreamReader();
			if (!eReader.Open(filename))
				return;
			try
			{
				string line = null;
				while ((line = eReader.ReadLine()) != null)
				{
					if ((line.Length == 0) || (line[0] == ';'))
						continue;
					string[] tokens = line.Split(new char[] { ',', ':' });
					if (tokens.Length < 2)
						continue;
					AConfigItem item = GetReplaceItem(tokens[0].Trim());
					if (item != null)
						item.TryParse(tokens[1]);
				}
			}
			catch { return; }
			finally { eReader.Dispose(); }
		}
	}
}