using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameView;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
using System.Windows.Forms;
namespace MinorShift.Emuera.GameProc
{

	internal sealed partial class Process
	{
		public Process(EmueraConsole view)
		{
			console = view;
		}

		/// <summary>
		/// @~~$~~W߂́BCALL߂ȂǂŎg
		/// sLogicalLinegێB
		/// </summary>
		LabelDictionary labelDic;

		/// <summary>
		/// ϐSBXNvgŕKvɂȂϐ́i[U[ڐGȂ̂܂߁j̒ɂ
		/// </summary>
		private VariableEvaluator vEvaluator;
		private ExpressionEvaluator eEvaluator;
		private GameBase gamebase;
		readonly EmueraConsole console;
		ProcessState state;
		public bool Initialize()
		{
			isInitialized = false;
			state = new ProcessState();
			string csvDir = Program.ExeDir + "csv\\";
			string erbDir = Program.ExeDir + "erb\\";
			try
			{

				if (Config.Instance.UseReplaceFile)
				{
					if (File.Exists(csvDir + "_Replace.csv"))
					{
						if (Config.Instance.DisplayReport)
							console.PrintLine("_Replace.csvǂݍݒEEE");
						Config.Instance.LoadReplaceFile(csvDir + "_Replace.csv");
                        console.ChangeStBar();
					}
					//else
					//	console.PrintLine("csv\\_Replace.csv܂");
				}
				if (!Config.Instance.DisplayReport)
				{
					console.PrintLine(Config.Instance.LoadLabel);
					console.RefreshStrings(true);
				}
				gamebase = new GameBase();
				gamebase.LoadGameBaseCsv(csvDir + "GAMEBASE.CSV");
				ConstantData constant = new ConstantData(gamebase);
				constant.LoadData(csvDir, console);
				vEvaluator = new VariableEvaluator(gamebase, constant);
				//VariableEvaluator.SetTestData(vEvaluator);
				eEvaluator = new ExpressionEvaluator(vEvaluator);
				//if (File.Exists(csvDir + "_Rename.csv"))
				//    VarData.LoadEraExRenameFile(csvDir + "_Rename.csv");
				ErbLoader loader = new ErbLoader(console, vEvaluator);
				if (Config.Instance.UseRenameFile)
				{
					if (File.Exists(csvDir + "_Rename.csv"))
						loader.LoadEraExRenameFile(csvDir + "_Rename.csv");
					else
						console.PrintLine("csv\\_Rename.csv܂");
				}

				labelDic = loader.LoadErbFiles(erbDir, Config.Instance.DisplayReport);
				initSystemProcess();
			}
			catch (CodeEE e)
			{
				if (e.Position != null)
				{
					console.PrintLine(e.Position.Filename + "" + e.Position.LineNo.ToString() + "sڂŃG[܂");
					console.PrintLine(e.Position.RowLine);
				}
				console.PrintLine(e.Message);
				return false;
			}
			catch (Exception)
			{
				console.PrintLine("ɒvIȃG[܂");
				return false;
			}
			if (labelDic == null)
			{
				return false;
			}
			isInitialized = true;
			state.SystemState = SystemStateCode.Title_Begin;
			return true;
		}

		//public bool InitialaizeWithoutLoad()
		//{
		//    vEvaluator = new VariableEvaluator(vEvaluator.Gamebase, vEvaluator.Constant);
		//    //VariableEvaluator.SetTestData(vEvaluator);
		//    eEvaluator = new ExpressionEvaluator(vEvaluator);
		//    vEvaluator.AddCharacter(0, false);
		//    if (vEvaluator.Gamebase.DefaultCharacter > 0)
		//        vEvaluator.AddCharacter(vEvaluator.Gamebase.DefaultCharacter, false);
		//    return true;
		//}

        public void ReloadErb()
        {
			saveCurrentState(false);
			state.ClearFunctionList();
			state.SystemState = SystemStateCode.System_Reloaderb;
            isInitialized = false;
            labelDic = null;
            string erbDir = Program.ExeDir + "erb\\";
            ErbLoader loader = new ErbLoader(console, vEvaluator);
            labelDic = loader.LoadErbFiles(erbDir, false);
			isInitialized = true;
			console.ReadAnyKey();
        }

        public void SetCommnds(Int64 count)
        {
            coms = new List<long>((int)count);
            isCTrain = true;
            for (int i = 0; i < (int)count; i++)
            {
                string comStr = string.Format("SELECTCOM:{0}", (i + 1));
                StringStream aSt = new StringStream(comStr);
                Int64 comNum = eEvaluator.GetInteger(ExpressionParser.ReduceIntegerTerm(aSt));
                coms.Add(comNum);
            }
        }

        public void InputInteger(Int64 i)
		{
			vEvaluator.RESULT = i;
		}
		public void InputSystemInteger(Int64 i)
		{
			systemResult = i;
		}
		public void InputString(string s)
		{
			vEvaluator.RESULTS = s;
		}

		public bool isInitialized = false;
		private long lineCount = 0;
		private uint startTime = 0;
		public void DoScript()
		{
			startTime = _Library.WinmmTimer.TickCount;
			lineCount = 0;
			while (true)
			{
                if (state.ScriptEnd)
                    runSystemProcWithCatch();
				if (!console.IsRunning)
				{
				//    if (console.hasWaitRefresh || console.needRefresh)
				//        console.RefreshStrings(true);
					break;
				}
				runScriptProcWithCatch();
				//if (console.needRefresh)
				//    console.RefreshStrings(true);
			}
			return;
		}

		private void runSystemProcWithCatch()
		{
			try
			{
				runSystemProc();
			}
			catch (Exception e)
			{
				if (e is CodeEE)
					console.PrintLine("֐̏I[ŃG[܂");
				else if (e is ExeEE)
					console.PrintLine("֐̏I[EmuerãG[܂");
				else
					console.PrintLine("֐̏I[ŗ\ȂG[܂");
				console.PrintLine(e.Message);
				console.ThrowError();
			}
		}

        public void BeginTitle()
        {
			vEvaluator.ResetData();
			state.ClearFunctionList();
            state.SystemState = SystemStateCode.Title_Begin;
        }

		private void checkInfiniteLoop()
		{
			uint time = _Library.WinmmTimer.TickCount - startTime;
			if (time < Config.Instance.InfiniteLoopAlertTime)
				return;
			LogicalLine currentLine = state.CurrentLine;
			if ((currentLine == null) || (currentLine is NullLine))
				return;//݂̍sȏԂȂX[
			if (!console.Enabled)
				return;//N[YĂMessageBox.ShowłȂ̂ŁB
			string caption = string.Format("[v̉\܂");
			string text = string.Format(
				"݁A{0}{1}sڂsłB\nŌ̓͂{3}~bo߂{2}ss܂B\n𒆒fI܂H",
				currentLine.Position.Filename, currentLine.Position.LineNo, lineCount, time);
			DialogResult result = MessageBox.Show(text, caption, MessageBoxButtons.YesNo);
			if (result == DialogResult.Yes)
			{
				throw new CodeEE("[v̋^ɂ苭II܂");
			}
			else
			{
				lineCount = 0;
				startTime = _Library.WinmmTimer.TickCount;
			}
		}

		///DoScript()̈ꕔBG[Ȃ̂ŕB
		private void runScriptProcWithCatch()
		{
			try
			{
				runScriptProc();

				lineCount++;
				if (lineCount % 10000 == 0)
				{//WinmmTimer玞Ԃ擾̂͂ꎩ̌\ȃRXĝ1000sɈ񂭂炢ŁB

					//܂ȂBBEEP̂~߂Ȃ̂ł̏ȂƂɁi1.51j
					////t[Yh~Błł
					//System.Windows.Forms.Application.DoEvents();
					////System.Threading.Thread.Sleep(0);

					//if (!console.Enabled)
					//{
					//    //DoEvents()̊ԂɃEChEꂽ炨܂B
					//    console.ReadAnyKey();
					//    return;
					//}
					if (Config.Instance.InfiniteLoopAlertTime > 0)
					{
						checkInfiniteLoop();
					}
				}
			}
			catch (Exception ec)
			{
				LogicalLine currentLine = state.CurrentLine;
				if ((currentLine == null) || (currentLine is NullLine))
					currentLine = null;
				if ((currentLine != null) && (currentLine.Position != null))
				{
					if (ec is CodeEE)//*.ERB̖ƎvO
						console.PrintLine(currentLine.Position.Filename + "" + currentLine.Position.LineNo.ToString() + "sڂŃG[܂");
					else if (ec is ExeEE)//emuera.exe{̂ɋNƎvOBoOB
						console.PrintLine(currentLine.Position.Filename + "" + currentLine.Position.LineNo.ToString() + "sڂEmuera.exẽG[܂");
					else//SystemExceptionB\ȂO
						console.PrintLine(currentLine.Position.Filename + "" + currentLine.Position.LineNo.ToString() + "sڂŗ\ȂG[܂");
					console.PrintLine(currentLine.Position.RowLine);
				}
				else
				{
					if (ec is CodeEE)//*.ERB̖ƎvO
						console.PrintLine("G[܂");
					else if (ec is ExeEE)//emuera.exe{̂ɋNƎvOBoOB
						console.PrintLine("Emuera.exẽG[܂");
					else//SystemExceptionB\ȂO
						console.PrintLine("\ȂG[܂");
					console.PrintLine("ӏł܂ł");
				}
				if (ec is EmueraException)
					console.PrintLine(ec.Message);
				else//SystemExceptionBG[em邽߂ɂMessageނType̕dv
					console.PrintLine(ec.GetType().ToString() + ":" + ec.Message);
				console.ThrowError();
			}
			return;
		}

	}
}
