using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace MinorShift.Emuera.Sub
{
	internal enum EraDataState
	{
		OK = 0,//[h\
		FILENOTFOUND = 1,//t@C݂
		GAME_ERROR = 2,//Q[Ⴄ
		VIRSION_ERROR = 3,//o[WႤ
		ETC_ERROR = 4,//̑̃G[

	}

	internal sealed class EraDataResult
	{
		public EraDataState State = EraDataState.OK;
		public string DataMes = "";
	}

	/// <summary>
	/// Z[uf[^ǂݎ
	/// </summary>
	internal sealed class EraDataReader : IDisposable
	{
		public EraDataReader(StreamReader stream)
		{
			reader = stream;
		}
		StreamReader reader;
		public const string FINISHER = "__FINISHED";
		public string ReadString()
		{
			if (reader == null)
				throw new FileEE("ȃXg[ł");
			string str = reader.ReadLine();
			if(str == null)
				throw new FileEE("ǂݎׂ񂪂܂");
			return str;
		}

		public Int64 ReadInt64()
		{
			if (reader == null)
				throw new FileEE("ȃXg[ł");
			Int64 ret = 0;
			string str = reader.ReadLine();
			if (str == null)
				throw new FileEE("ǂݎׂl܂");
			if (!Int64.TryParse(str, out ret))
				throw new FileEE("lƂĔFł܂");
			return ret;
		}


		public void ReadInt64Array(Int64[] array)
		{
			if (reader == null)
				throw new FileEE("ȃXg[ł");
			if (array == null)
				throw new FileEE("Ȕz񂪓n܂");
			int i = -1;
			string str = null;
			Int64 integer = 0;
			i = -1;
			while (true)
			{
				i++;
				str = reader.ReadLine();
				if (str == null)
					throw new FileEE("\ȂZ[uf[^̏I[ł");
				if (str.Equals(FINISHER, StringComparison.Ordinal))
					break;
				if (i >= array.Length)//z𒴂ĕۑĂĂȂœǂݔ΂B
					continue;
				if (!Int64.TryParse(str, out integer))
					throw new FileEE("lƂĔFł܂");
				array[i] = integer;
			}
			for (; i < array.Length; i++)//ۑĂlȂ0ɏ
				array[i] = 0;
		}

		public void ReadStringArray(string[] array)
		{
			if (reader == null)
				throw new FileEE("ȃXg[ł");
			if (array == null)
				throw new FileEE("Ȕz񂪓n܂");
			int i = -1;
			string str = null;
			i = -1;
			while (true)
			{
				i++;
				str = reader.ReadLine();
				if (str == null)
					throw new FileEE("\ȂZ[uf[^̏I[ł");
				if (str.Equals(FINISHER, StringComparison.Ordinal))
					break;
				if (i >= array.Length)//z𒴂ĕۑĂĂȂœǂݔ΂B
					continue;
				array[i] = str;
			}
			for (; i < array.Length; i++)//ۑĂlȂ""ɏ
				array[i] = "";
		}

		#region IDisposable o

		public void Dispose()
		{
			if (reader != null)
				reader.Close();
			reader = null;
		}

		#endregion
		public void Close()
		{
			this.Dispose();
		}

	}

	/// <summary>
	/// Z[uf[^
	/// </summary>
	internal sealed class EraDataWriter : IDisposable
	{
		public EraDataWriter(StreamWriter stream)
		{
			writer = stream;
		}

		public const string FINISHER = EraDataReader.FINISHER;
		StreamWriter writer;
		public void Write(Int64 integer)
		{
			if (writer == null)
				throw new FileEE("ȃXg[ł");
			writer.WriteLine(integer.ToString());
		}


		public void Write(string str)
		{
			if (writer == null)
				throw new FileEE("ȃXg[ł");
			if (str == null)
				writer.WriteLine("");
			else
				writer.WriteLine(str);
		}

		public void Write(Int64[] array)
		{
			if (writer == null)
				throw new FileEE("ȃXg[ł");
			if (array == null)
				throw new FileEE("Ȕz񂪓n܂");
			int count = -1;
			for (int i = 0; i < array.Length; i++)
				if (array[i] != 0)
					count = i;
			count++;
			for (int i = 0; i < count; i++)
				writer.WriteLine(array[i].ToString());
			writer.WriteLine(FINISHER);
		}


		public void Write(string[] array)
		{
			if (writer == null)
				throw new FileEE("ȃXg[ł");
			if (array == null)
				throw new FileEE("Ȕz񂪓n܂");
			int count = -1;
			for (int i = 0; i < array.Length; i++)
				if (!string.IsNullOrEmpty(array[i]))
					count = i;
			count++;
			for (int i = 0; i < count; i++)
			{
				if (array[i] == null)
					writer.WriteLine("");
				else
					writer.WriteLine(array[i]);
			}
			writer.WriteLine(FINISHER);
		}

		#region IDisposable o

		public void Dispose()
		{
			if (writer != null)
				writer.Close();
			writer = null;
		}

		#endregion
		public void Close()
		{
			this.Dispose();
		}
	}
}
