using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera.GameData
{
	internal sealed class GameBase
	{
		public string ScriptAutherName = "";
		public string ScriptDetail = "";//ڍׂȐ
		public string ScriptYear = "";
		public string ScriptTitle = "";
		public int ScriptUniqueCode = 0;
		public int ScriptVersion = 1000;
		public int ScriptCompatibleMinVersion = -1;

		public int DefaultCharacter = -1;
		public int DefaultNoItem = 0;

		public void LoadGameBaseCsv(string basePath)
		{
			if (!File.Exists(basePath))
				return;

			EraStreamReader eReader = new EraStreamReader();
			if (!eReader.Open(basePath))
			{
				//output.PrintLine(eReader.Filename + "̃I[vɎs܂");
				return;
			}
			try
			{
				string line = null;
				while ((line = eReader.ReadLine()) != null)
				{
					if ((line.Length == 0) || (line[0] == ';'))
						continue;
					string[] tokens = line.Split(',');
					if (tokens.Length < 2)
						continue;
					string param = tokens[1].Trim();
					int i = 0;
					switch (tokens[0])
					{
						case "R[h":
							if(Int32.TryParse(tokens[1], out i))
								ScriptUniqueCode = i;
							break;
						case "o[W":
							if(Int32.TryParse(tokens[1], out i))
								ScriptVersion = i;
							break;
						case "o[WႢF߂":
							if(Int32.TryParse(tokens[1], out i))
								ScriptCompatibleMinVersion = i;
							break;
						case "ŏ炢L":
							if(Int32.TryParse(tokens[1], out i))
								DefaultCharacter = i;
							break;
						case "ACeȂ":
							if(Int32.TryParse(tokens[1], out i))
								DefaultNoItem = i;
							break;
						case "^Cg":
							ScriptTitle = tokens[1];
							break;
						case "":
							ScriptAutherName = tokens[1];
							break;
						case "N":
							ScriptYear = tokens[1];
							break;
						case "ǉ":
							ScriptDetail = tokens[1];
							break;

					}

				}
			}
			catch
			{
				return;
			}
			finally
			{
				eReader.Close();
			}
			return;
		}

	}





}
