using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
using MinorShift._Library;
namespace MinorShift.Emuera.GameProc
{
	internal sealed partial class Process
	{

		private void runScriptProc()
		{
			bool sequential = state.Sequential;
			state.ShfitNextLine();
			LogicalLine line = state.CurrentLine;
			vEvaluator.Scope = state.Scope;
			if (line == null)
				throw new ExeEE("Emuera.exe͎Ɏss܂");
			else if (line.IsError)
				throw new CodeEE(line.ErrMes);
			else if (line is NullLine)
			{//t@CI[
				vEvaluator.RESULT = 0;
				state.Return(0);
			}
			else if (line is FunctionLabelLine)
			{
				if (sequential)
				{//ꗎĂi֐I[j
					vEvaluator.RESULT = 0;
					state.Return(0);
				}
				else//CALLJUMPŔł
					return;
			}
			else if (line is GotoLabelLine)
				return;//xB邱Ƃ͂ȂB
			else if (line is InstructionLine)
			{
				InstructionLine func = (InstructionLine)line;
				if (func.Argument == null)
					LogicalLineParser.SetArgumentTo(func, null);
				if (func.IsError)
					throw new CodeEE(func.ErrMes);
				if (BuiltInFunctionManager.IsFlowContorol(func.Function))
					doFlowControlFunction(func, sequential);
				else
					doNormalFunction(func);
			}
			else if (line is InvalidLine)
			{
				if (string.IsNullOrEmpty(line.ErrMes))
					throw new CodeEE("ǍɎsss܂BG[̏ڍׂ͓Ǎ̌xQƂĂB");
				else
					throw new CodeEE(line.ErrMes);
			}
			else
				throw new ExeEE("`ĂȂނ̍sł");
		}

		public void DoDebugNormalFunction(InstructionLine line)
		{
			doNormalFunction(line);
			vEvaluator.IamaMunchkin();
		}

		#region normal
		void doNormalFunction(InstructionLine line)
		{
			string str = null;
			IOperandTerm term = null;
			switch (line.Function)
			{
				case BuiltInFunctionCode.SET:
					{
						SpSetArgument spsetarg = (SpSetArgument)line.Argument;
						FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetarg.VariableDest);
						vEvaluator.SetValue(p, eEvaluator.GetInteger(spsetarg.Term));
					}
					break;
				case BuiltInFunctionCode.SETS:
					{
						SpSetsArgument spsetsarg = (SpSetsArgument)line.Argument;
						FixedVariablePointer p = eEvaluator.GetFixedVariable(spsetsarg.VariableDest);
						vEvaluator.SetValue(p, spsetsarg.StrForm.GetString(eEvaluator));
					}
					break;
				case BuiltInFunctionCode.PRINT://\
				case BuiltInFunctionCode.PRINTL://s
				case BuiltInFunctionCode.PRINTW://͑҂(s)
					str = ((StrArgument)line.Argument).Str;
					console.Print(str);
					if (line.Function != BuiltInFunctionCode.PRINT)
						console.NewLine();
					if (line.Function == BuiltInFunctionCode.PRINTW)
						console.ReadAnyKey();
					break;

				case BuiltInFunctionCode.PRINTV://ϐ̓e
				case BuiltInFunctionCode.PRINTVL:
				case BuiltInFunctionCode.PRINTVW:
					foreach (IOperandTerm termV in ((SpPrintVArgument)line.Argument).Terms)
					{
						if (termV.GetOperandType() == typeof(Int64))
							console.Print(eEvaluator.GetInteger(termV).ToString());
						else
							console.Print(((SingleTerm)termV).Str);

					}
					if (line.Function != BuiltInFunctionCode.PRINTV)
						console.NewLine();
					if (line.Function == BuiltInFunctionCode.PRINTVW)
						console.ReadAnyKey();
					break;
				case BuiltInFunctionCode.PRINTS://ϐ̓e
				case BuiltInFunctionCode.PRINTSL:
				case BuiltInFunctionCode.PRINTSW:
					term = ((ExpressionArgument)line.Argument).Term;
					console.Print(eEvaluator.GetString(term));
					if (line.Function != BuiltInFunctionCode.PRINTS)
						console.NewLine();
					if (line.Function == BuiltInFunctionCode.PRINTSW)
						console.ReadAnyKey();
					break;

				case BuiltInFunctionCode.PRINTFORM://{}A%ϐ%Ȃǂ̏gB
				case BuiltInFunctionCode.PRINTFORML:
				case BuiltInFunctionCode.PRINTFORMW:
					{
						StringForm strForm = ((FormStrArgument)line.Argument).StrForm;
						console.Print(strForm.GetString(eEvaluator));
						if (line.Function != BuiltInFunctionCode.PRINTFORM)
							console.NewLine();
						if (line.Function == BuiltInFunctionCode.PRINTFORMW)
							console.ReadAnyKey();
					}
					break;
				case BuiltInFunctionCode.PRINTFORMS://ϐ̓eϊĕ\܂B
				case BuiltInFunctionCode.PRINTFORMSL:
				case BuiltInFunctionCode.PRINTFORMSW:
					{
						term = ((ExpressionArgument)line.Argument).Term;
						str = eEvaluator.GetString(term);
						StringForm strForm = new StringForm(str);
						console.Print(strForm.GetString(eEvaluator));
						if (line.Function != BuiltInFunctionCode.PRINTFORMS)
							console.NewLine();
						if (line.Function == BuiltInFunctionCode.PRINTFORMSW)
							console.ReadAnyKey();
					}
					break;
				case BuiltInFunctionCode.PRINTC:
					console.PrintC(((StrArgument)line.Argument).Str, true);
					break;

				case BuiltInFunctionCode.WAIT://s҂B
					console.ReadAnyKey();
					break;
				case BuiltInFunctionCode.INPUT://́B͂RESULTցB
					console.ReadInteger();
					break;
				case BuiltInFunctionCode.INPUTS://́B͂RESULTSցB
					console.ReadString();
					break;

				case BuiltInFunctionCode.DRAWLINE://ʂ̍[E[܂----ƐB
					console.DrawLine();
					console.NewLine();
					break;
				case BuiltInFunctionCode.BAR://[*****....]̂悤ȃOtBBAR (ϐ) , (ől), ()
				case BuiltInFunctionCode.BARL://stB
					{
						SpBarArgument barArg = (SpBarArgument)line.Argument;
						Int64 var = eEvaluator.GetInteger(barArg.Terms[0]);
						Int64 max = eEvaluator.GetInteger(barArg.Terms[1]);
						Int64 length = eEvaluator.GetInteger(barArg.Terms[2]);
						console.Print(createBar(var, max, length));
					}
					if (line.Function == BuiltInFunctionCode.BARL)
						console.NewLine();
					break;
				case BuiltInFunctionCode.TIMES://vZBTIMES (ϐ) , (l)Ƃ`ŎgB
					{
						SpTimesArgument timesArg = (SpTimesArgument)line.Argument;
						VariableToken var = timesArg.VariableDest;
						double d = eEvaluator.GetInteger(var) * timesArg.DoubleValue;
						FixedVariablePointer p = eEvaluator.GetFixedVariable(var);
						unchecked
						{
							vEvaluator.SetValue(p, (Int64)d);
						}
					}
					break;
				case BuiltInFunctionCode.PRINT_ABL://\́B͓o^ԍ
				case BuiltInFunctionCode.PRINT_TALENT://f
				case BuiltInFunctionCode.PRINT_MARK://
				case BuiltInFunctionCode.PRINT_EXP://o
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(intExpArg.Term);
						console.Print(vEvaluator.GetCharacterDataString(target, line.Function));
						console.NewLine();
					}
					break;
				case BuiltInFunctionCode.PRINT_PALAM://p[^
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(intExpArg.Term);
						int count = 0;
						///100ȍ~͔ے̎ƂȂ̂ŕ\Ȃ
						for (int i = 0; i < 100; i++)
						{
							string printStr = vEvaluator.GetCharacterParamString(target, i);
							if (printStr != null)
							{
								console.PrintC(printStr, true);
								count++;
								if (count % Config.Instance.PrintCPerLine == 0)
									console.PrintFlash(false);
							}
						}
						console.PrintFlash(false);
					}
					break;
				case BuiltInFunctionCode.PRINT_ITEM://ACe
					console.Print(vEvaluator.GetHavingItemsString());
					console.NewLine();
					break;
				case BuiltInFunctionCode.PRINT_SHOPITEM://VbvŔĂACe
					{
						int length = Math.Min(vEvaluator.ITEMSALES.Length, vEvaluator.ITEMNAME.Length);
						int count = 0;
						for (int i = 0; i < length; i++)
						{
							if (vEvaluator.ItemSales(i))
							{
								string printStr = vEvaluator.ITEMNAME[i];
								if (printStr == null)
									printStr = "";
								Int64 price = vEvaluator.ITEMPRICE[i];
								// 1.52aϕ@iPʂ̍ւёOuAuɑΉj
								if (Config.Instance.MoneyFirst)
									console.PrintC(string.Format("[{2}] {0}({3}{1})", printStr, price, i, Config.Instance.MoneyLabel), false);
								else
									console.PrintC(string.Format("[{2}] {0}({1}{3})", printStr, price, i, Config.Instance.MoneyLabel), false);
								count++;
								if (count % Config.Instance.PrintCPerLine == 0)
									console.PrintFlash(false);
							}
						}
						console.PrintFlash(false);
					}
					break;
				case BuiltInFunctionCode.UPCHECK://p[^̕ϓ
					vEvaluator.UpdateInUpcheck(console);
					break;
				case BuiltInFunctionCode.ADDCHARA://(Lԍ)̃LN^ǉ
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 integer = eEvaluator.GetInteger(intExpArg.Term);
						vEvaluator.AddCharacter(integer, false);
					}
					break;
				case BuiltInFunctionCode.ADDSPCHARA://(Lԍ)SPLN^ǉitO01ɂč쐬j
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 integer = eEvaluator.GetInteger(intExpArg.Term);
						vEvaluator.AddCharacter(integer, true);
					}
					break;
				case BuiltInFunctionCode.DELCHARA://(Lo^ԍ)̃LN^폜B
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 integer = eEvaluator.GetInteger(intExpArg.Term);
						vEvaluator.DelCharacter(integer);
					}
					break;
				case BuiltInFunctionCode.PUTFORM://@SAVEINFO֐ł̂ݎgp\BPRINTFORMƓl̏ŃZ[uf[^ɊTvB
					{
						StringForm formStr = ((FormStrArgument)line.Argument).StrForm;
						state.AddPUTSAVE(formStr.GetString(eEvaluator));
						break;
					}
				case BuiltInFunctionCode.QUIT://Q[I
					console.Quit();
					break;


				case BuiltInFunctionCode.STRLEN://RESULTɕioCgj
					str = ((StrArgument)line.Argument).Str;
					this.vEvaluator.RESULT = ShiftJisManager.GetStrlenShiftJis(str);
					break;

				case BuiltInFunctionCode.STRLENS:
					term = ((ExpressionArgument)line.Argument).Term;
					this.vEvaluator.RESULT = ShiftJisManager.GetStrlenShiftJis(eEvaluator.GetString(term));
					break;

				case BuiltInFunctionCode.STRLENFORM:
					{
						StringForm strForm = ((FormStrArgument)line.Argument).StrForm;
						this.vEvaluator.RESULT = ShiftJisManager.GetStrlenShiftJis(strForm.GetString(eEvaluator));
					}
					break;

				//1.52bǉ
				case BuiltInFunctionCode.PRINTLC:
					console.PrintC(((StrArgument)line.Argument).Str, false);
					break;
				case BuiltInFunctionCode.PRINTFORMC:
					{
						StringForm strForm = ((FormStrArgument)line.Argument).StrForm;
						console.PrintC(strForm.GetString(eEvaluator), true);
					}
					break;
				//1.52cǉ
				case BuiltInFunctionCode.PRINTFORMLC:
					{
						StringForm strForm = ((FormStrArgument)line.Argument).StrForm;
						console.PrintC(strForm.GetString(eEvaluator), false);
					}
					break;
				case BuiltInFunctionCode.SUBSTRING:
					{
						SpSubstringArgument arg = (SpSubstringArgument)line.Argument;
						FixedVariablePointer p = eEvaluator.GetFixedVariable(arg.VariableSrc);
						str = this.vEvaluator.GetString(p);
						int start = (int)this.eEvaluator.GetInteger(arg.Start);
						int length = (int)this.eEvaluator.GetInteger(arg.Length);
						this.vEvaluator.RESULTS = ShiftJisManager.GetSubStringShiftJis(str, start, length);
					}
					break;
				case BuiltInFunctionCode.SWAPCHARA:
					{
						SpSwapCharaArgument arg = (SpSwapCharaArgument)line.Argument;
						long x = eEvaluator.GetInteger(arg.X);
						long y = eEvaluator.GetInteger(arg.Y);
						vEvaluator.SwapChara(x, y);
						break;
					}
				case BuiltInFunctionCode.VARSIZE:
					{
						SpVarsizeArgument versizeArg = (SpVarsizeArgument)line.Argument;
						VariableIdentifier varID = versizeArg.VariableID;
						this.vEvaluator.RESULT = vEvaluator.GetVariableSize(varID);
					}
					break;
				case BuiltInFunctionCode.SAVEDATA:
					{
						SpSaveDataArgument spSavedataArg = (SpSaveDataArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(spSavedataArg.Target);
						if (target < 0)
							throw new CodeEE("SAVEDATÄɕ̒l(" + target.ToString() + ")w肳܂");
						else if (target > int.MaxValue)
							throw new CodeEE("SAVEDATÄ(" + target.ToString() + ")傫܂");
						string savemes = eEvaluator.GetString(spSavedataArg.VariableSrc);
						saveTo((int)target, savemes);
					}
					break;
				case BuiltInFunctionCode.DELDATA:
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(intExpArg.Term);
						if (target < 0)
							throw new CodeEE("DELDATÄɕ̒l(" + target.ToString() + ")w肳܂");
						else if (target > int.MaxValue)
							throw new CodeEE("DELDATÄ(" + target.ToString() + ")傫܂");
						delData((int)target);
					}
					break;
				case BuiltInFunctionCode.CHKDATA:
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(intExpArg.Term);
						if (target < 0)
							throw new CodeEE("CHKDATÄɕ̒l(" + target.ToString() + ")w肳܂");
						else if (target > int.MaxValue)
							throw new CodeEE("CHKDATÄ(" + target.ToString() + ")傫܂");
						EraDataResult result = checkData((int)target);
						vEvaluator.RESULT = (long)result.State;
						vEvaluator.RESULTS = result.DataMes;
					}
					break;
				case BuiltInFunctionCode.GETTIME:
					{
						long date = DateTime.Now.Year;
						date = date * 100 + DateTime.Now.Month;
						date = date * 100 + DateTime.Now.Day;
						date = date * 100 + DateTime.Now.Hour;
						date = date * 100 + DateTime.Now.Minute;
						date = date * 100 + DateTime.Now.Second;
						date = date * 1000 + DateTime.Now.Millisecond;
						vEvaluator.RESULT = date;//17B2炢B
						vEvaluator.RESULTS = DateTime.Now.ToString();
					}
					break;
				default:
					throw new ExeEE("`̊֐");
			}
			return;
		}


		private string createBar(Int64 var, Int64 max, Int64 length)
		{
			if (max <= 0)
				throw new CodeEE("BAR̍ől̒lł͂܂");
			if (length <= 0)
				throw new CodeEE("BAR̒̒lł͂܂");
			if (length >= 100)//\h߁B
				throw new CodeEE("BAR܂");
			StringBuilder builder = new StringBuilder();
			builder.Append('[');
			int count;
			unchecked
			{
				count = (int)(var * length / max);
			}
			if (count < 0)
				count = 0;
			if (count > length)
				count = (int)length;
			builder.Append('*', count);
			builder.Append('.', (int)length - count);
			builder.Append(']');
			return builder.ToString();
		}

		#endregion

		#region flow control

		void doFlowControlFunction(InstructionLine line, bool sequential)
		{
			StringStream st = new StringStream(line.ArgumentStr);
			ExpressionArgument expArg = null;
			switch (line.Function)
			{
				case BuiltInFunctionCode.BEGIN://VXe֐̎sB
					string keyword = line.ArgumentStr;
					if (Config.Instance.IgnoreCase)
						keyword = keyword.ToUpper();
					if (!Enum.IsDefined(typeof(BeginType), keyword))
						throw new CodeEE("BEGIÑL[[h\"" + keyword + "\"͖`ł");
					state.SetBegin((BeginType)Enum.Parse(typeof(BeginType), keyword));
					state.Return(0);
					break;

				case BuiltInFunctionCode.SAVEGAME://Z[uʂĂԁBVbv̂݁B
					saveCurrentState();
					state.SaveLoadData(true);
					break;
				case BuiltInFunctionCode.LOADGAME://
					saveCurrentState();
					state.SaveLoadData(false);
					break;

				case BuiltInFunctionCode.SIF://ŝIF
					expArg = (ExpressionArgument)line.Argument;
					if (eEvaluator.GetInteger(expArg.Term) != 0)//]^Ȃ炻̂܂ܗꗎ
						break;
					state.ShfitNextLine();//UȂsƂ΂BɗƂƓɂ
					break;
				case BuiltInFunctionCode.IF:
					expArg = (ExpressionArgument)line.Argument;
					if (eEvaluator.GetInteger(expArg.Term) != 0)//^
						break;
					state.JumpTo(line.JumpTo);
					break;

				case BuiltInFunctionCode.ELSE:
					if (sequential)//ڗȂENDIF
					{
						state.JumpTo(line.JumpToEndif);
						break;
					}
					else//IFAELSEIF΂ꂽȂ炻̂܂܎
					{
						break;
					}
				case BuiltInFunctionCode.ELSEIF:
					if (sequential)//ڗȂELSEƓ
					{
						goto case BuiltInFunctionCode.ELSE;
					}
					else//(IFAELSEIF)΂ꂽꍇIFƓ
					{
						goto case BuiltInFunctionCode.IF;
					}
				case BuiltInFunctionCode.ENDIF:
					break;//ENDIFłׂƂ͓ɖ

				case BuiltInFunctionCode.REPEAT://REND܂ŌJԂBJԂ񐔂COUNTցBlXgsB
					if (sequential)//ォ痈Ȃ񐔂̃Zbg
					{
						expArg = (ExpressionArgument)line.Argument;
						line.SubData = eEvaluator.GetInteger(expArg.Term);
						vEvaluator.COUNT = 0;
					}
					else//iRENDACONTINUEjłȂJE^[̑
						vEvaluator.COUNT++;
					if (line.SubData > vEvaluator.COUNT)//܂񐔂cĂȂA
						break;//̂܂܎̍s
					state.JumpTo(line.JumpTo);
					break;


				case BuiltInFunctionCode.REND://REPEATɖ߂
					if (!sequential)//REPEATABREAKłȂ
						break;
					//ŗȂREPEATɋABJԂ񐔂̋Lƃ`FbNREPEATsB
					state.JumpTo(line.JumpTo);
					break;
				case BuiltInFunctionCode.BREAK://REND܂ŃWv
					vEvaluator.COUNT++;//{ƂłBREAKCOUNT
					state.JumpTo(line.JumpTo);
					break;
				case BuiltInFunctionCode.CONTINUE://REPEATɖ߂
				case BuiltInFunctionCode.GOTO://$xփWv
				case BuiltInFunctionCode.TRYGOTO:
				case BuiltInFunctionCode.JUMP://֐Ɉړ
				case BuiltInFunctionCode.TRYJUMP:
				case BuiltInFunctionCode.RESTART://֐̍ĊJB֐̍ŏɖ߂B
					if (line.JumpTo == null)
					{
						if (line.Function == BuiltInFunctionCode.TRYGOTO)
							break;
						if (line.Function == BuiltInFunctionCode.TRYJUMP)
							break;
						throw new ExeEE("Wv悪K؂ɐݒ肳ĂȂ");
					}
					state.JumpTo(line.JumpTo);
					break;
				case BuiltInFunctionCode.CALL://֐ɈړBړLARETURNŋAB
				case BuiltInFunctionCode.TRYCALL:
					{
						if ((line.JumpTo == null) && (line.Function == BuiltInFunctionCode.TRYCALL))
							break;
						if (!sequential)//RETURNŋAĂ
							break;//Ȃ
						string label = line.ArgumentStr.Trim();
						if (Config.Instance.IgnoreCase)
							label = label.ToUpper();
						CalledFunction call = CalledFunction.CallFunction(this, label, line, false);
						if ((call == null) || (call.NextLine == null))
							throw new CodeEE("֐\"@" + label + "\"܂");
						if (call.Count >= 2)
							throw new ExeEE("֐\"@" + label + "\"̌₪Ԃꂽ");
						state.AddFunction(call);
						break;
					}
				case BuiltInFunctionCode.RETURN://֐̏IBRESULTɐi[\B
					{
						expArg = (ExpressionArgument)line.Argument;
						Int64 ret = eEvaluator.GetInteger(expArg.Term);
						vEvaluator.RESULT = ret;
						state.Return(ret);
						break;
					}
				case BuiltInFunctionCode.LOADDATA:
					{
						ExpressionArgument intExpArg = (ExpressionArgument)line.Argument;
						Int64 target = eEvaluator.GetInteger(intExpArg.Term);
						if (target < 0)
							throw new CodeEE("LOADDATÄɕ̒l(" + target.ToString() + ")w肳܂");
						else if (target > int.MaxValue)
							throw new CodeEE("LOADDATÄ(" + target.ToString() + ")傫܂");
						EraDataResult result = checkData((int)target);
						if (result.State != EraDataState.OK)
							throw new CodeEE("sȃf[^[h悤Ƃ܂");

						loadFrom((int)target);
						state.ClearFunctionList();
						state.SystemState = SystemStateCode.LoadData_DataLoaded;
					}
					break;
				case BuiltInFunctionCode.JUMPFORM:
				case BuiltInFunctionCode.TRYJUMPFORM:
					{
						StringForm strForm = ((FormStrArgument)line.Argument).StrForm;
						string label = strForm.GetString(eEvaluator).Trim();
						if (Config.Instance.IgnoreCase)
							label = label.ToUpper(); ;
						CalledFunction call = CalledFunction.CallFunction(this, label, line, false);
						if ((call == null) || (call.NextLine == null))
						{
							if (line.Function == BuiltInFunctionCode.TRYJUMPFORM)
								break;
							throw new CodeEE("֐\"@" + label + "\"܂");
						}
						state.JumpTo(call.NextLine);
						break;
					}

				case BuiltInFunctionCode.CALLFORM:
				case BuiltInFunctionCode.TRYCALLFORM:
					{
						if (!sequential)//RETURNŋAĂ
							break;//Ȃ
						StringForm strForm = ((FormStrArgument)line.Argument).StrForm;
						string label = strForm.GetString(eEvaluator).Trim();
						if (Config.Instance.IgnoreCase)
							label = label.ToUpper(); ;
						CalledFunction call = CalledFunction.CallFunction(this, label, line, false);
						if ((call == null)||(call.NextLine == null))
						{
							if (line.Function == BuiltInFunctionCode.TRYCALLFORM)
								break;
							throw new CodeEE("֐\"@" + label + "\"܂");

						}
						state.AddFunction(call);
						break;
					}
				case BuiltInFunctionCode.GOTOFORM:
				case BuiltInFunctionCode.TRYGOTOFORM:
					{
						StringForm strForm = ((FormStrArgument)line.Argument).StrForm;
						string label = strForm.GetString(eEvaluator).Trim();
						if (Config.Instance.IgnoreCase)
							label = label.ToUpper();
						LogicalLine jumpto = state.CurrentCalled.CallLabel(this, label);
						if (jumpto == null)
						{
							if (line.Function == BuiltInFunctionCode.TRYGOTOFORM)
								break;
							throw new CodeEE("x\"$" + label + "\"܂");
						}
						state.JumpTo(jumpto);
						break;
					}

				default:
					throw new ExeEE("`̊֐ł");
			}

		}





		ProcessState prevState = null;
		private void saveCurrentState()
		{
			if (prevState != null)
				throw new ExeEE("LĂԂ̂ɍēxL悤Ƃ");
			prevState = state.Clone();
		}

		private void loadPrevState()
		{
			if (prevState == null)
				throw new ExeEE("LĂԂȂ̂ɌĂі߂ꂽ");
			state = prevState;
			deletePrevState();
		}

		private void deletePrevState()
		{
			prevState = null;
		}

		#endregion
	}
}
