﻿using System;
using System.Collections.Generic;
using System.Text;

namespace MinorShift.Emuera.GameData.Variable
{
	internal class VariableLocal
	{
		public VariableLocal(int size)
		{
			this.size = size;
		}
		readonly int size;
		public int Size
		{
			get
			{
				return size;
			}
		}
		Dictionary<string, long[]> localVars = new Dictionary<string, long[]>();

		public Int64 GetValue(string key, long index)
		{
			long[] varList = getVarList(key);
			return varList[index];
		}
		public void SetValue(string key, long index, long value)
		{
			long[] varList = getVarList(key);
			varList[index] = value;
		}

		public void Clear()
		{
			localVars.Clear();
		}

		private long[] getVarList(string key)
		{

			long[] varList = null;
			if (localVars.ContainsKey(key))
				varList = localVars[key];
			else
			{
				varList = new long[size];
				localVars.Add(key, varList);
			}
			return varList;
		}
	}
}
