using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera.GameData
{
    internal sealed class StringForm
    {
        public StringForm(string row)
        {
            rowString = row;
        }

        readonly string rowString;
        string formString;
        List<IOperandTerm> argList = new List<IOperandTerm>();


        public bool Reduced
        {
            get
            {
                return formString != null;
            }
        }

        private VariableToken getVariable(VariableCode code, VariableCode subCode)
        {
            VariableIdentifier subId = VariableIdentifier.GetVariableId(subCode);
            VariableToken subToken = new VariableToken(subId, new SingleTerm(0), null);
            VariableIdentifier id = VariableIdentifier.GetVariableId(VariableCode.NAME);
            VariableToken token = new VariableToken(id, subToken, null);
            return token;
        }

        public void Reduce()
        {
            if (this.Reduced)
                return;
            StringStream st = new StringStream(rowString);
            StringBuilder buffer = new StringBuilder();
            int countArg = 0;
            while (!st.EOS)
            {
                if (st.Current == '%')
                {
                    st.ShiftNext();
                    argList.Add(ExpressionParser.ReduceStringTerm(st));
                    TokenReader.SkipWhiteSpace(st);
                    if (st.Current != '%')
                        throw new CodeEE("\'%\'g܂Ή\'%\'̏I[܂");
                    st.ShiftNext();
                    buffer.Append("{");
                    buffer.Append(countArg.ToString());
                    buffer.Append("}");
                    countArg++;
                    continue;
                }
                if (st.Current == '{')
                {
                    st.ShiftNext();
                    argList.Add(ExpressionParser.ReduceIntegerTerm(st));
                    TokenReader.SkipWhiteSpace(st);
                    if (st.Current != '}')
                        throw new CodeEE("\'{\'g܂Ή\'}\'܂");
                    st.ShiftNext();
                    buffer.Append("{");
                    buffer.Append(countArg.ToString());
                    buffer.Append("}");
                    countArg++;
                    continue;
                }
                if (st.Current == '}')
                {
                    throw new CodeEE("\'}\'g܂Ή\'{\'܂");
                }
                if ((st.Current == '*') && (st.Next == '*') && (st.NextNext == '*'))
                {
                    st.ShiftNext();
                    st.ShiftNext();
                    st.ShiftNext();
                    VariableToken token = getVariable(VariableCode.NAME, VariableCode.TARGET);
                    argList.Add(token);
                    buffer.Append("{");
                    buffer.Append(countArg.ToString());
                    buffer.Append("}");
                    countArg++;
                    continue;
                }
                if ((st.Current == '+') && (st.Next == '+') && (st.NextNext == '+'))
                {
                    st.ShiftNext();
                    st.ShiftNext();
                    st.ShiftNext();
                    VariableToken token = getVariable(VariableCode.CALLNAME, VariableCode.MASTER);
                    argList.Add(token);
                    buffer.Append("{");
                    buffer.Append(countArg.ToString());
                    buffer.Append("}");
                    countArg++;
                    continue;
                }
                if ((st.Current == '=') && (st.Next == '=') && (st.NextNext == '='))
                {
                    st.ShiftNext();
                    st.ShiftNext();
                    st.ShiftNext();
                    VariableToken token = getVariable(VariableCode.CALLNAME, VariableCode.PLAYER);
                    argList.Add(token);
                    buffer.Append("{");
                    buffer.Append(countArg.ToString());
                    buffer.Append("}");
                    countArg++;
                    continue;
                }
                if ((st.Current == '/') && (st.Next == '/') && (st.NextNext == '/'))
                {
                    st.ShiftNext();
                    st.ShiftNext();
                    st.ShiftNext();
                    VariableToken token = getVariable(VariableCode.CALLNAME, VariableCode.ASSI);
                    argList.Add(token);
                    buffer.Append("{");
                    buffer.Append(countArg.ToString());
                    buffer.Append("}");
                    countArg++;
                    continue;
                }
                if ((st.Current == '$') && (st.Next == '$') && (st.NextNext == '$'))
                {
                    st.ShiftNext();
                    st.ShiftNext();
                    st.ShiftNext();
                    VariableToken token = getVariable(VariableCode.CALLNAME, VariableCode.TARGET);
                    argList.Add(token);
                    buffer.Append("{");
                    buffer.Append(countArg.ToString());
                    buffer.Append("}");
                    countArg++;
                    continue;
                }
                //GXP[v̎gp
                if (st.Current == '\\')
                {
                    st.ShiftNext();
                    switch (st.Current)
                    {
                        case StringStream.EndOfString:
                            throw new CodeEE("GXP[v\\̌ɕ܂");
                        case '\n':
                            break;
                        case 's':
                            buffer.Append(' ');
                            break;
                        case 'S':
                            buffer.Append('@');
                            break;
                        case 't':
                            buffer.Append('\t');
                            break;
                        case 'n':
                            buffer.Append('\n');
                            break;
                        case '{':
                            buffer.Append('{');
                            buffer.Append('{');
                            break;
                        case '}':
                            buffer.Append('}');
                            buffer.Append('}');
                            break;
                        default:
                            buffer.Append(st.Current);
                            break;
                    }
                    st.ShiftNext();
                    continue;
                }
                buffer.Append(st.Current);
                st.ShiftNext();
            }
            formString = buffer.ToString();
        }

        public string GetString(ExpressionEvaluator eEvaluator)
        {
            if (!this.Reduced)
                this.Reduce();
            string[] objArgList = new string[argList.Count];
            for (int i = 0; i < objArgList.Length; i++)
            {
                IOperandTerm term = argList[i];
                if (term.GetOperandType() == typeof(Int64))
                    objArgList[i] = eEvaluator.GetInteger(term).ToString();
                else if (term.GetOperandType() == typeof(string))
                    objArgList[i] = eEvaluator.GetString(term);
            }
            return string.Format(formString, objArgList);
        }
        public string Format
        {
            get
            {
                if (!this.Reduced)
                    this.Reduce();
                return formString;
            }
        }

        public List<IOperandTerm> ArgList
        {
            get
            {
                if (!this.Reduced)
                    this.Reduce();
                return argList;
            }
        }

    }
}